/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.bitcoin.tool.fee.bitcore.config;

import java.util.Objects;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.tbk.bitcoin.tool.fee.bitcore.BitcoreFeeApiClient;
import org.tbk.bitcoin.tool.fee.bitcore.BitcoreFeeApiClientImpl;
import org.tbk.bitcoin.tool.fee.bitcore.BitcoreFeeProvider;
import org.tbk.bitcoin.tool.fee.bitcore.config.BitcoreFeeClientAutoConfigProperties;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={BitcoreFeeClientAutoConfigProperties.class})
@ConditionalOnClass(value={BitcoreFeeApiClient.class, BitcoreFeeProvider.class})
@ConditionalOnProperty(name={"org.tbk.bitcoin.tool.fee.enabled", "org.tbk.bitcoin.tool.fee.bitcore.enabled"}, havingValue="true", matchIfMissing=true)
public class BitcoreFeeClientAutoConfiguration {
    private final BitcoreFeeClientAutoConfigProperties properties;

    public BitcoreFeeClientAutoConfiguration(BitcoreFeeClientAutoConfigProperties properties) {
        this.properties = Objects.requireNonNull(properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={BitcoreFeeApiClient.class})
    public BitcoreFeeApiClient bitcoreFeeApiClient() {
        return new BitcoreFeeApiClientImpl(this.properties.getBaseUrl(), (String)this.properties.getToken().orElse(null));
    }

    @Bean
    @ConditionalOnMissingBean(value={BitcoreFeeProvider.class})
    public BitcoreFeeProvider bitcoreFeeProvider(BitcoreFeeApiClient bitcoreFeeApiClient) {
        return new BitcoreFeeProvider(bitcoreFeeApiClient);
    }
}

