/*
 * Decompiled with CFR 0.152.
 */
package io.github.techgnious.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class IVFileUtils {
    public static final int BUFFER_SIZE = 4096;

    private IVFileUtils() {
    }

    public static byte[] copyToByteArray(InputStream in) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        IVFileUtils.copy(in, out);
        return out.toByteArray();
    }

    public static byte[] copyToByteArray(File in) throws IOException {
        IVFileUtils.checkNull(in, "No input File specified");
        return IVFileUtils.copyToByteArray(Files.newInputStream(in.toPath(), new OpenOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, OutputStream out) throws IOException {
        IVFileUtils.checkNull(in, "No InputStream specified");
        IVFileUtils.checkNull(out, "No OutputStream specified");
        try {
            int bytesRead;
            int byteCount = 0;
            byte[] buffer = new byte[4096];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            IVFileUtils.close(in);
            IVFileUtils.close(out);
        }
    }

    private static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void checkNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }
}

