/*
 * Decompiled with CFR 0.152.
 */
package io.github.techgnious;

import io.github.techgnious.dto.IVAudioAttributes;
import io.github.techgnious.dto.IVSize;
import io.github.techgnious.dto.IVVideoAttributes;
import io.github.techgnious.dto.ImageFormats;
import io.github.techgnious.dto.ResizeResolution;
import io.github.techgnious.dto.VideoFormats;
import io.github.techgnious.exception.ImageException;
import io.github.techgnious.exception.VideoException;
import io.github.techgnious.utils.IVFileUtils;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import ws.schild.jave.Encoder;
import ws.schild.jave.MultimediaObject;
import ws.schild.jave.encode.AudioAttributes;
import ws.schild.jave.encode.EncodingAttributes;
import ws.schild.jave.encode.VideoAttributes;
import ws.schild.jave.encode.enums.X264_PROFILE;
import ws.schild.jave.info.VideoSize;

public class IVCompressor {
    private Encoder encoder;
    private AudioAttributes audioAttributes;
    private VideoAttributes videoAttributes;
    private EncodingAttributes encodingAttributes;
    private ResizeResolution imageResolution = ResizeResolution.IMAGE_DEFAULT;
    private ResizeResolution videoResolution = ResizeResolution.VIDEO_DEFAULT;

    public IVCompressor() {
        this.encoder = new Encoder();
        this.videoAttributes = new VideoAttributes();
        this.videoAttributes.setCodec("h264");
        this.videoAttributes.setX264Profile(X264_PROFILE.BASELINE);
        this.videoAttributes.setBitRate(Integer.valueOf(160000));
        this.videoAttributes.setFrameRate(Integer.valueOf(15));
        this.videoAttributes.setSize(new VideoSize(this.videoResolution.getWidth(), this.videoResolution.getHeight()));
        this.audioAttributes = new AudioAttributes();
        this.audioAttributes.setCodec("aac");
        this.audioAttributes.setBitRate(Integer.valueOf(64000));
        this.audioAttributes.setChannels(Integer.valueOf(2));
        this.audioAttributes.setSamplingRate(Integer.valueOf(44100));
        this.encodingAttributes = new EncodingAttributes();
        this.encodingAttributes.setVideoAttributes(this.videoAttributes);
        this.encodingAttributes.setAudioAttributes(this.audioAttributes);
    }

    public byte[] resizeImage(byte[] data, ImageFormats fileFormat, ResizeResolution resolution) throws ImageException {
        if (resolution != null) {
            this.imageResolution = resolution;
        }
        return this.rescaleImage(data, this.imageResolution.getWidth(), this.imageResolution.getHeight(), fileFormat.getType());
    }

    public byte[] resizeImageWithCustomRes(byte[] data, ImageFormats fileFormat, IVSize res) throws ImageException {
        return this.rescaleImage(data, res.getWidth(), res.getHeight(), fileFormat.getType());
    }

    public String resizeAndSaveImageToAPath(File file, ImageFormats fileFormat, String path, ResizeResolution imageResolution) throws ImageException {
        try {
            byte[] data = this.resizeImage(IVFileUtils.copyToByteArray(file), fileFormat, imageResolution);
            String fileName = file.getName();
            if (!file.getName().contains(fileFormat.getType())) {
                fileName = fileName.substring(0, fileName.indexOf(".")) + "." + fileFormat.getType();
            }
            return this.createAndStoreNewFile(fileName, path, data);
        }
        catch (IOException e) {
            throw new ImageException(e);
        }
    }

    public String resizeAndSaveImageToAPath(byte[] fileData, String fileName, ImageFormats fileFormat, String path, ResizeResolution imageResolution) throws ImageException {
        try {
            byte[] data = this.resizeImage(fileData, fileFormat, imageResolution);
            if (!fileName.contains(fileFormat.getType())) {
                fileName = fileName.substring(0, fileName.indexOf(".")) + "." + fileFormat.getType();
            }
            return this.createAndStoreNewFile(fileName, path, data);
        }
        catch (IOException e) {
            throw new ImageException(e);
        }
    }

    public byte[] resizeImageUsingFile(File file, ImageFormats fileFormat, ResizeResolution imageResolution) throws ImageException, IOException {
        return this.resizeImage(IVFileUtils.copyToByteArray(file), fileFormat, imageResolution);
    }

    public InputStream resizeImage(InputStream stream, ImageFormats fileFormat, ResizeResolution imageResolution) throws ImageException {
        ByteArrayInputStream targetStream = null;
        try {
            byte[] data = this.resizeImage(IVFileUtils.copyToByteArray(stream), fileFormat, imageResolution);
            targetStream = new ByteArrayInputStream(data);
            return targetStream;
        }
        catch (IOException e) {
            throw new ImageException(e);
        }
    }

    public byte[] reduceVideoSize(byte[] data, VideoFormats fileFormat, ResizeResolution resolution) throws VideoException {
        String fileType = this.setAttributes(fileFormat, resolution);
        return this.encodeVideo(data, fileType);
    }

    public byte[] convertAndResizeVideo(byte[] data, VideoFormats inputFormat, VideoFormats outputFormat, ResizeResolution resolution) throws VideoException {
        Optional videoAttr;
        String fileType = inputFormat.getType();
        this.encodingAttributes.setInputFormat(fileType);
        this.encodingAttributes.setOutputFormat(outputFormat.getType());
        if (resolution != null && (videoAttr = this.encodingAttributes.getVideoAttributes()).isPresent()) {
            ((VideoAttributes)videoAttr.get()).setSize(new VideoSize(resolution.getWidth(), resolution.getHeight()));
        }
        return this.encodeVideo(data, fileType);
    }

    public byte[] reduceVideoSizeWithCustomRes(byte[] data, VideoFormats fileFormat, IVSize resolution) throws VideoException {
        Optional videoAttr;
        String fileType = fileFormat.getType();
        this.encodingAttributes.setInputFormat(fileType);
        this.encodingAttributes.setOutputFormat(fileType);
        if (resolution != null && (videoAttr = this.encodingAttributes.getVideoAttributes()).isPresent()) {
            ((VideoAttributes)videoAttr.get()).setSize(new VideoSize(resolution.getWidth(), resolution.getHeight()));
        }
        return this.encodeVideo(data, fileType);
    }

    public byte[] reduceVideoSize(File file, VideoFormats fileFormat, ResizeResolution resolution) throws VideoException, IOException {
        String fileType = this.setAttributes(fileFormat, resolution);
        return this.encodeVideo(IVFileUtils.copyToByteArray(file), fileType);
    }

    public String reduceVideoSizeAndSaveToAPath(File file, VideoFormats fileFormat, ResizeResolution resolution, String path) throws VideoException, IOException {
        String fileType = this.setAttributes(fileFormat, resolution);
        byte[] data = this.encodeVideo(IVFileUtils.copyToByteArray(file), fileType);
        String fileName = file.getName();
        if (!fileName.contains(fileFormat.getType())) {
            fileName = fileName.substring(0, fileName.indexOf(".")) + "." + fileFormat.getType();
        }
        return this.createAndStoreNewFile(fileName, path, data);
    }

    public String reduceVideoSizeAndSaveToAPath(byte[] fileData, String fileName, VideoFormats fileFormat, ResizeResolution resolution, String path) throws VideoException, IOException {
        String fileType = this.setAttributes(fileFormat, resolution);
        byte[] data = this.encodeVideo(fileData, fileType);
        if (!fileName.contains(fileFormat.getType())) {
            fileName = fileName.substring(0, fileName.indexOf(".")) + "." + fileFormat.getType();
        }
        return this.createAndStoreNewFile(fileName, path, data);
    }

    public byte[] encodeVideoWithAttributes(byte[] data, VideoFormats fileFormat, IVAudioAttributes audioAttribute, IVVideoAttributes videoAttribute) throws VideoException {
        String filetype = fileFormat.getType();
        this.setAudioAndVideoAttributes(filetype, audioAttribute, videoAttribute);
        return this.encodeVideo(data, filetype);
    }

    public byte[] convertVideoFormat(byte[] data, VideoFormats inputFormat, VideoFormats outputFormat) throws VideoException {
        String filetype = inputFormat.getType();
        AudioAttributes audioAttr = new AudioAttributes();
        VideoAttributes videoAttr = new VideoAttributes();
        this.encodingAttributes.setInputFormat(inputFormat.getType());
        this.encodingAttributes.setOutputFormat(outputFormat.getType());
        this.encodingAttributes.setAudioAttributes(audioAttr);
        this.encodingAttributes.setVideoAttributes(videoAttr);
        return this.encodeVideo(data, filetype);
    }

    private void setAudioAndVideoAttributes(String fileFormat, IVAudioAttributes audioAttribute, IVVideoAttributes videoAttribute) {
        if (videoAttribute != null) {
            this.videoAttributes.setCodec("h264");
            this.videoAttributes.setX264Profile(X264_PROFILE.BASELINE);
            if (videoAttribute.getBitRate() != null) {
                this.videoAttributes.setBitRate(videoAttribute.getBitRate());
            }
            if (videoAttribute.getFrameRate() != null) {
                this.videoAttributes.setFrameRate(videoAttribute.getFrameRate());
            }
            if (videoAttribute.getSize() != null) {
                this.videoAttributes.setSize(new VideoSize(videoAttribute.getSize().getWidth(), videoAttribute.getSize().getHeight()));
            }
            this.encodingAttributes.setVideoAttributes(this.videoAttributes);
        }
        if (audioAttribute != null) {
            this.audioAttributes.setCodec("aac");
            if (audioAttribute.getBitRate() != null) {
                this.audioAttributes.setBitRate(audioAttribute.getBitRate());
            }
            if (audioAttribute.getChannels() != null) {
                this.audioAttributes.setChannels(audioAttribute.getChannels());
            }
            if (audioAttribute.getSamplingRate() != null) {
                this.audioAttributes.setSamplingRate(audioAttribute.getSamplingRate());
            }
            this.encodingAttributes.setAudioAttributes(this.audioAttributes);
        }
        this.encodingAttributes.setInputFormat(fileFormat);
        this.encodingAttributes.setOutputFormat(fileFormat);
    }

    private byte[] encodeVideo(byte[] data, String fileFormat) throws VideoException {
        File target = null;
        File file = null;
        try {
            target = File.createTempFile("target", fileFormat);
            file = File.createTempFile("source", fileFormat);
            FileUtils.writeByteArrayToFile((File)file, (byte[])data);
            MultimediaObject source = new MultimediaObject(file);
            this.encoder.encode(source, target, this.encodingAttributes);
            byte[] byArray = FileUtils.readFileToByteArray((File)target);
            return byArray;
        }
        catch (Exception e) {
            throw new VideoException("Error Occurred while resizing the video");
        }
        finally {
            try {
                if (file != null) {
                    Files.deleteIfExists(file.toPath());
                }
                if (target != null) {
                    Files.deleteIfExists(target.toPath());
                }
            }
            catch (IOException iOException) {}
        }
    }

    private byte[] rescaleImage(byte[] data, int width, int height, String contentType) throws ImageException {
        try {
            BufferedImage originalImage = ImageIO.read(new ByteArrayInputStream(data));
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            int type = originalImage.getType() == 0 ? 2 : originalImage.getType();
            BufferedImage resizedImage = new BufferedImage(width, height, type);
            Graphics2D g = resizedImage.createGraphics();
            g.drawImage(originalImage, 0, 0, width, height, null);
            g.dispose();
            ImageIO.write((RenderedImage)resizedImage, contentType, outputStream);
            return outputStream.toByteArray();
        }
        catch (Exception e) {
            throw new ImageException("Byte Array doesn't contain valid Image");
        }
    }

    private String createAndStoreNewFile(String fileName, String path, byte[] data) throws IOException {
        this.checkForValidPath(path);
        String fullPath = path;
        if (!path.endsWith(File.separator)) {
            fullPath = fullPath + File.separator;
        }
        fullPath = fullPath + fileName;
        File newFile = new File(fullPath);
        FileUtils.writeByteArrayToFile((File)newFile, (byte[])data);
        return "File is saved in path::" + newFile.getAbsolutePath();
    }

    private void checkForValidPath(String path) throws IOException {
        try {
            Paths.get(path, new String[0]);
        }
        catch (Exception e) {
            throw new IOException("Invalid Path");
        }
    }

    private String setAttributes(VideoFormats fileFormat, ResizeResolution resolution) {
        Optional videoAttr;
        String fileType = fileFormat.getType();
        this.encodingAttributes.setInputFormat(fileType);
        this.encodingAttributes.setOutputFormat(fileType);
        if (resolution != null && (videoAttr = this.encodingAttributes.getVideoAttributes()).isPresent()) {
            ((VideoAttributes)videoAttr.get()).setSize(new VideoSize(resolution.getWidth(), resolution.getHeight()));
        }
        return fileType;
    }
}

