/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.markup.builder.internal;

import io.github.swagger2markup.markup.builder.MarkupBlockStyle;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.markup.builder.MarkupLanguage;
import io.github.swagger2markup.markup.builder.internal.Markup;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.Normalizer;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.jworks.markdown_to_asciidoc.Converter;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMarkupDocBuilder
implements MarkupDocBuilder {
    protected static final boolean LINE_BREAK_DEFAULT = false;
    protected static final Pattern ANCHOR_UNIGNORABLE_PATTERN = Pattern.compile("[^0-9a-zA-Z-_]+");
    protected static final Pattern ANCHOR_IGNORABLE_PATTERN = Pattern.compile("[\\s@#&(){}\\[\\]!$*%+=/:.;,?\\\\<>|]+");
    protected static final String ANCHOR_SEPARATION_CHARACTERS = "_-";
    protected static final int MAX_TITLE_LEVEL = 5;
    protected static final String NEW_LINES = "\\r\\n|\\r|\\n";
    protected static final String WHITESPACE = " ";
    protected StringBuilder documentBuilder = new StringBuilder();
    protected String newLine;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String anchorPrefix = null;

    public AbstractMarkupDocBuilder() {
        this(System.getProperty("line.separator"));
    }

    public AbstractMarkupDocBuilder(String newLine) {
        this.newLine = newLine;
    }

    protected abstract MarkupLanguage getMarkupLanguage();

    @Override
    public MarkupDocBuilder withAnchorPrefix(String prefix) {
        this.anchorPrefix = prefix;
        return this;
    }

    @Override
    public String getAnchorPrefix() {
        return this.anchorPrefix;
    }

    protected void documentTitle(Markup markup, String title) {
        Validate.notBlank((CharSequence)title, (String)"title must not be blank", (Object[])new Object[0]);
        this.documentBuilder.append(markup).append(this.replaceNewLinesWithWhiteSpace(title)).append(this.newLine).append(this.newLine);
    }

    protected void sectionTitleLevel(Markup markup, int level, String title) {
        Validate.notBlank((CharSequence)title, (String)"title must not be blank", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)1L, (long)5L, (long)level);
        this.documentBuilder.append(this.newLine);
        this.documentBuilder.append(StringUtils.repeat((String)markup.toString(), (int)(level + 1))).append(WHITESPACE).append(this.replaceNewLinesWithWhiteSpace(title)).append(this.newLine);
    }

    protected void sectionTitleWithAnchorLevel(Markup markup, int level, String title, String anchor) {
        Validate.notBlank((CharSequence)title, (String)"title must not be blank", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)1L, (long)5L, (long)level);
        this.documentBuilder.append(this.newLine);
        if (anchor == null) {
            anchor = title;
        }
        this.anchor(this.replaceNewLinesWithWhiteSpace(anchor)).newLine();
        this.documentBuilder.append(StringUtils.repeat((String)markup.toString(), (int)(level + 1))).append(WHITESPACE).append(this.replaceNewLinesWithWhiteSpace(title)).append(this.newLine);
    }

    @Override
    public MarkupDocBuilder sectionTitleWithAnchorLevel(int level, String title) {
        return this.sectionTitleWithAnchorLevel(level, title, null);
    }

    @Override
    public MarkupDocBuilder sectionTitleLevel1(String title) {
        return this.sectionTitleLevel(1, title);
    }

    @Override
    public MarkupDocBuilder sectionTitleWithAnchorLevel1(String title, String anchor) {
        return this.sectionTitleWithAnchorLevel(1, title, anchor);
    }

    @Override
    public MarkupDocBuilder sectionTitleWithAnchorLevel1(String title) {
        return this.sectionTitleWithAnchorLevel1(title, null);
    }

    @Override
    public MarkupDocBuilder sectionTitleLevel2(String title) {
        return this.sectionTitleLevel(2, title);
    }

    @Override
    public MarkupDocBuilder sectionTitleWithAnchorLevel2(String title, String anchor) {
        return this.sectionTitleWithAnchorLevel(2, title, anchor);
    }

    @Override
    public MarkupDocBuilder sectionTitleWithAnchorLevel2(String title) {
        return this.sectionTitleWithAnchorLevel2(title, null);
    }

    @Override
    public MarkupDocBuilder sectionTitleLevel3(String title) {
        return this.sectionTitleLevel(3, title);
    }

    @Override
    public MarkupDocBuilder sectionTitleWithAnchorLevel3(String title, String anchor) {
        return this.sectionTitleWithAnchorLevel(3, title, anchor);
    }

    @Override
    public MarkupDocBuilder sectionTitleWithAnchorLevel3(String title) {
        return this.sectionTitleWithAnchorLevel3(title, null);
    }

    @Override
    public MarkupDocBuilder sectionTitleLevel4(String title) {
        return this.sectionTitleLevel(4, title);
    }

    @Override
    public MarkupDocBuilder sectionTitleWithAnchorLevel4(String title, String anchor) {
        return this.sectionTitleWithAnchorLevel(4, title, anchor);
    }

    @Override
    public MarkupDocBuilder sectionTitleWithAnchorLevel4(String title) {
        return this.sectionTitleWithAnchorLevel4(title, null);
    }

    @Override
    public MarkupDocBuilder sectionTitleLevel5(String title) {
        return this.sectionTitleLevel(5, title);
    }

    @Override
    public MarkupDocBuilder sectionTitleWithAnchorLevel5(String title, String anchor) {
        return this.sectionTitleWithAnchorLevel(5, title, anchor);
    }

    @Override
    public MarkupDocBuilder sectionTitleWithAnchorLevel5(String title) {
        return this.sectionTitleWithAnchorLevel5(title, null);
    }

    @Override
    public MarkupDocBuilder textLine(String text, boolean forceLineBreak) {
        Validate.notNull((Object)text, (String)"text must not be null", (Object[])new Object[0]);
        this.text(this.replaceNewLines(text));
        this.newLine(forceLineBreak);
        return this;
    }

    @Override
    public MarkupDocBuilder textLine(String text) {
        this.textLine(text, false);
        return this;
    }

    @Override
    public MarkupDocBuilder text(String text) {
        Validate.notNull((Object)text, (String)"text must not be null", (Object[])new Object[0]);
        this.documentBuilder.append(this.replaceNewLines(text));
        return this;
    }

    @Override
    public MarkupDocBuilder paragraph(String text) {
        return this.paragraph(text, false);
    }

    @Override
    public MarkupDocBuilder block(String text, MarkupBlockStyle style) {
        Validate.notBlank((CharSequence)text, (String)"text must not be blank", (Object[])new Object[0]);
        return this.block(this.replaceNewLines(text), style, null, null);
    }

    @Override
    public MarkupDocBuilder listingBlock(String text) {
        Validate.notBlank((CharSequence)text, (String)"text must not be blank", (Object[])new Object[0]);
        return this.listingBlock(this.replaceNewLines(text), null);
    }

    protected void delimitedBlockText(Markup begin, String text, Markup end) {
        Validate.notBlank((CharSequence)text, (String)"text must not be blank", (Object[])new Object[0]);
        if (!StringUtils.isBlank((CharSequence)begin.toString())) {
            this.documentBuilder.append(begin).append(this.newLine);
        }
        this.documentBuilder.append(this.replaceNewLines(text)).append(this.newLine);
        if (!StringUtils.isBlank((CharSequence)end.toString())) {
            this.documentBuilder.append(end).append(this.newLine);
        }
        this.documentBuilder.append(this.newLine);
    }

    protected void delimitedTextWithoutLineBreaks(Markup begin, String text, Markup end) {
        Validate.notBlank((CharSequence)text, (String)"text must not be blank", (Object[])new Object[0]);
        if (!StringUtils.isBlank((CharSequence)begin.toString())) {
            this.documentBuilder.append(begin);
        }
        this.documentBuilder.append(this.replaceNewLines(text));
        if (!StringUtils.isBlank((CharSequence)end.toString())) {
            this.documentBuilder.append(end);
        }
    }

    protected void delimitedBlockText(Markup markup, String text) {
        this.delimitedBlockText(markup, text, markup);
    }

    protected void delimitedTextWithoutLineBreaks(Markup markup, String text) {
        this.delimitedTextWithoutLineBreaks(markup, text, markup);
    }

    protected void literalText(Markup markup, String text) {
        this.delimitedTextWithoutLineBreaks(markup, text);
    }

    @Override
    public MarkupDocBuilder literalTextLine(String text, boolean forceLineBreak) {
        Validate.notBlank((CharSequence)text, (String)"text must not be blank", (Object[])new Object[0]);
        this.literalText(this.replaceNewLines(text));
        this.newLine(forceLineBreak);
        return this;
    }

    @Override
    public MarkupDocBuilder literalTextLine(String text) {
        return this.literalTextLine(text, false);
    }

    protected void boldText(Markup markup, String text) {
        this.delimitedTextWithoutLineBreaks(markup, text);
    }

    @Override
    public MarkupDocBuilder boldTextLine(String text, boolean forceLineBreak) {
        Validate.notBlank((CharSequence)text, (String)"text must not be blank", (Object[])new Object[0]);
        this.boldText(this.replaceNewLines(text));
        this.newLine(forceLineBreak);
        return this;
    }

    @Override
    public MarkupDocBuilder boldTextLine(String text) {
        return this.boldTextLine(text, false);
    }

    protected void italicText(Markup markup, String text) {
        this.delimitedTextWithoutLineBreaks(markup, text);
    }

    @Override
    public MarkupDocBuilder italicTextLine(String text, boolean forceLineBreak) {
        this.italicText(text);
        this.newLine(forceLineBreak);
        return this;
    }

    @Override
    public MarkupDocBuilder italicTextLine(String text) {
        return this.italicTextLine(text, false);
    }

    protected void unorderedList(Markup markup, List<String> list) {
        Validate.notEmpty(list, (String)"list must not be empty", (Object[])new Object[0]);
        this.documentBuilder.append(this.newLine);
        for (String listEntry : list) {
            this.unorderedListItem(markup, listEntry);
        }
        this.documentBuilder.append(this.newLine);
    }

    protected void unorderedListItem(Markup markup, String item) {
        Validate.notBlank((CharSequence)item, (String)"item must not be blank", (Object[])new Object[0]);
        this.documentBuilder.append(markup).append(item).append(this.newLine);
    }

    @Override
    public MarkupDocBuilder anchor(String anchor) {
        Validate.notBlank((CharSequence)anchor, (String)"anchor must not be blank", (Object[])new Object[0]);
        return this.anchor(anchor, null);
    }

    protected String normalizeAnchor(Markup spaceEscape, String anchor) {
        String normalizedAnchor = StringUtils.defaultString((String)this.anchorPrefix) + anchor.trim();
        normalizedAnchor = Normalizer.normalize(normalizedAnchor, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        normalizedAnchor = ANCHOR_IGNORABLE_PATTERN.matcher(normalizedAnchor).replaceAll(spaceEscape.toString());
        normalizedAnchor = normalizedAnchor.replaceAll(String.format("([%1$s])([%1$s]+)", ANCHOR_SEPARATION_CHARACTERS), "$1");
        normalizedAnchor = StringUtils.strip((String)normalizedAnchor, (String)ANCHOR_SEPARATION_CHARACTERS);
        String validAnchor = ANCHOR_UNIGNORABLE_PATTERN.matcher(normalizedAnchor = normalizedAnchor.trim().toLowerCase()).replaceAll("");
        normalizedAnchor = validAnchor.length() != normalizedAnchor.length() ? DigestUtils.md5Hex((String)normalizedAnchor) : validAnchor;
        return normalizedAnchor;
    }

    @Override
    public MarkupDocBuilder crossReferenceRaw(String anchor, String text) {
        return this.crossReferenceRaw(null, anchor, text);
    }

    @Override
    public MarkupDocBuilder crossReferenceRaw(String anchor) {
        return this.crossReferenceRaw(null, anchor, null);
    }

    @Override
    public MarkupDocBuilder crossReference(String anchor, String text) {
        return this.crossReference(null, anchor, text);
    }

    @Override
    public MarkupDocBuilder crossReference(String anchor) {
        return this.crossReference(null, anchor, null);
    }

    protected void newLine(Markup markup, boolean forceLineBreak) {
        if (forceLineBreak) {
            this.documentBuilder.append(markup);
        }
        this.documentBuilder.append(this.newLine);
    }

    @Override
    public MarkupDocBuilder newLine() {
        this.newLine(false);
        return this;
    }

    @Override
    public MarkupDocBuilder importMarkup(Reader markupText, MarkupLanguage markupLanguage) {
        Validate.notNull((Object)markupText, (String)"markupText must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)markupLanguage), (String)"markupLanguage must not be null", (Object[])new Object[0]);
        return this.importMarkup(markupText, markupLanguage, 0);
    }

    protected String convert(String markupText, MarkupLanguage markupLanguage) {
        if (markupLanguage == this.getMarkupLanguage()) {
            return markupText;
        }
        if (markupLanguage == MarkupLanguage.MARKDOWN && this.getMarkupLanguage() == MarkupLanguage.ASCIIDOC) {
            return Converter.convertMarkdownToAsciiDoc((String)markupText) + this.newLine;
        }
        return markupText;
    }

    protected void importMarkupStyle1(Pattern titlePattern, Markup titlePrefix, Reader markupText, MarkupLanguage markupLanguage, int levelOffset) {
        Validate.isTrue((levelOffset <= 5 ? 1 : 0) != 0, (String)String.format("Specified levelOffset (%d) > max levelOffset (%d)", levelOffset, 5), (Object[])new Object[0]);
        Validate.isTrue((levelOffset >= -5 ? 1 : 0) != 0, (String)String.format("Specified levelOffset (%d) < min levelOffset (%d)", levelOffset, -5), (Object[])new Object[0]);
        StringBuffer leveledText = new StringBuffer();
        try (BufferedReader bufferedReader = new BufferedReader(markupText);){
            String readLine;
            while ((readLine = bufferedReader.readLine()) != null) {
                Matcher titleMatcher = titlePattern.matcher(readLine);
                while (titleMatcher.find()) {
                    int titleLevel = titleMatcher.group(1).length() - 1;
                    String title = titleMatcher.group(2);
                    if (titleLevel + levelOffset > 5) {
                        throw new IllegalArgumentException(String.format("Specified levelOffset (%d) set title '%s' level (%d) > max title level (%d)", levelOffset, title, titleLevel, 5));
                    }
                    if (titleLevel + levelOffset < 0) {
                        throw new IllegalArgumentException(String.format("Specified levelOffset (%d) set title '%s' level (%d) < 0", levelOffset, title, titleLevel));
                    }
                    titleMatcher.appendReplacement(leveledText, Matcher.quoteReplacement(String.format("%s %s", StringUtils.repeat((String)titlePrefix.toString(), (int)(1 + titleLevel + levelOffset)), title)));
                }
                titleMatcher.appendTail(leveledText);
                leveledText.append(this.newLine);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to import Markup", e);
        }
        if (!StringUtils.isBlank((CharSequence)leveledText)) {
            this.documentBuilder.append(this.newLine);
            this.documentBuilder.append(this.convert(leveledText.toString(), markupLanguage));
            this.documentBuilder.append(this.newLine);
        }
    }

    protected void importMarkupStyle2(Pattern titlePattern, String titleFormat, boolean startFrom0, Reader markupText, MarkupLanguage markupLanguage, int levelOffset) {
        Validate.isTrue((levelOffset <= 5 ? 1 : 0) != 0, (String)String.format("Specified levelOffset (%d) > max levelOffset (%d)", levelOffset, 5), (Object[])new Object[0]);
        Validate.isTrue((levelOffset >= -5 ? 1 : 0) != 0, (String)String.format("Specified levelOffset (%d) < min levelOffset (%d)", levelOffset, -5), (Object[])new Object[0]);
        StringBuffer leveledText = new StringBuffer();
        try (BufferedReader bufferedReader = new BufferedReader(markupText);){
            String readLine;
            while ((readLine = bufferedReader.readLine()) != null) {
                Matcher titleMatcher = titlePattern.matcher(readLine);
                while (titleMatcher.find()) {
                    int titleLevel = Integer.valueOf(titleMatcher.group(1)) - (startFrom0 ? 0 : 1);
                    String title = titleMatcher.group(2);
                    if (titleLevel + levelOffset > 5) {
                        throw new IllegalArgumentException(String.format("Specified levelOffset (%d) set title '%s' level (%d) > max title level (%d)", levelOffset, title, titleLevel, 5));
                    }
                    if (titleLevel + levelOffset < 0) {
                        throw new IllegalArgumentException(String.format("Specified levelOffset (%d) set title '%s' level (%d) < 0", levelOffset, title, titleLevel));
                    }
                    titleMatcher.appendReplacement(leveledText, Matcher.quoteReplacement(String.format(titleFormat, (startFrom0 ? 0 : 1) + titleLevel + levelOffset, title)));
                }
                titleMatcher.appendTail(leveledText);
                leveledText.append(this.newLine);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to import Markup", e);
        }
        if (!StringUtils.isBlank((CharSequence)leveledText)) {
            this.documentBuilder.append(this.newLine);
            this.documentBuilder.append(this.convert(leveledText.toString(), markupLanguage));
            this.documentBuilder.append(this.newLine);
        }
    }

    @Override
    public MarkupDocBuilder table(List<List<String>> cells) {
        Validate.notEmpty(cells, (String)"cells must not be null", (Object[])new Object[0]);
        return this.tableWithColumnSpecs(null, cells);
    }

    @Override
    public String toString() {
        return this.documentBuilder.toString();
    }

    @Override
    public Path addFileExtension(Path file) {
        return file.resolveSibling(this.addFileExtension(file.getFileName().toString()));
    }

    @Override
    public void writeToFileWithoutExtension(Path file, Charset charset, OpenOption ... options) {
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed create directory", e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(file, charset, options);){
            writer.write(this.toString());
            writer.write(this.newLine);
            writer.write(this.newLine);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write file", e);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Markup document written to: {}", (Object)file);
        }
    }

    public String replaceNewLines(String content, String replacement) {
        return content.replaceAll(NEW_LINES, Matcher.quoteReplacement(replacement));
    }

    public String replaceNewLines(String content) {
        return this.replaceNewLines(content, this.newLine);
    }

    public String replaceNewLinesWithWhiteSpace(String content) {
        return this.replaceNewLines(content, WHITESPACE);
    }

    @Override
    public void writeToFile(Path file, Charset charset, OpenOption ... options) {
        this.writeToFileWithoutExtension(file.resolveSibling(this.addFileExtension(file.getFileName().toString())), charset, options);
    }
}

