/*
 * Decompiled with CFR 0.152.
 */
package io.github.sporklibrary.reflection;

import io.github.sporklibrary.reflection.AnnotatedMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AnnotatedMethodRetriever<AnnotationType extends Annotation> {
    private final Class<AnnotationType> mAnnotationClass;
    private final Map<Class<?>, Set<AnnotatedMethod<AnnotationType>>> mCache = new HashMap();

    public AnnotatedMethodRetriever(Class<AnnotationType> annotationClass) {
        this.mAnnotationClass = annotationClass;
    }

    public Set<AnnotatedMethod<AnnotationType>> getAnnotatedMethods(Class<?> classObject) {
        Set<AnnotatedMethod<AnnotationType>> annotated_method_set = this.mCache.get(classObject);
        if (annotated_method_set != null) {
            return annotated_method_set;
        }
        annotated_method_set = new HashSet<AnnotatedMethod<AnnotationType>>();
        for (Method method : classObject.getDeclaredMethods()) {
            AnnotationType annotation = method.getAnnotation(this.mAnnotationClass);
            if (annotation == null) continue;
            annotated_method_set.add(new AnnotatedMethod<AnnotationType>(annotation, method));
        }
        this.mCache.put(classObject, annotated_method_set);
        return annotated_method_set;
    }
}

