/*
 * Decompiled with CFR 0.152.
 */
package io.github.sporklibrary.reflection;

import io.github.sporklibrary.reflection.AnnotatedField;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AnnotatedFieldRetriever<AnnotationType extends Annotation> {
    private final Class<AnnotationType> mAnnotationClass;
    private final Map<Class<?>, Set<AnnotatedField<AnnotationType>>> mCache = new HashMap();

    public AnnotatedFieldRetriever(Class<AnnotationType> annotationClass) {
        this.mAnnotationClass = annotationClass;
    }

    public Set<AnnotatedField<AnnotationType>> getAnnotatedFields(Class<?> classObject) {
        Set<AnnotatedField<AnnotationType>> annotated_field_set = this.mCache.get(classObject);
        if (annotated_field_set != null) {
            return annotated_field_set;
        }
        annotated_field_set = new HashSet<AnnotatedField<AnnotationType>>();
        for (Field field : classObject.getDeclaredFields()) {
            AnnotationType annotation = field.getAnnotation(this.mAnnotationClass);
            if (annotation == null) continue;
            annotated_field_set.add(new AnnotatedField<AnnotationType>(annotation, field));
        }
        this.mCache.put(classObject, annotated_field_set);
        return annotated_field_set;
    }
}

