/*
 * Decompiled with CFR 0.152.
 */
package io.github.sporklibrary.binders.component;

import io.github.sporklibrary.annotations.BindComponent;
import io.github.sporklibrary.annotations.ComponentScope;
import io.github.sporklibrary.binders.component.ComponentFactory;
import io.github.sporklibrary.binders.component.factories.DefaultComponentFactory;
import io.github.sporklibrary.exceptions.BindException;
import io.github.sporklibrary.reflection.AnnotatedField;
import java.util.HashMap;
import java.util.Map;

public class ComponentInstanceManager {
    private final Map<Class<?>, Object> mSingletonInstances = new HashMap();
    private static ComponentFactory sComponentFactory = new DefaultComponentFactory();

    public static void setComponentFactory(ComponentFactory factory) {
        sComponentFactory = factory;
    }

    public Object getInstance(Object parent, AnnotatedField<BindComponent> annotatedField) {
        Class<?> field_target_class = this.getTargetClass(annotatedField);
        if (!annotatedField.getField().getType().isAssignableFrom(field_target_class)) {
            throw new BindException(BindComponent.class, parent.getClass(), annotatedField.getField(), "incompatible type");
        }
        ComponentScope.Scope scope = this.getScope(field_target_class);
        switch (scope) {
            case SINGLETON: {
                Object instance = this.mSingletonInstances.get(field_target_class);
                return instance != null ? instance : this.createSingletonInstance(field_target_class);
            }
        }
        return sComponentFactory.create(field_target_class, parent);
    }

    public ComponentScope.Scope getScope(Class<?> componentClass) {
        ComponentScope annotation = componentClass.getAnnotation(ComponentScope.class);
        return annotation != null ? annotation.value() : ComponentScope.Scope.DEFAULT;
    }

    private Class<?> getTargetClass(AnnotatedField<BindComponent> annotatedField) {
        Class<?> override_class = annotatedField.getAnnotation().value();
        if (override_class == BindComponent.Default.class) {
            return annotatedField.getField().getType();
        }
        return override_class;
    }

    private synchronized Object createSingletonInstance(Class<?> classObject) {
        Object instance = sComponentFactory.create(classObject, null);
        this.mSingletonInstances.put(classObject, instance);
        return instance;
    }
}

