/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift.data;

import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.TimestampNTZTypeExtractor$;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftConnection;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftResults;
import io.github.spark_redshift_community.spark.redshift.package$;
import io.github.spark_redshift_community.spark.redshift.pushdown.RedshiftSQLStatement;
import java.io.Serializable;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]e!B\u000b\u0017\u0001a\u0011\u0003\"\u0002\u001c\u0001\t\u00039\u0004b\u0002\u001e\u0001\u0005\u0004%\tb\u000f\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002\u001f\t\u000f\u0015\u0003!\u0019!C\tw!1a\t\u0001Q\u0001\nqBQa\u0012\u0001\u0005\u0002!Cq!\u001e\u0001\u0012\u0002\u0013\u0005a\u000fC\u0004\u0002\u0004\u0001!\t!!\u0002\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002bBA\u0017\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003k\u0001A\u0011AA\u001c\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bBq!!\u0015\u0001\t\u0003\t\u0019\u0006C\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0004\u0002CA;\u0001E\u0005I\u0011\u0001<\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005%a\u0004*fIND\u0017N\u001a;Xe\u0006\u0004\b/\u001a:\u000b\u0005]A\u0012\u0001\u00023bi\u0006T!!\u0007\u000e\u0002\u0011I,Gm\u001d5jMRT!a\u0007\u000f\u0002\u000bM\u0004\u0018M]6\u000b\u0005uq\u0012\u0001G:qCJ\\wL]3eg\"Lg\r^0d_6lWO\\5us*\u0011q\u0004I\u0001\u0007O&$\b.\u001e2\u000b\u0003\u0005\n!![8\u0014\u0007\u0001\u0019\u0013\u0006\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VM\u001a\t\u0003UMr!aK\u0019\u000f\u00051\u0002T\"A\u0017\u000b\u00059z\u0013A\u0002\u001fs_>$hh\u0001\u0001\n\u0003\u0019J!AM\u0013\u0002\u000fA\f7m[1hK&\u0011A'\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003e\u0015\na\u0001P5oSRtD#\u0001\u001d\u0011\u0005e\u0002Q\"\u0001\f\u0002#5\u000b5\u000bV#S?2{ui\u0018)S\u000b\u001aK\u0005,F\u0001=!\ti$)D\u0001?\u0015\ty\u0004)\u0001\u0003mC:<'\"A!\u0002\t)\fg/Y\u0005\u0003\u0007z\u0012aa\u0015;sS:<\u0017AE'B'R+%k\u0018'P\u000f~\u0003&+\u0012$J1\u0002\n\u0011cV(S\u0017\u0016\u0013v\fT(H?B\u0013VIR%Y\u0003I9vJU&F%~cujR0Q%\u00163\u0015\n\u0017\u0011\u0002\u0019M\u001c\u0007.Z7b'R\u0014\u0018N\\4\u0015\u0007%\u0003v\f\u0005\u0002K\u001d:\u00111\n\u0014\t\u0003Y\u0015J!!T\u0013\u0002\rA\u0013X\rZ3g\u0013\t\u0019uJ\u0003\u0002NK!)\u0011K\u0002a\u0001%\u000611o\u00195f[\u0006\u0004\"aU/\u000e\u0003QS!!\u0016,\u0002\u000bQL\b/Z:\u000b\u0005]C\u0016aA:rY*\u00111$\u0017\u0006\u00035n\u000ba!\u00199bG\",'\"\u0001/\u0002\u0007=\u0014x-\u0003\u0002_)\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000f\u00014\u0001\u0013!a\u0001C\u00061\u0001/\u0019:b[N\u00042\u0001\n2e\u0013\t\u0019WE\u0001\u0004PaRLwN\u001c\t\u0003KJt!A\u001a9\u000f\u0005\u001d|gB\u00015o\u001d\tIWN\u0004\u0002kY:\u0011Af[\u0005\u0002C%\u0011q\u0004I\u0005\u0003;yI!a\u0007\u000f\n\u0005eQ\u0012BA9\u0019\u0003)\u0001\u0016M]1nKR,'o]\u0005\u0003gR\u0014\u0001#T3sO\u0016$\u0007+\u0019:b[\u0016$XM]:\u000b\u0005ED\u0012AF:dQ\u0016l\u0017m\u0015;sS:<G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003]T#!\u0019=,\u0003e\u0004\"A_@\u000e\u0003mT!\u0001`?\u0002\u0013Ut7\r[3dW\u0016$'B\u0001@&\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u0003Y(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i1/\u001a;BkR|7i\\7nSR$b!a\u0002\u0002\u000e\u0005]\u0001c\u0001\u0013\u0002\n%\u0019\u00111B\u0013\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u001fA\u0001\u0019AA\t\u0003\u0011\u0019wN\u001c8\u0011\u0007e\n\u0019\"C\u0002\u0002\u0016Y\u0011!CU3eg\"Lg\r^\"p]:,7\r^5p]\"9\u0011\u0011\u0004\u0005A\u0002\u0005m\u0011AC1vi>\u001cu.\\7jiB\u0019A%!\b\n\u0007\u0005}QEA\u0004C_>dW-\u00198\u0002\r\r|W.\\5u)\u0011\t9!!\n\t\u000f\u0005=\u0011\u00021\u0001\u0002\u0012\u0005A!o\u001c7mE\u0006\u001c7\u000e\u0006\u0003\u0002\b\u0005-\u0002bBA\b\u0015\u0001\u0007\u0011\u0011C\u0001\u0015Kb,7-\u001e;f\u0013:$XM\u001d:vaRL'\r\\=\u0015\r\u0005m\u0011\u0011GA\u001a\u0011\u001d\tya\u0003a\u0001\u0003#AQaV\u0006A\u0002%\u000b\u0011$\u001a=fGV$X-U;fefLe\u000e^3seV\u0004H/\u001b2msR1\u0011\u0011HA \u0003\u0003\u00022!OA\u001e\u0013\r\tiD\u0006\u0002\u0010%\u0016$7\u000f[5giJ+7/\u001e7ug\"9\u0011q\u0002\u0007A\u0002\u0005E\u0001\"B,\r\u0001\u0004I\u0015AG3yK\u000e,H/Z+qI\u0006$X-\u00138uKJ\u0014X\u000f\u001d;jE2LHCBA$\u0003\u001b\ny\u0005E\u0002%\u0003\u0013J1!a\u0013&\u0005\u0011auN\\4\t\u000f\u0005=Q\u00021\u0001\u0002\u0012!)q+\u0004a\u0001\u0013\u0006iQ\r_3dkR,W\u000b\u001d3bi\u0016$b!a\u0012\u0002V\u0005]\u0003bBA\b\u001d\u0001\u0007\u0011\u0011\u0003\u0005\u0006/:\u0001\r!S\u0001\rO\u0016$8i\u001c8oK\u000e$xN\u001d\u000b\u0005\u0003#\ti\u0006C\u0003a\u001f\u0001\u0007A-\u0001\u000ehKR\u001cuN\u001c8fGR|'oV5uQF+XM]=He>,\b\u000f\u0006\u0004\u0002\u0012\u0005\r\u0014Q\r\u0005\u0006AB\u0001\r\u0001\u001a\u0005\u0007\u0003O\u0002\u0002\u0019A%\u0002\u0015E,XM]=He>,\b/\u0001\u0007sKN|GN^3UC\ndW\rF\u0004S\u0003[\ny'a\u001d\t\u000f\u0005=\u0011\u00031\u0001\u0002\u0012!1\u0011\u0011O\tA\u0002%\u000bQ\u0001^1cY\u0016Dq\u0001Y\t\u0011\u0002\u0003\u0007\u0011-\u0001\fsKN|GN^3UC\ndW\r\n3fM\u0006,H\u000e\u001e\u00134\u0003-!\u0018M\u00197f\u000bbL7\u000f^:\u0015\r\u0005m\u00111PA?\u0011\u001d\tya\u0005a\u0001\u0003#Aa!!\u001d\u0014\u0001\u0004I\u0015a\u0003;bE2,7k\u00195f[\u0006$rAUAB\u0003\u000b\u000b)\nC\u0004\u0002\u0010Q\u0001\r!!\u0005\t\u000f\u0005\u001dE\u00031\u0001\u0002\n\u0006I1\u000f^1uK6,g\u000e\u001e\t\u0005\u0003\u0017\u000b\t*\u0004\u0002\u0002\u000e*\u0019\u0011q\u0012\r\u0002\u0011A,8\u000f\u001b3po:LA!a%\u0002\u000e\n!\"+\u001a3tQ&4GoU)M'R\fG/Z7f]RDQ\u0001\u0019\u000bA\u0002\u0011\u0004")
public class RedshiftWrapper
implements Serializable {
    private final String MASTER_LOG_PREFIX;
    private final String WORKER_LOG_PREFIX;

    public String MASTER_LOG_PREFIX() {
        return this.MASTER_LOG_PREFIX;
    }

    public String WORKER_LOG_PREFIX() {
        return this.WORKER_LOG_PREFIX;
    }

    public String schemaString(StructType schema, Option<Parameters.MergedParameters> params) {
        StringBuilder sb = new StringBuilder();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)field -> {
            Object object;
            String name = field.name();
            if (field.metadata().contains("redshift_type")) {
                object = field.metadata().getString("redshift_type");
            } else {
                Option<Object> option;
                DataType dataType = field.dataType();
                if (IntegerType$.MODULE$.equals(dataType)) {
                    object = "INTEGER";
                } else if (LongType$.MODULE$.equals(dataType)) {
                    object = "BIGINT";
                } else if (DoubleType$.MODULE$.equals(dataType)) {
                    object = "DOUBLE PRECISION";
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    object = "REAL";
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    object = params.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.legacyMappingShortToInt())) ? "INTEGER" : "SMALLINT";
                } else if (ByteType$.MODULE$.equals(dataType)) {
                    object = "SMALLINT";
                } else if (BooleanType$.MODULE$.equals(dataType)) {
                    object = "BOOLEAN";
                } else if (StringType$.MODULE$.equals(dataType)) {
                    object = field.metadata().contains("maxlength") ? "VARCHAR(" + field.metadata().getLong("maxlength") + ")" : "VARCHAR(MAX)";
                } else if (TimestampType$.MODULE$.equals(dataType)) {
                    object = package$.MODULE$.legacyTimestampHandling() ? "TIMESTAMP" : "TIMESTAMPTZ";
                } else if (dataType != null && !(option = TimestampNTZTypeExtractor$.MODULE$.unapply(dataType)).isEmpty() && !package$.MODULE$.legacyTimestampHandling()) {
                    object = "TIMESTAMP";
                } else if (DateType$.MODULE$.equals(dataType)) {
                    object = "DATE";
                } else if (dataType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType;
                    object = "DECIMAL(" + decimalType.precision() + "," + decimalType.scale() + ")";
                } else if (dataType instanceof ArrayType ? true : (dataType instanceof MapType ? true : dataType instanceof StructType)) {
                    object = "SUPER";
                } else {
                    throw new IllegalArgumentException("Don't know how to save " + field + " to JDBC");
                }
            }
            String typ = object;
            String nullable = field.nullable() ? "" : "NOT NULL";
            String encoding = field.metadata().contains("encoding") ? "ENCODE " + field.metadata().getString("encoding") : "";
            return sb.append((", \"" + name.replace("\"", "\\\"") + "\" " + typ + " " + nullable + " " + encoding).trim());
        });
        if (sb.length() < 2) {
            return "";
        }
        return sb.substring(2);
    }

    public Option<Parameters.MergedParameters> schemaString$default$2() {
        return None$.MODULE$;
    }

    public void setAutoCommit(RedshiftConnection conn, boolean autoCommit) {
        throw new NotImplementedError();
    }

    public void commit(RedshiftConnection conn) {
        throw new NotImplementedError();
    }

    public void rollback(RedshiftConnection conn) {
        throw new NotImplementedError();
    }

    public boolean executeInterruptibly(RedshiftConnection conn, String sql) {
        throw new NotImplementedError();
    }

    public RedshiftResults executeQueryInterruptibly(RedshiftConnection conn, String sql) {
        throw new NotImplementedError();
    }

    public long executeUpdateInterruptibly(RedshiftConnection conn, String sql) {
        throw new NotImplementedError();
    }

    public long executeUpdate(RedshiftConnection conn, String sql) {
        throw new NotImplementedError();
    }

    public RedshiftConnection getConnector(Parameters.MergedParameters params) {
        throw new NotImplementedError();
    }

    public RedshiftConnection getConnectorWithQueryGroup(Parameters.MergedParameters params, String queryGroup) {
        throw new NotImplementedError();
    }

    public StructType resolveTable(RedshiftConnection conn, String table, Option<Parameters.MergedParameters> params) {
        throw new NotImplementedError();
    }

    public Option<Parameters.MergedParameters> resolveTable$default$3() {
        return None$.MODULE$;
    }

    public boolean tableExists(RedshiftConnection conn, String table) {
        throw new NotImplementedError();
    }

    public StructType tableSchema(RedshiftConnection conn, RedshiftSQLStatement statement, Parameters.MergedParameters params) {
        throw new NotImplementedError();
    }

    public RedshiftWrapper() {
        this.MASTER_LOG_PREFIX = "Spark Connector Master";
        this.WORKER_LOG_PREFIX = "Spark Connector Worker";
    }
}

