/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift.data;

import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.TimestampNTZTypeExtractor$;
import io.github.spark_redshift_community.spark.redshift.data.DataAPIConnection;
import io.github.spark_redshift_community.spark.redshift.data.DataAPIConnection$;
import io.github.spark_redshift_community.spark.redshift.data.DataApiCommand;
import io.github.spark_redshift_community.spark.redshift.data.DataApiCommand$;
import io.github.spark_redshift_community.spark.redshift.data.DataApiResults;
import io.github.spark_redshift_community.spark.redshift.data.QueryParameter;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftConnection;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftResults;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftWrapper;
import io.github.spark_redshift_community.spark.redshift.package$;
import io.github.spark_redshift_community.spark.redshift.pushdown.BooleanVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.ByteVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.ConstantString;
import io.github.spark_redshift_community.spark.redshift.pushdown.DoubleVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.FloatVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.IntVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.LongVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.RedshiftSQLStatement;
import io.github.spark_redshift_community.spark.redshift.pushdown.ShortVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.StatementElement;
import io.github.spark_redshift_community.spark.redshift.pushdown.StringVariable;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse;

@ScalaSignature(bytes="\u0006\u0005\t]e!B\u0010!\u0001\tb\u0003\"\u0002!\u0001\t\u0003\t\u0005bB\"\u0001\u0005\u0004%\t\u0002\u0012\u0005\u0007\u001b\u0002\u0001\u000b\u0011B#\t\u00119\u0003\u0001R1A\u0005\f=C\u0001b\u0017\u0001\t\u0006\u0004%Y\u0001\u0018\u0005\tI\u0002A)\u0019!C\u0005K\")1\u000f\u0001C\u0005i\"9\u0011\u0011\u0003\u0001\u0005B\u0005M\u0001bBA\u0018\u0001\u0011\u0005\u0013\u0011\u0007\u0005\b\u0003k\u0001A\u0011IA\u001c\u0011\u001d\tY\u0004\u0001C\u0005\u0003{Aq!!\u0011\u0001\t\u0013\t\u0019\u0005\u0003\u0004t\u0001\u0011\u0005\u0013\u0011\r\u0005\b\u0003S\u0002A\u0011IA6\u0011\u001d\t9\b\u0001C!\u0003sBq!!\"\u0001\t\u0003\n9\tC\u0004\u0002\u000e\u0002!\t%a$\t\u000f\u0005]\u0006\u0001\"\u0011\u0002:\"9\u0011\u0011\u0019\u0001\u0005B\u0005\r\u0007bBAf\u0001\u0011\u0005\u0013Q\u001a\u0005\n\u0003_\u0004\u0011\u0013!C\u0001\u0003cDqAa\u0002\u0001\t\u0013\u0011I\u0001C\u0004\u0003\u0012\u0001!IAa\u0005\t\u0013\t5\u0002!%A\u0005\n\u0005E\bb\u0002B\u0018\u0001\u0011\u0005#\u0011\u0007\u0005\b\u0005\u000f\u0002A\u0011\u0002B%\u0011%\u0011\u0019\u0006AI\u0001\n\u0013\u0011)\u0006C\u0004\u0003Z\u0001!IAa\u0017\t\u000f\tm\u0004\u0001\"\u0003\u0003~!9!\u0011\u0011\u0001\u0005\n\t\r%A\u0004#bi\u0006\f\u0005/[,sCB\u0004XM\u001d\u0006\u0003C\t\nA\u0001Z1uC*\u00111\u0005J\u0001\te\u0016$7\u000f[5gi*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\n\u0001d\u001d9be.|&/\u001a3tQ&4GoX2p[6,h.\u001b;z\u0015\tI#&\u0001\u0004hSRDWO\u0019\u0006\u0002W\u0005\u0011\u0011n\\\n\u0004\u00015\n\u0004C\u0001\u00180\u001b\u0005\u0001\u0013B\u0001\u0019!\u0005=\u0011V\rZ:iS\u001a$xK]1qa\u0016\u0014\bC\u0001\u001a>\u001d\t\u0019$H\u0004\u00025q5\tQG\u0003\u00027o\u00051AH]8piz\u001a\u0001!C\u0001:\u0003\u0015\u00198-\u00197b\u0013\tYD(A\u0004qC\u000e\\\u0017mZ3\u000b\u0003eJ!AP \u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005mb\u0014A\u0002\u001fj]&$h\bF\u0001C!\tq\u0003!A\u0002m_\u001e,\u0012!\u0012\t\u0003\r.k\u0011a\u0012\u0006\u0003\u0011&\u000bQa\u001d7gi)T\u0011AS\u0001\u0004_J<\u0017B\u0001'H\u0005\u0019aunZ4fe\u0006!An\\4!\u0003M\u0019\u0017\r\u001c7Ok6\u0014WM]$f]\u0016\u0014\u0018\r^8s+\u0005\u0001\u0006c\u0001\u001aR'&\u0011!k\u0010\u0002\t\u0013R,'/\u0019;peB\u0011A+V\u0007\u0002y%\u0011a\u000b\u0010\u0002\u0004\u0013:$\bF\u0001\u0003Y!\t!\u0016,\u0003\u0002[y\tIAO]1og&,g\u000e^\u0001\u0003K\u000e,\u0012!\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0003Ar\n!bY8oGV\u0014(/\u001a8u\u0013\t\u0011wL\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\"\u0012Q\u0001W\u0001\u0010G\u0006t7-\u001a7mCRLwN\\'baV\ta\r\u0005\u0003h[>\u001cV\"\u00015\u000b\u0005\u0001L'B\u00016l\u0003\u0011)H/\u001b7\u000b\u00031\fAA[1wC&\u0011a\u000e\u001b\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bC\u0001\u0018q\u0013\t\t\bE\u0001\bECR\f\u0017\t]5D_6l\u0017M\u001c3)\u0005\u0019A\u0016\u0001F3yK\u000e,H/Z%oi\u0016\u0014(/\u001e9uS\nd\u00170\u0006\u0002vqR)a/a\u0001\u0002\bA\u0011q\u000f\u001f\u0007\u0001\t\u0015IxA1\u0001{\u0005\u0005!\u0016CA>\u007f!\t!F0\u0003\u0002~y\t9aj\u001c;iS:<\u0007C\u0001+\u0000\u0013\r\t\t\u0001\u0010\u0002\u0004\u0003:L\bBBA\u0003\u000f\u0001\u0007q.A\u0002d[\u0012Dq!!\u0003\b\u0001\u0004\tY!\u0001\u0002paB)A+!\u0004pm&\u0019\u0011q\u0002\u001f\u0003\u0013\u0019+hn\u0019;j_:\f\u0014!D:fi\u0006+Ho\\\"p[6LG\u000f\u0006\u0004\u0002\u0016\u0005m\u0011Q\u0005\t\u0004)\u0006]\u0011bAA\ry\t!QK\\5u\u0011\u001d\ti\u0002\u0003a\u0001\u0003?\tAaY8o]B\u0019a&!\t\n\u0007\u0005\r\u0002E\u0001\nSK\u0012\u001c\b.\u001b4u\u0007>tg.Z2uS>t\u0007bBA\u0014\u0011\u0001\u0007\u0011\u0011F\u0001\u000bCV$xnQ8n[&$\bc\u0001+\u0002,%\u0019\u0011Q\u0006\u001f\u0003\u000f\t{w\u000e\\3b]\u000611m\\7nSR$B!!\u0006\u00024!9\u0011QD\u0005A\u0002\u0005}\u0011\u0001\u0003:pY2\u0014\u0017mY6\u0015\t\u0005U\u0011\u0011\b\u0005\b\u0003;Q\u0001\u0019AA\u0010\u0003])\u00070Z2vi\u0016\u0014UO\u001a4fe\u0016$7i\\7nC:$7\u000f\u0006\u0003\u0002\u0016\u0005}\u0002bBA\u000f\u0017\u0001\u0007\u0011qD\u0001\rKb,7-\u001e;f\u0005\u0006$8\r\u001b\u000b\u0007\u0003S\t)%a\u0012\t\u000f\u0005uA\u00021\u0001\u0002 !9\u0011\u0011\n\u0007A\u0002\u0005-\u0013\u0001B:rYN\u0004RAMA'\u0003#J1!a\u0014@\u0005\r\u0019V-\u001d\t\u0005\u0003'\nYF\u0004\u0003\u0002V\u0005]\u0003C\u0001\u001b=\u0013\r\tI\u0006P\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0013q\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005eC\b\u0006\u0004\u0002*\u0005\r\u0014Q\r\u0005\b\u0003;i\u0001\u0019AA\u0010\u0011\u001d\t9'\u0004a\u0001\u0003#\n1a]9m\u0003e)\u00070Z2vi\u0016\fV/\u001a:z\u0013:$XM\u001d:vaRL'\r\\=\u0015\r\u00055\u00141OA;!\rq\u0013qN\u0005\u0004\u0003c\u0002#a\u0004*fIND\u0017N\u001a;SKN,H\u000e^:\t\u000f\u0005ua\u00021\u0001\u0002 !9\u0011q\r\bA\u0002\u0005E\u0013AG3yK\u000e,H/Z+qI\u0006$X-\u00138uKJ\u0014X\u000f\u001d;jE2LHCBA>\u0003\u0003\u000b\u0019\tE\u0002U\u0003{J1!a =\u0005\u0011auN\\4\t\u000f\u0005uq\u00021\u0001\u0002 !9\u0011qM\bA\u0002\u0005E\u0013!D3yK\u000e,H/Z+qI\u0006$X\r\u0006\u0004\u0002|\u0005%\u00151\u0012\u0005\b\u0003;\u0001\u0002\u0019AA\u0010\u0011\u001d\t9\u0007\u0005a\u0001\u0003#\nAbZ3u\u0007>tg.Z2u_J$B!a\b\u0002\u0012\"9\u00111S\tA\u0002\u0005U\u0015A\u00029be\u0006l7\u000f\u0005\u0003\u0002\u0018\u0006Ef\u0002BAM\u0003[sA!a'\u0002,:!\u0011QTAU\u001d\u0011\ty*a*\u000f\t\u0005\u0005\u0016Q\u0015\b\u0004i\u0005\r\u0016\"A\u0016\n\u0005%R\u0013BA\u0014)\u0013\t)c%\u0003\u0002$I%\u0019\u0011q\u0016\u0012\u0002\u0015A\u000b'/Y7fi\u0016\u00148/\u0003\u0003\u00024\u0006U&\u0001E'fe\u001e,G\rU1sC6,G/\u001a:t\u0015\r\tyKI\u0001\u001bO\u0016$8i\u001c8oK\u000e$xN],ji\"\fV/\u001a:z\u000fJ|W\u000f\u001d\u000b\u0007\u0003?\tY,!0\t\u000f\u0005M%\u00031\u0001\u0002\u0016\"9\u0011q\u0018\nA\u0002\u0005E\u0013AC9vKJLxI]8va\u0006YA/\u00192mK\u0016C\u0018n\u001d;t)\u0019\tI#!2\u0002H\"9\u0011QD\nA\u0002\u0005}\u0001bBAe'\u0001\u0007\u0011\u0011K\u0001\u0006i\u0006\u0014G.Z\u0001\re\u0016\u001cx\u000e\u001c<f)\u0006\u0014G.\u001a\u000b\t\u0003\u001f\f\u0019/!:\u0002hB!\u0011\u0011[Ap\u001b\t\t\u0019N\u0003\u0003\u0002V\u0006]\u0017!\u0002;za\u0016\u001c(\u0002BA4\u00033T1!JAn\u0015\r\ti.S\u0001\u0007CB\f7\r[3\n\t\u0005\u0005\u00181\u001b\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA\u000f)\u0001\u0007\u0011q\u0004\u0005\b\u0003\u0013$\u0002\u0019AA)\u0011%\t\u0019\n\u0006I\u0001\u0002\u0004\tI\u000fE\u0003U\u0003W\f)*C\u0002\u0002nr\u0012aa\u00149uS>t\u0017A\u0006:fg>dg/\u001a+bE2,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005M(\u0006BAu\u0003k\\#!a>\u0011\t\u0005e(1A\u0007\u0003\u0003wTA!!@\u0002\u0000\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u0003a\u0014AC1o]>$\u0018\r^5p]&!!QAA~\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0015e\u0016\u001cx\u000e\u001c<f)\u0006\u0014G.\u001a$s_6lU\r^1\u0015\r\u0005='1\u0002B\b\u0011\u001d\u0011iA\u0006a\u0001\u0003[\nqA]3tk2$8\u000fC\u0004\u0002\u0014Z\u0001\r!!&\u0002\u001f\u001d,GoQ1uC2L8\u000f\u001e+za\u0016$BB!\u0006\u0003\u001c\t}!1\u0005B\u0014\u0005W\u0001B!!5\u0003\u0018%!!\u0011DAj\u0005!!\u0015\r^1UsB,\u0007b\u0002B\u000f/\u0001\u0007\u0011\u0011K\u0001\re\u0016$7\u000f[5giRK\b/\u001a\u0005\u0007\u0005C9\u0002\u0019A*\u0002\u0013A\u0014XmY5tS>t\u0007B\u0002B\u0013/\u0001\u00071+A\u0003tG\u0006dW\rC\u0004\u0003*]\u0001\r!!\u000b\u0002\rMLwM\\3e\u0011%\t\u0019j\u0006I\u0001\u0002\u0004\tI/A\rhKR\u001c\u0015\r^1msN$H+\u001f9fI\u0011,g-Y;mi\u0012*\u0014a\u0003;bE2,7k\u00195f[\u0006$\u0002\"a4\u00034\tU\"Q\t\u0005\b\u0003;I\u0002\u0019AA\u0010\u0011\u001d\u00119$\u0007a\u0001\u0005s\t\u0011b\u001d;bi\u0016lWM\u001c;\u0011\t\tm\"\u0011I\u0007\u0003\u0005{Q1Aa\u0010#\u0003!\u0001Xo\u001d5e_^t\u0017\u0002\u0002B\"\u0005{\u0011ACU3eg\"Lg\r^*R\u0019N#\u0018\r^3nK:$\bbBAJ3\u0001\u0007\u0011QS\u0001\u001bi\u0006\u0014G.Z'fi\u0006$\u0015\r^1Ge>l7\u000b^1uK6,g\u000e\u001e\u000b\t\u0003[\u0012YE!\u0014\u0003P!9\u0011Q\u0004\u000eA\u0002\u0005}\u0001b\u0002B\u001c5\u0001\u0007!\u0011\b\u0005\n\u0005#R\u0002\u0013!a\u0001\u0003S\t1CY5oIZ\u000b'/[1cY\u0016,e.\u00192mK\u0012\fA\u0005^1cY\u0016lU\r^1ECR\fgI]8n'R\fG/Z7f]R$C-\u001a4bk2$HeM\u000b\u0003\u0005/RC!!\u000b\u0002v\u0006\u0001\u0002O]3qCJ,7\u000b^1uK6,g\u000e\u001e\u000b\u0007\u0005;\u0012)H!\u001f\u0011\u000fQ\u0013y&!\u0015\u0003d%\u0019!\u0011\r\u001f\u0003\rQ+\b\u000f\\33!\u0015!\u00161\u001eB3!\u0015\u0011\u0014Q\nB4a\u0011\u0011IG!\u001d\u0011\u000b9\u0012YGa\u001c\n\u0007\t5\u0004E\u0001\bRk\u0016\u0014\u0018\u0010U1sC6,G/\u001a:\u0011\u0007]\u0014\t\b\u0002\u0006\u0003tq\t\t\u0011!A\u0003\u0002i\u00141a\u0018\u00132\u0011\u001d\u00119\b\ba\u0001\u0005s\tAb]9m'R\fG/Z7f]RDqA!\u0015\u001d\u0001\u0004\tI#\u0001\u000eqe\u0016\u0004\u0018M]3XSRDw.\u001e;CS:$g+\u0019:jC\ndW\r\u0006\u0003\u0002R\t}\u0004b\u0002B<;\u0001\u0007!\u0011H\u0001\u0018aJ,\u0007/\u0019:f/&$\bNQ5oIZ\u000b'/[1cY\u0016$BA!\"\u0003\u0016B9AKa\u0018\u0002R\t\u001d\u0005#\u0002+\u0002l\n%\u0005#\u0002\u001a\u0002N\t-\u0005\u0007\u0002BG\u0005#\u0003RA\fB6\u0005\u001f\u00032a\u001eBI\t)\u0011\u0019JHA\u0001\u0002\u0003\u0015\tA\u001f\u0002\u0004?\u0012\u0012\u0004b\u0002B<=\u0001\u0007!\u0011\b")
public class DataApiWrapper
extends RedshiftWrapper {
    private transient Iterator<Object> callNumberGenerator;
    private transient ExecutionContext ec;
    private transient ConcurrentHashMap<DataApiCommand, Object> cancellationMap;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile transient byte bitmap$trans$0;

    public Logger log() {
        return this.log;
    }

    private Iterator<Object> callNumberGenerator$lzycompute() {
        DataApiWrapper dataApiWrapper = this;
        synchronized (dataApiWrapper) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.callNumberGenerator = scala.package$.MODULE$.Iterator().from(1);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.callNumberGenerator;
    }

    private Iterator<Object> callNumberGenerator() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.callNumberGenerator$lzycompute();
        }
        return this.callNumberGenerator;
    }

    private ExecutionContext ec$lzycompute() {
        DataApiWrapper dataApiWrapper = this;
        synchronized (dataApiWrapper) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                ThreadFactory threadFactory = new ThreadFactory(null){
                    private final AtomicInteger count;

                    public Thread newThread(Runnable r) {
                        Thread thread = new Thread(r);
                        thread.setName("spark-redshift-DataApiWrapper-" + this.count.incrementAndGet());
                        thread.setDaemon(true);
                        return thread;
                    }
                    {
                        this.count = new AtomicInteger();
                    }
                };
                this.ec = ExecutionContext$.MODULE$.fromExecutorService(Executors.newCachedThreadPool(threadFactory));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.ec;
    }

    private ExecutionContext ec() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.ec$lzycompute();
        }
        return this.ec;
    }

    private ConcurrentHashMap<DataApiCommand, Object> cancellationMap$lzycompute() {
        DataApiWrapper dataApiWrapper = this;
        synchronized (dataApiWrapper) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.cancellationMap = new ConcurrentHashMap();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.cancellationMap;
    }

    private ConcurrentHashMap<DataApiCommand, Object> cancellationMap() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.cancellationMap$lzycompute();
        }
        return this.cancellationMap;
    }

    private <T> T executeInterruptibly(DataApiCommand cmd, Function1<DataApiCommand, T> op) {
        Object object;
        int callNumber = BoxesRunTime.unboxToInt((Object)this.callNumberGenerator().next());
        try {
            try {
                this.log().info("Begin Redshift Data API call {}", (Object)BoxesRunTime.boxToInteger((int)callNumber));
                this.cancellationMap().put(cmd, BoxesRunTime.boxToInteger((int)callNumber));
                Future future = Future$.MODULE$.apply((Function0 & Serializable)() -> op.apply((Object)cmd), this.ec());
                try {
                    object = Await$.MODULE$.result((Awaitable)future, (Duration)Duration$.MODULE$.Inf());
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 instanceof SQLException) {
                        SQLException sQLException = (SQLException)throwable3;
                        throw new SQLException("Exception thrown in awaitResult: ", sQLException);
                    }
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        throw new Exception("Exception thrown in awaitResult: ", throwable2);
                    }
                    throw throwable;
                }
            }
            catch (InterruptedException e) {
                try {
                    cmd.cancel();
                    throw e;
                }
                catch (SQLException s) {
                    this.log().error("Exception occurred while cancelling query: {}", (Object)s.getMessage());
                    throw e;
                }
            }
        }
        finally {
            this.cancellationMap().remove(cmd);
            this.log().info("End Redshift Data API call {}", (Object)BoxesRunTime.boxToInteger((int)callNumber));
        }
        return (T)object;
    }

    @Override
    public void setAutoCommit(RedshiftConnection conn, boolean autoCommit) {
        if (conn.getAutoCommit() != autoCommit) {
            conn.setAutoCommit(autoCommit);
            this.executeBufferedCommands(conn);
            return;
        }
    }

    @Override
    public void commit(RedshiftConnection conn) {
        if (conn.getAutoCommit()) {
            throw new IllegalStateException("Cannot commit when autoCommit is enabled.");
        }
        this.executeBufferedCommands(conn);
    }

    @Override
    public void rollback(RedshiftConnection conn) {
        if (conn.getAutoCommit()) {
            throw new IllegalStateException("Cannot rollback when autoCommit is enabled.");
        }
        DataAPIConnection dataApiConnection = (DataAPIConnection)conn;
        dataApiConnection.bufferedCommands().clear();
    }

    private void executeBufferedCommands(RedshiftConnection conn) {
        DataAPIConnection dataApiConnection = (DataAPIConnection)conn;
        if (dataApiConnection.bufferedCommands().length() > 0) {
            this.executeBatch(conn, (scala.collection.immutable.Seq<String>)dataApiConnection.bufferedCommands().toSeq());
            dataApiConnection.bufferedCommands().clear();
            return;
        }
    }

    private boolean executeBatch(RedshiftConnection conn, scala.collection.immutable.Seq<String> sqls) {
        DataAPIConnection dataApiConnection = (DataAPIConnection)conn;
        return BoxesRunTime.unboxToBoolean(this.executeInterruptibly(new DataApiCommand(dataApiConnection, DataApiCommand$.MODULE$.$lessinit$greater$default$2()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.executeBatch((Seq<String>)sqls))));
    }

    @Override
    public boolean executeInterruptibly(RedshiftConnection conn, String sql) {
        DataAPIConnection dataApiConnection = (DataAPIConnection)conn;
        if (!conn.getAutoCommit()) {
            this.log().info("Buffering statement for batch execution later since auto-commit is disabled.");
            dataApiConnection.bufferedCommands().append((Object)sql);
            return false;
        }
        return BoxesRunTime.unboxToBoolean(this.executeInterruptibly(new DataApiCommand(dataApiConnection, DataApiCommand$.MODULE$.$lessinit$greater$default$2()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.execute(sql))));
    }

    @Override
    public RedshiftResults executeQueryInterruptibly(RedshiftConnection conn, String sql) {
        if (!conn.getAutoCommit()) {
            throw new IllegalStateException("Cannot execute queries while not in auto-commit mode!");
        }
        DataAPIConnection dataApiConnection = (DataAPIConnection)conn;
        return (RedshiftResults)this.executeInterruptibly(new DataApiCommand(dataApiConnection, DataApiCommand$.MODULE$.$lessinit$greater$default$2()), (Function1 & Serializable)x$3 -> x$3.executeQueryInterruptibly(sql));
    }

    @Override
    public long executeUpdateInterruptibly(RedshiftConnection conn, String sql) {
        DataAPIConnection dataApiConnection = (DataAPIConnection)conn;
        if (!conn.getAutoCommit()) {
            this.log().info("Buffering statement for batch execution later since auto-commit is disabled.");
            dataApiConnection.bufferedCommands().append((Object)sql);
            return 0L;
        }
        return BoxesRunTime.unboxToLong(this.executeInterruptibly(new DataApiCommand(dataApiConnection, DataApiCommand$.MODULE$.$lessinit$greater$default$2()), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.executeUpdate(sql))));
    }

    @Override
    public long executeUpdate(RedshiftConnection conn, String sql) {
        DataAPIConnection dataApiConnection = (DataAPIConnection)conn;
        if (!conn.getAutoCommit()) {
            this.log().info("Buffering statement for batch execution later since auto-commit is disabled.");
            dataApiConnection.bufferedCommands().append((Object)sql);
            return 0L;
        }
        return BoxesRunTime.unboxToLong(this.executeInterruptibly(new DataApiCommand(dataApiConnection, DataApiCommand$.MODULE$.$lessinit$greater$default$2()), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.executeUpdate(sql))));
    }

    @Override
    public RedshiftConnection getConnector(Parameters.MergedParameters params) {
        return new DataAPIConnection(params, DataAPIConnection$.MODULE$.apply$default$2());
    }

    @Override
    public RedshiftConnection getConnectorWithQueryGroup(Parameters.MergedParameters params, String queryGroup) {
        return new DataAPIConnection(params, (Option<String>)Option$.MODULE$.apply((Object)queryGroup));
    }

    @Override
    public boolean tableExists(RedshiftConnection conn, String table) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> {
            String sql = "SELECT 1 FROM " + table + " LIMIT 1";
            GetStatementResultResponse results = ((DataApiResults)this.executeInterruptibly(new DataApiCommand((DataAPIConnection)conn, DataApiCommand$.MODULE$.$lessinit$greater$default$2()), (Function1 & Serializable)x$6 -> x$6.executeQueryInterruptibly(sql))).results();
            return ((SeqOps)JavaConverters$.MODULE$.asScalaBufferConverter(results.columnMetadata()).asScala()).length();
        }).isSuccess();
    }

    @Override
    public StructType resolveTable(RedshiftConnection conn, String table, Option<Parameters.MergedParameters> params) {
        this.log().info("Getting schema from Redshift for table: {}", (Object)table);
        DataApiResults res = (DataApiResults)this.executeQueryInterruptibly(conn, "SELECT * FROM " + table + " LIMIT 1");
        Buffer rsmd = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(res.results().columnMetadata()).asScala();
        int ncols = rsmd.length();
        StructField[] fields = new StructField[ncols];
        for (int i = 0; i < ncols; ++i) {
            ColumnMetadata colmd = (ColumnMetadata)rsmd.apply(i);
            String columnName = colmd.label();
            String rsType = colmd.typeName();
            Integer fieldSize = colmd.precision();
            Integer fieldScale = colmd.scale();
            Boolean isSigned = colmd.isSigned();
            boolean nullable = params.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.overrideNullable())) ? true : !BoxesRunTime.equalsNumObject((Number)colmd.nullable(), (Object)BoxesRunTime.boxToInteger((int)0));
            DataType columnType = this.getCatalystType(rsType, Predef$.MODULE$.Integer2int(fieldSize), Predef$.MODULE$.Integer2int(fieldScale), Predef$.MODULE$.Boolean2boolean(isSigned), params);
            Metadata meta = new MetadataBuilder().putString("redshift_type", rsType).build();
            fields[i] = new StructField(columnName, columnType, nullable, meta);
        }
        return new StructType(fields);
    }

    @Override
    public Option<Parameters.MergedParameters> resolveTable$default$3() {
        return None$.MODULE$;
    }

    private StructType resolveTableFromMeta(RedshiftResults results, Parameters.MergedParameters params) {
        Buffer rsmd = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((DataApiResults)results).results().columnMetadata()).asScala();
        int ncols = rsmd.length();
        StructField[] fields = new StructField[ncols];
        for (int i = 0; i < ncols; ++i) {
            ColumnMetadata colmd = (ColumnMetadata)rsmd.apply(i);
            String columnName = colmd.label();
            String rsType = colmd.typeName();
            Integer fieldSize = colmd.precision();
            Integer fieldScale = colmd.scale();
            Boolean isSigned = colmd.isSigned();
            boolean nullable = !BoxesRunTime.equalsNumObject((Number)colmd.nullable(), (Object)BoxesRunTime.boxToInteger((int)0));
            DataType columnType = this.getCatalystType(rsType, Predef$.MODULE$.Integer2int(fieldSize), Predef$.MODULE$.Integer2int(fieldScale), Predef$.MODULE$.Boolean2boolean(isSigned), (Option<Parameters.MergedParameters>)new Some((Object)params));
            Metadata meta = new MetadataBuilder().putString("redshift_type", rsType).build();
            fields[i] = new StructField((String)(columnName.matches("[_A-Z]([_0-9A-Z])*") ? columnName : "\"" + columnName + "\""), columnType, nullable, meta);
        }
        return new StructType(fields);
    }

    private DataType getCatalystType(String redshiftType, int precision, int scale, boolean signed, Option<Parameters.MergedParameters> params) {
        StringType$ answer;
        block34: {
            Object object;
            String string = redshiftType;
            switch (string == null ? 0 : string.hashCode()) {
                case -2000413939: {
                    if (!"numeric".equals(string) || precision == 0 && scale == 0) break;
                    object = new DecimalType(precision, scale);
                    break block34;
                }
                case -1382823772: {
                    if (!"bpchar".equals(string)) break;
                    object = StringType$.MODULE$;
                    break block34;
                }
                case -1271649960: {
                    if (!"float4".equals(string)) break;
                    object = params.exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.legacyJdbcRealTypeMapping())) ? DoubleType$.MODULE$ : FloatType$.MODULE$;
                    break block34;
                }
                case -1271649956: {
                    if (!"float8".equals(string)) break;
                    object = DoubleType$.MODULE$;
                    break block34;
                }
                case -1233260552: {
                    if (!"time with time zone".equals(string)) break;
                    object = TimestampType$.MODULE$;
                    break block34;
                }
                case -1198484871: {
                    if (!"character varying".equals(string)) break;
                    object = StringType$.MODULE$;
                    break block34;
                }
                case -1191034305: {
                    if (!"abstime".equals(string)) break;
                    object = TimestampType$.MODULE$;
                    break block34;
                }
                case -873668077: {
                    if (!"timetz".equals(string)) break;
                    object = TimestampType$.MODULE$;
                    break block34;
                }
                case -805895441: {
                    if (!"double precision".equals(string)) break;
                    object = DoubleType$.MODULE$;
                    break block34;
                }
                case -510877388: {
                    if (!"time without time zone".equals(string)) break;
                    object = TimestampType$.MODULE$;
                    break block34;
                }
                case 97549: {
                    if (!"bit".equals(string)) break;
                    object = BooleanType$.MODULE$;
                    break block34;
                }
                case 110026: {
                    if (!"oid".equals(string)) break;
                    object = signed ? LongType$.MODULE$ : new DecimalType(20, 0);
                    break block34;
                }
                case 114831: {
                    if (!"tid".equals(string)) break;
                    object = StringType$.MODULE$;
                    break block34;
                }
                case 118675: {
                    if (!"xid".equals(string)) break;
                    object = signed ? LongType$.MODULE$ : new DecimalType(20, 0);
                    break block34;
                }
                case 3029738: {
                    if (!"bool".equals(string)) break;
                    object = BooleanType$.MODULE$;
                    break block34;
                }
                case 3052374: {
                    if (!"char".equals(string)) break;
                    object = StringType$.MODULE$;
                    break block34;
                }
                case 3076014: {
                    if (!"date".equals(string)) break;
                    object = DateType$.MODULE$;
                    break block34;
                }
                case 3237411: {
                    if (!"int2".equals(string)) break;
                    object = params.exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.legacyMappingShortToInt())) ? IntegerType$.MODULE$ : ShortType$.MODULE$;
                    break block34;
                }
                case 3237413: {
                    if (!"int4".equals(string)) break;
                    object = signed ? IntegerType$.MODULE$ : LongType$.MODULE$;
                    break block34;
                }
                case 3237417: {
                    if (!"int8".equals(string)) break;
                    object = signed ? LongType$.MODULE$ : new DecimalType(20, 0);
                    break block34;
                }
                case 3373707: {
                    if (!"name".equals(string)) break;
                    object = StringType$.MODULE$;
                    break block34;
                }
                case 3556653: {
                    if (!"text".equals(string)) break;
                    object = StringType$.MODULE$;
                    break block34;
                }
                case 3560141: {
                    if (!"time".equals(string)) break;
                    object = TimestampType$.MODULE$;
                    break block34;
                }
                case 55126294: {
                    if (!"timestamp".equals(string)) break;
                    object = package$.MODULE$.legacyTimestampHandling() ? TimestampType$.MODULE$ : TimestampNTZTypeExtractor$.MODULE$.defaultType();
                    break block34;
                }
                case 104079552: {
                    if (!"money".equals(string)) break;
                    object = DoubleType$.MODULE$;
                    break block34;
                }
                case 109801339: {
                    if (!"super".equals(string)) break;
                    object = StringType$.MODULE$;
                    break block34;
                }
                case 236613373: {
                    if (!"varchar".equals(string)) break;
                    object = StringType$.MODULE$;
                    break block34;
                }
                case 392943421: {
                    if (!"timestamp without time zone".equals(string)) break;
                    object = package$.MODULE$.legacyTimestampHandling() ? TimestampType$.MODULE$ : TimestampNTZTypeExtractor$.MODULE$.defaultType();
                    break block34;
                }
                case 792501903: {
                    if (!"timestamp with time zone".equals(string)) break;
                    object = TimestampType$.MODULE$;
                    break block34;
                }
                case 1436764700: {
                    if (!"timestamptz".equals(string)) break;
                    object = TimestampType$.MODULE$;
                    break block34;
                }
                case 1578143629: {
                    if (!"oidvector".equals(string)) break;
                    object = StringType$.MODULE$;
                    break block34;
                }
            }
            object = answer = null;
        }
        if (answer == null) {
            throw new SQLException("Unsupported type " + redshiftType);
        }
        return answer;
    }

    private Option<Parameters.MergedParameters> getCatalystType$default$5() {
        return None$.MODULE$;
    }

    @Override
    public StructType tableSchema(RedshiftConnection conn, RedshiftSQLStatement statement, Parameters.MergedParameters params) {
        return this.resolveTableFromMeta(this.tableMetaDataFromStatement(conn, statement, this.tableMetaDataFromStatement$default$3()), params);
    }

    private RedshiftResults tableMetaDataFromStatement(RedshiftConnection conn, RedshiftSQLStatement statement, boolean bindVariableEnabled) {
        RedshiftSQLStatement sqlStatement = new ConstantString("select * from").$plus(statement).$plus("where 1 = 0");
        Tuple2<String, Option<scala.collection.immutable.Seq<QueryParameter<?>>>> tuple2 = this.prepareStatement(sqlStatement, bindVariableEnabled);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String query = (String)tuple2._1();
        Option params = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)query, (Object)params);
        String query2 = (String)tuple22._1();
        Option params2 = (Option)tuple22._2();
        DataAPIConnection dataApiConnection = (DataAPIConnection)conn;
        return (RedshiftResults)this.executeInterruptibly(new DataApiCommand(dataApiConnection, params2), (Function1 & Serializable)x$11 -> x$11.executeQueryInterruptibly(query2));
    }

    private boolean tableMetaDataFromStatement$default$3() {
        return true;
    }

    private Tuple2<String, Option<scala.collection.immutable.Seq<QueryParameter<?>>>> prepareStatement(RedshiftSQLStatement sqlStatement, boolean bindVariableEnabled) {
        if (bindVariableEnabled) {
            return this.prepareWithBindVariable(sqlStatement);
        }
        return new Tuple2((Object)this.prepareWithoutBindVariable(sqlStatement), (Object)None$.MODULE$);
    }

    private String prepareWithoutBindVariable(RedshiftSQLStatement sqlStatement) {
        List sql = sqlStatement.list().reverse();
        String query = ((StringBuilder)sql.foldLeft((Object)new StringBuilder(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                StringBuilder buffer = (StringBuilder)tuple2._1();
                StatementElement statement = (StatementElement)tuple2._2();
                buffer.append(statement instanceof ConstantString ? statement : statement.sql());
                return buffer.append(" ");
            }
            throw new MatchError((Object)tuple2);
        })).toString();
        String logPrefix = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(this.MASTER_LOG_PREFIX() + ":\n         | execute query without bind variable:\n         |"))), (Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DataApiWrapper.$anonfun$prepareWithoutBindVariable$2(BoxesRunTime.unboxToChar((Object)x$12))));
        return query;
    }

    private Tuple2<String, Option<scala.collection.immutable.Seq<QueryParameter<?>>>> prepareWithBindVariable(RedshiftSQLStatement sqlStatement) {
        List sql = sqlStatement.list().reverse();
        StatementElement[] varArray = new StatementElement[sqlStatement.numOfVar()];
        IntRef indexOfVar = IntRef.create((int)0);
        StringBuilder buffer = new StringBuilder();
        sql.foreach((Function1 & Serializable)element -> {
            if (element instanceof ConstantString) {
                v0 = buffer.append(element);
            } else {
                buffer.append(":param" + indexOfVar$1.elem);
                varArray$1[indexOfVar$1.elem] = element;
                ++indexOfVar$1.elem;
                v0 = BoxedUnit.UNIT;
            }
            return buffer.append(" ");
        });
        String query = buffer.toString();
        if (varArray.length == 0) {
            return new Tuple2((Object)query, (Object)None$.MODULE$);
        }
        String logPrefix = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(this.MASTER_LOG_PREFIX() + ":\n         | execute query with bind variable:\n         |"))), (Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)DataApiWrapper.$anonfun$prepareWithBindVariable$2(BoxesRunTime.unboxToChar((Object)x$13))));
        ArrayBuffer parameters = new ArrayBuffer();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])varArray))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                QueryParameter<Object> queryParameter;
                StatementElement element = (StatementElement)tuple2._1();
                int index = tuple2._2$mcI$sp();
                String name = "param" + index;
                StatementElement statementElement = element;
                if (statementElement instanceof StringVariable) {
                    StringVariable stringVariable = (StringVariable)statementElement;
                    queryParameter = new QueryParameter<Object>(name, stringVariable.variable(), 12);
                } else if (statementElement instanceof IntVariable) {
                    IntVariable intVariable = (IntVariable)statementElement;
                    queryParameter = new QueryParameter<Object>(name, intVariable.variable(), 4);
                } else if (statementElement instanceof LongVariable) {
                    LongVariable longVariable = (LongVariable)statementElement;
                    queryParameter = new QueryParameter<Object>(name, longVariable.variable(), -5);
                } else if (statementElement instanceof ShortVariable) {
                    ShortVariable shortVariable = (ShortVariable)statementElement;
                    queryParameter = new QueryParameter<Object>(name, shortVariable.variable(), 5);
                } else if (statementElement instanceof FloatVariable) {
                    FloatVariable floatVariable = (FloatVariable)statementElement;
                    queryParameter = new QueryParameter<Object>(name, floatVariable.variable(), 6);
                } else if (statementElement instanceof DoubleVariable) {
                    DoubleVariable doubleVariable = (DoubleVariable)statementElement;
                    queryParameter = new QueryParameter<Object>(name, doubleVariable.variable(), 8);
                } else if (statementElement instanceof BooleanVariable) {
                    BooleanVariable booleanVariable = (BooleanVariable)statementElement;
                    queryParameter = new QueryParameter<Object>(name, booleanVariable.variable(), 16);
                } else if (statementElement instanceof ByteVariable) {
                    ByteVariable byteVariable = (ByteVariable)statementElement;
                    queryParameter = new QueryParameter<Object>(name, byteVariable.variable(), -6);
                } else {
                    throw new IllegalArgumentException("Unexpected Element Type: " + element.getClass().getName());
                }
                return (ArrayBuffer)parameters.$plus$eq(queryParameter);
            }
            throw new MatchError((Object)tuple2);
        });
        return new Tuple2((Object)query, (Object)Option$.MODULE$.apply((Object)parameters.toSeq()));
    }

    public static final /* synthetic */ void $anonfun$new$2(DataApiWrapper $this, DataApiCommand statement, int callNumber) {
        try {
            $this.log().info("Cancelling pending Data API call {}", (Object)BoxesRunTime.boxToInteger((int)callNumber));
            statement.cancel();
        }
        catch (Throwable e) {
            $this.log().error("Exception occurred while cancelling Data API request: {}", (Object)e.getMessage());
        }
    }

    public static final /* synthetic */ boolean $anonfun$prepareWithoutBindVariable$2(char x$12) {
        return x$12 >= ' ';
    }

    public static final /* synthetic */ boolean $anonfun$prepareWithBindVariable$2(char x$13) {
        return x$13 >= ' ';
    }

    public DataApiWrapper() {
        scala.sys.package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable)() -> this.cancellationMap().forEach((statement, callNumber) -> DataApiWrapper.$anonfun$new$2(this, statement, BoxesRunTime.unboxToInt((Object)callNumber))));
    }
}

