/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import io.github.spark_redshift_community.spark.redshift.BuildInfo$;
import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.Parameters$;
import io.github.spark_redshift_community.spark.redshift.RedshiftConstraintViolationException;
import io.github.spark_redshift_community.spark.redshift.Utils;
import io.github.spark_redshift_community.spark.redshift.data.JDBCWrapper$;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataClient;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataClientBuilder;
import software.amazon.awssdk.services.s3.S3BaseClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLocationRequest;
import software.amazon.awssdk.services.s3.model.LifecycleRule;

public final class Utils$ {
    public static final Utils$ MODULE$ = new Utils$();
    private static final Logger log = LoggerFactory.getLogger(MODULE$.getClass());
    private static final Map<String, String> lastBuildStmt = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private static String lastTempPathGenerated = null;
    private static final String CONNECTOR_REJECT_UNSECURE_JDBC_CONNECTION = "spark.datasource.redshift.community.reject_unsecure_jdbc_connection";
    private static final String CONNECTOR_REDSHIFT_S3_CONNECTION_IAM_ROLE_ONLY = "spark.datasource.redshift.community.redshift_s3_connection_iam_role_only";
    private static final String CONNECTOR_DATA_API_ENDPOINT = "spark.datasource.redshift.community.data_api_endpoint";
    private static final String CONNECTOR_SERVICE_NAME_ENV_VAR = "AWS_SPARK_REDSHIFT_CONNECTOR_SERVICE_NAME";
    private static final String DEFAULT_APP_NAME = "SparkRedshiftConnector";
    private static final String CONNECTOR_TRACE_ID_ENV_VAR = "AWS_SPARK_REDSHIFT_CONNECTOR_TRACE_ID";
    private static final String CONNECTOR_TRACE_ID_SPARK_CONF = "spark.datasource.redshift.community.trace_id";
    private static final String CONNECTOR_LABEL_SPARK_CONF = "spark.datasource.redshift.community.label";

    private Logger log() {
        return log;
    }

    public Map<String, String> lastBuildStmt() {
        return lastBuildStmt;
    }

    public Class<?> classForName(String className) {
        ClassLoader classLoader = (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0 & Serializable)() -> MODULE$.getClass().getClassLoader());
        return Class.forName(className, true, classLoader);
    }

    public String joinUrls(String a, String b) {
        return StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(a), "/") + "/" + StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(b), "/")), "/") + "/";
    }

    public String fixS3Url(String url) {
        return url.replaceAll("s3[an]://", "s3://");
    }

    private Utils.S3Location parseS3Location(String url) {
        Utils.S3Location s3Location;
        try {
            Tuple2<String, String> tuple2;
            URI uri = new URI(url);
            String string = uri.getScheme();
            String string2 = "s3";
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new IllegalArgumentException("Not an S3 URI: " + url);
            }
            String string3 = uri.getHost();
            String string4 = "s3.amazonaws.com";
            Tuple2<String, String> tuple22 = !(string3 != null ? !string3.equals(string4) : string4 != null) ? this.parsePathStyleUrl(uri) : (tuple2 = this.parseVirtualHostedUrl(uri));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String bucket = (String)tuple2._1();
            String key = (String)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)bucket, (Object)key);
            String bucket2 = (String)tuple23._1();
            String key2 = (String)tuple23._2();
            Predef$.MODULE$.assert(bucket2 != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(bucket2)), (Function0 & Serializable)() -> "Could not get bucket from S3 URI");
            s3Location = new Utils.S3Location(bucket2, key2);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid S3 URI: " + url, e);
        }
        return s3Location;
    }

    private Tuple2<String, String> parsePathStyleUrl(URI uri) {
        String path = (String)Option$.MODULE$.apply((Object)uri.getPath()).map((Function1 & Serializable)x$2 -> StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(x$2), "/")).getOrElse((Function0 & Serializable)() -> "");
        int firstSlash = path.indexOf(47);
        if (firstSlash == -1) {
            return new Tuple2((Object)path, (Object)"");
        }
        return new Tuple2((Object)path.substring(0, firstSlash), (Object)path.substring(firstSlash + 1));
    }

    private Tuple2<String, String> parseVirtualHostedUrl(URI uri) {
        String key = (String)Option$.MODULE$.apply((Object)uri.getPath()).map((Function1 & Serializable)x$3 -> StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(x$3), "/")).getOrElse((Function0 & Serializable)() -> "");
        return new Tuple2((Object)uri.getHost(), (Object)key);
    }

    public String addEndpointToUrl(String url, String domain) {
        URI uri = new URI(url);
        String hostWithEndpoint = uri.getHost() + "." + domain;
        return new URI(uri.getScheme(), uri.getUserInfo(), hostWithEndpoint, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
    }

    public String addEndpointToUrl$default$2() {
        return "s3.amazonaws.com";
    }

    public URI removeCredentialsFromURI(URI uri) {
        return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    public String lastTempPathGenerated() {
        return lastTempPathGenerated;
    }

    public void lastTempPathGenerated_$eq(String x$1) {
        lastTempPathGenerated = x$1;
    }

    public String makeTempPath(String tempRoot) {
        String _lastTempPathGenerated = this.joinUrls(tempRoot, UUID.randomUUID().toString());
        this.lastTempPathGenerated_$eq(_lastTempPathGenerated);
        return _lastTempPathGenerated;
    }

    public boolean checkThatBucketHasObjectLifecycleConfiguration(Parameters.MergedParameters params, S3Client s3Client) {
        boolean bl;
        try {
            Utils.S3Location s3Location = this.parseS3Location(this.fixS3Url(params.rootTempDir()));
            GetBucketLifecycleConfigurationRequest request = (GetBucketLifecycleConfigurationRequest)GetBucketLifecycleConfigurationRequest.builder().bucket(s3Location.bucket()).build();
            Seq rules = (Seq)Option$.MODULE$.apply((Object)s3Client.getBucketLifecycleConfiguration(request)).map((Function1 & Serializable)x$4 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$4.rules()).asScala()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
            boolean hasMatchingBucketLifecycleRule = rules.exists((Function1 & Serializable)rule -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$checkThatBucketHasObjectLifecycleConfiguration$3(s3Location, rule)));
            if (!hasMatchingBucketLifecycleRule) {
                this.log().warn("The S3 bucket " + s3Location.bucket() + " does not have an object lifecycle configuration to ensure cleanup of temporary files. Consider configuring `tempdir` to point to a bucket with an object lifecycle policy that automatically deletes files after an expiration period. For more information, see https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html");
            }
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.log().warn("An error occurred while trying to read the S3 bucket lifecycle configuration: {}", (Object)throwable2.getMessage());
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    public void assertThatFileSystemIsNotS3BlockFileSystem(URI uri, Configuration hadoopConfig) {
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)hadoopConfig);
        String string = fs.getClass().getCanonicalName();
        String string2 = "org.apache.hadoop.fs.s3.S3FileSystem";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new IllegalArgumentException("spark-redshift does not support the S3 Block FileSystem. Please reconfigure `tempdir` touse a s3n:// or s3a:// scheme.");
        }
    }

    public void checkJDBCSecurity(String driverClass, String updatedURL, Properties driverProperties) {
        if (!this.isUnsecureJDBCConnectionRejected()) {
            return;
        }
        if (!JDBCWrapper$.MODULE$.REDSHIFT_FIRST_PARTY_DRIVERS().contains((Object)driverClass)) {
            throw new RedshiftConstraintViolationException("Arbitrary driver class is not supported when using spark-redshift connector with " + this.CONNECTOR_REJECT_UNSECURE_JDBC_CONNECTION() + " set to true: " + driverClass);
        }
        if (Utils$.urlContainsSSLDisable$1(updatedURL) || driverProperties.containsKey("ssl") && driverProperties.getProperty("ssl").equalsIgnoreCase("false")) {
            throw new RedshiftConstraintViolationException("To use spark-redshift connector with " + this.CONNECTOR_REJECT_UNSECURE_JDBC_CONNECTION() + " turned on, SSL must be enabled for the JDBC connection. ");
        }
    }

    public String getResourceIdForARN(String arn) {
        return (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(arn), new char[]{'/', ':'})));
    }

    public Option<String> getRegionForS3Bucket(Parameters.MergedParameters params, S3Client s3Client) {
        None$ none$;
        try {
            String string;
            block10: {
                String string2;
                block9: {
                    Utils.S3Location s3Location = this.parseS3Location(this.fixS3Url(params.rootTempDir()));
                    GetBucketLocationRequest request = (GetBucketLocationRequest)GetBucketLocationRequest.builder().bucket(s3Location.bucket()).build();
                    string2 = s3Client.getBucketLocation(request).locationConstraintAsString();
                    switch (string2 == null ? 0 : string2.hashCode()) {
                        case 0: {
                            if (string2 == null || "".equals(string2)) {
                                break;
                            }
                            break block9;
                        }
                        case 2718: {
                            if ("US".equals(string2)) {
                                break;
                            }
                            break block9;
                        }
                        default: {
                            break block9;
                        }
                    }
                    string = "us-east-1";
                    break block10;
                }
                string = string2;
            }
            String region = string;
            none$ = new Some((Object)region);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.log().warn("An error occurred while trying to determine the S3 bucket's region: {}", (Object)throwable2.getMessage());
                none$ = None$.MODULE$;
            }
            throw throwable;
        }
        return none$;
    }

    public Option<String> getRegionForRedshiftCluster(String url) {
        Option option;
        Regex regionRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\.([^.]+)\\.redshift\\.amazonaws\\.com.*"));
        String string = url;
        if (string != null && !(option = regionRegex.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String region = (String)((LinearSeqOps)option.get()).apply(0);
            return new Some((Object)region);
        }
        return None$.MODULE$;
    }

    public Option<String> getRegionForRedshiftCluster(Parameters.MergedParameters params) {
        if (params.jdbcUrl().isDefined()) {
            return this.getRegionForRedshiftCluster((String)params.jdbcUrl().get());
        }
        return params.dataApiRegion();
    }

    public void checkRedshiftAndS3OnSameRegion(Parameters.MergedParameters params, S3Client s3Client) {
        this.getRegionForRedshiftCluster(params).foreach((Function1 & Serializable)redshiftRegion -> {
            Utils$.$anonfun$checkRedshiftAndS3OnSameRegion$1(params, s3Client, redshiftRegion);
            return BoxedUnit.UNIT;
        });
    }

    public void checkRedshiftAndS3OnSameRegionParquetWrite(Parameters.MergedParameters params, S3Client s3Client) {
        Option<String> redshiftRegion = this.getRegionForRedshiftCluster(params);
        if (redshiftRegion.isEmpty()) {
            this.log().warn("Unable to determine region for redshift cluster, copy may fail if S3 bucket region does not match redshift cluster region.");
            return;
        }
        Option<String> s3Region = this.getRegionForS3Bucket(params, s3Client);
        if (s3Region.isEmpty()) {
            this.log().warn("Unable to determine region for S3 bucket, copy may fail if redshift cluster region does not match S3 bucket region.");
            return;
        }
        if (!BoxesRunTime.equals((Object)redshiftRegion.get(), (Object)s3Region.get())) {
            this.log().error("The Redshift cluster and S3 bucket are in different regions (" + redshiftRegion.get() + " and " + s3Region.get() + ", respectively). Cross-region copy operation is not available when tempformat is set to parquet");
            throw new IllegalArgumentException("Redshift cluster and S3 bucket are in different regions when tempformat is set to parquet");
        }
    }

    public String getDefaultRegion() {
        String currRegion;
        String string;
        try {
            string = new DefaultAwsRegionProviderChain().getRegion().toString();
        }
        catch (Throwable throwable) {
            string = currRegion = null;
        }
        if (currRegion == null || currRegion.isEmpty()) {
            this.log().warn("The connector cannot automatically determine a region for 'tempdir'. It is highly recommended that the 'tempdir_region' parameter is set to avoid a performance penalty while trying to automatically determine a region, especially when operating outside of AWS.");
        }
        if (currRegion != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(currRegion))) {
            return currRegion;
        }
        return Region.US_EAST_1.toString();
    }

    public String getDefaultTempDirRegion(Option<String> tempDirRegion) {
        if (tempDirRegion.isDefined()) {
            return (String)tempDirRegion.get();
        }
        return this.getDefaultRegion();
    }

    public Function2<AwsCredentialsProvider, Parameters.MergedParameters, S3Client> s3ClientBuilder() {
        return (Function2 & Serializable)(awsCredentials, mergedParameters) -> (S3Client)((S3BaseClientBuilder)S3Client.builder().region(Region.of((String)MODULE$.getDefaultTempDirRegion(mergedParameters.tempDirRegion()))).credentialsProvider(awsCredentials)).serviceConfiguration((S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Predef$.MODULE$.boolean2Boolean(true)).useArnRegionEnabled(Predef$.MODULE$.boolean2Boolean(true)).build()).build();
    }

    public String getSparkConfigValue(String key, String string) {
        SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable)() -> (SparkSession)SparkSession$.MODULE$.getDefaultSession().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        if (sparkSession == null) {
            return string;
        }
        return sparkSession.conf().get(key, string);
    }

    public String getSparkStaticConfigValue(String key, String string) {
        SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable)() -> (SparkSession)SparkSession$.MODULE$.getDefaultSession().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        if (sparkSession == null) {
            return string;
        }
        return sparkSession.sparkContext().getConf().get(key, string);
    }

    public String CONNECTOR_REJECT_UNSECURE_JDBC_CONNECTION() {
        return CONNECTOR_REJECT_UNSECURE_JDBC_CONNECTION;
    }

    public boolean isUnsecureJDBCConnectionRejected() {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(this.getSparkStaticConfigValue(this.CONNECTOR_REJECT_UNSECURE_JDBC_CONNECTION(), "false")));
    }

    public String CONNECTOR_REDSHIFT_S3_CONNECTION_IAM_ROLE_ONLY() {
        return CONNECTOR_REDSHIFT_S3_CONNECTION_IAM_ROLE_ONLY;
    }

    public boolean isRedshiftS3ConnectionViaIAMRoleOnly() {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(this.getSparkStaticConfigValue(this.CONNECTOR_REDSHIFT_S3_CONNECTION_IAM_ROLE_ONLY(), "false")));
    }

    public String CONNECTOR_DATA_API_ENDPOINT() {
        return CONNECTOR_DATA_API_ENDPOINT;
    }

    public RedshiftDataClient createDataApiClient(Option<String> region, Option<AwsCredentialsProvider> creds) {
        String endpoint;
        String tempRegion = (String)region.getOrElse((Function0 & Serializable)() -> MODULE$.getDefaultRegion());
        RedshiftDataClientBuilder builder = RedshiftDataClient.builder();
        if (creds.isDefined()) {
            builder = (RedshiftDataClientBuilder)builder.credentialsProvider((AwsCredentialsProvider)creds.get());
        }
        builder = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(endpoint = this.getSparkConfigValue(this.CONNECTOR_DATA_API_ENDPOINT(), ""))) ? (RedshiftDataClientBuilder)((AwsClientBuilder)builder.endpointOverride(URI.create(endpoint))).region(Region.of((String)tempRegion)) : (RedshiftDataClientBuilder)builder.region(Region.of((String)tempRegion));
        return (RedshiftDataClient)builder.build();
    }

    public Option<String> createDataApiClient$default$1() {
        return None$.MODULE$;
    }

    public Option<AwsCredentialsProvider> createDataApiClient$default$2() {
        return None$.MODULE$;
    }

    public void collectMetrics(Parameters.MergedParameters params, Option<Logger> logger) {
        Logger metricLogger = (Logger)logger.getOrElse((Function0 & Serializable)() -> MODULE$.log());
        metricLogger.info(BuildInfo$.MODULE$.toString());
        if (params.legacyJdbcRealTypeMapping()) {
            metricLogger.info(Parameters$.MODULE$.PARAM_LEGACY_JDBC_REAL_TYPE_MAPPING() + " is enabled");
        }
        if (params.legacyTrimCSVWrites()) {
            metricLogger.info(Parameters$.MODULE$.PARAM_LEGACY_TRIM_CSV_WRITES() + " is enabled");
        }
        if (params.overrideNullable()) {
            metricLogger.info(Parameters$.MODULE$.PARAM_OVERRIDE_NULLABLE() + " is enabled");
        }
        if (params.legacyMappingShortToInt()) {
            metricLogger.info(Parameters$.MODULE$.PARAM_LEGACY_MAPPING_SHORT_TO_INT() + " is enabled");
            return;
        }
    }

    public Option<Logger> collectMetrics$default$2() {
        return None$.MODULE$;
    }

    public String CONNECTOR_SERVICE_NAME_ENV_VAR() {
        return CONNECTOR_SERVICE_NAME_ENV_VAR;
    }

    private Option<String> connectorServiceName() {
        String configuredValue = ((String)scala.sys.package$.MODULE$.env().getOrElse((Object)this.CONNECTOR_SERVICE_NAME_ENV_VAR(), (Function0 & Serializable)() -> "")).trim();
        if (configuredValue.matches("^[a-zA-Z]+$")) {
            return Option$.MODULE$.apply((Object)configuredValue);
        }
        return None$.MODULE$;
    }

    private Option<String> connectorHostName(Parameters.MergedParameters params) {
        String configuredValue = ((String)params.hostConnector().getOrElse((Function0 & Serializable)() -> "")).trim();
        if (configuredValue.matches("^[a-zA-Z]+$")) {
            return Option$.MODULE$.apply((Object)configuredValue);
        }
        return None$.MODULE$;
    }

    public String DEFAULT_APP_NAME() {
        return DEFAULT_APP_NAME;
    }

    public String getApplicationName(Parameters.MergedParameters params) {
        String app = this.DEFAULT_APP_NAME();
        String svc = (String)this.connectorServiceName().getOrElse((Function0 & Serializable)() -> "");
        String hst = (String)this.connectorHostName(params).getOrElse((Function0 & Serializable)() -> "");
        return app + svc + hst;
    }

    public String CONNECTOR_TRACE_ID_ENV_VAR() {
        return CONNECTOR_TRACE_ID_ENV_VAR;
    }

    public String CONNECTOR_TRACE_ID_SPARK_CONF() {
        return CONNECTOR_TRACE_ID_SPARK_CONF;
    }

    private String connectorTraceId(SQLContext sqlContext) {
        String configuredValue = this.getSparkConfigValue(this.CONNECTOR_TRACE_ID_SPARK_CONF(), (String)scala.sys.package$.MODULE$.env().getOrElse((Object)this.CONNECTOR_TRACE_ID_ENV_VAR(), (Function0 & Serializable)() -> "")).trim();
        boolean validValue = StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(configuredValue), (Function1 & Serializable)object -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$connectorTraceId$2(BoxesRunTime.unboxToChar((Object)object))));
        if (!validValue) {
            this.log().warn("Configured trace id is not valid. It must only contain characters that are valid unicode identifier parts or '-'.");
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(configuredValue)) && validValue) {
            return configuredValue;
        }
        return sqlContext.sparkContext().applicationId();
    }

    public String CONNECTOR_LABEL_SPARK_CONF() {
        return CONNECTOR_LABEL_SPARK_CONF;
    }

    private Option<String> connectorLabel(Parameters.MergedParameters params) {
        String configuredValue = (String)params.user_query_group_label().getOrElse((Function0 & Serializable)() -> MODULE$.getSparkConfigValue(MODULE$.CONNECTOR_LABEL_SPARK_CONF(), ""));
        boolean validValue = StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(configuredValue), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isUnicodeIdentifierPart$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$5)))));
        if (!validValue) {
            this.log().warn("Configured query group label is not valid. It must only contain characters that are valid unicode identifier parts.");
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(configuredValue)) && validValue) {
            return Option$.MODULE$.apply((Object)configuredValue);
        }
        return None$.MODULE$;
    }

    public String queryGroupInfo(Utils.MetricOperation operation, Parameters.MergedParameters params, SQLContext sqlContext) {
        int MAX_SVC_LENGTH = 10;
        int MAX_HST_LENGTH = 10;
        int MAX_LBL_LENGTH = 100;
        int MAX_TID_LENGTH = 75;
        String svc = (String)this.connectorServiceName().getOrElse((Function0 & Serializable)() -> "");
        String hst = (String)this.connectorHostName(params).getOrElse((Function0 & Serializable)() -> "");
        String lbl = (String)this.connectorLabel(params).getOrElse((Function0 & Serializable)() -> "");
        String tid = this.connectorTraceId(sqlContext);
        String trimmedSvc = svc.substring(0, scala.math.package$.MODULE$.min(svc.length(), MAX_SVC_LENGTH));
        String trimmedHst = hst.substring(0, scala.math.package$.MODULE$.min(hst.length(), MAX_HST_LENGTH));
        String trimmedLbl = lbl.substring(0, scala.math.package$.MODULE$.min(lbl.length(), MAX_LBL_LENGTH));
        String trimmedTid = tid.substring(0, scala.math.package$.MODULE$.min(tid.length(), MAX_TID_LENGTH));
        return "{\"spark-redshift-connector\":{\"svc\":\"" + trimmedSvc + "\",\"hst\":\"" + trimmedHst + "\",\"ver\":\"" + BuildInfo$.MODULE$.version() + "\",\"op\":\"" + operation + "\",\"lbl\":\"" + trimmedLbl + "\"," + StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\"tid\":\"" + trimmedTid + "\"}}"));
    }

    public <T> T retry(int count, long delay, Function0<T> retryBlock) {
        Object object;
        while (true) {
            try {
                object = retryBlock.apply();
            }
            catch (Throwable e) {
                if (count <= 0) {
                    throw e;
                }
                this.log().warn("Sleeping " + delay + " milliseconds before proceeding to retry redshift operation; " + count + " retries remain");
                Thread.sleep(delay);
                --count;
                continue;
            }
            break;
        }
        return (T)object;
    }

    public void copyProperty(String name, scala.collection.immutable.Map<String, String> sourceProps, Properties destProps) {
        this.copyProperty(name, name, sourceProps, destProps);
    }

    public void copyProperty(String searchName, String replaceName, scala.collection.immutable.Map<String, String> sourceProps, Properties destProps) {
        sourceProps.get((Object)searchName).foreach((Function1 & Serializable)x$6 -> destProps.setProperty(replaceName, (String)x$6));
    }

    public void copyProperties(String matchRegex, String searchRegex, String replaceName, scala.collection.immutable.Map<String, String> sourceProps, Properties destProps) {
        sourceProps.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                if (key.matches(matchRegex)) {
                    return destProps.setProperty(key.replaceFirst(searchRegex, replaceName), value);
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$checkThatBucketHasObjectLifecycleConfiguration$3(Utils.S3Location s3Location$1, LifecycleRule rule) {
        String string = rule.status().toString();
        String string2 = "Enabled";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (rule.filter() == null) return true;
        if (rule.filter().prefix() == null) return true;
        if (!s3Location$1.key().startsWith(rule.filter().prefix())) return false;
        return true;
    }

    private static final boolean urlContainsSSLDisable$1(String updatedURL$1) {
        return updatedURL$1.toLowerCase().contains(";ssl=false") || updatedURL$1.toLowerCase().contains("&ssl=false") || updatedURL$1.toLowerCase().contains("?ssl=false");
    }

    public static final /* synthetic */ void $anonfun$checkRedshiftAndS3OnSameRegion$2(String redshiftRegion$1, Parameters.MergedParameters params$1, String s3Region) {
        String string = redshiftRegion$1;
        String string2 = s3Region;
        if ((string == null ? string2 != null : !string.equals(string2)) && params$1.tempDirRegion().isEmpty()) {
            MODULE$.log().error("The Redshift cluster and S3 bucket are in different regions (" + redshiftRegion$1 + " and " + s3Region + ", respectively). In order to perform this cross-region operation, you should set the tempdir_region parameter to '" + s3Region + "'. For more details on cross-region usage, see the README.");
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$checkRedshiftAndS3OnSameRegion$1(Parameters.MergedParameters params$1, S3Client s3Client$1, String redshiftRegion) {
        MODULE$.getRegionForS3Bucket(params$1, s3Client$1).foreach((Function1 & Serializable)s3Region -> {
            Utils$.$anonfun$checkRedshiftAndS3OnSameRegion$2(redshiftRegion, params$1, s3Region);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$connectorTraceId$2(char c) {
        return RichChar$.MODULE$.isUnicodeIdentifierPart$extension(Predef$.MODULE$.charWrapper(c)) || c == '-';
    }

    private Utils$() {
    }
}

