/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.spark_redshift_community.spark.redshift.AWSCredentialsUtils$;
import io.github.spark_redshift_community.spark.redshift.Conversions$;
import io.github.spark_redshift_community.spark.redshift.FilterPushdown$;
import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.Parameters$;
import io.github.spark_redshift_community.spark.redshift.RedshiftFileFormat;
import io.github.spark_redshift_community.spark.redshift.RedshiftRelation$;
import io.github.spark_redshift_community.spark.redshift.RedshiftWriter;
import io.github.spark_redshift_community.spark.redshift.RowEncoderUtils$;
import io.github.spark_redshift_community.spark.redshift.TableName;
import io.github.spark_redshift_community.spark.redshift.TimestampNTZTypeExtractor$;
import io.github.spark_redshift_community.spark.redshift.Utils$;
import io.github.spark_redshift_community.spark.redshift.Utils$Read$;
import io.github.spark_redshift_community.spark.redshift.Utils$Write$;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftConnection;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftResults;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftWrapper;
import io.github.spark_redshift_community.spark.redshift.package$;
import io.github.spark_redshift_community.spark.redshift.pushdown.RedshiftSQLStatement;
import io.github.spark_redshift_community.spark.redshift.pushdown.SqlToS3TempCache$;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.s3.S3Client;

@ScalaSignature(bytes="\u0006\u0005\u00115a\u0001B\u001d;\u0001\u0016C\u0001\"\u001d\u0001\u0003\u0016\u0004%\tA\u001d\u0005\ts\u0002\u0011\t\u0012)A\u0005g\"A!\u0010\u0001BK\u0002\u0013\u00051\u0010C\u0005\u0002N\u0001\u0011\t\u0012)A\u0005y\"Q\u0011q\n\u0001\u0003\u0016\u0004%\t!!\u0015\t\u0015\u0005M\u0003A!E!\u0002\u0013\tY\u0002\u0003\u0006\u0002V\u0001\u0011)\u001a!C\u0001\u0003/B!\"a\u001b\u0001\u0005#\u0005\u000b\u0011BA-\u0011)\ti\u0007\u0001BC\u0002\u0013\u0005\u0011q\u000e\u0005\u000b\u0003s\u0002!\u0011!Q\u0001\n\u0005E\u0004bBAB\u0001\u0011\u0005\u0011Q\u0011\u0005\n\u0003/\u0003!\u0019!C\u0005\u00033C\u0001\"a+\u0001A\u0003%\u00111\u0014\u0005\u000b\u0003[\u0003\u0001R1A\u0005B\u0005=\u0006bBAY\u0001\u0011\u0005\u00131\u0017\u0005\b\u0003\u0007\u0004A\u0011IAc\u0011\u001d\t)\u0010\u0001C!\u0003oDqA!\u0003\u0001\t\u0013\u0011Y\u0001C\u0004\u0003\u0014\u0001!\tE!\u0006\t\u000f\tE\u0002\u0001\"\u0011\u00034!9!Q\u0007\u0001\u0005\n\t]\u0002b\u0002B\u001b\u0001\u0011%!\u0011\n\u0005\b\u0005O\u0002A\u0011\u0002B5\u0011\u001d\u0011\t\b\u0001C\u0001\u0005gB\u0011Ba%\u0001#\u0003%\tA!&\t\u000f\t=\u0006\u0001\"\u0001\u00032\"9!1\u0018\u0001\u0005\n\tu\u0006b\u0002Bb\u0001\u0011%!Q\u0019\u0005\b\u00057\u0004A\u0011\u0002Bo\u0011\u001d\u0011\u0019\u000f\u0001C\u0005\u0005KDqA!>\u0001\t\u0013\u00119\u0010C\u0004\u0004\f\u0001!Ia!\u0004\t\u000f\rm\u0001\u0001\"\u0003\u0004\u001e!91Q\u0006\u0001\u0005\n\r=\u0002bBB!\u0001\u0011%11\t\u0005\b\u0007\u001f\u0002A\u0011BB)\u0011%\u0019I\u0006AA\u0001\n\u0003\u0019Y\u0006C\u0005\u0004j\u0001\t\n\u0011\"\u0001\u0004l!I1q\u000e\u0001\u0012\u0002\u0013\u00051\u0011\u000f\u0005\n\u0007k\u0002\u0011\u0013!C\u0001\u0007oB\u0011ba\u001f\u0001#\u0003%\ta! \t\u0013\r\u0005\u0005!!A\u0005B\u0005e\u0005\"CBB\u0001\u0005\u0005I\u0011ABC\u0011%\u0019i\tAA\u0001\n\u0003\u0019y\tC\u0005\u0004\u0016\u0002\t\t\u0011\"\u0011\u0004\u0018\"I1Q\u0015\u0001\u0002\u0002\u0013\u00051q\u0015\u0005\n\u0007W\u0003\u0011\u0011!C!\u0007[C\u0011b!-\u0001\u0003\u0003%\tea-\t\u0013\rU\u0006!!A\u0005B\r]v\u0001CB^u!\u0005!h!0\u0007\u000feR\u0004\u0012\u0001\u001e\u0004@\"9\u00111Q\u001a\u0005\u0002\r=\u0007bBBig\u0011\u000511\u001b\u0005\n\u0007G\u001c\u0014\u0011!CA\u0007KD\u0011ba=4\u0003\u0003%\ti!>\t\u0013\u0011\r1'!A\u0005\n\u0011\u0015!\u0001\u0005*fIND\u0017N\u001a;SK2\fG/[8o\u0015\tYD(\u0001\u0005sK\u0012\u001c\b.\u001b4u\u0015\tid(A\u0003ta\u0006\u00148N\u0003\u0002@\u0001\u0006A2\u000f]1sW~\u0013X\rZ:iS\u001a$xlY8n[Vt\u0017\u000e^=\u000b\u0005\u0005\u0013\u0015AB4ji\",(MC\u0001D\u0003\tIwn\u0001\u0001\u0014\u000f\u000115KV-`KB\u0011q)U\u0007\u0002\u0011*\u0011\u0011JS\u0001\bg>,(oY3t\u0015\tYE*A\u0002tc2T!!P'\u000b\u00059{\u0015AB1qC\u000eDWMC\u0001Q\u0003\ry'oZ\u0005\u0003%\"\u0013ABQ1tKJ+G.\u0019;j_:\u0004\"a\u0012+\n\u0005UC%A\u0005)sk:,GMR5mi\u0016\u0014X\rZ*dC:\u0004\"aR,\n\u0005aC%AE%og\u0016\u0014H/\u00192mKJ+G.\u0019;j_:\u0004\"AW/\u000e\u0003mS!\u0001\u0018'\u0002\u0011%tG/\u001a:oC2L!AX.\u0003\u000f1{wmZ5oOB\u0011\u0001mY\u0007\u0002C*\t!-A\u0003tG\u0006d\u0017-\u0003\u0002eC\n9\u0001K]8ek\u000e$\bC\u00014o\u001d\t9GN\u0004\u0002iW6\t\u0011N\u0003\u0002k\t\u00061AH]8pizJ\u0011AY\u0005\u0003[\u0006\fq\u0001]1dW\u0006<W-\u0003\u0002pa\na1+\u001a:jC2L'0\u00192mK*\u0011Q.Y\u0001\u0010e\u0016$7\u000f[5gi^\u0013\u0018\r\u001d9feV\t1\u000f\u0005\u0002uo6\tQO\u0003\u0002wu\u0005!A-\u0019;b\u0013\tAXOA\bSK\u0012\u001c\b.\u001b4u/J\f\u0007\u000f]3s\u0003A\u0011X\rZ:iS\u001a$xK]1qa\u0016\u0014\b%A\btg\rc\u0017.\u001a8u\r\u0006\u001cGo\u001c:z+\u0005a\bc\u00021~\u007f\u0006m\u0011QH\u0005\u0003}\u0006\u0014\u0011BR;oGRLwN\u001c\u001a\u0011\t\u0005\u0005\u0011qC\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005Y1M]3eK:$\u0018.\u00197t\u0015\u0011\tI!a\u0003\u0002\t\u0005,H\u000f\u001b\u0006\u0005\u0003\u001b\ty!\u0001\u0004boN\u001cHm\u001b\u0006\u0005\u0003#\t\u0019\"\u0001\u0004b[\u0006TxN\u001c\u0006\u0003\u0003+\t\u0001b]8gi^\f'/Z\u0005\u0005\u00033\t\u0019A\u0001\fBoN\u001c%/\u001a3f]RL\u0017\r\\:Qe>4\u0018\u000eZ3s!\u0011\ti\"a\u000e\u000f\t\u0005}\u00111\u0007\b\u0005\u0003C\t\tD\u0004\u0003\u0002$\u0005=b\u0002BA\u0013\u0003[qA!a\n\u0002,9\u0019\u0001.!\u000b\n\u0003\rK!!\u0011\"\n\u0005}\u0002\u0015BA\u001f?\u0013\tYD(C\u0002\u00026i\n!\u0002U1sC6,G/\u001a:t\u0013\u0011\tI$a\u000f\u0003!5+'oZ3e!\u0006\u0014\u0018-\\3uKJ\u001c(bAA\u001buA!\u0011qHA%\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013AA:4\u0015\u0011\t9%a\u0003\u0002\u0011M,'O^5dKNLA!a\u0013\u0002B\tA1kM\"mS\u0016tG/\u0001\ttg\rc\u0017.\u001a8u\r\u0006\u001cGo\u001c:zA\u00051\u0001/\u0019:b[N,\"!a\u0007\u0002\u000fA\f'/Y7tA\u0005QQo]3s'\u000eDW-\\1\u0016\u0005\u0005e\u0003#\u00021\u0002\\\u0005}\u0013bAA/C\n1q\n\u001d;j_:\u0004B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0004\u0003KR\u0015!\u0002;za\u0016\u001c\u0018\u0002BA5\u0003G\u0012!b\u0015;sk\u000e$H+\u001f9f\u0003-)8/\u001a:TG\",W.\u0019\u0011\u0002\u0015M\fHnQ8oi\u0016DH/\u0006\u0002\u0002rA!\u00111OA;\u001b\u0005Q\u0015bAA<\u0015\nQ1+\u0015'D_:$X\r\u001f;\u0002\u0017M\fHnQ8oi\u0016DH\u000f\t\u0015\u0004\u0015\u0005u\u0004c\u00011\u0002\u0000%\u0019\u0011\u0011Q1\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018A\u0002\u001fj]&$h\b\u0006\u0006\u0002\b\u0006=\u0015\u0011SAJ\u0003+#B!!#\u0002\u000eB\u0019\u00111\u0012\u0001\u000e\u0003iBq!!\u001c\f\u0001\u0004\t\t\bC\u0003r\u0017\u0001\u00071\u000fC\u0003{\u0017\u0001\u0007A\u0010C\u0004\u0002P-\u0001\r!a\u0007\t\u000f\u0005U3\u00021\u0001\u0002Z\u0005\u0019B/\u00192mK:\u000bW.Z(s'V\u0014\u0017/^3ssV\u0011\u00111\u0014\t\u0005\u0003;\u000b9+\u0004\u0002\u0002 *!\u0011\u0011UAR\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0016\u0001\u00026bm\u0006LA!!+\u0002 \n11\u000b\u001e:j]\u001e\fA\u0003^1cY\u0016t\u0015-\\3PeN+(-];fef\u0004\u0013AB:dQ\u0016l\u0017-\u0006\u0002\u0002`\u0005AAo\\*ue&tw\r\u0006\u0002\u00026B!\u0011qWA`\u001d\u0011\tI,a/\u0011\u0005!\f\u0017bAA_C\u00061\u0001K]3eK\u001aLA!!+\u0002B*\u0019\u0011QX1\u0002\r%t7/\u001a:u)\u0019\t9-!4\u0002lB\u0019\u0001-!3\n\u0007\u0005-\u0017M\u0001\u0003V]&$\bB\u0002<\u0011\u0001\u0004\ty\r\u0005\u0003\u0002R\u0006\u0015h\u0002BAj\u0003GtA!!6\u0002b:!\u0011q[Ap\u001d\u0011\tI.!8\u000f\u0007!\fY.C\u0001Q\u0013\tqu*\u0003\u0002>\u001b&\u00111\nT\u0005\u0003[*KA!a:\u0002j\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003[*Cq!!<\u0011\u0001\u0004\ty/A\u0005pm\u0016\u0014xO]5uKB\u0019\u0001-!=\n\u0007\u0005M\u0018MA\u0004C_>dW-\u00198\u0002!Ut\u0007.\u00198eY\u0016$g)\u001b7uKJ\u001cH\u0003BA}\u0005\u000b\u0001R\u0001YA~\u0003\u007fL1!!@b\u0005\u0015\t%O]1z!\r9%\u0011A\u0005\u0004\u0005\u0007A%A\u0002$jYR,'\u000fC\u0004\u0003\bE\u0001\r!!?\u0002\u000f\u0019LG\u000e^3sg\u0006\u00112\r[3dWN\u001b$)^2lKR,6/Y4f)\u0019\t9M!\u0004\u0003\u0010!9\u0011q\n\nA\u0002\u0005m\u0001B\u0002B\t%\u0001\u0007q0A\u0007de\u0016$7\u000f\u0015:pm&$WM]\u0001\nEVLG\u000eZ*dC:$bAa\u0006\u0003*\t=\u0002C\u0002B\r\u0005?\u0011\u0019#\u0004\u0002\u0003\u001c)\u0019!Q\u0004'\u0002\u0007I$G-\u0003\u0003\u0003\"\tm!a\u0001*E\tB!\u00111\u000fB\u0013\u0013\r\u00119C\u0013\u0002\u0004%><\bb\u0002B\u0016'\u0001\u0007!QF\u0001\u0010e\u0016\fX/\u001b:fI\u000e{G.^7ogB)\u0001-a?\u00026\"9!qA\nA\u0002\u0005e\u0018A\u00048fK\u0012\u001cuN\u001c<feNLwN\\\u000b\u0003\u0003_\fqBY;jY\u0012,f\u000e\\8bIN#X\u000e\u001e\u000b\r\u0003k\u0013IDa\u000f\u0003>\t\u0005#1\t\u0005\b\u0005W)\u0002\u0019\u0001B\u0017\u0011\u001d\u00119!\u0006a\u0001\u0003sDqAa\u0010\u0016\u0001\u0004\t),A\u0004uK6\u0004H)\u001b:\t\r\tEQ\u00031\u0001\u0000\u0011\u001d\u0011)%\u0006a\u0001\u0005\u000f\n\u0011b]:f\u00176\u001c8*Z=\u0011\u000b\u0001\fY&!.\u0015\u001d\u0005U&1\nB.\u0005;\u0012yF!\u0019\u0003d!9!Q\n\fA\u0002\t=\u0013!C:uCR,W.\u001a8u!\u0011\u0011\tFa\u0016\u000e\u0005\tM#b\u0001B+u\u0005A\u0001/^:iI><h.\u0003\u0003\u0003Z\tM#\u0001\u0006*fIND\u0017N\u001a;T#2\u001bF/\u0019;f[\u0016tG\u000fC\u0004\u0002.Z\u0001\r!a\u0018\t\u000f\t}b\u00031\u0001\u00026\"1!\u0011\u0003\fA\u0002}DqA!\u0012\u0017\u0001\u0004\u00119\u0005C\u0004\u0003fY\u0001\r!!.\u0002\u0015QD'/Z1e\u001d\u0006lW-A\u0006qeVtWmU2iK6\fGCBA0\u0005W\u0012i\u0007C\u0004\u0002.^\u0001\r!a\u0018\t\u000f\t=t\u00031\u0001\u0003.\u000591m\u001c7v[:\u001c\u0018\u0001\u00052vS2$7kY1o\rJ|WnU)M+\u0011\u0011)H! \u0015\u0011\t]$Q\u0012BH\u0005#\u0003bA!\u0007\u0003 \te\u0004\u0003\u0002B>\u0005{b\u0001\u0001B\u0004\u0003(a\u0011\rAa \u0012\t\t\u0005%q\u0011\t\u0004A\n\r\u0015b\u0001BCC\n9aj\u001c;iS:<\u0007c\u00011\u0003\n&\u0019!1R1\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003Na\u0001\rAa\u0014\t\u000f\u00055\u0006\u00041\u0001\u0002Z!I!Q\r\r\u0011\u0002\u0003\u0007\u0011QW\u0001\u001bEVLG\u000eZ*dC:4%o\\7T#2#C-\u001a4bk2$HeM\u000b\u0005\u0005/\u0013i+\u0006\u0002\u0003\u001a*\"\u0011Q\u0017BNW\t\u0011i\n\u0005\u0003\u0003 \n%VB\u0001BQ\u0015\u0011\u0011\u0019K!*\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BTC\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t-&\u0011\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,Ga\u0002B\u00143\t\u0007!qP\u0001\u000eeVtG)\u0014'Ge>l7+\u0015'\u0015\t\tM&\u0011\u0018\t\u0006M\nU&1E\u0005\u0004\u0005o\u0003(aA*fc\"9!Q\n\u000eA\u0002\t=\u0013\u0001F$fi\u000e\u000b7\r[3e'N\nV/\u001a:z!\u0006$\b\u000e\u0006\u0004\u0003H\t}&\u0011\u0019\u0005\b\u0005\u001bZ\u0002\u0019\u0001B(\u0011\u001d\u0011)g\u0007a\u0001\u0003k\u000ba\"\u001e8m_\u0006$G)\u0019;b)>\u001c6\u0007\u0006\u0007\u0003H\t\u001d'\u0011\u001aBj\u0005/\u0014I\u000eC\u0004\u0003Nq\u0001\rAa\u0014\t\u000f\t-G\u00041\u0001\u0003N\u0006!1m\u001c8o!\r!(qZ\u0005\u0004\u0005#,(A\u0005*fIND\u0017N\u001a;D_:tWm\u0019;j_:DqA!6\u001d\u0001\u0004\ty&\u0001\u0007sKN,H\u000e^*dQ\u0016l\u0017\r\u0003\u0004\u0003\u0012q\u0001\ra \u0005\b\u0005Kb\u0002\u0019AA[\u0003m\u0019wN\u001c<feR\u001cu.\u001c9mKb$\u0016\u0010]3t)>\u001cFO]5oOR!\u0011q\fBp\u0011\u001d\u0011\t/\ba\u0001\u0003?\n1\"\u001b8qkR\u001c6\r[3nC\u0006)R.\u00199D_6\u0004H.\u001a=UsB,7\u000fV8Kg>tG\u0003\u0002Bt\u0005g\u0004\u0002\"a.\u0003j\u0006U&Q^\u0005\u0005\u0005W\f\tMA\u0002NCB\u0004B!a\u001d\u0003p&\u0019!\u0011\u001f&\u0003\r\r{G.^7o\u0011\u001d\u0011\tO\ba\u0001\u0003?\nqA]3bIJ#E)\u0006\u0003\u0003z\n}HC\u0002B~\u0007\u0007\u0019)\u0001\u0005\u0004\u0003\u001a\t}!Q \t\u0005\u0005w\u0012y\u0010B\u0004\u0004\u0002}\u0011\rAa \u0003\u0003QCqA!6 \u0001\u0004\ty\u0006C\u0004\u0004\b}\u0001\ra!\u0003\u0002\u0017\u0019LG.Z:U_J+\u0017\r\u001a\t\u0006M\nU\u0016QW\u0001\u0013e\u0016\fGM\u0015#E\rJ|W\u000eU1scV,G/\u0006\u0003\u0004\u0010\rUACBB\t\u0007/\u0019I\u0002\u0005\u0004\u0003\u001a\t}11\u0003\t\u0005\u0005w\u001a)\u0002B\u0004\u0004\u0002\u0001\u0012\rAa \t\u000f\tU\u0007\u00051\u0001\u0002`!91q\u0001\u0011A\u0002\r%\u0011AD4fi\u001aKG.Z:U_J+\u0017\r\u001a\u000b\u0007\u0007\u0013\u0019yb!\t\t\u000f\t}\u0012\u00051\u0001\u00026\"911E\u0011A\u0002\r\u0015\u0012AA:d!\u0011\u00199c!\u000b\u000e\u00031K1aa\u000bM\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0003e)\u0007\u0010\u001e:bGR\u001c%/\u001a3f]RL\u0017\r\\:Ge>lWK]5\u0015\t\t\u001d3\u0011\u0007\u0005\b\u0007g\u0011\u0003\u0019AB\u001b\u0003\r)(/\u001b\t\u0005\u0007o\u0019i$\u0004\u0002\u0004:)!11HAR\u0003\rqW\r^\u0005\u0005\u0007\u007f\u0019IDA\u0002V%&\u000bQ$\u00193e\u0007J,G-\u001a8uS\u0006d7/\u00118e\u000b:\u001cXO]3TG\",W.\u001a\u000b\t\u0003k\u001b)e!\u0013\u0004L!91qI\u0012A\u0002\u0005U\u0016\u0001\u00034jY\u0016\u0004\u0016\r\u001e5\t\u000f\u0005\u00151\u00051\u0001\u0003H!91QJ\u0012A\u0002\u0005U\u0016AB:dQ\u0016lW-A\bhKR\u0014Vm];miN\u001b\u0007.Z7b)!\tyfa\u0015\u0004V\r]\u0003b\u0002B'I\u0001\u0007!q\n\u0005\b\u0003[#\u0003\u0019AA-\u0011\u001d\u0011Y\r\na\u0001\u0005\u001b\fAaY8qsRQ1QLB1\u0007G\u001a)ga\u001a\u0015\t\u0005%5q\f\u0005\b\u0003[*\u0003\u0019AA9\u0011\u001d\tX\u0005%AA\u0002MDqA_\u0013\u0011\u0002\u0003\u0007A\u0010C\u0005\u0002P\u0015\u0002\n\u00111\u0001\u0002\u001c!I\u0011QK\u0013\u0011\u0002\u0003\u0007\u0011\u0011L\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019iGK\u0002t\u00057\u000babY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0004t)\u001aAPa'\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u00111\u0011\u0010\u0016\u0005\u00037\u0011Y*\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r}$\u0006BA-\u00057\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\u0018\u0001\u00049s_\u0012,8\r^!sSRLXCABD!\r\u00017\u0011R\u0005\u0004\u0007\u0017\u000b'aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002BD\u0007#C\u0011ba%-\u0003\u0003\u0005\raa\"\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0019I\n\u0005\u0004\u0004\u001c\u000e\u0005&qQ\u0007\u0003\u0007;S1aa(b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0007G\u001biJ\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAx\u0007SC\u0011ba%/\u0003\u0003\u0005\rAa\"\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u00037\u001by\u000bC\u0005\u0004\u0014>\n\t\u00111\u0001\u0004\b\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0004\b\u00061Q-];bYN$B!a<\u0004:\"I11S\u0019\u0002\u0002\u0003\u0007!qQ\u0001\u0011%\u0016$7\u000f[5giJ+G.\u0019;j_:\u00042!a#4'\u0015\u00194\u0011YBd!\r\u000171Y\u0005\u0004\u0007\u000b\f'AB!osJ+g\r\u0005\u0003\u0004J\u000e5WBABf\u0015\r\u0019\u00151U\u0005\u0004_\u000e-GCAB_\u0003A\u00198\r[3nCRK\b/Z:NCR\u001c\u0007\u000e\u0006\u0004\u0002p\u000eU7q\u001c\u0005\b\u0007/,\u0004\u0019ABm\u0003\u001d\u00198\r[3nCF\u0002B!!\u0019\u0004\\&!1Q\\A2\u0005!!\u0015\r^1UsB,\u0007bBBqk\u0001\u00071\u0011\\\u0001\bg\u000eDW-\\13\u0003\u0015\t\u0007\u000f\u001d7z))\u00199oa;\u0004n\u000e=8\u0011\u001f\u000b\u0005\u0003\u0013\u001bI\u000fC\u0004\u0002nY\u0002\r!!\u001d\t\u000bE4\u0004\u0019A:\t\u000bi4\u0004\u0019\u0001?\t\u000f\u0005=c\u00071\u0001\u0002\u001c!9\u0011Q\u000b\u001cA\u0002\u0005e\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0007o\u001cy\u0010E\u0003a\u00037\u001aI\u0010E\u0005a\u0007w\u001cH0a\u0007\u0002Z%\u00191Q`1\u0003\rQ+\b\u000f\\35\u0011%!\taNA\u0001\u0002\u0004\tI)A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"\u0001b\u0002\u0011\t\u0005uE\u0011B\u0005\u0005\t\u0017\tyJ\u0001\u0004PE*,7\r\u001e")
public class RedshiftRelation
extends BaseRelation
implements PrunedFilteredScan,
InsertableRelation,
Logging,
Product,
Serializable {
    private StructType schema;
    private final RedshiftWrapper redshiftWrapper;
    private final Function2<AwsCredentialsProvider, Parameters.MergedParameters, S3Client> s3ClientFactory;
    private final Parameters.MergedParameters params;
    private final Option<StructType> userSchema;
    private final transient SQLContext sqlContext;
    private final String tableNameOrSubquery;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<RedshiftWrapper, Function2<AwsCredentialsProvider, Parameters.MergedParameters, S3Client>, Parameters.MergedParameters, Option<StructType>>> unapply(RedshiftRelation x$0) {
        return RedshiftRelation$.MODULE$.unapply(x$0);
    }

    public static RedshiftRelation apply(RedshiftWrapper redshiftWrapper, Function2<AwsCredentialsProvider, Parameters.MergedParameters, S3Client> s3ClientFactory, Parameters.MergedParameters params, Option<StructType> userSchema, SQLContext sqlContext) {
        return RedshiftRelation$.MODULE$.apply(redshiftWrapper, s3ClientFactory, params, userSchema, sqlContext);
    }

    public static boolean schemaTypesMatch(DataType schema1, DataType schema2) {
        return RedshiftRelation$.MODULE$.schemaTypesMatch(schema1, schema2);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RedshiftWrapper redshiftWrapper() {
        return this.redshiftWrapper;
    }

    public Function2<AwsCredentialsProvider, Parameters.MergedParameters, S3Client> s3ClientFactory() {
        return this.s3ClientFactory;
    }

    public Parameters.MergedParameters params() {
        return this.params;
    }

    public Option<StructType> userSchema() {
        return this.userSchema;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    private String tableNameOrSubquery() {
        return this.tableNameOrSubquery;
    }

    private StructType schema$lzycompute() {
        RedshiftRelation redshiftRelation = this;
        synchronized (redshiftRelation) {
            if (!this.bitmap$0) {
                this.schema = (StructType)this.userSchema().getOrElse((Function0 & Serializable)() -> {
                    StructType structType;
                    String tableNameOrSubquery = (String)this.params().query().map((Function1 & Serializable)q -> "(" + q + ")").orElse((Function0 & Serializable)() -> this.params().table().map((Function1 & Serializable)x$2 -> x$2.toString())).get();
                    try (RedshiftConnection conn = this.redshiftWrapper().getConnector(this.params());){
                        structType = this.redshiftWrapper().resolveTable(conn, tableNameOrSubquery, (Option<Parameters.MergedParameters>)new Some((Object)this.params()));
                    }
                    return structType;
                });
                this.bitmap$0 = true;
            }
        }
        return this.schema;
    }

    public StructType schema() {
        if (!this.bitmap$0) {
            return this.schema$lzycompute();
        }
        return this.schema;
    }

    public String toString() {
        return "RedshiftRelation(" + this.tableNameOrSubquery() + ")";
    }

    public void insert(Dataset<Row> data, boolean overwrite) {
        SaveMode saveMode = overwrite ? SaveMode.Overwrite : SaveMode.Append;
        RedshiftWriter writer = new RedshiftWriter(this.redshiftWrapper(), this.s3ClientFactory());
        writer.saveToRedshift(this.sqlContext(), data, saveMode, this.params());
    }

    public Filter[] unhandledFilters(Filter[] filters) {
        return (Filter[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])filters), (Function1 & Serializable)filter -> BoxesRunTime.boxToBoolean((boolean)RedshiftRelation.$anonfun$unhandledFilters$1(this, filter)));
    }

    private void checkS3BucketUsage(Parameters.MergedParameters params, AwsCredentialsProvider credsProvider) {
        if (!params.checkS3BucketUsage()) {
            return;
        }
        S3Client s3Client = (S3Client)this.s3ClientFactory().apply((Object)credsProvider, (Object)params);
        Utils$.MODULE$.checkRedshiftAndS3OnSameRegion(params, s3Client);
        Utils$.MODULE$.checkThatBucketHasObjectLifecycleConfiguration(params, s3Client);
    }

    public RDD<Row> buildScan(String[] requiredColumns, Filter[] filters) {
        AwsCredentialsProvider credsProvider = AWSCredentialsUtils$.MODULE$.load(this.params(), this.sqlContext().sparkContext().hadoopConfiguration());
        this.checkS3BucketUsage(this.params(), credsProvider);
        Utils$.MODULE$.collectMetrics(this.params(), Utils$.MODULE$.collectMetrics$default$2());
        String queryGroup = Utils$.MODULE$.queryGroupInfo(Utils$Read$.MODULE$, this.params(), this.sqlContext());
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])requiredColumns))) {
            RDD rDD;
            block9: {
                String whereClause = FilterPushdown$.MODULE$.buildWhereClause(this.schema(), (Seq<Filter>)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])filters)), FilterPushdown$.MODULE$.buildWhereClause$default$3());
                String countQuery = "SELECT count(*) FROM " + this.tableNameOrSubquery() + " " + whereClause;
                try (RedshiftConnection conn = this.redshiftWrapper().getConnectorWithQueryGroup(this.params(), queryGroup);){
                    this.log().info("Getting number of rows from Redshift");
                    RedshiftResults results = this.redshiftWrapper().executeQueryInterruptibly(conn, countQuery);
                    if (results.next()) {
                        long numRows = results.getLong(1);
                        this.log().info("Number of rows is {}", (Object)BoxesRunTime.boxToLong((long)numRows));
                        int parallelism = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.sqlContext().getConf("spark.sql.shuffle.partitions", "200")));
                        InternalRow emptyRow = RowEncoderUtils$.MODULE$.expressionEncoderForSchema(StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().empty())).createSerializer().apply((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{scala.package$.MODULE$.Seq().empty()})));
                        rDD = this.sqlContext().sparkContext().parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)numRows)), parallelism, (ClassTag)ClassTag$.MODULE$.Long()).map((Function1 & Serializable)x$3 -> emptyRow, ClassTag$.MODULE$.apply(InternalRow.class));
                        break block9;
                    }
                    throw new IllegalStateException("Could not read count from Redshift");
                }
            }
            return rDD;
        }
        String tempDir = this.params().createPerQueryTempDir();
        String unloadSql = this.buildUnloadStmt(requiredColumns, filters, tempDir, credsProvider, this.params().sseKmsKey());
        try (RedshiftConnection conn = this.redshiftWrapper().getConnectorWithQueryGroup(this.params(), queryGroup);){
            this.log().info("Unloading data from Redshift");
            this.redshiftWrapper().executeInterruptibly(conn, unloadSql);
        }
        Seq<String> filesToRead = this.getFilesToRead(tempDir, this.sqlContext().sparkContext());
        StructType prunedSchema = this.pruneSchema(this.schema(), requiredColumns);
        String string = this.params().unloadS3Format();
        String string2 = "PARQUET";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.readRDDFromParquet(prunedSchema, filesToRead);
        }
        return this.readRDD(prunedSchema, filesToRead);
    }

    public boolean needConversion() {
        return false;
    }

    private String buildUnloadStmt(String[] requiredColumns, Filter[] filters, String tempDir, AwsCredentialsProvider credsProvider, Option<String> sseKmsKey) {
        Predef$.MODULE$.assert(!ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)));
        String columnList = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])requiredColumns), (Function1 & Serializable)col -> "\"" + col + "\"", ClassTag$.MODULE$.apply(String.class))).mkString(", ");
        String whereClause = FilterPushdown$.MODULE$.buildWhereClause(this.schema(), (Seq<Filter>)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])filters)), true);
        String credsString = AWSCredentialsUtils$.MODULE$.getRedshiftCredentialsString(this.params(), credsProvider);
        String escapedTableNameOrSubqury = this.tableNameOrSubquery().replace("\\", "\\\\").replace("'", "\\'");
        String query = "SELECT " + columnList + " FROM " + escapedTableNameOrSubqury + " " + whereClause;
        Utils$.MODULE$.lastBuildStmt().update((Object)Thread.currentThread().getName(), (Object)query);
        String fixedUrl = Utils$.MODULE$.fixS3Url(Utils$.MODULE$.removeCredentialsFromURI(new URI(tempDir)).toString());
        String unloadClause = "UNLOAD ('" + query + "') TO '" + fixedUrl + "'";
        String credClause = "WITH CREDENTIALS '" + credsString + "'";
        String string = this.params().unloadS3Format();
        String string2 = "PARQUET";
        String manifestClause = !(string != null ? !string.equals(string2) : string2 != null) ? "FORMAT AS PARQUET  MANIFEST" : "ESCAPE MANIFEST NULL AS '" + this.params().nullString() + "'";
        String sseKmsClause = (String)sseKmsKey.map((Function1 & Serializable)key -> "KMS_KEY_ID '" + key + "' ENCRYPTED").getOrElse((Function0 & Serializable)() -> "");
        String regionClause = (String)this.params().tempDirRegion().map((Function1 & Serializable)region -> "REGION AS '" + region + "'").getOrElse((Function0 & Serializable)() -> "");
        String extraClause = String.valueOf(this.params().extraUnloadOptions());
        String string3 = unloadClause;
        String string4 = credClause;
        String string5 = manifestClause;
        String string6 = sseKmsClause;
        String string7 = regionClause;
        String string8 = extraClause;
        List unloadStmtList = Nil$.MODULE$.$colon$colon((Object)string8).$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3);
        return unloadStmtList.mkString(" ");
    }

    private String buildUnloadStmt(RedshiftSQLStatement statement, StructType schema, String tempDir, AwsCredentialsProvider credsProvider, Option<String> sseKmsKey, String threadName) {
        Predef$.MODULE$.assert(schema.nonEmpty());
        String credsString = AWSCredentialsUtils$.MODULE$.getRedshiftCredentialsString(this.params(), credsProvider);
        String query = statement.statementString().replace("\\", "\\\\").replace("'", "\\'");
        Utils$.MODULE$.lastBuildStmt().update((Object)threadName, (Object)query);
        String fixedUrl = Utils$.MODULE$.fixS3Url(Utils$.MODULE$.removeCredentialsFromURI(new URI(tempDir)).toString());
        String unloadClause = "UNLOAD ('SELECT * FROM (" + query + ")') TO '" + fixedUrl + "'";
        String credClause = "WITH CREDENTIALS '" + credsString + "'";
        String string = this.params().unloadS3Format();
        String string2 = "PARQUET";
        String manifestClause = !(string != null ? !string.equals(string2) : string2 != null) ? "FORMAT AS PARQUET  MANIFEST" : "ESCAPE MANIFEST NULL AS '" + this.params().nullString() + "'";
        String sseKmsClause = (String)sseKmsKey.map((Function1 & Serializable)key -> "KMS_KEY_ID '" + key + "' ENCRYPTED").getOrElse((Function0 & Serializable)() -> "");
        String regionClause = (String)this.params().tempDirRegion().map((Function1 & Serializable)region -> "REGION AS '" + region + "'").getOrElse((Function0 & Serializable)() -> "");
        String extraClause = String.valueOf(this.params().extraUnloadOptions());
        String string3 = unloadClause;
        String string4 = credClause;
        String string5 = manifestClause;
        String string6 = sseKmsClause;
        String string7 = regionClause;
        String string8 = extraClause;
        List unloadStmtList = Nil$.MODULE$.$colon$colon((Object)string8).$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3);
        return unloadStmtList.mkString(" ");
    }

    private StructType pruneSchema(StructType schema, String[] columns) {
        scala.collection.immutable.Map fieldMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x.name()), x), ClassTag$.MODULE$.apply(Tuple2.class)))));
        return new StructType((StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)name -> (StructField)fieldMap.apply(name), ClassTag$.MODULE$.apply(StructField.class)));
    }

    public <Row> RDD<Row> buildScanFromSQL(RedshiftSQLStatement statement, Option<StructType> schema, String threadName) {
        Option option;
        StructType structType;
        try (RedshiftConnection conn = this.redshiftWrapper().getConnector(this.params());){
            structType = this.getResultSchema(statement, schema, conn);
        }
        StructType resultSchema = structType;
        AwsCredentialsProvider credsProvider = AWSCredentialsUtils$.MODULE$.load(this.params(), this.sqlContext().sparkContext().hadoopConfiguration());
        String queryGroup = Utils$.MODULE$.queryGroupInfo(Utils$Read$.MODULE$, this.params(), this.sqlContext());
        try (RedshiftConnection connWithQG = this.redshiftWrapper().getConnectorWithQueryGroup(this.params(), queryGroup);){
            this.checkS3BucketUsage(this.params(), credsProvider);
            Utils$.MODULE$.collectMetrics(this.params(), Utils$.MODULE$.collectMetrics$default$2());
            option = this.GetCachedS3QueryPath(statement, threadName).orElse((Function0 & Serializable)() -> this.unloadDataToS3(statement, connWithQG, resultSchema, credsProvider, threadName));
        }
        Option tempDir = option;
        Seq<String> filesToRead = this.getFilesToRead((String)tempDir.get(), this.sqlContext().sparkContext());
        String string = this.params().unloadS3Format();
        String string2 = "PARQUET";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.readRDDFromParquet(resultSchema, filesToRead);
        }
        return this.readRDD(resultSchema, filesToRead);
    }

    public <Row> String buildScanFromSQL$default$3() {
        return Thread.currentThread().getName();
    }

    public Seq<Row> runDMLFromSQL(RedshiftSQLStatement statement) {
        .colon.colon colon2;
        String statementStr = statement.statementString();
        Utils$.MODULE$.lastBuildStmt().update((Object)Thread.currentThread().getName(), (Object)statementStr);
        String queryGroup = Utils$.MODULE$.queryGroupInfo(Utils$Write$.MODULE$, this.params(), this.sqlContext());
        this.redshiftWrapper().setAutoCommit(conn, false);
        try (RedshiftConnection conn = this.redshiftWrapper().getConnectorWithQueryGroup(this.params(), queryGroup);){
            if (this.params().table().isDefined() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(((TableName)this.params().table().get()).unescapedDatabaseName()))) {
                String useDbStr = "use " + ((TableName)this.params().table().get()).escapedDatabaseName();
                v0 = BoxesRunTime.boxToBoolean((boolean)this.redshiftWrapper().executeInterruptibly(conn, useDbStr));
            } else {
                v0 = BoxedUnit.UNIT;
            }
            long affectedRows = this.redshiftWrapper().executeUpdate(conn, statementStr);
            this.redshiftWrapper().commit(conn);
            colon2 = new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)affectedRows)})), (List)Nil$.MODULE$);
        }
        return colon2;
    }

    private Option<String> GetCachedS3QueryPath(RedshiftSQLStatement statement, String threadName) {
        Option<String> cachedPath;
        block1: {
            if (!this.params().pushdownS3ResultCache()) {
                return None$.MODULE$;
            }
            cachedPath = SqlToS3TempCache$.MODULE$.getS3Path(statement.statementString());
            if (!cachedPath.isDefined()) break block1;
            Utils$.MODULE$.lastBuildStmt().update((Object)threadName, (Object)statement.statementString().replace("\\", "\\\\").replace("'", "\\'"));
        }
        return cachedPath;
    }

    private Option<String> unloadDataToS3(RedshiftSQLStatement statement, RedshiftConnection conn, StructType resultSchema, AwsCredentialsProvider credsProvider, String threadName) {
        String newTempDir = this.params().createPerQueryTempDir();
        String unloadSql = this.buildUnloadStmt(statement, resultSchema, newTempDir, credsProvider, this.params().sseKmsKey(), threadName);
        this.log().info("Unloading data from Redshift");
        this.redshiftWrapper().executeInterruptibly(conn, unloadSql);
        SqlToS3TempCache$.MODULE$.setS3Path(statement.statementString(), newTempDir);
        return new Some((Object)newTempDir);
    }

    private StructType convertComplexTypesToString(StructType inputSchema) {
        return StructType$.MODULE$.apply((Seq)inputSchema.map((Function1 & Serializable)field -> {
            DataType dataType = field.dataType();
            if (dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType)) {
                return new StructField(field.name(), (DataType)StringType$.MODULE$, field.nullable(), field.metadata());
            }
            return field;
        }));
    }

    private scala.collection.immutable.Map<String, Column> mapComplexTypesToJson(StructType inputSchema) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])inputSchema.fields()), (Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)RedshiftRelation.$anonfun$mapComplexTypesToJson$1(field)))), (Function1 & Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), (Object)functions$.MODULE$.from_json(functions$.MODULE$.col(field.name()), field.dataType())), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private <T> RDD<T> readRDD(StructType resultSchema, Seq<String> filesToRead) {
        this.log().info("Reading S3 Text files");
        StructType noRepeatSchema = StructType$.MODULE$.apply((Seq)((IterableOps)resultSchema.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField f = (StructField)tuple2._1();
                int index = tuple2._2$mcI$sp();
                return new StructField("field" + index, f.dataType(), f.nullable(), f.metadata());
            }
            throw new MatchError((Object)tuple2);
        }));
        StructType modifiedSchema = this.convertComplexTypesToString(noRepeatSchema);
        Dataset dataFrame = this.sqlContext().read().format(RedshiftFileFormat.class.getName()).schema(modifiedSchema).option("nullString", this.params().nullString()).option(Parameters$.MODULE$.PARAM_OVERRIDE_NULLABLE(), this.params().overrideNullable()).load(filesToRead);
        scala.collection.immutable.Map<String, Column> mapping = this.mapComplexTypesToJson(noRepeatSchema);
        if (mapping.nonEmpty()) {
            return dataFrame.withColumns(mapping).queryExecution().executedPlan().execute();
        }
        return dataFrame.queryExecution().executedPlan().execute();
    }

    private <T> RDD<T> readRDDFromParquet(StructType resultSchema, Seq<String> filesToRead) {
        boolean conversionNeeded;
        this.log().info("Reading S3 Parquet files");
        DataFrameReader reader = this.sqlContext().read().format("parquet");
        StructType modifiedSchema = this.convertComplexTypesToString(resultSchema);
        Object object = filesToRead.isEmpty() ? reader.schema(modifiedSchema) : BoxedUnit.UNIT;
        boolean overrideNullable = this.params().overrideNullable();
        Dataset data = reader.load(filesToRead);
        scala.collection.immutable.Map<String, Column> mapping = this.mapComplexTypesToJson(new StructType((StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])data.schema().fields()), (IterableOnce)resultSchema)), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField actualField = (StructField)tuple2._1();
                StructField expectedField = (StructField)tuple2._2();
                return new StructField(actualField.name(), expectedField.dataType(), expectedField.nullable(), expectedField.metadata());
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(StructField.class))));
        Dataset jsonLoaded = mapping.nonEmpty() ? data.withColumns(mapping) : data;
        StructType jsonLoadedSchema = jsonLoaded.schema();
        boolean schemasDoNotMatch = !RedshiftRelation$.MODULE$.schemaTypesMatch((DataType)resultSchema, (DataType)jsonLoadedSchema);
        boolean bl = conversionNeeded = ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])resultSchema.fields()), (Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)RedshiftRelation.$anonfun$readRDDFromParquet$2(field))) || overrideNullable || schemasDoNotMatch;
        if (schemasDoNotMatch) {
            this.log().warn("Expected schema does not match schema of loaded parquet");
        }
        if (conversionNeeded) {
            RDD qual$1 = jsonLoaded.queryExecution().executedPlan().execute().map((Function1 & Serializable)row -> {
                Seq typeConvertedRow = (Seq)((IterableOps)row.toSeq(jsonLoadedSchema).zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        Object f = tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        return Conversions$.MODULE$.parquetDataTypeConvert(f, resultSchema.fields()[i].dataType(), resultSchema.fields()[i].metadata().contains("redshift_type") ? resultSchema.fields()[i].metadata().getString("redshift_type") : null, overrideNullable);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return InternalRow$.MODULE$.apply(typeConvertedRow);
            }, ClassTag$.MODULE$.apply(InternalRow.class));
            Function1 & Serializable x$1 = (Function1 & Serializable)iter -> {
                UnsafeProjection projection = UnsafeProjection$.MODULE$.create(resultSchema);
                return iter.map((Function1)projection);
            };
            boolean x$2 = qual$1.mapPartitions$default$2();
            return qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(InternalRow.class));
        }
        return jsonLoaded.queryExecution().executedPlan().execute();
    }

    private Seq<String> getFilesToRead(String tempDir, SparkContext sc) {
        Path manifestPath;
        URI tempDirUri = URI.create(tempDir);
        URI cleanedTempDirUri = Utils$.MODULE$.removeCredentialsFromURI(tempDirUri);
        String tempDirScheme = tempDirUri.getScheme();
        Option<String> credentials = this.extractCredentialsFromUri(tempDirUri);
        Configuration conf = sc.hadoopConfiguration();
        FileSystem fs = FileSystem.get((URI)cleanedTempDirUri, (Configuration)conf);
        if (fs.exists(manifestPath = new Path(cleanedTempDirUri.toString() + "/manifest"))) {
            Seq seq;
            FSDataInputStream is = fs.open(manifestPath);
            try {
                this.log().info("Begin finding S3 files to read");
                ObjectMapper mapper = new ObjectMapper();
                JsonNode entries = mapper.readTree((Reader)new InputStreamReader((InputStream)is)).get("entries");
                Seq results = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(entries.iterator()).asScala()).map((Function1 & Serializable)x$4 -> x$4.get("url").asText()).toSeq();
                this.log().info("Found {} S3 file(s)", (Object)BoxesRunTime.boxToInteger((int)results.length()));
                seq = results;
            }
            finally {
                is.close();
                this.log().info("End finding S3 files to read");
            }
            Seq s3Files = seq;
            Seq correctedS3Files = (Seq)s3Files.map((Function1 & Serializable)file -> this.addCredentialsAndEnsureScheme((String)file, credentials, tempDirScheme));
            return correctedS3Files;
        }
        this.log().debug("Manifest path not found");
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    private Option<String> extractCredentialsFromUri(URI uri) {
        return Option$.MODULE$.apply((Object)uri.getUserInfo());
    }

    private String addCredentialsAndEnsureScheme(String filePath, Option<String> credentials, String scheme) {
        URI fileUri = URI.create(filePath);
        String bucket = fileUri.getHost();
        String prefixPath = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(fileUri.getPath()), "/");
        String filePathWithoutSchemeAndCreds = bucket + "/" + prefixPath;
        Option<String> option = credentials;
        if (option instanceof Some) {
            Some some = (Some)option;
            String creds = (String)some.value();
            return scheme + "://" + creds + "@" + filePathWithoutSchemeAndCreds;
        }
        if (None$.MODULE$.equals(option)) {
            return scheme + "://" + filePathWithoutSchemeAndCreds;
        }
        throw new MatchError(option);
    }

    private StructType getResultSchema(RedshiftSQLStatement statement, Option<StructType> schema, RedshiftConnection conn) {
        StructType resultSchema = (StructType)schema.getOrElse((Function0 & Serializable)() -> this.redshiftWrapper().tableSchema(conn, statement, this.params()));
        if (resultSchema.isEmpty()) {
            throw new Exception("resultSchema isEmpty for " + statement.statementString());
        }
        return resultSchema;
    }

    public RedshiftRelation copy(RedshiftWrapper redshiftWrapper, Function2<AwsCredentialsProvider, Parameters.MergedParameters, S3Client> s3ClientFactory, Parameters.MergedParameters params, Option<StructType> userSchema, SQLContext sqlContext) {
        return new RedshiftRelation(redshiftWrapper, s3ClientFactory, params, userSchema, sqlContext);
    }

    public RedshiftWrapper copy$default$1() {
        return this.redshiftWrapper();
    }

    public Function2<AwsCredentialsProvider, Parameters.MergedParameters, S3Client> copy$default$2() {
        return this.s3ClientFactory();
    }

    public Parameters.MergedParameters copy$default$3() {
        return this.params();
    }

    public Option<StructType> copy$default$4() {
        return this.userSchema();
    }

    public String productPrefix() {
        return "RedshiftRelation";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.redshiftWrapper();
            }
            case 1: {
                return this.s3ClientFactory();
            }
            case 2: {
                return this.params();
            }
            case 3: {
                return this.userSchema();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RedshiftRelation;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "redshiftWrapper";
            }
            case 1: {
                return "s3ClientFactory";
            }
            case 2: {
                return "params";
            }
            case 3: {
                return "userSchema";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RedshiftRelation)) return false;
        boolean bl = true;
        if (!bl) return false;
        RedshiftRelation redshiftRelation = (RedshiftRelation)x$1;
        RedshiftWrapper redshiftWrapper = this.redshiftWrapper();
        RedshiftWrapper redshiftWrapper2 = redshiftRelation.redshiftWrapper();
        if (redshiftWrapper == null) {
            if (redshiftWrapper2 != null) {
                return false;
            }
        } else if (!redshiftWrapper.equals(redshiftWrapper2)) return false;
        Function2<AwsCredentialsProvider, Parameters.MergedParameters, S3Client> function2 = this.s3ClientFactory();
        Function2<AwsCredentialsProvider, Parameters.MergedParameters, S3Client> function22 = redshiftRelation.s3ClientFactory();
        if (function2 == null) {
            if (function22 != null) {
                return false;
            }
        } else if (!function2.equals(function22)) return false;
        Parameters.MergedParameters mergedParameters = this.params();
        Parameters.MergedParameters mergedParameters2 = redshiftRelation.params();
        if (mergedParameters == null) {
            if (mergedParameters2 != null) {
                return false;
            }
        } else if (!((Object)mergedParameters).equals(mergedParameters2)) return false;
        Option<StructType> option = this.userSchema();
        Option<StructType> option2 = redshiftRelation.userSchema();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!redshiftRelation.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$unhandledFilters$1(RedshiftRelation $this, Filter filter) {
        return FilterPushdown$.MODULE$.buildFilterExpression($this.schema(), filter, FilterPushdown$.MODULE$.buildFilterExpression$default$3()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$mapComplexTypesToJson$1(StructField field) {
        DataType dataType = field.dataType();
        return dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType);
    }

    public static final /* synthetic */ boolean $anonfun$readRDDFromParquet$2(StructField field) {
        Option<Object> option;
        DataType dataType = field.dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            return field.metadata().contains("redshift_type") && new .colon.colon((Object)"super", (List)new .colon.colon((Object)"bpchar", (List)Nil$.MODULE$)).contains((Object)field.metadata().getString("redshift_type"));
        }
        if (TimestampType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType))) {
            return true;
        }
        return dataType != null && !(option = TimestampNTZTypeExtractor$.MODULE$.unapply(dataType)).isEmpty() && !package$.MODULE$.legacyTimestampHandling();
    }

    public RedshiftRelation(RedshiftWrapper redshiftWrapper, Function2<AwsCredentialsProvider, Parameters.MergedParameters, S3Client> s3ClientFactory, Parameters.MergedParameters params, Option<StructType> userSchema, SQLContext sqlContext) {
        this.redshiftWrapper = redshiftWrapper;
        this.s3ClientFactory = s3ClientFactory;
        this.params = params;
        this.userSchema = userSchema;
        this.sqlContext = sqlContext;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        if (params.checkS3BucketUsage() && sqlContext != null) {
            Utils$.MODULE$.assertThatFileSystemIsNotS3BlockFileSystem(new URI(params.rootTempDir()), sqlContext.sparkContext().hadoopConfiguration());
        }
        this.tableNameOrSubquery = (String)params.query().map((Function1 & Serializable)q -> "(" + q + ")").orElse((Function0 & Serializable)() -> this.params().table().map((Function1 & Serializable)x$1 -> x$1.toString())).get();
    }
}

