/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import io.github.spark_redshift_community.spark.redshift.Parameters;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;

public final class Parameters$ {
    public static final Parameters$ MODULE$ = new Parameters$();
    private static final String PARAM_AUTO_PUSHDOWN = "autopushdown";
    private static final String PARAM_PUSHDOWN_S3_RESULT_CACHE = "autopushdown.s3_result_cache";
    private static final String PARAM_UNLOAD_S3_FORMAT = "unload_s3_format";
    private static final String PARAM_COPY_RETRY_COUNT = "copyretrycount";
    private static final String PARAM_COPY_DELAY = "copydelay";
    private static final String PARAM_LEGACY_JDBC_REAL_TYPE_MAPPING = "legacy_jdbc_real_type_mapping";
    private static final String PARAM_LEGACY_TRIM_CSV_WRITES = "legacy_trim_csv_writes";
    private static final String PARAM_OVERRIDE_NULLABLE = "overridenullable";
    private static final String PARAM_TEMPDIR_REGION = "tempdir_region";
    private static final String PARAM_SECRET_ID = "secret.id";
    private static final String PARAM_SECRET_REGION = "secret.region";
    private static final String PARAM_USER_QUERY_GROUP_LABEL = "label";
    private static final String PARAM_DATA_API_REGION = "data_api_region";
    private static final String PARAM_DATA_API_DATABASE = "data_api_database";
    private static final String PARAM_DATA_API_USER = "data_api_user";
    private static final String PARAM_DATA_API_CLUSTER = "data_api_cluster";
    private static final String PARAM_DATA_API_WORKGROUP = "data_api_workgroup";
    private static final String PARAM_TEMPORARY_AWS_ACCESS_KEY_ID = "temporary_aws_access_key_id";
    private static final String PARAM_TEMPORARY_AWS_SECRET_ACCESS_KEY = "temporary_aws_secret_access_key";
    private static final String PARAM_TEMPORARY_AWS_SESSION_TOKEN = "temporary_aws_session_token";
    private static final String PARAM_LEGACY_MAPPING_SHORT_TO_INT = "legacy_mapping_short_to_int";
    private static final String PARAM_CHECK_S3_BUCKET_USAGE = "check_s3_bucket_usage";
    private static final String PARAM_HOST_CONNECTOR = "host_connector";
    private static final Map<String, String> DEFAULT_PARAMETERS = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"forward_spark_s3_credentials"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tempformat"), (Object)"AVRO"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"csvnullstring"), (Object)"@NULL@"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"overwrite"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"diststyle"), (Object)"EVEN"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"usestagingtable"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"preactions"), (Object)";"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"postactions"), (Object)";"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"include_column_list"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.PARAM_AUTO_PUSHDOWN()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.PARAM_PUSHDOWN_S3_RESULT_CACHE()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.PARAM_UNLOAD_S3_FORMAT()), (Object)"PARQUET"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.PARAM_OVERRIDE_NULLABLE()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.PARAM_COPY_RETRY_COUNT()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.PARAM_COPY_DELAY()), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.PARAM_LEGACY_JDBC_REAL_TYPE_MAPPING()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.PARAM_LEGACY_TRIM_CSV_WRITES()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.PARAM_TEMPDIR_REGION()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.PARAM_LEGACY_MAPPING_SHORT_TO_INT()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.PARAM_CHECK_S3_BUCKET_USAGE()), (Object)"true")}));
    private static final Set<String> VALID_TEMP_FORMATS = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"AVRO", "CSV", "CSV GZIP", "PARQUET"}));
    private static final long DEFAULT_RETRY_DELAY = 30000L;

    public String PARAM_AUTO_PUSHDOWN() {
        return PARAM_AUTO_PUSHDOWN;
    }

    public String PARAM_PUSHDOWN_S3_RESULT_CACHE() {
        return PARAM_PUSHDOWN_S3_RESULT_CACHE;
    }

    public String PARAM_UNLOAD_S3_FORMAT() {
        return PARAM_UNLOAD_S3_FORMAT;
    }

    public String PARAM_COPY_RETRY_COUNT() {
        return PARAM_COPY_RETRY_COUNT;
    }

    public String PARAM_COPY_DELAY() {
        return PARAM_COPY_DELAY;
    }

    public String PARAM_LEGACY_JDBC_REAL_TYPE_MAPPING() {
        return PARAM_LEGACY_JDBC_REAL_TYPE_MAPPING;
    }

    public String PARAM_LEGACY_TRIM_CSV_WRITES() {
        return PARAM_LEGACY_TRIM_CSV_WRITES;
    }

    public String PARAM_OVERRIDE_NULLABLE() {
        return PARAM_OVERRIDE_NULLABLE;
    }

    public String PARAM_TEMPDIR_REGION() {
        return PARAM_TEMPDIR_REGION;
    }

    public String PARAM_SECRET_ID() {
        return PARAM_SECRET_ID;
    }

    public String PARAM_SECRET_REGION() {
        return PARAM_SECRET_REGION;
    }

    public String PARAM_USER_QUERY_GROUP_LABEL() {
        return PARAM_USER_QUERY_GROUP_LABEL;
    }

    public String PARAM_DATA_API_REGION() {
        return PARAM_DATA_API_REGION;
    }

    public String PARAM_DATA_API_DATABASE() {
        return PARAM_DATA_API_DATABASE;
    }

    public String PARAM_DATA_API_USER() {
        return PARAM_DATA_API_USER;
    }

    public String PARAM_DATA_API_CLUSTER() {
        return PARAM_DATA_API_CLUSTER;
    }

    public String PARAM_DATA_API_WORKGROUP() {
        return PARAM_DATA_API_WORKGROUP;
    }

    public String PARAM_TEMPORARY_AWS_ACCESS_KEY_ID() {
        return PARAM_TEMPORARY_AWS_ACCESS_KEY_ID;
    }

    public String PARAM_TEMPORARY_AWS_SECRET_ACCESS_KEY() {
        return PARAM_TEMPORARY_AWS_SECRET_ACCESS_KEY;
    }

    public String PARAM_TEMPORARY_AWS_SESSION_TOKEN() {
        return PARAM_TEMPORARY_AWS_SESSION_TOKEN;
    }

    public String PARAM_LEGACY_MAPPING_SHORT_TO_INT() {
        return PARAM_LEGACY_MAPPING_SHORT_TO_INT;
    }

    public String PARAM_CHECK_S3_BUCKET_USAGE() {
        return PARAM_CHECK_S3_BUCKET_USAGE;
    }

    public String PARAM_HOST_CONNECTOR() {
        return PARAM_HOST_CONNECTOR;
    }

    public Map<String, String> DEFAULT_PARAMETERS() {
        return DEFAULT_PARAMETERS;
    }

    public Set<String> VALID_TEMP_FORMATS() {
        return VALID_TEMP_FORMATS;
    }

    public long DEFAULT_RETRY_DELAY() {
        return DEFAULT_RETRY_DELAY;
    }

    private boolean dataAPICredentials(Map<String, String> userParameters) {
        return userParameters.contains((Object)this.PARAM_DATA_API_REGION()) || userParameters.contains((Object)this.PARAM_DATA_API_DATABASE()) || userParameters.contains((Object)this.PARAM_DATA_API_USER()) || userParameters.contains((Object)this.PARAM_DATA_API_CLUSTER()) || userParameters.contains((Object)this.PARAM_DATA_API_WORKGROUP());
    }

    private void checkUnsupportedParameters(Map<String, String> userParameters, String incompatibleType, Seq<String> unsupportedParams) {
        unsupportedParams.foreach((Function1 & Serializable)unsupportedParam -> {
            Parameters$.$anonfun$checkUnsupportedParameters$1(userParameters, incompatibleType, unsupportedParam);
            return BoxedUnit.UNIT;
        });
    }

    private void validateUserParameters(Map<String, String> userParameters) {
        if (!userParameters.contains((Object)"tempdir")) {
            throw new IllegalArgumentException("'tempdir' is required for all Redshift loads and saves");
        }
        if (userParameters.contains((Object)"tempformat") && !this.VALID_TEMP_FORMATS().contains((Object)((String)userParameters.apply((Object)"tempformat")).toUpperCase())) {
            throw new IllegalArgumentException("Invalid temp format: " + userParameters.apply((Object)"tempformat") + "; valid formats are: " + this.VALID_TEMP_FORMATS().mkString(", "));
        }
        if (!userParameters.contains((Object)"dbtable") && !userParameters.contains((Object)"query")) {
            throw new IllegalArgumentException("You must specify a Redshift table name with the 'dbtable' parameter or a query with the 'query' parameter.");
        }
        if (userParameters.contains((Object)"dbtable") && userParameters.contains((Object)"query")) {
            throw new IllegalArgumentException("You cannot specify both the 'dbtable' and 'query' parameters at the same time.");
        }
        if (userParameters.get((Object)this.PARAM_HOST_CONNECTOR()).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(x$1), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Parameters$.$anonfun$validateUserParameters$2(BoxesRunTime.unboxToChar((Object)x$2))))))) {
            char invalid = BoxesRunTime.unboxToChar((Object)StringOps$.MODULE$.find$extension(Predef$.MODULE$.augmentString((String)userParameters.apply((Object)this.PARAM_HOST_CONNECTOR())), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Parameters$.$anonfun$validateUserParameters$3(BoxesRunTime.unboxToChar((Object)x$3)))).get());
            throw new IllegalArgumentException("All characters in '" + this.PARAM_HOST_CONNECTOR() + "' option must be valid unicode identifier parts (char.isUnicodeIdentifierPart == true), '" + invalid + "' character not allowed");
        }
        if (userParameters.get((Object)this.PARAM_USER_QUERY_GROUP_LABEL()).exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(x$4), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Parameters$.$anonfun$validateUserParameters$5(BoxesRunTime.unboxToChar((Object)x$5))))))) {
            char invalid = BoxesRunTime.unboxToChar((Object)StringOps$.MODULE$.find$extension(Predef$.MODULE$.augmentString((String)userParameters.apply((Object)this.PARAM_USER_QUERY_GROUP_LABEL())), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Parameters$.$anonfun$validateUserParameters$6(BoxesRunTime.unboxToChar((Object)x$6)))).get());
            throw new IllegalArgumentException("All characters in '" + this.PARAM_USER_QUERY_GROUP_LABEL() + "' option must be valid unicode identifier parts (char.isUnicodeIdentifierPart == true), '" + invalid + "' character not allowed");
        }
        if (!this.dataAPICredentials(userParameters)) {
            if (!userParameters.contains((Object)"url")) {
                throw new IllegalArgumentException("A JDBC URL must be provided with 'url' parameter");
            }
            Option credsInURL = userParameters.get((Object)"url").filter((Function1 & Serializable)url -> BoxesRunTime.boxToBoolean((boolean)Parameters$.$anonfun$validateUserParameters$7(url)));
            if ((userParameters.contains((Object)"user") || userParameters.contains((Object)"password")) && credsInURL.isDefined()) {
                throw new IllegalArgumentException("You cannot specify credentials in both the URL and as user/password options");
            }
            if (credsInURL.isDefined() && userParameters.contains((Object)this.PARAM_SECRET_ID())) {
                throw new IllegalArgumentException("You cannot give a secret and specify credentials in URL");
            }
            if ((userParameters.contains((Object)"user") || userParameters.contains((Object)"password")) && userParameters.contains((Object)this.PARAM_SECRET_ID())) {
                throw new IllegalArgumentException("You cannot give a secret and specify user/password options");
            }
            return;
        }
        this.checkUnsupportedParameters(userParameters, "Data API", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"user", "password", "url", "jdbcdriver", this.PARAM_SECRET_REGION(), "secret.vpcEndpointUrl", "secret.vpcEndpointRegion"}));
        userParameters.foreach((Function1 & Serializable)x0$1 -> {
            Parameters$.$anonfun$validateUserParameters$8(x0$1);
            return BoxedUnit.UNIT;
        });
        if (userParameters.contains((Object)this.PARAM_DATA_API_USER()) && userParameters.contains((Object)this.PARAM_SECRET_ID())) {
            throw new IllegalArgumentException("You cannot specify both the 'data_api_user' and provide a secret at the same time.");
        }
        if (!userParameters.contains((Object)this.PARAM_DATA_API_DATABASE())) {
            throw new IllegalArgumentException("You must specify a Redshift database name with the 'data_api_database' parameter to use the Redshift Data API");
        }
        if (userParameters.contains((Object)this.PARAM_DATA_API_CLUSTER()) && userParameters.contains((Object)this.PARAM_DATA_API_WORKGROUP())) {
            throw new IllegalArgumentException("The parameters 'data_api_cluster' and 'data_api_workgroup' are mutually-exclusive.");
        }
        if (userParameters.contains((Object)this.PARAM_DATA_API_WORKGROUP()) && userParameters.contains((Object)this.PARAM_DATA_API_USER())) {
            throw new IllegalArgumentException("You cannot use 'data_api_user' when connecting to a serverless workgroup using 'data_api_workgroup'");
        }
    }

    public Parameters.MergedParameters mergeParameters(Map<String, String> userParameters) {
        this.validateUserParameters(userParameters);
        return new Parameters.MergedParameters((Map<String, String>)((Map)this.DEFAULT_PARAMETERS().$plus$plus(userParameters)));
    }

    public static final /* synthetic */ void $anonfun$checkUnsupportedParameters$1(Map userParameters$1, String incompatibleType$1, String unsupportedParam) {
        if (userParameters$1.contains((Object)unsupportedParam)) {
            throw new IllegalArgumentException("The parameter '" + unsupportedParam + "' is not compatible with " + incompatibleType$1 + " credentials.");
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateUserParameters$2(char x$2) {
        return !RichChar$.MODULE$.isUnicodeIdentifierPart$extension(Predef$.MODULE$.charWrapper(x$2));
    }

    public static final /* synthetic */ boolean $anonfun$validateUserParameters$3(char x$3) {
        return !RichChar$.MODULE$.isUnicodeIdentifierPart$extension(Predef$.MODULE$.charWrapper(x$3));
    }

    public static final /* synthetic */ boolean $anonfun$validateUserParameters$5(char x$5) {
        return !RichChar$.MODULE$.isUnicodeIdentifierPart$extension(Predef$.MODULE$.charWrapper(x$5));
    }

    public static final /* synthetic */ boolean $anonfun$validateUserParameters$6(char x$6) {
        return !RichChar$.MODULE$.isUnicodeIdentifierPart$extension(Predef$.MODULE$.charWrapper(x$6));
    }

    public static final /* synthetic */ boolean $anonfun$validateUserParameters$7(String url) {
        return url.contains("user=") || url.contains("password=") || url.contains("DbUser=");
    }

    public static final /* synthetic */ void $anonfun$validateUserParameters$8(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            if (key.matches("^jdbc\\..+")) {
                throw new IllegalArgumentException("The parameter '" + key + "' is not compatible with Data API credentials.");
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private Parameters$() {
    }
}

