/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import io.github.spark_redshift_community.spark.redshift.RowEncoderUtils$;
import io.github.spark_redshift_community.spark.redshift.package$;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Conversions$ {
    public static final Conversions$ MODULE$ = new Conversions$();
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S][X]");

    private DateTimeFormatter formatter() {
        return formatter;
    }

    private boolean parseBoolean(String s) {
        String string = s;
        String string2 = "t";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return true;
        }
        String string3 = s;
        String string4 = "f";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            return false;
        }
        throw new IllegalArgumentException("Expected 't' or 'f' but got '" + s + "'");
    }

    public DecimalFormat createRedshiftDecimalFormat() {
        DecimalFormat format = new DecimalFormat();
        format.setParseBigDecimal(true);
        format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        return format;
    }

    public SimpleDateFormat createRedshiftDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public DateTimeFormatter createRedshiftTimestampFormat() {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSSSS");
    }

    public Timestamp parseRedshiftTimestamp(String s) {
        Timestamp timestamp;
        TemporalAccessor temporalAccessor = this.formatter().parse(s);
        try {
            timestamp = Timestamp.from(ZonedDateTime.from(temporalAccessor).toInstant());
        }
        catch (DateTimeException e) {
            timestamp = Timestamp.valueOf(LocalDateTime.from(temporalAccessor));
        }
        return timestamp;
    }

    public Function1<String[], InternalRow> createRowConverter(StructType schema, String nullString, boolean overrideNullable) {
        SimpleDateFormat dateFormat = this.createRedshiftDateFormat();
        DecimalFormat decimalFormat = this.createRedshiftDecimalFormat();
        Function1[] conversionFunctions = (Function1[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)field -> {
            DataType dataType = field.dataType();
            if (ByteType$.MODULE$.equals(dataType)) {
                return (Function1 & Serializable)data -> BoxesRunTime.boxToByte((byte)Conversions$.$anonfun$createRowConverter$2(data));
            }
            if (BooleanType$.MODULE$.equals(dataType)) {
                return (Function1 & Serializable)data -> BoxesRunTime.boxToBoolean((boolean)Conversions$.MODULE$.parseBoolean(data));
            }
            if (DateType$.MODULE$.equals(dataType)) {
                return (Function1 & Serializable)data -> new Date(dateFormat.parse((String)data).getTime());
            }
            if (DoubleType$.MODULE$.equals(dataType)) {
                return (Function1 & Serializable)data -> {
                    String string = data;
                    switch (string == null ? 0 : string.hashCode()) {
                        case 104417: {
                            if (!"inf".equals(string)) break;
                            return BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY);
                        }
                        case 108827: {
                            if (!"nan".equals(string)) break;
                            return BoxesRunTime.boxToDouble((double)Double.NaN);
                        }
                        case 1445012: {
                            if (!"-inf".equals(string)) break;
                            return BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY);
                        }
                    }
                    return BoxesRunTime.boxToDouble((double)Double.parseDouble(data));
                };
            }
            if (FloatType$.MODULE$.equals(dataType)) {
                return (Function1 & Serializable)data -> {
                    String string = data;
                    switch (string == null ? 0 : string.hashCode()) {
                        case 104417: {
                            if (!"inf".equals(string)) break;
                            return BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY);
                        }
                        case 108827: {
                            if (!"nan".equals(string)) break;
                            return BoxesRunTime.boxToFloat((float)Float.NaN);
                        }
                        case 1445012: {
                            if (!"-inf".equals(string)) break;
                            return BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY);
                        }
                    }
                    return BoxesRunTime.boxToFloat((float)Float.parseFloat(data));
                };
            }
            if (dataType instanceof DecimalType) {
                return (Function1 & Serializable)data -> (BigDecimal)decimalFormat.parse((String)data);
            }
            if (IntegerType$.MODULE$.equals(dataType)) {
                return (Function1 & Serializable)data -> BoxesRunTime.boxToInteger((int)Conversions$.$anonfun$createRowConverter$8(data));
            }
            if (LongType$.MODULE$.equals(dataType)) {
                return (Function1 & Serializable)data -> BoxesRunTime.boxToLong((long)Conversions$.$anonfun$createRowConverter$9(data));
            }
            if (ShortType$.MODULE$.equals(dataType)) {
                return (Function1 & Serializable)data -> BoxesRunTime.boxToShort((short)Conversions$.$anonfun$createRowConverter$10(data));
            }
            if (StringType$.MODULE$.equals(dataType)) {
                return (Function1 & Serializable)data -> data;
            }
            if (TimestampType$.MODULE$.equals(dataType)) {
                return (Function1 & Serializable)data -> MODULE$.parseRedshiftTimestamp((String)data);
            }
            return (Function1 & Serializable)data -> data;
        }, ClassTag$.MODULE$.apply(Function1.class));
        Object[] converted = (Object[])Array$.MODULE$.fill(schema.length(), (Function0 & Serializable)() -> null, ClassTag$.MODULE$.Any());
        GenericRow externalRow = new GenericRow(converted);
        ExpressionEncoder.Serializer toRow = RowEncoderUtils$.MODULE$.expressionEncoderForSchema(schema).createSerializer();
        return arg_0 -> Conversions$.$anonfun$createRowConverter$15(schema, overrideNullable, converted, conversionFunctions, nullString, toRow, externalRow, arg_0);
    }

    public Object parquetDataTypeConvert(Object from, DataType dataType, String redshiftType, boolean overrideNullable) {
        boolean bl = false;
        DecimalType decimalType = null;
        DataType dataType2 = dataType;
        if (overrideNullable && from != null && from.toString().isEmpty()) {
            return null;
        }
        if (ByteType$.MODULE$.equals(dataType2) && from != null) {
            return BoxesRunTime.boxToByte((byte)Byte.parseByte(from.toString()));
        }
        if (DoubleType$.MODULE$.equals(dataType2) && from != null) {
            return BoxesRunTime.boxToDouble((double)((Number)from).doubleValue());
        }
        if (FloatType$.MODULE$.equals(dataType2) && from != null) {
            return BoxesRunTime.boxToFloat((float)((Number)from).floatValue());
        }
        if (IntegerType$.MODULE$.equals(dataType2) && from != null) {
            return BoxesRunTime.boxToInteger((int)((Number)from).intValue());
        }
        if (LongType$.MODULE$.equals(dataType2) && from != null) {
            return BoxesRunTime.boxToLong((long)((Number)from).longValue());
        }
        if (ShortType$.MODULE$.equals(dataType2) && from != null) {
            return BoxesRunTime.boxToShort((short)((Number)from).shortValue());
        }
        if (dataType2 instanceof DecimalType) {
            bl = true;
            decimalType = (DecimalType)dataType2;
            if (from != null && from instanceof Double) {
                return Decimal$.MODULE$.apply(BoxesRunTime.unboxToDouble((Object)from));
            }
        }
        if (bl && from != null & from instanceof Decimal) {
            return Decimal$.MODULE$.apply(((Decimal)from).toBigDecimal());
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            if (from == null) {
                String string = redshiftType;
                String string2 = "super";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return UTF8String.fromString((String)"null");
                }
            }
            if (from != null) {
                String string = redshiftType;
                String string3 = "bpchar";
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    return ((UTF8String)from).trimRight();
                }
            }
            return from;
        }
        if (DateType$.MODULE$.equals(dataType2) && from != null && from instanceof Long) {
            return BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.microsToDays(BoxesRunTime.unboxToLong((Object)from), ZoneId.of("UTC")));
        }
        if (TimestampType$.MODULE$.equals(dataType2) && package$.MODULE$.legacyTimestampHandling() && from != null) {
            String string = redshiftType;
            String string4 = "timestamptz";
            if (!(string != null ? !string.equals(string4) : string4 != null)) {
                return from;
            }
            return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.toUTCTime(BoxesRunTime.unboxToLong((Object)from), ZoneId.systemDefault().getId()));
        }
        return from;
    }

    public static final /* synthetic */ byte $anonfun$createRowConverter$2(String data) {
        return Byte.parseByte(data);
    }

    public static final /* synthetic */ int $anonfun$createRowConverter$8(String data) {
        return Integer.parseInt(data);
    }

    public static final /* synthetic */ long $anonfun$createRowConverter$9(String data) {
        return Long.parseLong(data);
    }

    public static final /* synthetic */ short $anonfun$createRowConverter$10(String data) {
        return Short.parseShort(data);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ InternalRow $anonfun$createRowConverter$15(StructType schema$1, boolean overrideNullable$1, Object[] converted$1, Function1[] conversionFunctions$1, String nullString$1, ExpressionEncoder.Serializer toRow$1, GenericRow externalRow$1, String[] inputRow) {
        for (i = 0; i < schema$1.length(); ++i) {
            data = inputRow[i];
            if (overrideNullable$1) {
                converted$1[i] = data == null || data.isEmpty() != false ? null : conversionFunctions$1[i].apply((Object)data);
                continue;
            }
            if (data == null) ** GOTO lbl-1000
            v0 = data;
            var10_10 = nullString$1;
            if (!(v0 == null ? var10_10 != null : v0.equals(var10_10) == false)) ** GOTO lbl-1000
            if (data.isEmpty()) {
                v1 = schema$1.fields()[i].dataType();
                var11_11 = StringType$.MODULE$;
                ** if (!(v1 == null ? var11_11 != null : v1.equals((Object)var11_11) == false)) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 3 sources

            {
                v2 = null;
                ** GOTO lbl18
            }
lbl-1000:
            // 2 sources

            {
                v2 = data.isEmpty() != false ? "" : conversionFunctions$1[i].apply((Object)data);
            }
lbl18:
            // 2 sources

            converted$1[i] = v2;
        }
        return toRow$1.apply((Object)externalRow$1);
    }

    private Conversions$() {
    }
}

