/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift.data;

import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.data.DataApiWrapper;
import io.github.spark_redshift_community.spark.redshift.data.JDBCWrapper;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftWrapper;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftWrapperType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;

public final class RedshiftWrapperFactory$ {
    public static RedshiftWrapperFactory$ MODULE$;
    private final Logger log;
    private final RedshiftWrapper jdbcSingleton;
    private final RedshiftWrapper dataAPISingleton;

    static {
        new RedshiftWrapperFactory$();
    }

    private Logger log() {
        return this.log;
    }

    private RedshiftWrapper jdbcSingleton() {
        return this.jdbcSingleton;
    }

    private RedshiftWrapper dataAPISingleton() {
        return this.dataAPISingleton;
    }

    public RedshiftWrapper apply(Parameters.MergedParameters params) {
        RedshiftWrapper redshiftWrapper;
        if (params.dataAPICreds()) {
            this.log().debug("Using Data API to communicate with Redshift");
            redshiftWrapper = this.dataAPISingleton();
        } else {
            this.log().debug("Using JDBC to communicate with Redshift");
            redshiftWrapper = this.jdbcSingleton();
        }
        return redshiftWrapper;
    }

    private RedshiftWrapper apply(Enumeration.Value dataInterfaceType) {
        Enumeration.Value value = dataInterfaceType;
        Enumeration.Value value2 = RedshiftWrapperType$.MODULE$.DataAPI();
        Enumeration.Value value3 = value;
        RedshiftWrapper redshiftWrapper = !(value2 != null ? !value2.equals(value3) : value3 != null) ? new DataApiWrapper() : new JDBCWrapper();
        return redshiftWrapper;
    }

    private RedshiftWrapperFactory$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.jdbcSingleton = this.apply(RedshiftWrapperType$.MODULE$.JDBC());
        this.dataAPISingleton = this.apply(RedshiftWrapperType$.MODULE$.DataAPI());
    }
}

