/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift.data;

import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.TimestampNTZTypeExtractor$;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftConnection;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftResults;
import io.github.spark_redshift_community.spark.redshift.package$;
import io.github.spark_redshift_community.spark.redshift.pushdown.RedshiftSQLStatement;
import java.io.Serializable;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-e!B\u000b\u0017\u0001a\u0011\u0003\"\u0002\u0017\u0001\t\u0003q\u0003bB\u0019\u0001\u0005\u0004%\tB\r\u0005\u0007w\u0001\u0001\u000b\u0011B\u001a\t\u000fq\u0002!\u0019!C\te!1Q\b\u0001Q\u0001\nMBQA\u0010\u0001\u0005\u0002}Bqa\u001c\u0001\u0012\u0002\u0013\u0005\u0001\u000fC\u0003|\u0001\u0011\u0005A\u0010C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003o\u0001A\u0011AA\u001d\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000fBq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002T\u0001!\t!!\u0016\t\u000f\u0005u\u0003\u0001\"\u0001\u0002`!A\u0011\u0011\u000e\u0001\u0012\u0002\u0013\u0005\u0001\u000fC\u0004\u0002l\u0001!\t!!\u001c\t\u000f\u0005M\u0004\u0001\"\u0001\u0002v\ty!+\u001a3tQ&4Go\u0016:baB,'O\u0003\u0002\u00181\u0005!A-\u0019;b\u0015\tI\"$\u0001\u0005sK\u0012\u001c\b.\u001b4u\u0015\tYB$A\u0003ta\u0006\u00148N\u0003\u0002\u001e=\u0005A2\u000f]1sW~\u0013X\rZ:iS\u001a$xlY8n[Vt\u0017\u000e^=\u000b\u0005}\u0001\u0013AB4ji\",(MC\u0001\"\u0003\tIwnE\u0002\u0001G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0007C\u0001\u0013+\u0013\tYSE\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGOP\u0002\u0001)\u0005y\u0003C\u0001\u0019\u0001\u001b\u00051\u0012!E'B'R+%k\u0018'P\u000f~\u0003&+\u0012$J1V\t1\u0007\u0005\u00025s5\tQG\u0003\u00027o\u0005!A.\u00198h\u0015\u0005A\u0014\u0001\u00026bm\u0006L!AO\u001b\u0003\rM#(/\u001b8h\u0003Ii\u0015i\u0015+F%~cujR0Q%\u00163\u0015\n\u0017\u0011\u0002#]{%kS#S?2{ui\u0018)S\u000b\u001aK\u0005,\u0001\nX\u001fJ[UIU0M\u001f\u001e{\u0006KU#G\u0013b\u0003\u0013\u0001D:dQ\u0016l\u0017m\u0015;sS:<Gc\u0001!K3B\u0011\u0011\t\u0013\b\u0003\u0005\u001a\u0003\"aQ\u0013\u000e\u0003\u0011S!!R\u0017\u0002\rq\u0012xn\u001c;?\u0013\t9U%\u0001\u0004Qe\u0016$WMZ\u0005\u0003u%S!aR\u0013\t\u000b-3\u0001\u0019\u0001'\u0002\rM\u001c\u0007.Z7b!\tiu+D\u0001O\u0015\ty\u0005+A\u0003usB,7O\u0003\u0002R%\u0006\u00191/\u001d7\u000b\u0005m\u0019&B\u0001+V\u0003\u0019\t\u0007/Y2iK*\ta+A\u0002pe\u001eL!\u0001\u0017(\u0003\u0015M#(/^2u)f\u0004X\rC\u0004[\rA\u0005\t\u0019A.\u0002\rA\f'/Y7t!\r!CLX\u0005\u0003;\u0016\u0012aa\u00149uS>t\u0007CA0m\u001d\t\u0001'N\u0004\u0002bS:\u0011!\r\u001b\b\u0003G\u001et!\u0001\u001a4\u000f\u0005\r+\u0017\"A\u0011\n\u0005}\u0001\u0013BA\u000f\u001f\u0013\tYB$\u0003\u0002\u001a5%\u00111\u000eG\u0001\u000b!\u0006\u0014\u0018-\\3uKJ\u001c\u0018BA7o\u0005AiUM]4fIB\u000b'/Y7fi\u0016\u00148O\u0003\u0002l1\u000512o\u00195f[\u0006\u001cFO]5oO\u0012\"WMZ1vYR$#'F\u0001rU\tY&oK\u0001t!\t!\u00180D\u0001v\u0015\t1x/A\u0005v]\u000eDWmY6fI*\u0011\u00010J\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001>v\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eg\u0016$\u0018)\u001e;p\u0007>lW.\u001b;\u0015\u000bu\f\t!a\u0003\u0011\u0005\u0011r\u0018BA@&\u0005\u0011)f.\u001b;\t\u000f\u0005\r\u0001\u00021\u0001\u0002\u0006\u0005!1m\u001c8o!\r\u0001\u0014qA\u0005\u0004\u0003\u00131\"A\u0005*fIND\u0017N\u001a;D_:tWm\u0019;j_:Dq!!\u0004\t\u0001\u0004\ty!\u0001\u0006bkR|7i\\7nSR\u00042\u0001JA\t\u0013\r\t\u0019\"\n\u0002\b\u0005>|G.Z1o\u0003\u0019\u0019w.\\7jiR\u0019Q0!\u0007\t\u000f\u0005\r\u0011\u00021\u0001\u0002\u0006\u0005A!o\u001c7mE\u0006\u001c7\u000eF\u0002~\u0003?Aq!a\u0001\u000b\u0001\u0004\t)!\u0001\u000bfq\u0016\u001cW\u000f^3J]R,'O];qi&\u0014G.\u001f\u000b\u0007\u0003\u001f\t)#a\n\t\u000f\u0005\r1\u00021\u0001\u0002\u0006!)\u0011k\u0003a\u0001\u0001\u0006IR\r_3dkR,\u0017+^3ss&sG/\u001a:skB$\u0018N\u00197z)\u0019\ti#a\r\u00026A\u0019\u0001'a\f\n\u0007\u0005EbCA\bSK\u0012\u001c\b.\u001b4u%\u0016\u001cX\u000f\u001c;t\u0011\u001d\t\u0019\u0001\u0004a\u0001\u0003\u000bAQ!\u0015\u0007A\u0002\u0001\u000b!$\u001a=fGV$X-\u00169eCR,\u0017J\u001c;feJ,\b\u000f^5cYf$b!a\u000f\u0002B\u0005\r\u0003c\u0001\u0013\u0002>%\u0019\u0011qH\u0013\u0003\t1{gn\u001a\u0005\b\u0003\u0007i\u0001\u0019AA\u0003\u0011\u0015\tV\u00021\u0001A\u00035)\u00070Z2vi\u0016,\u0006\u000fZ1uKR1\u00111HA%\u0003\u0017Bq!a\u0001\u000f\u0001\u0004\t)\u0001C\u0003R\u001d\u0001\u0007\u0001)\u0001\u0007hKR\u001cuN\u001c8fGR|'\u000f\u0006\u0003\u0002\u0006\u0005E\u0003\"\u0002.\u0010\u0001\u0004q\u0016AG4fi\u000e{gN\\3di>\u0014x+\u001b;i#V,'/_$s_V\u0004HCBA\u0003\u0003/\nI\u0006C\u0003[!\u0001\u0007a\f\u0003\u0004\u0002\\A\u0001\r\u0001Q\u0001\u000bcV,'/_$s_V\u0004\u0018\u0001\u0004:fg>dg/\u001a+bE2,Gc\u0002'\u0002b\u0005\r\u0014q\r\u0005\b\u0003\u0007\t\u0002\u0019AA\u0003\u0011\u0019\t)'\u0005a\u0001\u0001\u0006)A/\u00192mK\"9!,\u0005I\u0001\u0002\u0004Y\u0016A\u0006:fg>dg/\u001a+bE2,G\u0005Z3gCVdG\u000fJ\u001a\u0002\u0017Q\f'\r\\3Fq&\u001cHo\u001d\u000b\u0007\u0003\u001f\ty'!\u001d\t\u000f\u0005\r1\u00031\u0001\u0002\u0006!1\u0011QM\nA\u0002\u0001\u000b1\u0002^1cY\u0016\u001c6\r[3nCR9A*a\u001e\u0002z\u0005%\u0005bBA\u0002)\u0001\u0007\u0011Q\u0001\u0005\b\u0003w\"\u0002\u0019AA?\u0003%\u0019H/\u0019;f[\u0016tG\u000f\u0005\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\r\t\u0019\tG\u0001\taV\u001c\b\u000eZ8x]&!\u0011qQAA\u0005Q\u0011V\rZ:iS\u001a$8+\u0015'Ti\u0006$X-\\3oi\")!\f\u0006a\u0001=\u0002")
public class RedshiftWrapper
implements scala.Serializable {
    private final String MASTER_LOG_PREFIX;
    private final String WORKER_LOG_PREFIX;

    public String MASTER_LOG_PREFIX() {
        return this.MASTER_LOG_PREFIX;
    }

    public String WORKER_LOG_PREFIX() {
        return this.WORKER_LOG_PREFIX;
    }

    public String schemaString(StructType schema, Option<Parameters.MergedParameters> params) {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
            String string;
            String name = field.name();
            if (field.metadata().contains("redshift_type")) {
                string = field.metadata().getString("redshift_type");
            } else {
                String string2;
                DataType dataType = field.dataType();
                if (IntegerType$.MODULE$.equals(dataType)) {
                    string2 = "INTEGER";
                } else if (LongType$.MODULE$.equals(dataType)) {
                    string2 = "BIGINT";
                } else if (DoubleType$.MODULE$.equals(dataType)) {
                    string2 = "DOUBLE PRECISION";
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    string2 = "REAL";
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    string2 = params.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.legacyMappingShortToInt())) ? "INTEGER" : "SMALLINT";
                } else if (ByteType$.MODULE$.equals(dataType)) {
                    string2 = "SMALLINT";
                } else if (BooleanType$.MODULE$.equals(dataType)) {
                    string2 = "BOOLEAN";
                } else if (StringType$.MODULE$.equals(dataType)) {
                    string2 = field.metadata().contains("maxlength") ? new StringBuilder(9).append("VARCHAR(").append(field.metadata().getLong("maxlength")).append(")").toString() : "VARCHAR(MAX)";
                } else if (TimestampType$.MODULE$.equals(dataType)) {
                    string2 = package$.MODULE$.legacyTimestampHandling() ? "TIMESTAMP" : "TIMESTAMPTZ";
                } else {
                    Option<Object> option = TimestampNTZTypeExtractor$.MODULE$.unapply(dataType);
                    if (!option.isEmpty() && !package$.MODULE$.legacyTimestampHandling()) {
                        string2 = "TIMESTAMP";
                    } else if (DateType$.MODULE$.equals(dataType)) {
                        string2 = "DATE";
                    } else if (dataType instanceof DecimalType) {
                        DecimalType decimalType = (DecimalType)dataType;
                        string2 = new StringBuilder(10).append("DECIMAL(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString();
                    } else {
                        boolean bl = dataType instanceof ArrayType ? true : (dataType instanceof MapType ? true : dataType instanceof StructType);
                        if (bl) {
                            string2 = "SUPER";
                        } else {
                            throw new IllegalArgumentException(new StringBuilder(31).append("Don't know how to save ").append(field).append(" to JDBC").toString());
                        }
                    }
                }
                string = string2;
            }
            String typ = string;
            String nullable = field.nullable() ? "" : "NOT NULL";
            String encoding = field.metadata().contains("encoding") ? new StringBuilder(7).append("ENCODE ").append(field.metadata().getString("encoding")).toString() : "";
            return sb.append(new StringBuilder(7).append(", \"").append(name.replace("\"", "\\\"")).append("\" ").append(typ).append(" ").append(nullable).append(" ").append(encoding).toString().trim());
        });
        return sb.length() < 2 ? "" : sb.substring(2);
    }

    public Option<Parameters.MergedParameters> schemaString$default$2() {
        return None$.MODULE$;
    }

    public void setAutoCommit(RedshiftConnection conn, boolean autoCommit) {
        throw new NotImplementedError();
    }

    public void commit(RedshiftConnection conn) {
        throw new NotImplementedError();
    }

    public void rollback(RedshiftConnection conn) {
        throw new NotImplementedError();
    }

    public boolean executeInterruptibly(RedshiftConnection conn, String sql) {
        throw new NotImplementedError();
    }

    public RedshiftResults executeQueryInterruptibly(RedshiftConnection conn, String sql) {
        throw new NotImplementedError();
    }

    public long executeUpdateInterruptibly(RedshiftConnection conn, String sql) {
        throw new NotImplementedError();
    }

    public long executeUpdate(RedshiftConnection conn, String sql) {
        throw new NotImplementedError();
    }

    public RedshiftConnection getConnector(Parameters.MergedParameters params) {
        throw new NotImplementedError();
    }

    public RedshiftConnection getConnectorWithQueryGroup(Parameters.MergedParameters params, String queryGroup) {
        throw new NotImplementedError();
    }

    public StructType resolveTable(RedshiftConnection conn, String table, Option<Parameters.MergedParameters> params) {
        throw new NotImplementedError();
    }

    public Option<Parameters.MergedParameters> resolveTable$default$3() {
        return None$.MODULE$;
    }

    public boolean tableExists(RedshiftConnection conn, String table) {
        throw new NotImplementedError();
    }

    public StructType tableSchema(RedshiftConnection conn, RedshiftSQLStatement statement, Parameters.MergedParameters params) {
        throw new NotImplementedError();
    }

    public RedshiftWrapper() {
        this.MASTER_LOG_PREFIX = "Spark Connector Master";
        this.WORKER_LOG_PREFIX = "Spark Connector Worker";
    }
}

