/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift.data;

import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.Utils$;
import io.github.spark_redshift_community.spark.redshift.data.JDBCConnection;
import io.github.spark_redshift_community.spark.redshift.data.JDBCResults;
import io.github.spark_redshift_community.spark.redshift.data.JDBCWrapper$;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftConnection;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftResults;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftWrapper;
import io.github.spark_redshift_community.spark.redshift.pushdown.BooleanVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.ByteVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.ConstantString;
import io.github.spark_redshift_community.spark.redshift.pushdown.DoubleVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.FloatVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.Identifier;
import io.github.spark_redshift_community.spark.redshift.pushdown.IntVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.LongVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.RedshiftSQLStatement;
import io.github.spark_redshift_community.spark.redshift.pushdown.ShortVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.StatementElement;
import io.github.spark_redshift_community.spark.redshift.pushdown.StringVariable;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tEg!\u0002\u00180\u0001EZ\u0004\"\u0002$\u0001\t\u0003A\u0005b\u0002&\u0001\u0005\u0004%\tb\u0013\u0005\u0007)\u0002\u0001\u000b\u0011\u0002'\t\u0011U\u0003\u0001R1A\u0005\fYC\u0001\u0002\u001a\u0001\t\u0006\u0004%Y!\u001a\u0005\t[\u0002A)\u0019!C\u0005]\"1q\u0010\u0001C\u0005\u0003\u0003Aq!!\u000b\u0001\t\u0013\tY\u0003C\u0004\u0002R\u0001!\t%a\u0015\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"9\u00111\u0012\u0001\u0005B\u00055\u0005bBAR\u0001\u0011\u0005\u0013Q\u0015\u0005\b\u0003S\u0003A\u0011IAV\u0011\u0019y\b\u0001\"\u0011\u00020\"9\u0011Q\u0017\u0001\u0005B\u0005]\u0006bBAb\u0001\u0011\u0005\u0013Q\u0019\u0005\b\u0003#\u0004A\u0011IAj\u0011\u001d\tI\u000e\u0001C!\u00037D\u0011\"a?\u0001#\u0003%\t!!@\t\u000f\tM\u0001\u0001\"\u0003\u0003\u0016!9!1\u0005\u0001\u0005\n\t\u0015\u0002\"\u0003B \u0001E\u0005I\u0011BA\u007f\u0011\u001d\u0011\t\u0005\u0001C!\u0005\u0007BqA!\u0013\u0001\t\u0003\u0012Y\u0005C\u0004\u0003`\u0001!IA!\u0019\t\u0013\t-\u0004!%A\u0005\n\t5\u0004b\u0002B9\u0001\u0011%!1\u000f\u0005\b\u0005w\u0002A\u0011\u0002B?\u0011\u001d\u0011)\t\u0001C\u0005\u0005\u000f;\u0001B!$0\u0011\u0003\t$q\u0012\u0004\b]=B\t!\rBI\u0011\u00191u\u0004\"\u0001\u0003\u001a\"I!1T\u0010C\u0002\u0013\u0005!Q\u0014\u0005\t\u0005S{\u0002\u0015!\u0003\u0003 \"I!1V\u0010C\u0002\u0013\u0005!Q\u0014\u0005\t\u0005[{\u0002\u0015!\u0003\u0003 \"I!qV\u0010C\u0002\u0013\u0005!Q\u0014\u0005\t\u0005c{\u0002\u0015!\u0003\u0003 \"I!1W\u0010C\u0002\u0013\u0005!Q\u0014\u0005\t\u0005k{\u0002\u0015!\u0003\u0003 \"I!qW\u0010C\u0002\u0013\u0005!Q\u0014\u0005\t\u0005s{\u0002\u0015!\u0003\u0003 \"I!1X\u0010C\u0002\u0013\u0005!Q\u0018\u0005\t\u0005\u000b|\u0002\u0015!\u0003\u0003@\"I!qY\u0010\u0002\u0002\u0013%!\u0011\u001a\u0002\f\u0015\u0012\u00135i\u0016:baB,'O\u0003\u00021c\u0005!A-\u0019;b\u0015\t\u00114'\u0001\u0005sK\u0012\u001c\b.\u001b4u\u0015\t!T'A\u0003ta\u0006\u00148N\u0003\u00027o\u0005A2\u000f]1sW~\u0013X\rZ:iS\u001a$xlY8n[Vt\u0017\u000e^=\u000b\u0005aJ\u0014AB4ji\",(MC\u0001;\u0003\tIwnE\u0002\u0001y\u0001\u0003\"!\u0010 \u000e\u0003=J!aP\u0018\u0003\u001fI+Gm\u001d5jMR<&/\u00199qKJ\u0004\"!\u0011#\u000e\u0003\tS\u0011aQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000b\n\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002\u0013B\u0011Q\bA\u0001\u0004Y><W#\u0001'\u0011\u00055\u0013V\"\u0001(\u000b\u0005=\u0003\u0016!B:mMRR'\"A)\u0002\u0007=\u0014x-\u0003\u0002T\u001d\n1Aj\\4hKJ\fA\u0001\\8hA\u0005\u00192-\u00197m\u001dVl'-\u001a:HK:,'/\u0019;peV\tq\u000bE\u0002Y7vk\u0011!\u0017\u0006\u00035\n\u000b!bY8mY\u0016\u001cG/[8o\u0013\ta\u0016L\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\t\te,\u0003\u0002`\u0005\n\u0019\u0011J\u001c;)\u0005\u0011\t\u0007CA!c\u0013\t\u0019'IA\u0005ue\u0006t7/[3oi\u0006\u0011QmY\u000b\u0002MB\u0011qM[\u0007\u0002Q*\u0011\u0011NQ\u0001\u000bG>t7-\u001e:sK:$\u0018BA6i\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000f\u000b\u0002\u0006C\u0006y1-\u00198dK2d\u0017\r^5p]6\u000b\u0007/F\u0001p!\u0011\u0001h\u000f_/\u000e\u0003ET!!\u001b:\u000b\u0005M$\u0018\u0001B;uS2T\u0011!^\u0001\u0005U\u00064\u0018-\u0003\u0002xc\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0005edX\"\u0001>\u000b\u0005m$\u0018aA:rY&\u0011QP\u001f\u0002\u0012!J,\u0007/\u0019:fIN#\u0018\r^3nK:$\bF\u0001\u0004b\u0003Q)\u00070Z2vi\u0016Le\u000e^3seV\u0004H/\u001b2msV!\u00111AA\u0005)\u0019\t)!a\u0007\u0002 A!\u0011qAA\u0005\u0019\u0001!q!a\u0003\b\u0005\u0004\tiAA\u0001U#\u0011\ty!!\u0006\u0011\u0007\u0005\u000b\t\"C\u0002\u0002\u0014\t\u0013qAT8uQ&tw\rE\u0002B\u0003/I1!!\u0007C\u0005\r\te.\u001f\u0005\u0007\u0003;9\u0001\u0019\u0001=\u0002\u0013M$\u0018\r^3nK:$\bbBA\u0011\u000f\u0001\u0007\u00111E\u0001\u0003_B\u0004b!QA\u0013q\u0006\u0015\u0011bAA\u0014\u0005\nIa)\u001e8di&|g.M\u0001\u000fO\u0016$HI]5wKJ\u001cE.Y:t)\u0019\ti#a\u0011\u0002HA!\u0011qFA\u001f\u001d\u0011\t\t$!\u000f\u0011\u0007\u0005M\")\u0004\u0002\u00026)\u0019\u0011qG$\u0002\rq\u0012xn\u001c;?\u0013\r\tYDQ\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0012\u0011\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005m\"\tC\u0004\u0002F!\u0001\r!!\f\u0002\u001f)$'mY*vEB\u0014x\u000e^8d_2Dq!!\u0013\t\u0001\u0004\tY%A\fvg\u0016\u0014\bK]8wS\u0012,G\r\u0012:jm\u0016\u00148\t\\1tgB)\u0011)!\u0014\u0002.%\u0019\u0011q\n\"\u0003\r=\u0003H/[8o\u000319W\r^\"p]:,7\r^8s)\u0011\t)&a\u0017\u0011\u0007u\n9&C\u0002\u0002Z=\u0012!CU3eg\"Lg\r^\"p]:,7\r^5p]\"9\u0011QL\u0005A\u0002\u0005}\u0013A\u00029be\u0006l7\u000f\u0005\u0003\u0002b\u0005md\u0002BA2\u0003orA!!\u001a\u0002v9!\u0011qMA:\u001d\u0011\tI'!\u001d\u000f\t\u0005-\u0014q\u000e\b\u0005\u0003g\ti'C\u0001;\u0013\tA\u0014(\u0003\u00027o%\u0011A'N\u0005\u0003eMJ1!!\u001f2\u0003)\u0001\u0016M]1nKR,'o]\u0005\u0005\u0003{\nyH\u0001\tNKJ<W\r\u001a)be\u0006lW\r^3sg*\u0019\u0011\u0011P\u0019\u00025\u001d,GoQ8o]\u0016\u001cGo\u001c:XSRD\u0017+^3ss\u001e\u0013x.\u001e9\u0015\r\u0005U\u0013QQAD\u0011\u001d\tiF\u0003a\u0001\u0003?Bq!!#\u000b\u0001\u0004\ti#\u0001\u0006rk\u0016\u0014\u0018p\u0012:pkB\fQb]3u\u0003V$xnQ8n[&$HCBAH\u0003+\u000bI\nE\u0002B\u0003#K1!a%C\u0005\u0011)f.\u001b;\t\u000f\u0005]5\u00021\u0001\u0002V\u0005!1m\u001c8o\u0011\u001d\tYj\u0003a\u0001\u0003;\u000b!\"Y;u_\u000e{W.\\5u!\r\t\u0015qT\u0005\u0004\u0003C\u0013%a\u0002\"p_2,\u0017M\\\u0001\u0007G>lW.\u001b;\u0015\t\u0005=\u0015q\u0015\u0005\b\u0003/c\u0001\u0019AA+\u0003!\u0011x\u000e\u001c7cC\u000e\\G\u0003BAH\u0003[Cq!a&\u000e\u0001\u0004\t)\u0006\u0006\u0004\u0002\u001e\u0006E\u00161\u0017\u0005\b\u0003/s\u0001\u0019AA+\u0011\u0019Yh\u00021\u0001\u0002.\u0005IR\r_3dkR,\u0017+^3ss&sG/\u001a:skB$\u0018N\u00197z)\u0019\tI,a0\u0002BB\u0019Q(a/\n\u0007\u0005uvFA\bSK\u0012\u001c\b.\u001b4u%\u0016\u001cX\u000f\u001c;t\u0011\u001d\t9j\u0004a\u0001\u0003+Baa_\bA\u0002\u00055\u0012AG3yK\u000e,H/Z+qI\u0006$X-\u00138uKJ\u0014X\u000f\u001d;jE2LHCBAd\u0003\u001b\fy\rE\u0002B\u0003\u0013L1!a3C\u0005\u0011auN\\4\t\u000f\u0005]\u0005\u00031\u0001\u0002V!11\u0010\u0005a\u0001\u0003[\tQ\"\u001a=fGV$X-\u00169eCR,GCBAd\u0003+\f9\u000eC\u0004\u0002\u0018F\u0001\r!!\u0016\t\rm\f\u0002\u0019AA\u0017\u00031\u0011Xm]8mm\u0016$\u0016M\u00197f)!\ti.!=\u0002t\u0006]\b\u0003BAp\u0003[l!!!9\u000b\t\u0005\r\u0018Q]\u0001\u0006if\u0004Xm\u001d\u0006\u0004w\u0006\u001d(b\u0001\u001b\u0002j*\u0019\u00111\u001e)\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\ty/!9\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002\u0018J\u0001\r!!\u0016\t\u000f\u0005U(\u00031\u0001\u0002.\u0005)A/\u00192mK\"I\u0011Q\f\n\u0011\u0002\u0003\u0007\u0011\u0011 \t\u0006\u0003\u00065\u0013qL\u0001\u0017e\u0016\u001cx\u000e\u001c<f)\u0006\u0014G.\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q \u0016\u0005\u0003s\u0014\ta\u000b\u0002\u0003\u0004A!!Q\u0001B\b\u001b\t\u00119A\u0003\u0003\u0003\n\t-\u0011!C;oG\",7m[3e\u0015\r\u0011iAQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\t\u0005\u000f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Q\u0011Xm]8mm\u0016$\u0016M\u00197f\rJ|W.T3uCR1\u0011Q\u001cB\f\u0005CAqA!\u0007\u0015\u0001\u0004\u0011Y\"\u0001\u0003sg6$\u0007cA=\u0003\u001e%\u0019!q\u0004>\u0003#I+7/\u001e7u'\u0016$X*\u001a;b\t\u0006$\u0018\rC\u0004\u0002^Q\u0001\r!a\u0018\u0002\u001f\u001d,GoQ1uC2L8\u000f\u001e+za\u0016$BBa\n\u0003.\tE\"Q\u0007B\u001d\u0005{\u0001B!a8\u0003*%!!1FAq\u0005!!\u0015\r^1UsB,\u0007B\u0002B\u0018+\u0001\u0007Q,A\u0004tc2$\u0016\u0010]3\t\r\tMR\u00031\u0001^\u0003%\u0001(/Z2jg&|g\u000e\u0003\u0004\u00038U\u0001\r!X\u0001\u0006g\u000e\fG.\u001a\u0005\b\u0005w)\u0002\u0019AAO\u0003\u0019\u0019\u0018n\u001a8fI\"I\u0011QL\u000b\u0011\u0002\u0003\u0007\u0011\u0011`\u0001\u001aO\u0016$8)\u0019;bYf\u001cH\u000fV=qK\u0012\"WMZ1vYR$S'A\u0006uC\ndW-\u0012=jgR\u001cHCBAO\u0005\u000b\u00129\u0005C\u0004\u0002\u0018^\u0001\r!!\u0016\t\u000f\u0005Ux\u00031\u0001\u0002.\u0005YA/\u00192mKN\u001b\u0007.Z7b)!\tiN!\u0014\u0003P\tu\u0003bBAL1\u0001\u0007\u0011Q\u000b\u0005\b\u0003;A\u0002\u0019\u0001B)!\u0011\u0011\u0019F!\u0017\u000e\u0005\tU#b\u0001B,c\u0005A\u0001/^:iI><h.\u0003\u0003\u0003\\\tU#\u0001\u0006*fIND\u0017N\u001a;T#2\u001bF/\u0019;f[\u0016tG\u000fC\u0004\u0002^a\u0001\r!a\u0018\u00025Q\f'\r\\3NKR\fG)\u0019;b\rJ|Wn\u0015;bi\u0016lWM\u001c;\u0015\u0011\tm!1\rB3\u0005OBq!a&\u001a\u0001\u0004\t)\u0006C\u0004\u0002\u001ee\u0001\rA!\u0015\t\u0013\t%\u0014\u0004%AA\u0002\u0005u\u0015a\u00052j]\u00124\u0016M]5bE2,WI\\1cY\u0016$\u0017\u0001\n;bE2,W*\u001a;b\t\u0006$\u0018M\u0012:p[N#\u0018\r^3nK:$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t=$\u0006BAO\u0005\u0003\t\u0001\u0003\u001d:fa\u0006\u0014Xm\u0015;bi\u0016lWM\u001c;\u0015\u000fa\u0014)Ha\u001e\u0003z!9\u0011qS\u000eA\u0002\u0005U\u0003bBA\u000f7\u0001\u0007!\u0011\u000b\u0005\b\u0005SZ\u0002\u0019AAO\u0003i\u0001(/\u001a9be\u0016<\u0016\u000e\u001e5pkR\u0014\u0015N\u001c3WCJL\u0017M\u00197f)\u0015A(q\u0010BA\u0011\u001d\t9\n\ba\u0001\u0003+BqAa!\u001d\u0001\u0004\u0011\t&\u0001\u0007tc2\u001cF/\u0019;f[\u0016tG/A\fqe\u0016\u0004\u0018M]3XSRD')\u001b8e-\u0006\u0014\u0018.\u00192mKR)\u0001P!#\u0003\f\"9\u0011qS\u000fA\u0002\u0005U\u0003b\u0002BB;\u0001\u0007!\u0011K\u0001\f\u0015\u0012\u00135i\u0016:baB,'\u000f\u0005\u0002>?M!qDa%A!\r\t%QS\u0005\u0004\u0005/\u0013%AB!osJ+g\r\u0006\u0002\u0003\u0010\u0006A\"+\u0012#T\u0011&3Ek\u0018&E\u0005\u000e{Fg\u0018\u001a`\tJKe+\u0012*\u0016\u0005\t}\u0005\u0003\u0002BQ\u0005Ok!Aa)\u000b\u0007\t\u0015F/\u0001\u0003mC:<\u0017\u0002BA \u0005G\u000b\u0011DU#E'\"Ke\tV0K\t\n\u001bu\fN03?\u0012\u0013\u0016JV#SA\u0005A\"+\u0012#T\u0011&3Ek\u0018&E\u0005\u000e{FgX\u0019`\tJKe+\u0012*\u00023I+Ei\u0015%J\rR{&\n\u0012\"D?Rz\u0016g\u0018#S\u0013Z+%\u000bI\u0001\u0017%\u0016#5\u000bS%G)~SEIQ\"`i}#%+\u0013,F%\u00069\"+\u0012#T\u0011&3Ek\u0018&E\u0005\u000e{Fg\u0018#S\u0013Z+%\u000bI\u0001\u0012!>\u001bFk\u0012*F'Fcu\f\u0012*J-\u0016\u0013\u0016A\u0005)P'R;%+R*R\u0019~#%+\u0013,F%\u0002\nadU#D%\u0016#v,T!O\u0003\u001e+%k\u0018*F\tNC\u0015J\u0012+`\tJKe+\u0012*\u0002?M+5IU#U?6\u000be*Q$F%~\u0013V\tR*I\u0013\u001a#v\f\u0012*J-\u0016\u0013\u0006%\u0001\u000fS\u000b\u0012\u001b\u0006*\u0013$U?\u001aK%k\u0015+`!\u0006\u0013F+W0E%&3VIU*\u0016\u0005\t}\u0006#\u0002-\u0003B\n}\u0015b\u0001Bb3\n\u00191+Z9\u0002;I+Ei\u0015%J\rR{f)\u0013*T)~\u0003\u0016I\u0015+Z?\u0012\u0013\u0016JV#S'\u0002\n1B]3bIJ+7o\u001c7wKR\u0011!1\u001a\t\u0005\u0005C\u0013i-\u0003\u0003\u0003P\n\r&AB(cU\u0016\u001cG\u000f")
public class JDBCWrapper
extends RedshiftWrapper {
    private transient Iterator<Object> callNumberGenerator;
    private transient ExecutionContext ec;
    private transient ConcurrentHashMap<PreparedStatement, Object> cancellationMap;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile transient byte bitmap$trans$0;

    public static Seq<String> REDSHIFT_FIRST_PARTY_DRIVERS() {
        return JDBCWrapper$.MODULE$.REDSHIFT_FIRST_PARTY_DRIVERS();
    }

    public static String SECRET_MANAGER_REDSHIFT_DRIVER() {
        return JDBCWrapper$.MODULE$.SECRET_MANAGER_REDSHIFT_DRIVER();
    }

    public static String POSTGRESQL_DRIVER() {
        return JDBCWrapper$.MODULE$.POSTGRESQL_DRIVER();
    }

    public static String REDSHIFT_JDBC_4_DRIVER() {
        return JDBCWrapper$.MODULE$.REDSHIFT_JDBC_4_DRIVER();
    }

    public static String REDSHIFT_JDBC_4_1_DRIVER() {
        return JDBCWrapper$.MODULE$.REDSHIFT_JDBC_4_1_DRIVER();
    }

    public static String REDSHIFT_JDBC_4_2_DRIVER() {
        return JDBCWrapper$.MODULE$.REDSHIFT_JDBC_4_2_DRIVER();
    }

    public Logger log() {
        return this.log;
    }

    private Iterator<Object> callNumberGenerator$lzycompute() {
        JDBCWrapper jDBCWrapper = this;
        synchronized (jDBCWrapper) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.callNumberGenerator = package$.MODULE$.Iterator().from(1);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.callNumberGenerator;
    }

    private Iterator<Object> callNumberGenerator() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.callNumberGenerator$lzycompute() : this.callNumberGenerator;
    }

    private ExecutionContext ec$lzycompute() {
        JDBCWrapper jDBCWrapper = this;
        synchronized (jDBCWrapper) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                ThreadFactory threadFactory = new ThreadFactory(null){
                    private final AtomicInteger count;

                    /*
                     * WARNING - void declaration
                     */
                    public Thread newThread(Runnable r) {
                        void var2_2;
                        Thread thread = new Thread(r);
                        thread.setName(new java.lang.StringBuilder(27).append("spark-redshift-JDBCWrapper-").append(this.count.incrementAndGet()).toString());
                        thread.setDaemon(true);
                        return var2_2;
                    }
                    {
                        this.count = new AtomicInteger();
                    }
                };
                this.ec = ExecutionContext$.MODULE$.fromExecutorService(Executors.newCachedThreadPool(threadFactory));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.ec;
    }

    private ExecutionContext ec() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.ec$lzycompute() : this.ec;
    }

    private ConcurrentHashMap<PreparedStatement, Object> cancellationMap$lzycompute() {
        JDBCWrapper jDBCWrapper = this;
        synchronized (jDBCWrapper) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.cancellationMap = new ConcurrentHashMap();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.cancellationMap;
    }

    private ConcurrentHashMap<PreparedStatement, Object> cancellationMap() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.cancellationMap$lzycompute() : this.cancellationMap;
    }

    private <T> T executeInterruptibly(PreparedStatement statement, Function1<PreparedStatement, T> op) {
        Object object;
        int callNumber = BoxesRunTime.unboxToInt((Object)this.callNumberGenerator().next());
        try {
            try {
                this.log().info("Begin JDBC call {}", (Object)BoxesRunTime.boxToInteger((int)callNumber));
                this.cancellationMap().put(statement, BoxesRunTime.boxToInteger((int)callNumber));
                Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> op.apply((Object)statement), this.ec());
                try {
                    object = Await$.MODULE$.result((Awaitable)future, (Duration)Duration$.MODULE$.Inf());
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof SQLException) {
                        SQLException sQLException = (SQLException)throwable2;
                        throw new SQLException("Exception thrown in awaitResult: ", sQLException);
                    }
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable t = (Throwable)option.get();
                        throw new Exception("Exception thrown in awaitResult: ", t);
                    }
                    throw throwable;
                }
            }
            catch (InterruptedException e) {
                try {
                    statement.cancel();
                    throw e;
                }
                catch (SQLException s) {
                    this.log().error("Exception occurred while cancelling query: {}", new Object[]{s.getMessage()});
                    throw e;
                }
            }
        }
        finally {
            this.cancellationMap().remove(statement);
            this.log().info("End JDBC call {}", (Object)BoxesRunTime.boxToInteger((int)callNumber));
        }
        return (T)object;
    }

    private String getDriverClass(String jdbcSubprotocol, Option<String> userProvidedDriverClass) {
        return (String)userProvidedDriverClass.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String string;
            String string2 = jdbcSubprotocol;
            if ("redshift".equals(string2)) {
                String string3;
                try {
                    string3 = Utils$.MODULE$.classForName(JDBCWrapper$.MODULE$.REDSHIFT_JDBC_4_2_DRIVER()).getName();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        string3 = Utils$.MODULE$.classForName(JDBCWrapper$.MODULE$.REDSHIFT_JDBC_4_1_DRIVER()).getName();
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        try {
                            string3 = Utils$.MODULE$.classForName(JDBCWrapper$.MODULE$.REDSHIFT_JDBC_4_DRIVER()).getName();
                        }
                        catch (ClassNotFoundException e) {
                            throw new ClassNotFoundException("Could not load an Amazon Redshift JDBC driver; see the README for instructions on downloading and configuring the official Amazon driver.", e);
                        }
                    }
                }
                string = string3;
            } else if ("postgresql".equals(string2)) {
                string = JDBCWrapper$.MODULE$.POSTGRESQL_DRIVER();
            } else if ("jdbc-secretsmanager".equals(string2)) {
                string = JDBCWrapper$.MODULE$.SECRET_MANAGER_REDSHIFT_DRIVER();
            } else {
                throw new IllegalArgumentException(new java.lang.StringBuilder(29).append("Unsupported JDBC protocol: '").append(string2).append("'").toString());
            }
            return string;
        });
    }

    @Override
    public RedshiftConnection getConnector(Parameters.MergedParameters params) {
        String updatedURL = params.secretId().isDefined() ? ((String)params.jdbcUrl().get()).replaceFirst("jdbc", "jdbc-secretsmanager") : (String)params.jdbcUrl().get();
        Properties driverProperties = new Properties();
        Utils$.MODULE$.copyProperty("user", params.parameters(), driverProperties);
        Utils$.MODULE$.copyProperty("password", params.parameters(), driverProperties);
        Utils$.MODULE$.copyProperty("secret.id", "user", params.parameters(), driverProperties);
        Utils$.MODULE$.copyProperties("^jdbc\\..+", "^jdbc\\.", "", params.parameters(), driverProperties);
        Utils$.MODULE$.copyProperties("^secret\\..+", "^secret\\.", "drivers\\.", (Map<String, String>)((Map)params.parameters().$minus((Object)"secret.id")), System.getProperties());
        Object object = !updatedURL.toLowerCase().contains("applicationname=") && !driverProperties.containsKey("applicationname") ? driverProperties.setProperty("applicationname", Utils$.MODULE$.getApplicationName(params)) : BoxedUnit.UNIT;
        String subprotocol = new StringOps(Predef$.MODULE$.augmentString(updatedURL)).stripPrefix("jdbc:").split(":")[0];
        String driverClass = this.getDriverClass(subprotocol, params.jdbcDriver());
        DriverRegistry$.MODULE$.register(driverClass);
        Class<?> driverWrapperClass = org.apache.spark.package$.MODULE$.SPARK_VERSION().startsWith("1.4") ? Utils$.MODULE$.classForName("org.apache.spark.sql.jdbc.package$DriverWrapper") : Utils$.MODULE$.classForName("org.apache.spark.sql.execution.datasources.jdbc.DriverWrapper");
        Utils$.MODULE$.checkJDBCSecurity(driverClass, updatedURL, driverProperties);
        Driver driver = (Driver)((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(DriverManager.getDrivers()).asScala()).collectFirst((PartialFunction)new scala.Serializable(this, driverWrapperClass, driverClass){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCWrapper $outer;
            private final Class driverWrapperClass$1;
            private final String driverClass$1;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends Driver, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var3_8;
                A1 A1 = x1;
                if (this.driverWrapperClass$1.isAssignableFrom(A1.getClass())) {
                    String string = JDBCWrapper.io$github$spark_redshift_community$spark$redshift$data$JDBCWrapper$$getWrapped$1(A1, this.driverWrapperClass$1).getClass().getCanonicalName();
                    String string2 = this.driverClass$1;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        A1 A12 = A1;
                        return var3_8;
                    }
                }
                String string = A1.getClass().getCanonicalName();
                String string3 = this.driverClass$1;
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    A1 A13 = A1;
                    return var3_8;
                }
                Object object = function1.apply(x1);
                return var3_8;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Driver x1) {
                Driver driver = x1;
                if (this.driverWrapperClass$1.isAssignableFrom(driver.getClass())) {
                    String string = JDBCWrapper.io$github$spark_redshift_community$spark$redshift$data$JDBCWrapper$$getWrapped$1(driver, this.driverWrapperClass$1).getClass().getCanonicalName();
                    String string2 = this.driverClass$1;
                    if (string == null) {
                        if (string2 == null) return true;
                    } else if (string.equals(string2)) {
                        return true;
                    }
                }
                String string = driver.getClass().getCanonicalName();
                String string3 = this.driverClass$1;
                if (string != null) {
                    if (!string.equals(string3)) return false;
                    return true;
                }
                if (string3 == null) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driverWrapperClass$1 = driverWrapperClass$1;
                this.driverClass$1 = driverClass$1;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new java.lang.StringBuilder(42).append("Did not find registered driver with class ").append(driverClass).toString());
        });
        Connection conn = driver.connect(updatedURL, driverProperties);
        return new JDBCConnection(conn);
    }

    @Override
    public RedshiftConnection getConnectorWithQueryGroup(Parameters.MergedParameters params, String queryGroup) {
        RedshiftConnection redshiftConnection;
        RedshiftConnection conn = this.getConnector(params);
        try {
            this.executeInterruptibly(conn, new java.lang.StringBuilder(21).append("set query_group to '").append(queryGroup).append("'").toString());
            redshiftConnection = conn;
        }
        catch (Throwable e) {
            this.log().debug(new java.lang.StringBuilder(27).append("Unable to set query group: ").append(e.getMessage()).toString());
            conn.close();
            redshiftConnection = this.getConnector(params);
        }
        return redshiftConnection;
    }

    @Override
    public void setAutoCommit(RedshiftConnection conn, boolean autoCommit) {
        conn.setAutoCommit(autoCommit);
    }

    @Override
    public void commit(RedshiftConnection conn) {
        JDBCConnection jdbcConnection = (JDBCConnection)conn;
        jdbcConnection.conn().commit();
    }

    @Override
    public void rollback(RedshiftConnection conn) {
        JDBCConnection jdbcConnection = (JDBCConnection)conn;
        jdbcConnection.conn().rollback();
    }

    @Override
    public boolean executeInterruptibly(RedshiftConnection conn, String sql) {
        JDBCConnection jdbcConnection = (JDBCConnection)conn;
        PreparedStatement statement = jdbcConnection.conn().prepareStatement(sql);
        return BoxesRunTime.unboxToBoolean(this.executeInterruptibly(statement, (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.execute())));
    }

    @Override
    public RedshiftResults executeQueryInterruptibly(RedshiftConnection conn, String sql) {
        JDBCConnection jdbcConnection = (JDBCConnection)conn;
        PreparedStatement statement = jdbcConnection.conn().prepareStatement(sql);
        ResultSet resultSet = (ResultSet)this.executeInterruptibly(statement, (Function1 & Serializable & scala.Serializable)x$2 -> x$2.executeQuery());
        return new JDBCResults(resultSet);
    }

    @Override
    public long executeUpdateInterruptibly(RedshiftConnection conn, String sql) {
        JDBCConnection jdbcConnection = (JDBCConnection)conn;
        PreparedStatement statement = jdbcConnection.conn().prepareStatement(sql);
        return BoxesRunTime.unboxToLong(this.executeInterruptibly(statement, (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.executeLargeUpdate())));
    }

    @Override
    public long executeUpdate(RedshiftConnection conn, String sql) {
        JDBCConnection jdbcConnection = (JDBCConnection)conn;
        PreparedStatement statement = jdbcConnection.conn().prepareStatement(sql);
        return BoxesRunTime.unboxToLong(this.executeInterruptibly(statement, (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.executeUpdate())));
    }

    @Override
    public StructType resolveTable(RedshiftConnection conn, String table, Option<Parameters.MergedParameters> params) {
        StructType structType;
        JDBCConnection jdbcConnection = (JDBCConnection)conn;
        try (PreparedStatement ps = jdbcConnection.conn().prepareStatement(new java.lang.StringBuilder(22).append("SELECT * FROM ").append(table).append(" LIMIT 1").toString());){
            this.log().info("Getting schema from Redshift for table: {}", new Object[]{table});
            ResultSetMetaData rsmd = (ResultSetMetaData)this.executeInterruptibly(ps, (Function1 & Serializable & scala.Serializable)x$5 -> x$5.getMetaData());
            int ncols = rsmd.getColumnCount();
            StructField[] fields = new StructField[ncols];
            for (int i = 0; i < ncols; ++i) {
                String columnName = rsmd.getColumnLabel(i + 1);
                String rsType = rsmd.getColumnTypeName(i + 1);
                int dataType = rsmd.getColumnType(i + 1);
                int fieldSize = rsmd.getPrecision(i + 1);
                int fieldScale = rsmd.getScale(i + 1);
                boolean isSigned = rsmd.isSigned(i + 1);
                boolean nullable = params.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.overrideNullable())) ? true : rsmd.isNullable(i + 1) != 0;
                DataType columnType = this.getCatalystType(dataType, fieldSize, fieldScale, isSigned, params);
                Metadata meta = new MetadataBuilder().putString("redshift_type", rsType).build();
                fields[i] = new StructField(columnName, columnType, nullable, meta);
            }
            structType = new StructType(fields);
        }
        return structType;
    }

    @Override
    public Option<Parameters.MergedParameters> resolveTable$default$3() {
        return None$.MODULE$;
    }

    private StructType resolveTableFromMeta(ResultSetMetaData rsmd, Parameters.MergedParameters params) {
        int ncols = rsmd.getColumnCount();
        StructField[] fields = new StructField[ncols];
        for (int i = 0; i < ncols; ++i) {
            String columnName = rsmd.getColumnLabel(i + 1);
            String rsType = rsmd.getColumnTypeName(i + 1);
            int dataType = rsmd.getColumnType(i + 1);
            int fieldSize = rsmd.getPrecision(i + 1);
            int fieldScale = rsmd.getScale(i + 1);
            boolean isSigned = rsmd.isSigned(i + 1);
            boolean nullable = rsmd.isNullable(i + 1) != 0;
            DataType columnType = this.getCatalystType(dataType, fieldSize, fieldScale, isSigned, (Option<Parameters.MergedParameters>)new Some((Object)params));
            Metadata meta = new MetadataBuilder().putString("redshift_type", rsType).build();
            fields[i] = new StructField(columnName.matches("[_A-Z]([_0-9A-Z])*") ? columnName : new java.lang.StringBuilder(2).append("\"").append(columnName).append("\"").toString(), columnType, nullable, meta);
        }
        return new StructType(fields);
    }

    private DataType getCatalystType(int sqlType, int precision, int scale, boolean signed, Option<Parameters.MergedParameters> params) {
        StringType$ stringType$;
        int n = sqlType;
        switch (n) {
            case 0: {
                stringType$ = null;
                break;
            }
            case 1: {
                stringType$ = StringType$.MODULE$;
                break;
            }
            case -15: {
                stringType$ = StringType$.MODULE$;
                break;
            }
            case -9: {
                stringType$ = StringType$.MODULE$;
                break;
            }
            case 12: {
                stringType$ = StringType$.MODULE$;
                break;
            }
            case -1: {
                stringType$ = StringType$.MODULE$;
                break;
            }
            case 91: {
                stringType$ = DateType$.MODULE$;
                break;
            }
            case 92: {
                stringType$ = TimestampType$.MODULE$;
                break;
            }
            case 93: {
                stringType$ = TimestampType$.MODULE$;
                break;
            }
            case 2014: {
                stringType$ = TimestampType$.MODULE$;
                break;
            }
            case -7: {
                stringType$ = BooleanType$.MODULE$;
                break;
            }
            case 16: {
                stringType$ = BooleanType$.MODULE$;
                break;
            }
            case -5: {
                if (signed) {
                    stringType$ = LongType$.MODULE$;
                    break;
                }
                stringType$ = new DecimalType(20, 0);
                break;
            }
            case 3: {
                if (precision != 0 || scale != 0) {
                    stringType$ = new DecimalType(precision, scale);
                    break;
                }
                stringType$ = new DecimalType(38, 18);
                break;
            }
            case 8: {
                stringType$ = DoubleType$.MODULE$;
                break;
            }
            case 6: {
                stringType$ = FloatType$.MODULE$;
                break;
            }
            case 4: {
                if (signed) {
                    stringType$ = IntegerType$.MODULE$;
                    break;
                }
                stringType$ = LongType$.MODULE$;
                break;
            }
            case 2: {
                if (precision != 0 || scale != 0) {
                    stringType$ = new DecimalType(precision, scale);
                    break;
                }
                stringType$ = new DecimalType(38, 18);
                break;
            }
            case 7: {
                if (params.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.legacyJdbcRealTypeMapping()))) {
                    stringType$ = DoubleType$.MODULE$;
                    break;
                }
                stringType$ = FloatType$.MODULE$;
                break;
            }
            case 5: {
                if (params.exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.legacyMappingShortToInt()))) {
                    stringType$ = IntegerType$.MODULE$;
                    break;
                }
                stringType$ = ShortType$.MODULE$;
                break;
            }
            case -6: {
                stringType$ = ByteType$.MODULE$;
                break;
            }
            default: {
                stringType$ = null;
                break;
            }
        }
        StringType$ answer = stringType$;
        if (answer == null) {
            throw new SQLException(new java.lang.StringBuilder(17).append("Unsupported type ").append(sqlType).toString());
        }
        return answer;
    }

    private Option<Parameters.MergedParameters> getCatalystType$default$5() {
        return None$.MODULE$;
    }

    @Override
    public boolean tableExists(RedshiftConnection conn, String table) {
        JDBCConnection jdbcConnection = (JDBCConnection)conn;
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            PreparedStatement stmt = jdbcConnection.conn().prepareStatement(new java.lang.StringBuilder(22).append("SELECT 1 FROM ").append(table).append(" LIMIT 1").toString());
            this.log().info("Checking if table exists: {}", new Object[]{table});
            return ((ResultSetMetaData)this.executeInterruptibly(stmt, (Function1 & Serializable & scala.Serializable)x$9 -> x$9.getMetaData())).getColumnCount();
        }).isSuccess();
    }

    @Override
    public StructType tableSchema(RedshiftConnection conn, RedshiftSQLStatement statement, Parameters.MergedParameters params) {
        return this.resolveTableFromMeta(this.tableMetaDataFromStatement(conn, statement, this.tableMetaDataFromStatement$default$3()), params);
    }

    private ResultSetMetaData tableMetaDataFromStatement(RedshiftConnection conn, RedshiftSQLStatement statement, boolean bindVariableEnabled) {
        RedshiftSQLStatement sqlStatement = new ConstantString("select * from").$plus(statement).$plus("where 1 = 0");
        return this.prepareStatement(conn, sqlStatement, bindVariableEnabled).getMetaData();
    }

    private boolean tableMetaDataFromStatement$default$3() {
        return true;
    }

    private PreparedStatement prepareStatement(RedshiftConnection conn, RedshiftSQLStatement statement, boolean bindVariableEnabled) {
        return bindVariableEnabled ? this.prepareWithBindVariable(conn, statement) : this.prepareWithoutBindVariable(conn, statement);
    }

    private PreparedStatement prepareWithoutBindVariable(RedshiftConnection conn, RedshiftSQLStatement sqlStatement) {
        List sql = sqlStatement.list().reverse();
        String query = ((StringBuilder)sql.foldLeft((Object)new StringBuilder(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StringBuilder buffer = (StringBuilder)tuple2._1();
            StatementElement statement = (StatementElement)tuple2._2();
            buffer.append(statement instanceof ConstantString ? statement : statement.sql());
            StringBuilder stringBuilder = buffer.append(" ");
            return stringBuilder;
        })).toString();
        String logPrefix = (String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(88).append(this.MASTER_LOG_PREFIX()).append(":\n                       | execute query without bind variable:\n                       |").toString())).stripMargin())).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)JDBCWrapper.$anonfun$prepareWithoutBindVariable$2(BoxesRunTime.unboxToChar((Object)x$10))));
        return ((JDBCConnection)conn).conn().prepareStatement(query);
    }

    private PreparedStatement prepareWithBindVariable(RedshiftConnection conn, RedshiftSQLStatement sqlStatement) {
        List sql = sqlStatement.list().reverse();
        StatementElement[] varArray = new StatementElement[sqlStatement.numOfVar()];
        IntRef indexOfVar = IntRef.create((int)0);
        StringBuilder buffer = new StringBuilder();
        sql.foreach((Function1 & Serializable & scala.Serializable)element -> {
            block0: {
                buffer.append(element);
                if (element instanceof ConstantString) break block0;
                varArray$1[indexOfVar$1.elem] = element;
                ++indexOfVar$1.elem;
            }
            return buffer.append(" ");
        });
        String query = buffer.toString();
        String logPrefix = (String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(85).append(this.MASTER_LOG_PREFIX()).append(":\n                       | execute query with bind variable:\n                       |").toString())).stripMargin())).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)JDBCWrapper.$anonfun$prepareWithBindVariable$2(BoxesRunTime.unboxToChar((Object)x$11))));
        PreparedStatement statement = ((JDBCConnection)conn).conn().prepareStatement(query);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])varArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JDBCWrapper.$anonfun$prepareWithBindVariable$3(statement, x0$1);
            return BoxedUnit.UNIT;
        });
        return statement;
    }

    public static final /* synthetic */ void $anonfun$new$2(JDBCWrapper $this, PreparedStatement statement, int callNumber) {
        try {
            $this.log().info("Cancelling pending JDBC call {}", (Object)BoxesRunTime.boxToInteger((int)callNumber));
            statement.cancel();
        }
        catch (Throwable e) {
            $this.log().error("Exception occurred while cancelling statement: {}", new Object[]{e.getMessage()});
        }
    }

    public static final Driver io$github$spark_redshift_community$spark$redshift$data$JDBCWrapper$$getWrapped$1(Driver d, Class driverWrapperClass$1) {
        Predef$.MODULE$.require(driverWrapperClass$1.isAssignableFrom(d.getClass()));
        return (Driver)driverWrapperClass$1.getDeclaredMethod("wrapped", new Class[0]).invoke((Object)d, new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$prepareWithoutBindVariable$2(char x$10) {
        return x$10 >= ' ';
    }

    public static final /* synthetic */ boolean $anonfun$prepareWithBindVariable$2(char x$11) {
        return x$11 >= ' ';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$prepareWithBindVariable$3(PreparedStatement statement$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        StatementElement element = (StatementElement)tuple2._1();
        int index = tuple2._2$mcI$sp();
        StatementElement statementElement = element;
        if (statementElement instanceof StringVariable) {
            BoxedUnit boxedUnit;
            StringVariable stringVariable = (StringVariable)statementElement;
            if (stringVariable.variable().isDefined()) {
                statement$2.setString(index + 1, (String)stringVariable.variable().get());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                statement$2.setNull(index + 1, 12);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (statementElement instanceof Identifier) {
            Identifier identifier = (Identifier)statementElement;
            statement$2.setString(index + 1, (String)identifier.variable().get());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statementElement instanceof IntVariable) {
            BoxedUnit boxedUnit;
            IntVariable intVariable = (IntVariable)statementElement;
            if (intVariable.variable().isDefined()) {
                statement$2.setInt(index + 1, BoxesRunTime.unboxToInt((Object)intVariable.variable().get()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                statement$2.setNull(index + 1, 4);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if (statementElement instanceof LongVariable) {
            BoxedUnit boxedUnit;
            LongVariable longVariable = (LongVariable)statementElement;
            if (longVariable.variable().isDefined()) {
                statement$2.setLong(index + 1, BoxesRunTime.unboxToLong((Object)longVariable.variable().get()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                statement$2.setNull(index + 1, -5);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else if (statementElement instanceof ShortVariable) {
            BoxedUnit boxedUnit;
            ShortVariable shortVariable = (ShortVariable)statementElement;
            if (shortVariable.variable().isDefined()) {
                statement$2.setShort(index + 1, BoxesRunTime.unboxToShort((Object)shortVariable.variable().get()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                statement$2.setNull(index + 1, 5);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit;
        } else if (statementElement instanceof FloatVariable) {
            BoxedUnit boxedUnit;
            FloatVariable floatVariable = (FloatVariable)statementElement;
            if (floatVariable.variable().isDefined()) {
                statement$2.setFloat(index + 1, BoxesRunTime.unboxToFloat((Object)floatVariable.variable().get()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                statement$2.setNull(index + 1, 6);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit6 = boxedUnit;
        } else if (statementElement instanceof DoubleVariable) {
            BoxedUnit boxedUnit;
            DoubleVariable doubleVariable = (DoubleVariable)statementElement;
            if (doubleVariable.variable().isDefined()) {
                statement$2.setDouble(index + 1, BoxesRunTime.unboxToDouble((Object)doubleVariable.variable().get()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                statement$2.setNull(index + 1, 8);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit7 = boxedUnit;
        } else if (statementElement instanceof BooleanVariable) {
            BoxedUnit boxedUnit;
            BooleanVariable booleanVariable = (BooleanVariable)statementElement;
            if (booleanVariable.variable().isDefined()) {
                statement$2.setBoolean(index + 1, BoxesRunTime.unboxToBoolean((Object)booleanVariable.variable().get()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                statement$2.setNull(index + 1, 16);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit8 = boxedUnit;
        } else {
            BoxedUnit boxedUnit;
            if (!(statementElement instanceof ByteVariable)) throw new IllegalArgumentException(new java.lang.StringBuilder(25).append("Unexpected Element Type: ").append(element.getClass().getName()).toString());
            ByteVariable byteVariable = (ByteVariable)statementElement;
            if (byteVariable.variable().isDefined()) {
                statement$2.setByte(index + 1, BoxesRunTime.unboxToByte((Object)byteVariable.variable().get()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                statement$2.setNull(index + 1, -6);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit9 = boxedUnit;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public JDBCWrapper() {
        scala.sys.package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.cancellationMap().forEach((statement, callNumber) -> JDBCWrapper.$anonfun$new$2(this, statement, BoxesRunTime.unboxToInt((Object)callNumber))));
    }
}

