/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift.data;

import com.amazonaws.services.redshiftdataapi.model.ColumnMetadata;
import com.amazonaws.services.redshiftdataapi.model.GetStatementResultResult;
import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.TimestampNTZTypeExtractor$;
import io.github.spark_redshift_community.spark.redshift.data.DataAPIConnection;
import io.github.spark_redshift_community.spark.redshift.data.DataAPIConnection$;
import io.github.spark_redshift_community.spark.redshift.data.DataApiCommand;
import io.github.spark_redshift_community.spark.redshift.data.DataApiCommand$;
import io.github.spark_redshift_community.spark.redshift.data.DataApiResults;
import io.github.spark_redshift_community.spark.redshift.data.QueryParameter;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftConnection;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftResults;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftWrapper;
import io.github.spark_redshift_community.spark.redshift.package$;
import io.github.spark_redshift_community.spark.redshift.pushdown.BooleanVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.ByteVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.ConstantString;
import io.github.spark_redshift_community.spark.redshift.pushdown.DoubleVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.FloatVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.IntVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.LongVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.RedshiftSQLStatement;
import io.github.spark_redshift_community.spark.redshift.pushdown.ShortVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.StatementElement;
import io.github.spark_redshift_community.spark.redshift.pushdown.StringVariable;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tue!B\u0010!\u0001\tb\u0003\"B\u001c\u0001\t\u0003I\u0004bB\u001e\u0001\u0005\u0004%\t\u0002\u0010\u0005\u0007\u000b\u0002\u0001\u000b\u0011B\u001f\t\u0011\u0019\u0003\u0001R1A\u0005\f\u001dC\u0001\"\u0016\u0001\t\u0006\u0004%YA\u0016\u0005\t=\u0002A)\u0019!C\u0005?\")Q\u000e\u0001C\u0005]\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0001bBA\u0012\u0001\u0011\u0005\u0013Q\u0005\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011\u001d\ty\u0003\u0001C\u0005\u0003cAq!!\u000e\u0001\t\u0013\t9\u0004\u0003\u0004n\u0001\u0011\u0005\u0013q\r\u0005\b\u0003_\u0002A\u0011IA9\u0011\u001d\ti\b\u0001C!\u0003\u007fBq!a#\u0001\t\u0003\ni\tC\u0004\u0002\u0014\u0002!\t%!&\t\u000f\u0005u\u0006\u0001\"\u0011\u0002@\"9\u0011q\u0019\u0001\u0005B\u0005%\u0007bBAi\u0001\u0011\u0005\u00131\u001b\u0005\n\u0003k\u0004\u0011\u0013!C\u0001\u0003oDqA!\u0004\u0001\t\u0013\u0011y\u0001C\u0004\u0003\u0018\u0001!IA!\u0007\t\u0013\tM\u0002!%A\u0005\n\u0005]\bb\u0002B\u001b\u0001\u0011\u0005#q\u0007\u0005\b\u0005\u001b\u0002A\u0011\u0002B(\u0011%\u0011I\u0006AI\u0001\n\u0013\u0011Y\u0006C\u0004\u0003`\u0001!IA!\u0019\t\u000f\t\u0005\u0005\u0001\"\u0003\u0003\u0004\"9!q\u0011\u0001\u0005\n\t%%A\u0004#bi\u0006\f\u0005/[,sCB\u0004XM\u001d\u0006\u0003C\t\nA\u0001Z1uC*\u00111\u0005J\u0001\te\u0016$7\u000f[5gi*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\n\u0001d\u001d9be.|&/\u001a3tQ&4GoX2p[6,h.\u001b;z\u0015\tI#&\u0001\u0004hSRDWO\u0019\u0006\u0002W\u0005\u0011\u0011n\\\n\u0004\u00015\n\u0004C\u0001\u00180\u001b\u0005\u0001\u0013B\u0001\u0019!\u0005=\u0011V\rZ:iS\u001a$xK]1qa\u0016\u0014\bC\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003i\u0002\"A\f\u0001\u0002\u00071|w-F\u0001>!\tq4)D\u0001@\u0015\t\u0001\u0015)A\u0003tY\u001a$$NC\u0001C\u0003\ry'oZ\u0005\u0003\t~\u0012a\u0001T8hO\u0016\u0014\u0018\u0001\u00027pO\u0002\n1cY1mY:+XNY3s\u000f\u0016tWM]1u_J,\u0012\u0001\u0013\t\u0004\u00132sU\"\u0001&\u000b\u0005-\u001b\u0014AC2pY2,7\r^5p]&\u0011QJ\u0013\u0002\t\u0013R,'/\u0019;peB\u0011!gT\u0005\u0003!N\u00121!\u00138uQ\t!!\u000b\u0005\u00023'&\u0011Ak\r\u0002\niJ\fgn]5f]R\f!!Z2\u0016\u0003]\u0003\"\u0001W.\u000e\u0003eS!AW\u001a\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002]3\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0015\u0003\u000bI\u000bqbY1oG\u0016dG.\u0019;j_:l\u0015\r]\u000b\u0002AB!\u0011mZ5O\u001b\u0005\u0011'B\u0001.d\u0015\t!W-\u0001\u0003vi&d'\"\u00014\u0002\t)\fg/Y\u0005\u0003Q\n\u0014\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\tq#.\u0003\u0002lA\tqA)\u0019;b\u0003BL7i\\7nC:$\u0007F\u0001\u0004S\u0003Q)\u00070Z2vi\u0016Le\u000e^3seV\u0004H/\u001b2msV\u0011qN\u001d\u000b\u0004anl\bCA9s\u0019\u0001!Qa]\u0004C\u0002Q\u0014\u0011\u0001V\t\u0003kb\u0004\"A\r<\n\u0005]\u001c$a\u0002(pi\"Lgn\u001a\t\u0003eeL!A_\u001a\u0003\u0007\u0005s\u0017\u0010C\u0003}\u000f\u0001\u0007\u0011.A\u0002d[\u0012DQA`\u0004A\u0002}\f!a\u001c9\u0011\u000bI\n\t!\u001b9\n\u0007\u0005\r1GA\u0005Gk:\u001cG/[8oc\u0005i1/\u001a;BkR|7i\\7nSR$b!!\u0003\u0002\u0010\u0005e\u0001c\u0001\u001a\u0002\f%\u0019\u0011QB\u001a\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003#A\u0001\u0019AA\n\u0003\u0011\u0019wN\u001c8\u0011\u00079\n)\"C\u0002\u0002\u0018\u0001\u0012!CU3eg\"Lg\r^\"p]:,7\r^5p]\"9\u00111\u0004\u0005A\u0002\u0005u\u0011AC1vi>\u001cu.\\7jiB\u0019!'a\b\n\u0007\u0005\u00052GA\u0004C_>dW-\u00198\u0002\r\r|W.\\5u)\u0011\tI!a\n\t\u000f\u0005E\u0011\u00021\u0001\u0002\u0014\u0005A!o\u001c7mE\u0006\u001c7\u000e\u0006\u0003\u0002\n\u00055\u0002bBA\t\u0015\u0001\u0007\u00111C\u0001\u0018Kb,7-\u001e;f\u0005V4g-\u001a:fI\u000e{W.\\1oIN$B!!\u0003\u00024!9\u0011\u0011C\u0006A\u0002\u0005M\u0011\u0001D3yK\u000e,H/\u001a\"bi\u000eDGCBA\u000f\u0003s\tY\u0004C\u0004\u0002\u00121\u0001\r!a\u0005\t\u000f\u0005uB\u00021\u0001\u0002@\u0005!1/\u001d7t!\u0019\t\t%!\u0015\u0002X9!\u00111IA'\u001d\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#bAA%q\u00051AH]8pizJ\u0011\u0001N\u0005\u0004\u0003\u001f\u001a\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003'\n)FA\u0002TKFT1!a\u00144!\u0011\tI&!\u0019\u000f\t\u0005m\u0013Q\f\t\u0004\u0003\u000b\u001a\u0014bAA0g\u00051\u0001K]3eK\u001aLA!a\u0019\u0002f\t11\u000b\u001e:j]\u001eT1!a\u00184)\u0019\ti\"!\u001b\u0002l!9\u0011\u0011C\u0007A\u0002\u0005M\u0001bBA7\u001b\u0001\u0007\u0011qK\u0001\u0004gFd\u0017!G3yK\u000e,H/Z)vKJL\u0018J\u001c;feJ,\b\u000f^5cYf$b!a\u001d\u0002z\u0005m\u0004c\u0001\u0018\u0002v%\u0019\u0011q\u000f\u0011\u0003\u001fI+Gm\u001d5jMR\u0014Vm];miNDq!!\u0005\u000f\u0001\u0004\t\u0019\u0002C\u0004\u0002n9\u0001\r!a\u0016\u00025\u0015DXmY;uKV\u0003H-\u0019;f\u0013:$XM\u001d:vaRL'\r\\=\u0015\r\u0005\u0005\u0015qQAE!\r\u0011\u00141Q\u0005\u0004\u0003\u000b\u001b$\u0001\u0002'p]\u001eDq!!\u0005\u0010\u0001\u0004\t\u0019\u0002C\u0004\u0002n=\u0001\r!a\u0016\u0002\u001b\u0015DXmY;uKV\u0003H-\u0019;f)\u0019\t\t)a$\u0002\u0012\"9\u0011\u0011\u0003\tA\u0002\u0005M\u0001bBA7!\u0001\u0007\u0011qK\u0001\rO\u0016$8i\u001c8oK\u000e$xN\u001d\u000b\u0005\u0003'\t9\nC\u0004\u0002\u001aF\u0001\r!a'\u0002\rA\f'/Y7t!\u0011\ti*a.\u000f\t\u0005}\u00151\u0017\b\u0005\u0003C\u000b\tL\u0004\u0003\u0002$\u0006=f\u0002BAS\u0003[sA!a*\u0002,:!\u0011QIAU\u0013\u0005Y\u0013BA\u0015+\u0013\t9\u0003&\u0003\u0002&M%\u00111\u0005J\u0005\u0004\u0003k\u0013\u0013A\u0003)be\u0006lW\r^3sg&!\u0011\u0011XA^\u0005AiUM]4fIB\u000b'/Y7fi\u0016\u00148OC\u0002\u00026\n\n!dZ3u\u0007>tg.Z2u_J<\u0016\u000e\u001e5Rk\u0016\u0014\u0018p\u0012:pkB$b!a\u0005\u0002B\u0006\r\u0007bBAM%\u0001\u0007\u00111\u0014\u0005\b\u0003\u000b\u0014\u0002\u0019AA,\u0003)\tX/\u001a:z\u000fJ|W\u000f]\u0001\fi\u0006\u0014G.Z#ySN$8\u000f\u0006\u0004\u0002\u001e\u0005-\u0017Q\u001a\u0005\b\u0003#\u0019\u0002\u0019AA\n\u0011\u001d\tym\u0005a\u0001\u0003/\nQ\u0001^1cY\u0016\fAB]3t_24X\rV1cY\u0016$\u0002\"!6\u0002j\u0006-\u0018Q\u001e\t\u0005\u0003/\f)/\u0004\u0002\u0002Z*!\u00111\\Ao\u0003\u0015!\u0018\u0010]3t\u0015\u0011\ti'a8\u000b\u0007\u0015\n\tOC\u0002\u0002d\u0006\u000ba!\u00199bG\",\u0017\u0002BAt\u00033\u0014!b\u0015;sk\u000e$H+\u001f9f\u0011\u001d\t\t\u0002\u0006a\u0001\u0003'Aq!a4\u0015\u0001\u0004\t9\u0006C\u0005\u0002\u001aR\u0001\n\u00111\u0001\u0002pB)!'!=\u0002\u001c&\u0019\u00111_\u001a\u0003\r=\u0003H/[8o\u0003Y\u0011Xm]8mm\u0016$\u0016M\u00197fI\u0011,g-Y;mi\u0012\u001aTCAA}U\u0011\ty/a?,\u0005\u0005u\b\u0003BA\u0000\u0005\u0013i!A!\u0001\u000b\t\t\r!QA\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u00024\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0017\u0011\tAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAC]3t_24X\rV1cY\u00164%o\\7NKR\fGCBAk\u0005#\u0011)\u0002C\u0004\u0003\u0014Y\u0001\r!a\u001d\u0002\u000fI,7/\u001e7ug\"9\u0011\u0011\u0014\fA\u0002\u0005m\u0015aD4fi\u000e\u000bG/\u00197zgR$\u0016\u0010]3\u0015\u0019\tm!\u0011\u0005B\u0013\u0005S\u0011iC!\r\u0011\t\u0005]'QD\u0005\u0005\u0005?\tIN\u0001\u0005ECR\fG+\u001f9f\u0011\u001d\u0011\u0019c\u0006a\u0001\u0003/\nAB]3eg\"Lg\r\u001e+za\u0016DaAa\n\u0018\u0001\u0004q\u0015!\u00039sK\u000eL7/[8o\u0011\u0019\u0011Yc\u0006a\u0001\u001d\u0006)1oY1mK\"9!qF\fA\u0002\u0005u\u0011AB:jO:,G\rC\u0005\u0002\u001a^\u0001\n\u00111\u0001\u0002p\u0006Ir-\u001a;DCR\fG._:u)f\u0004X\r\n3fM\u0006,H\u000e\u001e\u00136\u0003-!\u0018M\u00197f'\u000eDW-\\1\u0015\u0011\u0005U'\u0011\bB\u001e\u0005\u0017Bq!!\u0005\u001a\u0001\u0004\t\u0019\u0002C\u0004\u0003>e\u0001\rAa\u0010\u0002\u0013M$\u0018\r^3nK:$\b\u0003\u0002B!\u0005\u000fj!Aa\u0011\u000b\u0007\t\u0015#%\u0001\u0005qkNDGm\\<o\u0013\u0011\u0011IEa\u0011\u0003)I+Gm\u001d5jMR\u001c\u0016\u000bT*uCR,W.\u001a8u\u0011\u001d\tI*\u0007a\u0001\u00037\u000b!\u0004^1cY\u0016lU\r^1ECR\fgI]8n'R\fG/Z7f]R$\u0002\"a\u001d\u0003R\tM#Q\u000b\u0005\b\u0003#Q\u0002\u0019AA\n\u0011\u001d\u0011iD\u0007a\u0001\u0005\u007fA\u0011Ba\u0016\u001b!\u0003\u0005\r!!\b\u0002'\tLg\u000e\u001a,be&\f'\r\\3F]\u0006\u0014G.\u001a3\u0002IQ\f'\r\\3NKR\fG)\u0019;b\rJ|Wn\u0015;bi\u0016lWM\u001c;%I\u00164\u0017-\u001e7uIM*\"A!\u0018+\t\u0005u\u00111`\u0001\u0011aJ,\u0007/\u0019:f'R\fG/Z7f]R$bAa\u0019\u0003|\t}\u0004c\u0002\u001a\u0003f\u0005]#\u0011N\u0005\u0004\u0005O\u001a$A\u0002+va2,'\u0007E\u00033\u0003c\u0014Y\u0007\u0005\u0004\u0002B\u0005E#Q\u000e\u0019\u0005\u0005_\u00129\bE\u0003/\u0005c\u0012)(C\u0002\u0003t\u0001\u0012a\"U;fef\u0004\u0016M]1nKR,'\u000fE\u0002r\u0005o\"!B!\u001f\u001d\u0003\u0003\u0005\tQ!\u0001u\u0005\ryF%\r\u0005\b\u0005{b\u0002\u0019\u0001B \u00031\u0019\u0018\u000f\\*uCR,W.\u001a8u\u0011\u001d\u00119\u0006\ba\u0001\u0003;\t!\u0004\u001d:fa\u0006\u0014XmV5uQ>,HOQ5oIZ\u000b'/[1cY\u0016$B!a\u0016\u0003\u0006\"9!QP\u000fA\u0002\t}\u0012a\u00069sKB\f'/Z,ji\"\u0014\u0015N\u001c3WCJL\u0017M\u00197f)\u0011\u0011YIa'\u0011\u000fI\u0012)'a\u0016\u0003\u000eB)!'!=\u0003\u0010B1\u0011\u0011IA)\u0005#\u0003DAa%\u0003\u0018B)aF!\u001d\u0003\u0016B\u0019\u0011Oa&\u0005\u0015\tee$!A\u0001\u0002\u000b\u0005AOA\u0002`IIBqA! \u001f\u0001\u0004\u0011y\u0004")
public class DataApiWrapper
extends RedshiftWrapper {
    private transient Iterator<Object> callNumberGenerator;
    private transient ExecutionContext ec;
    private transient ConcurrentHashMap<DataApiCommand, Object> cancellationMap;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile transient byte bitmap$trans$0;

    public Logger log() {
        return this.log;
    }

    private Iterator<Object> callNumberGenerator$lzycompute() {
        DataApiWrapper dataApiWrapper = this;
        synchronized (dataApiWrapper) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.callNumberGenerator = scala.package$.MODULE$.Iterator().from(1);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.callNumberGenerator;
    }

    private Iterator<Object> callNumberGenerator() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.callNumberGenerator$lzycompute() : this.callNumberGenerator;
    }

    private ExecutionContext ec$lzycompute() {
        DataApiWrapper dataApiWrapper = this;
        synchronized (dataApiWrapper) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                ThreadFactory threadFactory = new ThreadFactory(null){
                    private final AtomicInteger count;

                    /*
                     * WARNING - void declaration
                     */
                    public Thread newThread(Runnable r) {
                        void var2_2;
                        Thread thread = new Thread(r);
                        thread.setName(new java.lang.StringBuilder(30).append("spark-redshift-DataApiWrapper-").append(this.count.incrementAndGet()).toString());
                        thread.setDaemon(true);
                        return var2_2;
                    }
                    {
                        this.count = new AtomicInteger();
                    }
                };
                this.ec = ExecutionContext$.MODULE$.fromExecutorService(Executors.newCachedThreadPool(threadFactory));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.ec;
    }

    private ExecutionContext ec() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.ec$lzycompute() : this.ec;
    }

    private ConcurrentHashMap<DataApiCommand, Object> cancellationMap$lzycompute() {
        DataApiWrapper dataApiWrapper = this;
        synchronized (dataApiWrapper) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.cancellationMap = new ConcurrentHashMap();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.cancellationMap;
    }

    private ConcurrentHashMap<DataApiCommand, Object> cancellationMap() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.cancellationMap$lzycompute() : this.cancellationMap;
    }

    private <T> T executeInterruptibly(DataApiCommand cmd, Function1<DataApiCommand, T> op) {
        Object object;
        int callNumber = BoxesRunTime.unboxToInt((Object)this.callNumberGenerator().next());
        try {
            try {
                this.log().info("Begin Redshift Data API call {}", (Object)BoxesRunTime.boxToInteger((int)callNumber));
                this.cancellationMap().put(cmd, BoxesRunTime.boxToInteger((int)callNumber));
                Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> op.apply((Object)cmd), this.ec());
                try {
                    object = Await$.MODULE$.result((Awaitable)future, (Duration)Duration$.MODULE$.Inf());
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof SQLException) {
                        SQLException sQLException = (SQLException)throwable2;
                        throw new SQLException("Exception thrown in awaitResult: ", sQLException);
                    }
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable t = (Throwable)option.get();
                        throw new Exception("Exception thrown in awaitResult: ", t);
                    }
                    throw throwable;
                }
            }
            catch (InterruptedException e) {
                try {
                    cmd.cancel();
                    throw e;
                }
                catch (SQLException s) {
                    this.log().error("Exception occurred while cancelling query: {}", new Object[]{s.getMessage()});
                    throw e;
                }
            }
        }
        finally {
            this.cancellationMap().remove(cmd);
            this.log().info("End Redshift Data API call {}", (Object)BoxesRunTime.boxToInteger((int)callNumber));
        }
        return (T)object;
    }

    @Override
    public void setAutoCommit(RedshiftConnection conn, boolean autoCommit) {
        block0: {
            if (conn.getAutoCommit() == autoCommit) break block0;
            conn.setAutoCommit(autoCommit);
            this.executeBufferedCommands(conn);
        }
    }

    @Override
    public void commit(RedshiftConnection conn) {
        if (conn.getAutoCommit()) {
            throw new IllegalStateException("Cannot commit when autoCommit is enabled.");
        }
        this.executeBufferedCommands(conn);
    }

    @Override
    public void rollback(RedshiftConnection conn) {
        if (conn.getAutoCommit()) {
            throw new IllegalStateException("Cannot rollback when autoCommit is enabled.");
        }
        DataAPIConnection dataApiConnection = (DataAPIConnection)conn;
        dataApiConnection.bufferedCommands().clear();
    }

    private void executeBufferedCommands(RedshiftConnection conn) {
        block0: {
            DataAPIConnection dataApiConnection = (DataAPIConnection)conn;
            if (dataApiConnection.bufferedCommands().length() <= 0) break block0;
            this.executeBatch(conn, (Seq<String>)dataApiConnection.bufferedCommands());
            dataApiConnection.bufferedCommands().clear();
        }
    }

    private boolean executeBatch(RedshiftConnection conn, Seq<String> sqls) {
        DataAPIConnection dataApiConnection = (DataAPIConnection)conn;
        return BoxesRunTime.unboxToBoolean(this.executeInterruptibly(new DataApiCommand(dataApiConnection, DataApiCommand$.MODULE$.$lessinit$greater$default$2()), (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.executeBatch((Seq<String>)sqls))));
    }

    @Override
    public boolean executeInterruptibly(RedshiftConnection conn, String sql) {
        boolean bl;
        DataAPIConnection dataApiConnection = (DataAPIConnection)conn;
        if (!conn.getAutoCommit()) {
            this.log().info("Buffering statement for batch execution later since auto-commit is disabled.");
            dataApiConnection.bufferedCommands().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sql}));
            bl = false;
        } else {
            bl = BoxesRunTime.unboxToBoolean(this.executeInterruptibly(new DataApiCommand(dataApiConnection, DataApiCommand$.MODULE$.$lessinit$greater$default$2()), (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.execute(sql))));
        }
        return bl;
    }

    @Override
    public RedshiftResults executeQueryInterruptibly(RedshiftConnection conn, String sql) {
        if (!conn.getAutoCommit()) {
            throw new IllegalStateException("Cannot execute queries while not in auto-commit mode!");
        }
        DataAPIConnection dataApiConnection = (DataAPIConnection)conn;
        return (RedshiftResults)this.executeInterruptibly(new DataApiCommand(dataApiConnection, DataApiCommand$.MODULE$.$lessinit$greater$default$2()), (Function1 & Serializable & scala.Serializable)x$3 -> x$3.executeQueryInterruptibly(sql));
    }

    @Override
    public long executeUpdateInterruptibly(RedshiftConnection conn, String sql) {
        long l;
        DataAPIConnection dataApiConnection = (DataAPIConnection)conn;
        if (!conn.getAutoCommit()) {
            this.log().info("Buffering statement for batch execution later since auto-commit is disabled.");
            dataApiConnection.bufferedCommands().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sql}));
            l = 0L;
        } else {
            l = BoxesRunTime.unboxToLong(this.executeInterruptibly(new DataApiCommand(dataApiConnection, DataApiCommand$.MODULE$.$lessinit$greater$default$2()), (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.executeUpdate(sql))));
        }
        return l;
    }

    @Override
    public long executeUpdate(RedshiftConnection conn, String sql) {
        long l;
        DataAPIConnection dataApiConnection = (DataAPIConnection)conn;
        if (!conn.getAutoCommit()) {
            this.log().info("Buffering statement for batch execution later since auto-commit is disabled.");
            dataApiConnection.bufferedCommands().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sql}));
            l = 0L;
        } else {
            l = BoxesRunTime.unboxToLong(this.executeInterruptibly(new DataApiCommand(dataApiConnection, DataApiCommand$.MODULE$.$lessinit$greater$default$2()), (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.executeUpdate(sql))));
        }
        return l;
    }

    @Override
    public RedshiftConnection getConnector(Parameters.MergedParameters params) {
        return new DataAPIConnection(params, DataAPIConnection$.MODULE$.apply$default$2());
    }

    @Override
    public RedshiftConnection getConnectorWithQueryGroup(Parameters.MergedParameters params, String queryGroup) {
        return new DataAPIConnection(params, (Option<String>)Option$.MODULE$.apply((Object)queryGroup));
    }

    @Override
    public boolean tableExists(RedshiftConnection conn, String table) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            String sql = new java.lang.StringBuilder(22).append("SELECT 1 FROM ").append(table).append(" LIMIT 1").toString();
            GetStatementResultResult results = ((DataApiResults)this.executeInterruptibly(new DataApiCommand((DataAPIConnection)conn, DataApiCommand$.MODULE$.$lessinit$greater$default$2()), (Function1 & Serializable & scala.Serializable)x$6 -> x$6.executeQueryInterruptibly(sql))).results();
            return ((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(results.getColumnMetadata()).asScala()).length();
        }).isSuccess();
    }

    @Override
    public StructType resolveTable(RedshiftConnection conn, String table, Option<Parameters.MergedParameters> params) {
        this.log().info("Getting schema from Redshift for table: {}", new Object[]{table});
        DataApiResults res = (DataApiResults)this.executeQueryInterruptibly(conn, new java.lang.StringBuilder(22).append("SELECT * FROM ").append(table).append(" LIMIT 1").toString());
        Buffer rsmd = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(res.results().getColumnMetadata()).asScala();
        int ncols = rsmd.length();
        StructField[] fields = new StructField[ncols];
        for (int i = 0; i < ncols; ++i) {
            ColumnMetadata colmd = (ColumnMetadata)rsmd.apply(i);
            String columnName = colmd.getLabel();
            String rsType = colmd.getTypeName();
            Integer fieldSize = colmd.getPrecision();
            Integer fieldScale = colmd.getScale();
            Boolean isSigned = colmd.isSigned();
            boolean nullable = params.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.overrideNullable())) ? true : !BoxesRunTime.equalsNumObject((Number)colmd.getNullable(), (Object)BoxesRunTime.boxToInteger((int)0));
            DataType columnType = this.getCatalystType(rsType, Predef$.MODULE$.Integer2int(fieldSize), Predef$.MODULE$.Integer2int(fieldScale), Predef$.MODULE$.Boolean2boolean(isSigned), params);
            Metadata meta = new MetadataBuilder().putString("redshift_type", rsType).build();
            fields[i] = new StructField(columnName, columnType, nullable, meta);
        }
        return new StructType(fields);
    }

    @Override
    public Option<Parameters.MergedParameters> resolveTable$default$3() {
        return None$.MODULE$;
    }

    private StructType resolveTableFromMeta(RedshiftResults results, Parameters.MergedParameters params) {
        Buffer rsmd = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((DataApiResults)results).results().getColumnMetadata()).asScala();
        int ncols = rsmd.length();
        StructField[] fields = new StructField[ncols];
        for (int i = 0; i < ncols; ++i) {
            ColumnMetadata colmd = (ColumnMetadata)rsmd.apply(i);
            String columnName = colmd.getLabel();
            String rsType = colmd.getTypeName();
            Integer fieldSize = colmd.getPrecision();
            Integer fieldScale = colmd.getScale();
            Boolean isSigned = colmd.isSigned();
            boolean nullable = !BoxesRunTime.equalsNumObject((Number)colmd.getNullable(), (Object)BoxesRunTime.boxToInteger((int)0));
            DataType columnType = this.getCatalystType(rsType, Predef$.MODULE$.Integer2int(fieldSize), Predef$.MODULE$.Integer2int(fieldScale), Predef$.MODULE$.Boolean2boolean(isSigned), (Option<Parameters.MergedParameters>)new Some((Object)params));
            Metadata meta = new MetadataBuilder().putString("redshift_type", rsType).build();
            fields[i] = new StructField(columnName.matches("[_A-Z]([_0-9A-Z])*") ? columnName : new java.lang.StringBuilder(2).append("\"").append(columnName).append("\"").toString(), columnType, nullable, meta);
        }
        return new StructType(fields);
    }

    private DataType getCatalystType(String redshiftType, int precision, int scale, boolean signed, Option<Parameters.MergedParameters> params) {
        String string = redshiftType;
        Object object = "oid".equals(string) ? (signed ? LongType$.MODULE$ : new DecimalType(20, 0)) : ("money".equals(string) ? DoubleType$.MODULE$ : ("double precision".equals(string) ? DoubleType$.MODULE$ : ("bpchar".equals(string) ? StringType$.MODULE$ : ("text".equals(string) ? StringType$.MODULE$ : ("name".equals(string) ? StringType$.MODULE$ : ("character varying".equals(string) ? StringType$.MODULE$ : ("bit".equals(string) ? BooleanType$.MODULE$ : ("time without time zone".equals(string) ? TimestampType$.MODULE$ : ("timestamp without time zone".equals(string) ? (package$.MODULE$.legacyTimestampHandling() ? TimestampType$.MODULE$ : TimestampNTZTypeExtractor$.MODULE$.defaultType()) : ("timestamp with time zone".equals(string) ? TimestampType$.MODULE$ : ("xid".equals(string) ? (signed ? LongType$.MODULE$ : new DecimalType(20, 0)) : ("tid".equals(string) ? StringType$.MODULE$ : ("abstime".equals(string) ? TimestampType$.MODULE$ : ("int2".equals(string) ? (params.exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.legacyMappingShortToInt())) ? IntegerType$.MODULE$ : ShortType$.MODULE$) : ("int4".equals(string) ? (signed ? IntegerType$.MODULE$ : LongType$.MODULE$) : ("int8".equals(string) ? (signed ? LongType$.MODULE$ : new DecimalType(20, 0)) : ("numeric".equals(string) && (precision != 0 || scale != 0) ? new DecimalType(precision, scale) : ("float4".equals(string) ? (params.exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.legacyJdbcRealTypeMapping())) ? DoubleType$.MODULE$ : FloatType$.MODULE$) : ("float8".equals(string) ? DoubleType$.MODULE$ : ("char".equals(string) ? StringType$.MODULE$ : ("varchar".equals(string) ? StringType$.MODULE$ : ("bool".equals(string) ? BooleanType$.MODULE$ : ("date".equals(string) ? DateType$.MODULE$ : ("time".equals(string) ? TimestampType$.MODULE$ : ("time with time zone".equals(string) ? TimestampType$.MODULE$ : ("timetz".equals(string) ? TimestampType$.MODULE$ : ("timestamp".equals(string) ? (package$.MODULE$.legacyTimestampHandling() ? TimestampType$.MODULE$ : TimestampNTZTypeExtractor$.MODULE$.defaultType()) : ("timestamptz".equals(string) ? TimestampType$.MODULE$ : ("oidvector".equals(string) ? StringType$.MODULE$ : ("super".equals(string) ? StringType$.MODULE$ : null))))))))))))))))))))))))))))));
        LongType$ answer = object;
        if (answer == null) {
            throw new SQLException(new java.lang.StringBuilder(17).append("Unsupported type ").append(redshiftType).toString());
        }
        return answer;
    }

    private Option<Parameters.MergedParameters> getCatalystType$default$5() {
        return None$.MODULE$;
    }

    @Override
    public StructType tableSchema(RedshiftConnection conn, RedshiftSQLStatement statement, Parameters.MergedParameters params) {
        return this.resolveTableFromMeta(this.tableMetaDataFromStatement(conn, statement, this.tableMetaDataFromStatement$default$3()), params);
    }

    private RedshiftResults tableMetaDataFromStatement(RedshiftConnection conn, RedshiftSQLStatement statement, boolean bindVariableEnabled) {
        RedshiftSQLStatement sqlStatement = new ConstantString("select * from").$plus(statement).$plus("where 1 = 0");
        Tuple2<String, Option<Seq<QueryParameter<?>>>> tuple2 = this.prepareStatement(sqlStatement, bindVariableEnabled);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String query = (String)tuple2._1();
        Option params = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)query, (Object)params);
        Tuple2 tuple23 = tuple22;
        String query2 = (String)tuple23._1();
        Option params2 = (Option)tuple23._2();
        DataAPIConnection dataApiConnection = (DataAPIConnection)conn;
        return (RedshiftResults)this.executeInterruptibly(new DataApiCommand(dataApiConnection, params2), (Function1 & Serializable & scala.Serializable)x$11 -> x$11.executeQueryInterruptibly(query2));
    }

    private boolean tableMetaDataFromStatement$default$3() {
        return true;
    }

    private Tuple2<String, Option<Seq<QueryParameter<?>>>> prepareStatement(RedshiftSQLStatement sqlStatement, boolean bindVariableEnabled) {
        return bindVariableEnabled ? this.prepareWithBindVariable(sqlStatement) : new Tuple2((Object)this.prepareWithoutBindVariable(sqlStatement), (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private String prepareWithoutBindVariable(RedshiftSQLStatement sqlStatement) {
        void var3_3;
        List sql = sqlStatement.list().reverse();
        String query = ((StringBuilder)sql.foldLeft((Object)new StringBuilder(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StringBuilder buffer = (StringBuilder)tuple2._1();
            StatementElement statement = (StatementElement)tuple2._2();
            buffer.append(statement instanceof ConstantString ? statement : statement.sql());
            StringBuilder stringBuilder = buffer.append(" ");
            return stringBuilder;
        })).toString();
        String logPrefix = (String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(60).append(this.MASTER_LOG_PREFIX()).append(":\n         | execute query without bind variable:\n         |").toString())).stripMargin())).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DataApiWrapper.$anonfun$prepareWithoutBindVariable$2(BoxesRunTime.unboxToChar((Object)x$12))));
        return var3_3;
    }

    private Tuple2<String, Option<Seq<QueryParameter<?>>>> prepareWithBindVariable(RedshiftSQLStatement sqlStatement) {
        List sql = sqlStatement.list().reverse();
        StatementElement[] varArray = new StatementElement[sqlStatement.numOfVar()];
        IntRef indexOfVar = IntRef.create((int)0);
        StringBuilder buffer = new StringBuilder();
        sql.foreach((Function1 & Serializable & scala.Serializable)element -> {
            StringBuilder stringBuilder;
            if (element instanceof ConstantString) {
                stringBuilder = buffer.append(element);
            } else {
                buffer.append(new java.lang.StringBuilder(6).append(":param").append(indexOfVar$1.elem).toString());
                varArray$1[indexOfVar$1.elem] = element;
                ++indexOfVar$1.elem;
                stringBuilder = BoxedUnit.UNIT;
            }
            return buffer.append(" ");
        });
        String query = buffer.toString();
        if (varArray.length == 0) {
            return new Tuple2((Object)query, (Object)None$.MODULE$);
        }
        String logPrefix = (String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(57).append(this.MASTER_LOG_PREFIX()).append(":\n         | execute query with bind variable:\n         |").toString())).stripMargin())).filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)DataApiWrapper.$anonfun$prepareWithBindVariable$2(BoxesRunTime.unboxToChar((Object)x$13))));
        ArrayBuffer parameters = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])varArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void var3_16;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            StatementElement element = (StatementElement)tuple2._1();
            int index = tuple2._2$mcI$sp();
            String name = new java.lang.StringBuilder(5).append("param").append(index).toString();
            StatementElement statementElement = element;
            if (statementElement instanceof StringVariable) {
                StringVariable stringVariable = (StringVariable)statementElement;
                QueryParameter<String> queryParameter = new QueryParameter<String>(name, stringVariable.variable(), 12);
                return parameters.$plus$eq((Object)var3_16);
            } else if (statementElement instanceof IntVariable) {
                IntVariable intVariable = (IntVariable)statementElement;
                QueryParameter<Object> queryParameter = new QueryParameter<Object>(name, intVariable.variable(), 4);
                return parameters.$plus$eq((Object)var3_16);
            } else if (statementElement instanceof LongVariable) {
                LongVariable longVariable = (LongVariable)statementElement;
                QueryParameter<Object> queryParameter = new QueryParameter<Object>(name, longVariable.variable(), -5);
                return parameters.$plus$eq((Object)var3_16);
            } else if (statementElement instanceof ShortVariable) {
                ShortVariable shortVariable = (ShortVariable)statementElement;
                QueryParameter<Object> queryParameter = new QueryParameter<Object>(name, shortVariable.variable(), 5);
                return parameters.$plus$eq((Object)var3_16);
            } else if (statementElement instanceof FloatVariable) {
                FloatVariable floatVariable = (FloatVariable)statementElement;
                QueryParameter<Object> queryParameter = new QueryParameter<Object>(name, floatVariable.variable(), 6);
                return parameters.$plus$eq((Object)var3_16);
            } else if (statementElement instanceof DoubleVariable) {
                DoubleVariable doubleVariable = (DoubleVariable)statementElement;
                QueryParameter<Object> queryParameter = new QueryParameter<Object>(name, doubleVariable.variable(), 8);
                return parameters.$plus$eq((Object)var3_16);
            } else if (statementElement instanceof BooleanVariable) {
                BooleanVariable booleanVariable = (BooleanVariable)statementElement;
                QueryParameter<Object> queryParameter = new QueryParameter<Object>(name, booleanVariable.variable(), 16);
                return parameters.$plus$eq((Object)var3_16);
            } else {
                if (!(statementElement instanceof ByteVariable)) throw new IllegalArgumentException(new java.lang.StringBuilder(25).append("Unexpected Element Type: ").append(element.getClass().getName()).toString());
                ByteVariable byteVariable = (ByteVariable)statementElement;
                QueryParameter<Object> queryParameter = new QueryParameter<Object>(name, byteVariable.variable(), -6);
            }
            return parameters.$plus$eq((Object)var3_16);
        });
        return new Tuple2((Object)query, (Object)Option$.MODULE$.apply((Object)parameters));
    }

    public static final /* synthetic */ void $anonfun$new$2(DataApiWrapper $this, DataApiCommand statement, int callNumber) {
        try {
            $this.log().info("Cancelling pending Data API call {}", (Object)BoxesRunTime.boxToInteger((int)callNumber));
            statement.cancel();
        }
        catch (Throwable e) {
            $this.log().error("Exception occurred while cancelling Data API request: {}", new Object[]{e.getMessage()});
        }
    }

    public static final /* synthetic */ boolean $anonfun$prepareWithoutBindVariable$2(char x$12) {
        return x$12 >= ' ';
    }

    public static final /* synthetic */ boolean $anonfun$prepareWithBindVariable$2(char x$13) {
        return x$13 >= ' ';
    }

    public DataApiWrapper() {
        scala.sys.package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.cancellationMap().forEach((statement, callNumber) -> DataApiWrapper.$anonfun$new$2(this, statement, BoxesRunTime.unboxToInt((Object)callNumber))));
    }
}

