/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift.data;

import com.amazonaws.services.redshiftdataapi.AWSRedshiftDataAPI;
import com.amazonaws.services.redshiftdataapi.model.BatchExecuteStatementRequest;
import com.amazonaws.services.redshiftdataapi.model.BatchExecuteStatementResult;
import com.amazonaws.services.redshiftdataapi.model.CancelStatementRequest;
import com.amazonaws.services.redshiftdataapi.model.CancelStatementResult;
import com.amazonaws.services.redshiftdataapi.model.DescribeStatementRequest;
import com.amazonaws.services.redshiftdataapi.model.DescribeStatementResult;
import com.amazonaws.services.redshiftdataapi.model.ExecuteStatementRequest;
import com.amazonaws.services.redshiftdataapi.model.ExecuteStatementResult;
import com.amazonaws.services.redshiftdataapi.model.GetStatementResultRequest;
import com.amazonaws.services.redshiftdataapi.model.GetStatementResultResult;
import com.amazonaws.services.redshiftdataapi.model.SqlParameter;
import com.amazonaws.services.redshiftdataapi.model.SubStatementData;
import io.github.spark_redshift_community.spark.redshift.Utils$;
import io.github.spark_redshift_community.spark.redshift.data.DataAPIConnection;
import io.github.spark_redshift_community.spark.redshift.data.DataApiCommand$;
import io.github.spark_redshift_community.spark.redshift.data.DataApiResults;
import io.github.spark_redshift_community.spark.redshift.data.DataApiRuntimeException;
import io.github.spark_redshift_community.spark.redshift.data.QueryParameter;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftResults;
import java.io.Serializable;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUa\u0001\u0002\u001a4\u0001\u0001C\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\")Q\r\u0001C\u0001M\"9\u0001\u000f\u0001b\u0001\n\u0013\t\bB\u0002>\u0001A\u0003%!\u000fC\u0004|\u0001\u0001\u0007I\u0011\u0002?\t\u0013\u0005M\u0001\u00011A\u0005\n\u0005U\u0001bBA\u0011\u0001\u0001\u0006K! \u0005\n\u0003G\u0001\u0001\u0019!C\u0005\u0003KA\u0011\"!\u0010\u0001\u0001\u0004%I!a\u0010\t\u0011\u0005\r\u0003\u0001)Q\u0005\u0003OA\u0011\"!\u0012\u0001\u0005\u0004%I!a\u0012\t\u0011\u0005]\u0003\u0001)A\u0005\u0003\u0013B\u0011\"!\u0017\u0001\u0005\u0004%I!a\u0012\t\u0011\u0005m\u0003\u0001)A\u0005\u0003\u0013B\u0011\"!\u0018\u0001\u0005\u0004%I!a\u0012\t\u0011\u0005}\u0003\u0001)A\u0005\u0003\u0013Bq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002p\u0001!\t!!\u001d\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~!9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0005bBAI\u0001\u0011\u0005\u00111\u0013\u0005\b\u0003+\u0003A\u0011BA\u0013\u0011\u001d\t9\n\u0001C\u0005\u00033Cq!!(\u0001\t\u0013\ty\nC\u0004\u0002$\u0002!I!!*\t\u000f\u0005%\u0006\u0001\"\u0003\u0002,\"I\u0011Q\u0016\u0001C\u0002\u0013\u0005\u0011q\t\u0005\t\u0003_\u0003\u0001\u0015!\u0003\u0002J!I\u0011\u0011\u0017\u0001C\u0002\u0013\u0005\u0011q\t\u0005\t\u0003g\u0003\u0001\u0015!\u0003\u0002J!I\u0011Q\u0017\u0001C\u0002\u0013\u0005\u0011q\t\u0005\t\u0003o\u0003\u0001\u0015!\u0003\u0002J!I\u0011\u0011\u0018\u0001C\u0002\u0013\u0005\u0011q\t\u0005\t\u0003w\u0003\u0001\u0015!\u0003\u0002J!I\u0011Q\u0018\u0001C\u0002\u0013\u0005\u0011q\t\u0005\t\u0003\u007f\u0003\u0001\u0015!\u0003\u0002J!I\u0011\u0011\u0019\u0001C\u0002\u0013\u0005\u0011q\t\u0005\t\u0003\u0007\u0004\u0001\u0015!\u0003\u0002J!9\u0011Q\u0019\u0001\u0005\n\u0005\u001d\u0007bBAk\u0001\u0011%\u00111\u0016\u0005\b\u0003/\u0004A\u0011BAJ\u0011\u001d\tI\u000e\u0001C\u0005\u00037Dq!a9\u0001\t\u0013\t)\u000fC\u0004\u0002h\u0002!I!a%\b\u0013\u0005%8'!A\t\u0002\u0005-h\u0001\u0003\u001a4\u0003\u0003E\t!!<\t\r\u0015|C\u0011AAx\u0011%\t\tpLI\u0001\n\u0003\t\u0019P\u0001\bECR\f\u0017\t]5D_6l\u0017M\u001c3\u000b\u0005Q*\u0014\u0001\u00023bi\u0006T!AN\u001c\u0002\u0011I,Gm\u001d5jMRT!\u0001O\u001d\u0002\u000bM\u0004\u0018M]6\u000b\u0005iZ\u0014\u0001G:qCJ\\wL]3eg\"Lg\r^0d_6lWO\\5us*\u0011A(P\u0001\u0007O&$\b.\u001e2\u000b\u0003y\n!![8\u0004\u0001M\u0011\u0001!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\u0015\r|gN\\3di&|g\u000e\u0005\u0002J\u00156\t1'\u0003\u0002Lg\t\tB)\u0019;b\u0003BK5i\u001c8oK\u000e$\u0018n\u001c8\u0002\rA\f'/Y7t!\r\u0011e\nU\u0005\u0003\u001f\u000e\u0013aa\u00149uS>t\u0007cA)U-6\t!K\u0003\u0002T\u0007\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005U\u0013&aA*fcB\u0012q\u000b\u0018\t\u0004\u0013bS\u0016BA-4\u00059\tV/\u001a:z!\u0006\u0014\u0018-\\3uKJ\u0004\"a\u0017/\r\u0001\u0011IQLAA\u0001\u0002\u0003\u0015\tA\u0018\u0002\u0004?\u0012\n\u0014CA0c!\t\u0011\u0005-\u0003\u0002b\u0007\n9aj\u001c;iS:<\u0007C\u0001\"d\u0013\t!7IA\u0002B]f\fa\u0001P5oSRtDcA4iSB\u0011\u0011\n\u0001\u0005\u0006\u000f\u000e\u0001\r\u0001\u0013\u0005\b\u0019\u000e\u0001\n\u00111\u0001k!\r\u0011ej\u001b\t\u0004#Rc\u0007GA7p!\rI\u0005L\u001c\t\u00037>$\u0011\"X5\u0002\u0002\u0003\u0005)\u0011\u00010\u0002\u00071|w-F\u0001s!\t\u0019\b0D\u0001u\u0015\t)h/A\u0003tY\u001a$$NC\u0001x\u0003\ry'oZ\u0005\u0003sR\u0014a\u0001T8hO\u0016\u0014\u0018\u0001\u00027pO\u0002\naa\u00197jK:$X#A?\u0011\u0007y\fy!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\u001fI,Gm\u001d5jMR$\u0017\r^1ba&TA!!\u0002\u0002\b\u0005A1/\u001a:wS\u000e,7O\u0003\u0003\u0002\n\u0005-\u0011!C1nCj|g.Y<t\u0015\t\ti!A\u0002d_6L1!!\u0005\u0000\u0005I\tuk\u0015*fIND\u0017N\u001a;ECR\f\u0017\tU%\u0002\u0015\rd\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002\u0018\u0005u\u0001c\u0001\"\u0002\u001a%\u0019\u00111D\"\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003?9\u0011\u0011!a\u0001{\u0006\u0019\u0001\u0010J\u0019\u0002\u000f\rd\u0017.\u001a8uA\u0005I!/Z9vKN$\u0018\nZ\u000b\u0003\u0003O\u0001B!!\u000b\u000289!\u00111FA\u001a!\r\ticQ\u0007\u0003\u0003_Q1!!\r@\u0003\u0019a$o\\8u}%\u0019\u0011QG\"\u0002\rA\u0013X\rZ3g\u0013\u0011\tI$a\u000f\u0003\rM#(/\u001b8h\u0015\r\t)dQ\u0001\u000ee\u0016\fX/Z:u\u0013\u0012|F%Z9\u0015\t\u0005]\u0011\u0011\t\u0005\n\u0003?Q\u0011\u0011!a\u0001\u0003O\t!B]3rk\u0016\u001cH/\u00133!\u0003=\u0019F+\u0011+V'~3\u0015JT%T\u0011\u0016#UCAA%!\u0011\tY%!\u0016\u000e\u0005\u00055#\u0002BA(\u0003#\nA\u0001\\1oO*\u0011\u00111K\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002:\u00055\u0013\u0001E*U\u0003R+6k\u0018$J\u001d&\u001b\u0006*\u0012#!\u00039\u0019F+\u0011+V'~\u000b%i\u0014*U\u000b\u0012\u000bqb\u0015+B)V\u001bv,\u0011\"P%R+E\tI\u0001\u000e'R\u000bE+V*`\r\u0006KE*\u0012#\u0002\u001dM#\u0016\tV+T?\u001a\u000b\u0015\nT#EA\u00059Q\r_3dkR,G\u0003BA3\u0003W\u00022AQA4\u0013\r\tIg\u0011\u0002\b\u0005>|G.Z1o\u0011\u001d\tiG\u0005a\u0001\u0003O\t1a]9m\u00035)\u00070Z2vi\u0016,\u0006\u000fZ1uKR!\u00111OA=!\r\u0011\u0015QO\u0005\u0004\u0003o\u001a%\u0001\u0002'p]\u001eDq!!\u001c\u0014\u0001\u0004\t9#A\rfq\u0016\u001cW\u000f^3Rk\u0016\u0014\u00180\u00138uKJ\u0014X\u000f\u001d;jE2LH\u0003BA@\u0003\u000b\u00032!SAA\u0013\r\t\u0019i\r\u0002\u0010%\u0016$7\u000f[5giJ+7/\u001e7ug\"9\u0011Q\u000e\u000bA\u0002\u0005\u001d\u0012\u0001D3yK\u000e,H/\u001a\"bi\u000eDG\u0003BA3\u0003\u0017Cq!!$\u0016\u0001\u0004\ty)\u0001\u0003tc2\u001c\b\u0003B)U\u0003O\taaY1oG\u0016dGCAA3\u0003=\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8OC6,\u0017aE2iK\u000e\\W\t_3dkR,\u0017I\u001c3XC&$H\u0003BA\f\u00037Cq!!$\u0019\u0001\u0004\ty)\u0001\u000btS:<G.Z#yK\u000e,H/Z!oI^\u000b\u0017\u000e\u001e\u000b\u0005\u0003/\t\t\u000bC\u0004\u0002ne\u0001\r!a\n\u0002'\t\fGo\u00195Fq\u0016\u001cW\u000f^3B]\u0012<\u0016-\u001b;\u0015\t\u0005]\u0011q\u0015\u0005\b\u0003\u001bS\u0002\u0019AAH\u0003]Ig.\u001b;jC2L'0\u001a#bi\u0006\f\u0005/[\"mS\u0016tG\u000f\u0006\u0002\u0002\u0018\u0005aB)\u0011+B?\u0006\u0003\u0016j\u0018*F)JKv\fR#M\u0003f{V*\u0013(`\u0017\u0016K\u0016!\b#B)\u0006{\u0016\tU%`%\u0016#&+W0E\u000b2\u000b\u0015lX'J\u001d~[U)\u0017\u0011\u00029\u0011\u000bE+Q0B!&{&+\u0012+S3~#U\tT!Z?6\u000b\u0005lX&F3\u0006iB)\u0011+B?\u0006\u0003\u0016j\u0018*F)JKv\fR#M\u0003f{V*\u0011-`\u0017\u0016K\u0006%A\u000fE\u0003R\u000bu,\u0011)J?J+EKU-`\t\u0016c\u0015)W0N+2#vlS#Z\u0003y!\u0015\tV!`\u0003BKuLU#U%f{F)\u0012'B3~kU\u000b\u0014+`\u0017\u0016K\u0006%\u0001\u0011E\u0003R\u000bu,\u0011)J?J+EKU-`\t\u0016c\u0015)W0N\u0013:{F)\u0012$B+2#\u0016!\t#B)\u0006{\u0016\tU%`%\u0016#&+W0E\u000b2\u000b\u0015lX'J\u001d~#UIR!V\u0019R\u0003\u0013\u0001\t#B)\u0006{\u0016\tU%`%\u0016#&+W0E\u000b2\u000b\u0015lX'B1~#UIR!V\u0019R\u000b\u0011\u0005R!U\u0003~\u000b\u0005+S0S\u000bR\u0013\u0016l\u0018#F\u0019\u0006Kv,T!Y?\u0012+e)Q+M)\u0002\n\u0011\u0005R!U\u0003~\u000b\u0005+S0S\u000bR\u0013\u0016l\u0018#F\u0019\u0006Kv,T+M)~#UIR!V\u0019R\u000b!\u0005R!U\u0003~\u000b\u0005+S0S\u000bR\u0013\u0016l\u0018#F\u0019\u0006Kv,T+M)~#UIR!V\u0019R\u0003\u0013!F4fi\u0012\u000bG/Y!qS\u0012+G.Y=QCJ\fWn\u001d\u000b\u0003\u0003\u0013\u0004\u0012BQAf\u0003\u001f\fy-a4\n\u0007\u000557I\u0001\u0004UkBdWm\r\t\u0004\u0005\u0006E\u0017bAAj\u0007\n1Ai\\;cY\u0016\fq\"Y<bSR\u001cu.\u001c9mKRLwN\\\u0001\u000bQ\u0006\u001c(+Z:vYR\u001c\u0018AC4fiJ+7/\u001e7ugR\u0011\u0011Q\u001c\t\u0004\u0013\u0006}\u0017bAAqg\tqA)\u0019;b\u0003BL'+Z:vYR\u001c\u0018!D4fiJ+7/\u001e7u%><8\u000f\u0006\u0002\u0002t\u0005i1-\u00198dK2\u0014V-];fgR\fa\u0002R1uC\u0006\u0003\u0018nQ8n[\u0006tG\r\u0005\u0002J_M\u0011q&\u0011\u000b\u0003\u0003W\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TCAA{U\u0011\t9Pa\u0001\u0011\t\ts\u0015\u0011 \t\u0005#R\u000bY\u0010\r\u0003\u0002~\n\u0005\u0001\u0003B%Y\u0003\u007f\u00042a\u0017B\u0001\t%i\u0016'!A\u0001\u0002\u000b\u0005al\u000b\u0002\u0003\u0006A!!q\u0001B\t\u001b\t\u0011IA\u0003\u0003\u0003\f\t5\u0011!C;oG\",7m[3e\u0015\r\u0011yaQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\n\u0005\u0013\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class DataApiCommand {
    private final DataAPIConnection connection;
    private final Option<Seq<QueryParameter<?>>> params;
    private final Logger log;
    private AWSRedshiftDataAPI client;
    private String requestId;
    private final String STATUS_FINISHED;
    private final String STATUS_ABORTED;
    private final String STATUS_FAILED;
    private final String DATA_API_RETRY_DELAY_MIN_KEY;
    private final String DATA_API_RETRY_DELAY_MAX_KEY;
    private final String DATA_API_RETRY_DELAY_MULT_KEY;
    private final String DATA_API_RETRY_DELAY_MIN_DEFAULT;
    private final String DATA_API_RETRY_DELAY_MAX_DEFAULT;
    private final String DATA_API_RETRY_DELAY_MULT_DEFAULT;

    public static Option<Seq<QueryParameter<?>>> $lessinit$greater$default$2() {
        return DataApiCommand$.MODULE$.$lessinit$greater$default$2();
    }

    private Logger log() {
        return this.log;
    }

    private AWSRedshiftDataAPI client() {
        return this.client;
    }

    private void client_$eq(AWSRedshiftDataAPI x$1) {
        this.client = x$1;
    }

    private String requestId() {
        return this.requestId;
    }

    private void requestId_$eq(String x$1) {
        this.requestId = x$1;
    }

    private String STATUS_FINISHED() {
        return this.STATUS_FINISHED;
    }

    private String STATUS_ABORTED() {
        return this.STATUS_ABORTED;
    }

    private String STATUS_FAILED() {
        return this.STATUS_FAILED;
    }

    public boolean execute(String sql) {
        this.checkExecuteAndWait((Seq<String>)((Seq)new .colon.colon((Object)sql, (List)Nil$.MODULE$)));
        return this.hasResults();
    }

    public long executeUpdate(String sql) {
        this.checkExecuteAndWait((Seq<String>)((Seq)new .colon.colon((Object)sql, (List)Nil$.MODULE$)));
        return this.getResultRows();
    }

    public RedshiftResults executeQueryInterruptibly(String sql) {
        this.checkExecuteAndWait((Seq<String>)((Seq)new .colon.colon((Object)sql, (List)Nil$.MODULE$)));
        return this.getResults();
    }

    public boolean executeBatch(Seq<String> sqls) {
        this.checkExecuteAndWait(sqls);
        return this.hasResults();
    }

    public boolean cancel() {
        return this.cancelRequest();
    }

    private String applicationName() {
        return new StringBuilder(7).append("Client:").append(Utils$.MODULE$.getApplicationName(this.connection.params())).toString();
    }

    private void checkExecuteAndWait(Seq<String> sqls) {
        ArrayBuffer updatedSqls;
        ArrayBuffer arrayBuffer;
        if (sqls == null || sqls.isEmpty() || sqls.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isEmpty()))) {
            throw new IllegalArgumentException("Data API cannot execute missing or empty commands!");
        }
        if (this.connection.queryGroup().isDefined()) {
            String strQG = new StringBuilder(21).append("set query_group to '").append(this.connection.queryGroup().get()).append("'").toString();
            arrayBuffer = ((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{strQG}))).$plus$plus$eq(sqls);
        } else {
            arrayBuffer = updatedSqls = sqls;
        }
        if (this.params.isDefined() && updatedSqls.length() > 1) {
            throw new IllegalArgumentException("Data API parameters require a single command with no query group specified!");
        }
        if (updatedSqls.length() == 1) {
            this.singleExecuteAndWait((String)updatedSqls.head());
        } else {
            this.batchExecuteAndWait((Seq<String>)updatedSqls);
        }
    }

    private void singleExecuteAndWait(String sql) {
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("Cannot execute null or empty command!");
        }
        this.initializeDataApiClient();
        ExecuteStatementRequest statementRequest = new ExecuteStatementRequest();
        statementRequest.setStatementName(this.applicationName());
        statementRequest.setDatabase((String)this.connection.params().dataApiDatabase().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Data API database is required!");
        }));
        if (this.connection.params().dataApiCluster().isDefined()) {
            statementRequest.setClusterIdentifier((String)this.connection.params().dataApiCluster().get());
        }
        if (this.connection.params().dataApiWorkgroup().isDefined()) {
            statementRequest.setWorkgroupName((String)this.connection.params().dataApiWorkgroup().get());
        }
        if (this.connection.params().dataApiUser().isDefined()) {
            statementRequest.setDbUser((String)this.connection.params().dataApiUser().get());
        }
        if (this.connection.params().secretId().isDefined()) {
            statementRequest.setSecretArn((String)this.connection.params().secretId().get());
        }
        statementRequest.setSql(sql);
        if (this.params.isDefined()) {
            ArrayBuffer sqlParams = new ArrayBuffer();
            ((IterableLike)this.params.get()).foreach((Function1 & Serializable & scala.Serializable)qp -> {
                DataApiCommand.$anonfun$singleExecuteAndWait$2(sqlParams, qp);
                return BoxedUnit.UNIT;
            });
            if (sqlParams.length() > 0) {
                statementRequest.setParameters((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)sqlParams).asJava());
            }
        }
        ExecuteStatementResult result = this.client().executeStatement(statementRequest);
        this.requestId_$eq(result.getId());
        this.log().info("Issued Redshift Data API execute statement with request id: {}", new Object[]{this.requestId()});
        this.awaitCompletion();
    }

    private void batchExecuteAndWait(Seq<String> sqls) {
        if (sqls == null || sqls.length() <= 0 || sqls.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty()))) {
            throw new IllegalArgumentException("Batch execution requires at least one command!");
        }
        this.initializeDataApiClient();
        BatchExecuteStatementRequest statementRequest = new BatchExecuteStatementRequest();
        statementRequest.setStatementName(this.applicationName());
        statementRequest.setDatabase((String)this.connection.params().dataApiDatabase().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Data API database is required!");
        }));
        if (this.connection.params().dataApiCluster().isDefined()) {
            statementRequest.setClusterIdentifier((String)this.connection.params().dataApiCluster().get());
        }
        if (this.connection.params().dataApiWorkgroup().isDefined()) {
            statementRequest.setWorkgroupName((String)this.connection.params().dataApiWorkgroup().get());
        }
        if (this.connection.params().dataApiUser().isDefined()) {
            statementRequest.setDbUser((String)this.connection.params().dataApiUser().get());
        }
        if (this.connection.params().secretId().isDefined()) {
            statementRequest.setSecretArn((String)this.connection.params().secretId().get());
        }
        statementRequest.setSqls((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(sqls).asJava());
        if (this.params.isDefined()) {
            throw new IllegalArgumentException("Parameters are not permitted with Data API batch execution!");
        }
        BatchExecuteStatementResult result = this.client().batchExecuteStatement(statementRequest);
        this.requestId_$eq(result.getId());
        this.log().info("Issued Redshift Data API batch execute statement with request id: {}", new Object[]{this.requestId()});
        this.awaitCompletion();
    }

    private void initializeDataApiClient() {
        this.client_$eq(Utils$.MODULE$.createDataApiClient(this.connection.params().dataApiRegion(), Utils$.MODULE$.createDataApiClient$default$2()));
    }

    public String DATA_API_RETRY_DELAY_MIN_KEY() {
        return this.DATA_API_RETRY_DELAY_MIN_KEY;
    }

    public String DATA_API_RETRY_DELAY_MAX_KEY() {
        return this.DATA_API_RETRY_DELAY_MAX_KEY;
    }

    public String DATA_API_RETRY_DELAY_MULT_KEY() {
        return this.DATA_API_RETRY_DELAY_MULT_KEY;
    }

    public String DATA_API_RETRY_DELAY_MIN_DEFAULT() {
        return this.DATA_API_RETRY_DELAY_MIN_DEFAULT;
    }

    public String DATA_API_RETRY_DELAY_MAX_DEFAULT() {
        return this.DATA_API_RETRY_DELAY_MAX_DEFAULT;
    }

    public String DATA_API_RETRY_DELAY_MULT_DEFAULT() {
        return this.DATA_API_RETRY_DELAY_MULT_DEFAULT;
    }

    private Tuple3<Object, Object, Object> getDataApiDelayParams() {
        double retryDelayMin = new StringOps(Predef$.MODULE$.augmentString(Utils$.MODULE$.getSparkConfigValue(this.DATA_API_RETRY_DELAY_MIN_KEY(), this.DATA_API_RETRY_DELAY_MIN_DEFAULT()))).toDouble();
        double retryDelayMax = new StringOps(Predef$.MODULE$.augmentString(Utils$.MODULE$.getSparkConfigValue(this.DATA_API_RETRY_DELAY_MAX_KEY(), this.DATA_API_RETRY_DELAY_MAX_DEFAULT()))).toDouble();
        double retryDelayMult = new StringOps(Predef$.MODULE$.augmentString(Utils$.MODULE$.getSparkConfigValue(this.DATA_API_RETRY_DELAY_MULT_KEY(), this.DATA_API_RETRY_DELAY_MULT_DEFAULT()))).toDouble();
        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)retryDelayMin), (Object)BoxesRunTime.boxToDouble((double)retryDelayMax), (Object)BoxesRunTime.boxToDouble((double)retryDelayMult));
    }

    private void awaitCompletion() {
        String string;
        String string2;
        DescribeStatementRequest describeStatementRequest = new DescribeStatementRequest();
        describeStatementRequest.setId(this.requestId());
        DescribeStatementResult describeResult = null;
        Tuple3<Object, Object, Object> tuple3 = this.getDataApiDelayParams();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        double retryDelayMin = BoxesRunTime.unboxToDouble((Object)tuple3._1());
        double retryDelayMax = BoxesRunTime.unboxToDouble((Object)tuple3._2());
        double retryDelayMult = BoxesRunTime.unboxToDouble((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)retryDelayMin), (Object)BoxesRunTime.boxToDouble((double)retryDelayMax), (Object)BoxesRunTime.boxToDouble((double)retryDelayMult));
        Tuple3 tuple33 = tuple32;
        double retryDelayMin2 = BoxesRunTime.unboxToDouble((Object)tuple33._1());
        double retryDelayMax2 = BoxesRunTime.unboxToDouble((Object)tuple33._2());
        double retryDelayMult2 = BoxesRunTime.unboxToDouble((Object)tuple33._3());
        double period = retryDelayMin2;
        do {
            Thread.sleep((long)period);
            period *= retryDelayMult2;
            period = Math.min(period, retryDelayMax2);
            describeResult = this.client().describeStatement(describeStatementRequest);
            String string3 = describeResult.getStatus();
            String string4 = this.STATUS_FINISHED();
            if (!(string3 == null ? string4 != null : !string3.equals(string4))) break;
            String string5 = describeResult.getStatus();
            String string6 = this.STATUS_ABORTED();
            if (!(string5 == null ? string6 != null : !string5.equals(string6))) break;
            string2 = describeResult.getStatus();
            string = this.STATUS_FAILED();
        } while (string2 == null ? string != null : !string2.equals(string));
        String string7 = describeResult.getStatus();
        String string8 = this.STATUS_ABORTED();
        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
            throw new DataApiRuntimeException("DataAPI query was aborted");
        }
        String string9 = describeResult.getStatus();
        String string10 = this.STATUS_FAILED();
        if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
            String error = describeResult.getError() != null ? describeResult.getError() : "unknown error";
            throw new DataApiRuntimeException(new StringBuilder(32).append("DataAPI query execution failed: ").append(error).toString());
        }
        this.log().info("The following Redshift Data API request id completed successfully: {}", new Object[]{this.requestId()});
    }

    private boolean hasResults() {
        DescribeStatementRequest describeStatementRequest = new DescribeStatementRequest();
        describeStatementRequest.setId(this.requestId());
        DescribeStatementResult describeResults = this.client().describeStatement(describeStatementRequest);
        return Predef$.MODULE$.Boolean2boolean(describeResults.getHasResultSet());
    }

    private DataApiResults getResults() {
        DescribeStatementRequest describeStatementRequest = new DescribeStatementRequest();
        describeStatementRequest.setId(this.requestId());
        DescribeStatementResult describeResults = this.client().describeStatement(describeStatementRequest);
        String resultId = describeResults.getSubStatements() == null || ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(describeResults.getSubStatements()).asScala()).isEmpty() ? this.requestId() : ((SubStatementData)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(describeResults.getSubStatements()).asScala()).last()).getId();
        GetStatementResultRequest statementResultRequest = new GetStatementResultRequest();
        statementResultRequest.setId(resultId);
        GetStatementResultResult results = this.client().getStatementResult(statementResultRequest);
        return new DataApiResults(results);
    }

    private long getResultRows() {
        DescribeStatementRequest describeStatementRequest = new DescribeStatementRequest();
        describeStatementRequest.setId(this.requestId());
        DescribeStatementResult describeResults = this.client().describeStatement(describeStatementRequest);
        return describeResults.getSubStatements() == null || ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(describeResults.getSubStatements()).asScala()).isEmpty() ? Predef$.MODULE$.Long2long(describeResults.getResultRows()) : Predef$.MODULE$.Long2long(((SubStatementData)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(describeResults.getSubStatements()).asScala()).last()).getResultRows());
    }

    private boolean cancelRequest() {
        CancelStatementRequest cancelRequest = new CancelStatementRequest();
        cancelRequest.setId(this.requestId());
        CancelStatementResult cancelResult = this.client().cancelStatement(cancelRequest);
        return Predef$.MODULE$.Boolean2boolean(cancelResult.getStatus());
    }

    public static final /* synthetic */ void $anonfun$singleExecuteAndWait$2(ArrayBuffer sqlParams$1, QueryParameter qp) {
        SqlParameter sqlParam = new SqlParameter().withName(qp.name());
        if (!qp.value().isDefined() || qp.value().get().toString().isEmpty()) {
            throw new IllegalArgumentException("Query parameters must not be null or non-empty!");
        }
        sqlParam.setValue(qp.value().get().toString());
        sqlParams$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SqlParameter[]{sqlParam}));
    }

    public DataApiCommand(DataAPIConnection connection, Option<Seq<QueryParameter<?>>> params) {
        this.connection = connection;
        this.params = params;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.client = null;
        this.requestId = "";
        this.STATUS_FINISHED = "FINISHED";
        this.STATUS_ABORTED = "ABORTED";
        this.STATUS_FAILED = "FAILED";
        this.DATA_API_RETRY_DELAY_MIN_KEY = "spark.datasource.redshift.community.data_api_retry_delay_min";
        this.DATA_API_RETRY_DELAY_MAX_KEY = "spark.datasource.redshift.community.data_api_retry_delay_max";
        this.DATA_API_RETRY_DELAY_MULT_KEY = "spark.datasource.redshift.community.data_api_retry_delay_mult";
        this.DATA_API_RETRY_DELAY_MIN_DEFAULT = "100.0";
        this.DATA_API_RETRY_DELAY_MAX_DEFAULT = "250.0";
        this.DATA_API_RETRY_DELAY_MULT_DEFAULT = "1.25";
    }
}

