/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.client.builder.AwsSyncClientBuilder;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.redshiftdataapi.AWSRedshiftDataAPI;
import com.amazonaws.services.redshiftdataapi.AWSRedshiftDataAPIClient;
import com.amazonaws.services.redshiftdataapi.AWSRedshiftDataAPIClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Builder;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3URI;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.HeadBucketRequest;
import io.github.spark_redshift_community.spark.redshift.BuildInfo$;
import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.Parameters$;
import io.github.spark_redshift_community.spark.redshift.RedshiftConstraintViolationException;
import io.github.spark_redshift_community.spark.redshift.Utils;
import io.github.spark_redshift_community.spark.redshift.data.JDBCWrapper$;
import java.io.Serializable;
import java.net.URI;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class Utils$ {
    public static Utils$ MODULE$;
    private final Logger log;
    private final Map<String, String> lastBuildStmt;
    private String lastTempPathGenerated;
    private final String CONNECTOR_REJECT_UNSECURE_JDBC_CONNECTION;
    private final String CONNECTOR_REDSHIFT_S3_CONNECTION_IAM_ROLE_ONLY;
    private final String CONNECTOR_DATA_API_ENDPOINT;
    private final String CONNECTOR_SERVICE_NAME_ENV_VAR;
    private final String DEFAULT_APP_NAME;
    private final String CONNECTOR_TRACE_ID_ENV_VAR;
    private final String CONNECTOR_TRACE_ID_SPARK_CONF;
    private final String CONNECTOR_LABEL_SPARK_CONF;

    static {
        new Utils$();
    }

    private Logger log() {
        return this.log;
    }

    public Map<String, String> lastBuildStmt() {
        return this.lastBuildStmt;
    }

    public Class<?> classForName(String className) {
        ClassLoader classLoader = (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getClass().getClassLoader());
        return Class.forName(className, true, classLoader);
    }

    public String joinUrls(String a, String b) {
        return new StringBuilder(2).append(new StringOps(Predef$.MODULE$.augmentString(a)).stripSuffix("/")).append("/").append(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(b)).stripPrefix("/"))).stripSuffix("/")).append("/").toString();
    }

    public String fixS3Url(String url) {
        return url.replaceAll("s3[an]://", "s3://");
    }

    public AmazonS3URI createS3URI(String url) {
        AmazonS3URI amazonS3URI;
        try {
            amazonS3URI = new AmazonS3URI(url);
        }
        catch (Throwable throwable) {
            IllegalArgumentException illegalArgumentException;
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof IllegalArgumentException) || !(illegalArgumentException = (IllegalArgumentException)throwable2).getMessage().startsWith("Invalid S3 URI: hostname does not appear to be a valid S3 endpoint")) {
                throw throwable;
            }
            AmazonS3URI amazonS3URI2 = new AmazonS3URI(this.addEndpointToUrl(url, this.addEndpointToUrl$default$2()));
            amazonS3URI = amazonS3URI2;
        }
        return amazonS3URI;
    }

    public String addEndpointToUrl(String url, String domain) {
        URI uri = new URI(url);
        String hostWithEndpoint = new StringBuilder(1).append(uri.getHost()).append(".").append(domain).toString();
        return new URI(uri.getScheme(), uri.getUserInfo(), hostWithEndpoint, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
    }

    public String addEndpointToUrl$default$2() {
        return "s3.amazonaws.com";
    }

    public URI removeCredentialsFromURI(URI uri) {
        return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    public String lastTempPathGenerated() {
        return this.lastTempPathGenerated;
    }

    public void lastTempPathGenerated_$eq(String x$1) {
        this.lastTempPathGenerated = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public String makeTempPath(String tempRoot) {
        void var2_2;
        String _lastTempPathGenerated = this.joinUrls(tempRoot, UUID.randomUUID().toString());
        this.lastTempPathGenerated_$eq(_lastTempPathGenerated);
        return var2_2;
    }

    public boolean checkThatBucketHasObjectLifecycleConfiguration(Parameters.MergedParameters params, AmazonS3 s3Client) {
        boolean bl;
        try {
            AmazonS3URI s3URI = this.createS3URI(this.fixS3Url(params.rootTempDir()));
            String bucket = s3URI.getBucket();
            Predef$.MODULE$.assert(bucket != null, (Function0 & Serializable & scala.Serializable)() -> "Could not get bucket from S3 URI");
            String key = (String)Option$.MODULE$.apply((Object)s3URI.getKey()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            Seq rules = (Seq)Option$.MODULE$.apply((Object)s3Client.getBucketLifecycleConfiguration(bucket)).map((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$1.getRules()).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
            boolean hasMatchingBucketLifecycleRule = rules.exists((Function1 & Serializable & scala.Serializable)rule -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$checkThatBucketHasObjectLifecycleConfiguration$5(key, rule)));
            if (!hasMatchingBucketLifecycleRule) {
                this.log().warn(new StringBuilder(346).append("The S3 bucket ").append(bucket).append(" does not have an object lifecycle configuration to ").append("ensure cleanup of temporary files. Consider configuring `tempdir` to point to a ").append("bucket with an object lifecycle policy that automatically deletes files after an ").append("expiration period. For more information, see ").append("https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html").toString());
            }
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.log().warn("An error occurred while trying to read the S3 bucket lifecycle configuration: {}", new Object[]{e.getMessage()});
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    public void assertThatFileSystemIsNotS3BlockFileSystem(URI uri, Configuration hadoopConfig) {
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)hadoopConfig);
        String string = fs.getClass().getCanonicalName();
        String string2 = "org.apache.hadoop.fs.s3.S3FileSystem";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new IllegalArgumentException("spark-redshift does not support the S3 Block FileSystem. Please reconfigure `tempdir` touse a s3n:// or s3a:// scheme.");
        }
    }

    public void checkJDBCSecurity(String driverClass, String updatedURL, Properties driverProperties) {
        if (!this.isUnsecureJDBCConnectionRejected()) {
            return;
        }
        if (!JDBCWrapper$.MODULE$.REDSHIFT_FIRST_PARTY_DRIVERS().contains((Object)driverClass)) {
            throw new RedshiftConstraintViolationException(new StringBuilder(95).append("Arbitrary driver class is not supported when using spark-redshift connector with ").append(this.CONNECTOR_REJECT_UNSECURE_JDBC_CONNECTION()).append(" set to true: ").append(driverClass).toString());
        }
        if (Utils$.urlContainsSSLDisable$1(updatedURL) || driverProperties.containsKey("ssl") && driverProperties.getProperty("ssl").equalsIgnoreCase("false")) {
            throw new RedshiftConstraintViolationException(new StringBuilder(94).append("To use spark-redshift connector ").append("with ").append(this.CONNECTOR_REJECT_UNSECURE_JDBC_CONNECTION()).append(" turned on, ").append("SSL must be enabled for the JDBC connection. ").toString());
        }
    }

    public String getResourceIdForARN(String arn) {
        return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(arn)).split(new char[]{'/', ':'}))).last();
    }

    public Option<String> getRegionForS3Bucket(Parameters.MergedParameters params, AmazonS3 s3Client) {
        None$ none$;
        try {
            AmazonS3URI s3URI = this.createS3URI(this.fixS3Url(params.rootTempDir()));
            String bucket = s3URI.getBucket();
            Predef$.MODULE$.assert(bucket != null, (Function0 & Serializable & scala.Serializable)() -> "Could not get bucket from S3 URI");
            String string = s3Client.headBucket(new HeadBucketRequest(bucket)).getBucketRegion();
            boolean bl = string == null ? true : "US".equals(string);
            String string2 = bl ? "us-east-1" : string;
            String region = string2;
            none$ = new Some((Object)region);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.log().warn("An error occurred while trying to determine the S3 bucket's region: {}", new Object[]{e.getMessage()});
            None$ none$2 = None$.MODULE$;
            none$ = none$2;
        }
        return none$;
    }

    public Option<String> getRegionForRedshiftCluster(String url) {
        None$ none$;
        String string;
        Regex regionRegex = new StringOps(Predef$.MODULE$.augmentString(".*\\.([^.]+)\\.redshift\\.amazonaws\\.com.*")).r();
        Option option = regionRegex.unapplySeq((CharSequence)(string = url));
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String region = (String)((LinearSeqOptimized)option.get()).apply(0);
            none$ = new Some((Object)region);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<String> getRegionForRedshiftCluster(Parameters.MergedParameters params) {
        return params.jdbcUrl().isDefined() ? this.getRegionForRedshiftCluster((String)params.jdbcUrl().get()) : params.dataApiRegion();
    }

    public void checkRedshiftAndS3OnSameRegion(Parameters.MergedParameters params, AmazonS3 s3Client) {
        this.getRegionForRedshiftCluster(params).foreach((Function1 & Serializable & scala.Serializable)redshiftRegion -> {
            Utils$.$anonfun$checkRedshiftAndS3OnSameRegion$1(params, s3Client, redshiftRegion);
            return BoxedUnit.UNIT;
        });
    }

    public void checkRedshiftAndS3OnSameRegionParquetWrite(Parameters.MergedParameters params, AmazonS3 s3Client) {
        Option<String> redshiftRegion = this.getRegionForRedshiftCluster(params);
        if (redshiftRegion.isEmpty()) {
            this.log().warn("Unable to determine region for redshift cluster, copy may fail if S3 bucket region does not match redshift cluster region.");
            return;
        }
        Option<String> s3Region = this.getRegionForS3Bucket(params, s3Client);
        if (s3Region.isEmpty()) {
            this.log().warn("Unable to determine region for S3 bucket, copy may fail if redshift cluster region does not match S3 bucket region.");
            return;
        }
        if (!BoxesRunTime.equals((Object)redshiftRegion.get(), (Object)s3Region.get())) {
            this.log().error(new StringBuilder(161).append("The Redshift cluster and S3 bucket are in different regions ").append("(").append(redshiftRegion).append(" and ").append(s3Region).append(", respectively). Cross-region copy operation is not ").append("available when tempformat is set to parquet").toString());
            throw new IllegalArgumentException("Redshift cluster and S3 bucket are in different regions when tempformat is set to parquet");
        }
    }

    public String getDefaultRegion() {
        String currRegion;
        String string;
        try {
            string = new DefaultAwsRegionProviderChain().getRegion();
        }
        catch (Throwable throwable) {
            string = currRegion = null;
        }
        if (currRegion == null || currRegion.isEmpty()) {
            this.log().warn(new StringBuilder(259).append("The connector cannot automatically determine a region for 'tempdir'. It ").append("is highly recommended that the 'tempdir_region' parameter is set to ").append("avoid a performance penalty while trying to automatically determine ").append("a region, especially when operating outside of AWS.").toString());
        }
        return currRegion != null && new StringOps(Predef$.MODULE$.augmentString(currRegion)).nonEmpty() ? currRegion : Regions.US_EAST_1.getName();
    }

    public String getDefaultTempDirRegion(Option<String> tempDirRegion) {
        return tempDirRegion.isDefined() ? (String)tempDirRegion.get() : this.getDefaultRegion();
    }

    public Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> s3ClientBuilder() {
        return (Function2 & Serializable & scala.Serializable)(awsCredentials, mergedParameters) -> (AmazonS3)((AwsSyncClientBuilder)((AmazonS3Builder)AmazonS3Client.builder().withRegion(MODULE$.getDefaultTempDirRegion(mergedParameters.tempDirRegion()))).withForceGlobalBucketAccessEnabled(Predef$.MODULE$.boolean2Boolean(true)).withCredentials(awsCredentials)).build();
    }

    public String getSparkConfigValue(String key, String string) {
        SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> (SparkSession)SparkSession$.MODULE$.getDefaultSession().orNull(Predef$.MODULE$.$conforms()));
        return sparkSession == null ? string : sparkSession.conf().get(key, string);
    }

    public String getSparkStaticConfigValue(String key, String string) {
        SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> (SparkSession)SparkSession$.MODULE$.getDefaultSession().orNull(Predef$.MODULE$.$conforms()));
        return sparkSession == null ? string : sparkSession.sparkContext().getConf().get(key, string);
    }

    public String CONNECTOR_REJECT_UNSECURE_JDBC_CONNECTION() {
        return this.CONNECTOR_REJECT_UNSECURE_JDBC_CONNECTION;
    }

    public boolean isUnsecureJDBCConnectionRejected() {
        return new StringOps(Predef$.MODULE$.augmentString(this.getSparkStaticConfigValue(this.CONNECTOR_REJECT_UNSECURE_JDBC_CONNECTION(), "false"))).toBoolean();
    }

    public String CONNECTOR_REDSHIFT_S3_CONNECTION_IAM_ROLE_ONLY() {
        return this.CONNECTOR_REDSHIFT_S3_CONNECTION_IAM_ROLE_ONLY;
    }

    public boolean isRedshiftS3ConnectionViaIAMRoleOnly() {
        return new StringOps(Predef$.MODULE$.augmentString(this.getSparkStaticConfigValue(this.CONNECTOR_REDSHIFT_S3_CONNECTION_IAM_ROLE_ONLY(), "false"))).toBoolean();
    }

    public String CONNECTOR_DATA_API_ENDPOINT() {
        return this.CONNECTOR_DATA_API_ENDPOINT;
    }

    public AWSRedshiftDataAPI createDataApiClient(Option<String> region, Option<AWSCredentialsProvider> creds) {
        String endpoint;
        String tempRegion = (String)region.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getDefaultRegion());
        AWSRedshiftDataAPIClientBuilder client = AWSRedshiftDataAPIClient.builder();
        if (creds.isDefined()) {
            client = (AWSRedshiftDataAPIClientBuilder)client.withCredentials((AWSCredentialsProvider)creds.get());
        }
        client = new StringOps(Predef$.MODULE$.augmentString(endpoint = this.getSparkConfigValue(this.CONNECTOR_DATA_API_ENDPOINT(), ""))).nonEmpty() ? (AWSRedshiftDataAPIClientBuilder)client.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, tempRegion)) : (AWSRedshiftDataAPIClientBuilder)client.withRegion(tempRegion);
        return (AWSRedshiftDataAPI)client.build();
    }

    public Option<String> createDataApiClient$default$1() {
        return None$.MODULE$;
    }

    public Option<AWSCredentialsProvider> createDataApiClient$default$2() {
        return None$.MODULE$;
    }

    public void collectMetrics(Parameters.MergedParameters params, Option<Logger> logger) {
        block3: {
            Logger metricLogger = (Logger)logger.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.log());
            metricLogger.info(BuildInfo$.MODULE$.toString());
            if (params.legacyJdbcRealTypeMapping()) {
                metricLogger.info(new StringBuilder(11).append(Parameters$.MODULE$.PARAM_LEGACY_JDBC_REAL_TYPE_MAPPING()).append(" is enabled").toString());
            }
            if (params.legacyTrimCSVWrites()) {
                metricLogger.info(new StringBuilder(11).append(Parameters$.MODULE$.PARAM_LEGACY_TRIM_CSV_WRITES()).append(" is enabled").toString());
            }
            if (params.overrideNullable()) {
                metricLogger.info(new StringBuilder(11).append(Parameters$.MODULE$.PARAM_OVERRIDE_NULLABLE()).append(" is enabled").toString());
            }
            if (!params.legacyMappingShortToInt()) break block3;
            metricLogger.info(new StringBuilder(11).append(Parameters$.MODULE$.PARAM_LEGACY_MAPPING_SHORT_TO_INT()).append(" is enabled").toString());
        }
    }

    public Option<Logger> collectMetrics$default$2() {
        return None$.MODULE$;
    }

    public String CONNECTOR_SERVICE_NAME_ENV_VAR() {
        return this.CONNECTOR_SERVICE_NAME_ENV_VAR;
    }

    private Option<String> connectorServiceName() {
        String configuredValue = ((String)scala.sys.package$.MODULE$.env().getOrElse((Object)this.CONNECTOR_SERVICE_NAME_ENV_VAR(), (Function0 & Serializable & scala.Serializable)() -> "")).trim();
        return configuredValue.matches("^[a-zA-Z]+$") ? Option$.MODULE$.apply((Object)configuredValue) : None$.MODULE$;
    }

    private Option<String> connectorHostName(Parameters.MergedParameters params) {
        String configuredValue = ((String)params.hostConnector().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).trim();
        return configuredValue.matches("^[a-zA-Z]+$") ? Option$.MODULE$.apply((Object)configuredValue) : None$.MODULE$;
    }

    public String DEFAULT_APP_NAME() {
        return this.DEFAULT_APP_NAME;
    }

    public String getApplicationName(Parameters.MergedParameters params) {
        String app = this.DEFAULT_APP_NAME();
        String svc = (String)this.connectorServiceName().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String hst = (String)this.connectorHostName(params).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new StringBuilder(0).append(app).append(svc).append(hst).toString();
    }

    public String CONNECTOR_TRACE_ID_ENV_VAR() {
        return this.CONNECTOR_TRACE_ID_ENV_VAR;
    }

    public String CONNECTOR_TRACE_ID_SPARK_CONF() {
        return this.CONNECTOR_TRACE_ID_SPARK_CONF;
    }

    private String connectorTraceId(SQLContext sqlContext) {
        String configuredValue = this.getSparkConfigValue(this.CONNECTOR_TRACE_ID_SPARK_CONF(), (String)scala.sys.package$.MODULE$.env().getOrElse((Object)this.CONNECTOR_TRACE_ID_ENV_VAR(), (Function0 & Serializable & scala.Serializable)() -> "")).trim();
        boolean validValue = new StringOps(Predef$.MODULE$.augmentString(configuredValue)).forall((Function1 & Serializable & scala.Serializable)object -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$connectorTraceId$2(BoxesRunTime.unboxToChar((Object)object))));
        if (!validValue) {
            this.log().warn("Configured trace id is not valid. It must only contain characters that are valid unicode identifier parts or '-'.");
        }
        return new StringOps(Predef$.MODULE$.augmentString(configuredValue)).nonEmpty() && validValue ? configuredValue : sqlContext.sparkContext().applicationId();
    }

    public String CONNECTOR_LABEL_SPARK_CONF() {
        return this.CONNECTOR_LABEL_SPARK_CONF;
    }

    private Option<String> connectorLabel(Parameters.MergedParameters params) {
        String configuredValue = (String)params.user_query_group_label().getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getSparkConfigValue(MODULE$.CONNECTOR_LABEL_SPARK_CONF(), ""));
        boolean validValue = new StringOps(Predef$.MODULE$.augmentString(configuredValue)).forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isUnicodeIdentifierPart$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$2)))));
        if (!validValue) {
            this.log().warn("Configured query group label is not valid. It must only contain characters that are valid unicode identifier parts.");
        }
        return new StringOps(Predef$.MODULE$.augmentString(configuredValue)).nonEmpty() && validValue ? Option$.MODULE$.apply((Object)configuredValue) : None$.MODULE$;
    }

    public String queryGroupInfo(Utils.MetricOperation operation, Parameters.MergedParameters params, SQLContext sqlContext) {
        int MAX_SVC_LENGTH = 10;
        int MAX_HST_LENGTH = 10;
        int MAX_LBL_LENGTH = 100;
        int MAX_TID_LENGTH = 75;
        String svc = (String)this.connectorServiceName().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String hst = (String)this.connectorHostName(params).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String lbl = (String)this.connectorLabel(params).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String tid = this.connectorTraceId(sqlContext);
        String trimmedSvc = svc.substring(0, package$.MODULE$.min(svc.length(), MAX_SVC_LENGTH));
        String trimmedHst = hst.substring(0, package$.MODULE$.min(hst.length(), MAX_HST_LENGTH));
        String trimmedLbl = lbl.substring(0, package$.MODULE$.min(lbl.length(), MAX_LBL_LENGTH));
        String trimmedTid = tid.substring(0, package$.MODULE$.min(tid.length(), MAX_TID_LENGTH));
        return new StringBuilder(73).append("{\"spark-redshift-connector\":{").append("\"svc\":\"").append(trimmedSvc).append("\",").append("\"hst\":\"").append(trimmedHst).append("\",").append("\"ver\":\"").append(BuildInfo$.MODULE$.version()).append("\",").append("\"op\":\"").append(operation).append("\",").append("\"lbl\":\"").append(trimmedLbl).append("\",").append(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(10).append("\"tid\":\"").append(trimmedTid).append("\"}}").toString())).stripMargin()).toString();
    }

    public <T> T retry(int count, long delay, Function0<T> retryBlock) {
        Object object;
        while (true) {
            try {
                object = retryBlock.apply();
            }
            catch (Throwable e) {
                if (count <= 0) {
                    throw e;
                }
                this.log().warn(new StringBuilder(85).append("Sleeping ").append(delay).append(" milliseconds before proceeding to retry redshift operation;").append(" ").append(count).append(" retries remain").toString());
                Thread.sleep(delay);
                --count;
                continue;
            }
            break;
        }
        return (T)object;
    }

    public void copyProperty(String name, scala.collection.immutable.Map<String, String> sourceProps, Properties destProps) {
        this.copyProperty(name, name, sourceProps, destProps);
    }

    public void copyProperty(String searchName, String replaceName, scala.collection.immutable.Map<String, String> sourceProps, Properties destProps) {
        sourceProps.get((Object)searchName).foreach((Function1 & Serializable & scala.Serializable)x$3 -> destProps.setProperty(replaceName, (String)x$3));
    }

    public void copyProperties(String matchRegex, String searchRegex, String replaceName, scala.collection.immutable.Map<String, String> sourceProps, Properties destProps) {
        sourceProps.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            BoxedUnit boxedUnit = key.matches(matchRegex) ? destProps.setProperty(key.replaceFirst(searchRegex, replaceName), value) : BoxedUnit.UNIT;
            return boxedUnit;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$checkThatBucketHasObjectLifecycleConfiguration$5(String key$1, BucketLifecycleConfiguration.Rule rule) {
        String string = rule.getStatus();
        String string2 = "Enabled";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (rule.getPrefix() == null) return true;
        if (!key$1.startsWith(rule.getPrefix())) return false;
        return true;
    }

    private static final boolean urlContainsSSLDisable$1(String updatedURL$1) {
        return updatedURL$1.toLowerCase().contains(";ssl=false") || updatedURL$1.toLowerCase().contains("&ssl=false") || updatedURL$1.toLowerCase().contains("?ssl=false");
    }

    public static final /* synthetic */ void $anonfun$checkRedshiftAndS3OnSameRegion$2(String redshiftRegion$1, Parameters.MergedParameters params$1, String s3Region) {
        block0: {
            String string = redshiftRegion$1;
            String string2 = s3Region;
            if (!(string == null ? string2 != null : !string.equals(string2)) || !params$1.tempDirRegion().isEmpty()) break block0;
            MODULE$.log().error(new StringBuilder(238).append("The Redshift cluster and S3 bucket are in different regions ").append("(").append(redshiftRegion$1).append(" and ").append(s3Region).append(", respectively). In order to perform this cross-region ").append("operation, you should set the tempdir_region parameter to '").append(s3Region).append("'. ").append("For more details on cross-region usage, see the README.").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$checkRedshiftAndS3OnSameRegion$1(Parameters.MergedParameters params$1, AmazonS3 s3Client$1, String redshiftRegion) {
        MODULE$.getRegionForS3Bucket(params$1, s3Client$1).foreach((Function1 & Serializable & scala.Serializable)s3Region -> {
            Utils$.$anonfun$checkRedshiftAndS3OnSameRegion$2(redshiftRegion, params$1, s3Region);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$connectorTraceId$2(char c) {
        return RichChar$.MODULE$.isUnicodeIdentifierPart$extension(Predef$.MODULE$.charWrapper(c)) || c == '-';
    }

    private Utils$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.lastBuildStmt = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lastTempPathGenerated = null;
        this.CONNECTOR_REJECT_UNSECURE_JDBC_CONNECTION = "spark.datasource.redshift.community.reject_unsecure_jdbc_connection";
        this.CONNECTOR_REDSHIFT_S3_CONNECTION_IAM_ROLE_ONLY = "spark.datasource.redshift.community.redshift_s3_connection_iam_role_only";
        this.CONNECTOR_DATA_API_ENDPOINT = "spark.datasource.redshift.community.data_api_endpoint";
        this.CONNECTOR_SERVICE_NAME_ENV_VAR = "AWS_SPARK_REDSHIFT_CONNECTOR_SERVICE_NAME";
        this.DEFAULT_APP_NAME = "SparkRedshiftConnector";
        this.CONNECTOR_TRACE_ID_ENV_VAR = "AWS_SPARK_REDSHIFT_CONNECTOR_TRACE_ID";
        this.CONNECTOR_TRACE_ID_SPARK_CONF = "spark.datasource.redshift.community.trace_id";
        this.CONNECTOR_LABEL_SPARK_CONF = "spark.datasource.redshift.community.label";
    }
}

