/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import io.github.spark_redshift_community.spark.redshift.AWSCredentialsUtils$;
import io.github.spark_redshift_community.spark.redshift.Conversions$;
import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.Parameters$;
import io.github.spark_redshift_community.spark.redshift.SetAccumulator;
import io.github.spark_redshift_community.spark.redshift.TableName;
import io.github.spark_redshift_community.spark.redshift.Utils$;
import io.github.spark_redshift_community.spark.redshift.Utils$Write$;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftConnection;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftResults;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftWrapper;
import java.io.Serializable;
import java.net.URI;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005mf!\u0002\b\u0010\u0001=I\u0002\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\t\u0011!\u0002!\u0011!Q\u0001\n%BQA\u0015\u0001\u0005\u0002MCq\u0001\u0017\u0001C\u0002\u0013%\u0011\f\u0003\u0004c\u0001\u0001\u0006IA\u0017\u0005\u0007G\u0002!\ta\u00043\t\u000f\u0005%\u0001\u0001\"\u0003\u0002\f!A\u00111\u0007\u0001\u0005\u0002=\t)\u0004C\u0004\u0002T\u0001!I!!\u0016\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!9\u0011q\u0010\u0001\u0005\n\u0005\u0005\u0005bBAO\u0001\u0011\u0005\u0011q\u0014\u0005\b\u0003c\u0003A\u0011BAZ\u00059\u0011V\rZ:iS\u001a$xK]5uKJT!\u0001E\t\u0002\u0011I,Gm\u001d5jMRT!AE\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q)\u0012\u0001G:qCJ\\wL]3eg\"Lg\r^0d_6lWO\\5us*\u0011acF\u0001\u0007O&$\b.\u001e2\u000b\u0003a\t!![8\u0014\u0005\u0001Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g-A\bsK\u0012\u001c\b.\u001b4u/J\f\u0007\u000f]3s\u0007\u0001\u0001\"a\t\u0014\u000e\u0003\u0011R!!J\b\u0002\t\u0011\fG/Y\u0005\u0003O\u0011\u0012qBU3eg\"Lg\r^,sCB\u0004XM]\u0001\u0010gN\u001aE.[3oi\u001a\u000b7\r^8ssB)1D\u000b\u00177\u0015&\u00111\u0006\b\u0002\n\rVt7\r^5p]J\u0002\"!\f\u001b\u000e\u00039R!a\f\u0019\u0002\t\u0005,H\u000f\u001b\u0006\u0003cI\n\u0011\"Y7bu>t\u0017m^:\u000b\u0003M\n1aY8n\u0013\t)dF\u0001\fB/N\u001b%/\u001a3f]RL\u0017\r\\:Qe>4\u0018\u000eZ3s!\t9tI\u0004\u00029\u000b:\u0011\u0011\b\u0012\b\u0003u\rs!a\u000f\"\u000f\u0005q\neBA\u001fA\u001b\u0005q$BA \"\u0003\u0019a$o\\8u}%\t\u0001$\u0003\u0002\u0017/%\u0011A#F\u0005\u0003%MI!\u0001E\t\n\u0005\u0019{\u0011A\u0003)be\u0006lW\r^3sg&\u0011\u0001*\u0013\u0002\u0011\u001b\u0016\u0014x-\u001a3QCJ\fW.\u001a;feNT!AR\b\u0011\u0005-\u0003V\"\u0001'\u000b\u00055s\u0015AA:4\u0015\ty\u0005'\u0001\u0005tKJ4\u0018nY3t\u0013\t\tFJ\u0001\u0005B[\u0006TxN\\*4\u0003\u0019a\u0014N\\5u}Q\u0019AKV,\u0011\u0005U\u0003Q\"A\b\t\u000b\u0001\u001a\u0001\u0019\u0001\u0012\t\u000b!\u001a\u0001\u0019A\u0015\u0002\u00071|w-F\u0001[!\tY\u0006-D\u0001]\u0015\tif,A\u0003tY\u001a$$NC\u0001`\u0003\ry'oZ\u0005\u0003Cr\u0013a\u0001T8hO\u0016\u0014\u0018\u0001\u00027pO\u0002\nab\u0019:fCR,G+\u00192mKN\u000bH\u000e\u0006\u0003f[\u0006\u0015\u0001C\u00014k\u001d\t9\u0007\u000e\u0005\u0002>9%\u0011\u0011\u000eH\u0001\u0007!J,G-\u001a4\n\u0005-d'AB*ue&twM\u0003\u0002j9!)QE\u0002a\u0001]B\u0011qn \b\u0003art!!]=\u000f\u0005I<hBA:v\u001d\tiD/C\u0001`\u0013\t1h,\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003%aT!A\u001e0\n\u0005i\\\u0018aA:rY*\u0011!\u0003_\u0005\u0003{z\fq\u0001]1dW\u0006<WM\u0003\u0002{w&!\u0011\u0011AA\u0002\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002~}\"1\u0011q\u0001\u0004A\u0002Y\na\u0001]1sC6\u001c\u0018aB2paf\u001c\u0016\u000f\u001c\u000b\fK\u00065\u0011\u0011DA\u0015\u0003W\ty\u0003C\u0004\u0002\u0010\u001d\u0001\r!!\u0005\u0002\u0015M\fHnQ8oi\u0016DH\u000f\u0005\u0003\u0002\u0014\u0005UQ\"\u0001@\n\u0007\u0005]aP\u0001\u0006T#2\u001buN\u001c;fqRDq!a\u0007\b\u0001\u0004\ti\"\u0001\u0004tG\",W.\u0019\t\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0019\u00111\u0005@\u0002\u000bQL\b/Z:\n\t\u0005\u001d\u0012\u0011\u0005\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007BBA\u0004\u000f\u0001\u0007a\u0007\u0003\u0004\u0002.\u001d\u0001\r\u0001L\u0001\u0006GJ,Gm\u001d\u0005\u0007\u0003c9\u0001\u0019A3\u0002\u00175\fg.\u001b4fgR,&\u000f\\\u0001\u000fG>lW.\u001a8u\u0003\u000e$\u0018n\u001c8t)\u0019\t9$a\u0012\u0002RA)\u0011\u0011HA!K:!\u00111HA \u001d\ri\u0014QH\u0005\u0002;%\u0011Q\u0010H\u0005\u0005\u0003\u0007\n)E\u0001\u0003MSN$(BA?\u001d\u0011\u001d\tI\u0005\u0003a\u0001\u0003\u0017\nA\u0002^1cY\u0016\u001cu.\\7f]R\u0004BaGA'K&\u0019\u0011q\n\u000f\u0003\r=\u0003H/[8o\u0011\u001d\tY\u0002\u0003a\u0001\u0003;\ta\u0002Z8SK\u0012\u001c\b.\u001b4u\u0019>\fG\r\u0006\u0007\u0002X\u0005u\u0013qMA5\u0003W\ni\u0007E\u0002\u001c\u00033J1!a\u0017\u001d\u0005\u0011)f.\u001b;\t\u000f\u0005}\u0013\u00021\u0001\u0002b\u0005!1m\u001c8o!\r\u0019\u00131M\u0005\u0004\u0003K\"#A\u0005*fIND\u0017N\u001a;D_:tWm\u0019;j_:DQ!J\u0005A\u00029Da!a\u0002\n\u0001\u00041\u0004BBA\u0017\u0013\u0001\u0007A\u0006C\u0004\u00022%\u0001\r!a\u0013\u00023\u0019Lg\u000eZ+ogV\u0004\bo\u001c:uK\u0012l\u0015\r]&fsRK\b/\u001a\u000b\u0005\u0003g\nY\bE\u0003\u001c\u0003\u001b\n)\b\u0005\u0003\u0002 \u0005]\u0014\u0002BA=\u0003C\u0011\u0001\u0002R1uCRK\b/\u001a\u0005\b\u0003{R\u0001\u0019AA;\u0003!!\u0017\r^1UsB,\u0017AC;oY>\fG\rR1uCRq\u00111JAB\u0003\u000b\u000b9)a#\u0002\u0010\u0006M\u0005bBA\b\u0017\u0001\u0007\u0011\u0011\u0003\u0005\u0006K-\u0001\rA\u001c\u0005\u0007\u0003\u0013[\u0001\u0019A3\u0002\u000fQ,W\u000e\u001d#je\"1\u0011QR\u0006A\u0002\u0015\f!\u0002^3na\u001a{'/\\1u\u0011\u0019\t\tj\u0003a\u0001K\u0006Qa.\u001e7m'R\u0014\u0018N\\4\t\u000f\u0005U5\u00021\u0001\u0002\u0018\u00069AO]5n\u0007N3\u0006cA\u000e\u0002\u001a&\u0019\u00111\u0014\u000f\u0003\u000f\t{w\u000e\\3b]\u0006q1/\u0019<f)>\u0014V\rZ:iS\u001a$HCCA,\u0003C\u000b\u0019+!*\u00020\"9\u0011q\u0002\u0007A\u0002\u0005E\u0001\"B\u0013\r\u0001\u0004q\u0007bBAT\u0019\u0001\u0007\u0011\u0011V\u0001\tg\u00064X-T8eKB!\u00111CAV\u0013\r\tiK \u0002\t'\u00064X-T8eK\"1\u0011q\u0001\u0007A\u0002Y\n!c\u00195fG.\u001c6GQ;dW\u0016$Xk]1hKR1\u0011qKA[\u0003oCa!a\u0002\u000e\u0001\u00041\u0004BBA]\u001b\u0001\u0007A&A\u0007de\u0016$7\u000f\u0015:pm&$WM\u001d")
public class RedshiftWriter {
    private final RedshiftWrapper redshiftWrapper;
    private final Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> s3ClientFactory;
    private final Logger log;

    private Logger log() {
        return this.log;
    }

    public String createTableSql(Dataset<Row> data, Parameters.MergedParameters params) {
        String string;
        String string2;
        String schemaSql = this.redshiftWrapper.schemaString(data.schema(), (Option<Parameters.MergedParameters>)new Some((Object)params));
        Option<String> option = params.distStyle();
        if (option instanceof Some) {
            Some some = (Some)option;
            String style = (String)some.value();
            string2 = new StringBuilder(10).append("DISTSTYLE ").append(style).toString();
        } else if (None$.MODULE$.equals(option)) {
            string2 = "";
        } else {
            throw new MatchError(option);
        }
        String distStyleDef = string2;
        Option<String> option2 = params.distKey();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String key = (String)some.value();
            string = new StringBuilder(10).append("DISTKEY (").append(key).append(")").toString();
        } else if (None$.MODULE$.equals(option2)) {
            string = "";
        } else {
            throw new MatchError(option2);
        }
        String distKeyDef = string;
        String sortKeyDef = (String)params.sortKeySpec().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        TableName table = (TableName)params.table().get();
        return new StringBuilder(33).append("CREATE TABLE IF NOT EXISTS ").append(table).append(" (").append(schemaSql).append(") ").append(distStyleDef).append(" ").append(distKeyDef).append(" ").append(sortKeyDef).toString();
    }

    private String copySql(SQLContext sqlContext, StructType schema, Parameters.MergedParameters params, AWSCredentialsProvider creds, String manifestUrl) {
        String string;
        String credsString = AWSCredentialsUtils$.MODULE$.getRedshiftCredentialsString(params, creds.getCredentials());
        String fixedUrl = Utils$.MODULE$.fixS3Url(manifestUrl);
        String string2 = params.tempFormat();
        if ("AVRO".equals(string2)) {
            string = "AVRO 'auto'";
        } else if ("PARQUET".equals(string2)) {
            string = "PARQUET";
        } else {
            String string3 = string2;
            String string4 = "CSV";
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                String string5 = string2;
                String string6 = "CSV GZIP";
                if (string5 != null ? !string5.equals(string6) : string6 != null) {
                    throw new MatchError((Object)string2);
                }
            }
            string = new StringBuilder(11).append(string2).append(" NULL AS '").append(params.nullString()).append("'").toString();
        }
        String format = string;
        String columns = params.includeColumnList() ? new StringBuilder(3).append("(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).map((Function1 & Serializable & scala.Serializable)name -> new StringBuilder(2).append("\"").append((String)name).append("\"").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",")).append(") ").toString() : "";
        String string7 = format;
        String string8 = "PARQUET";
        String regionClause = !(string7 != null ? !string7.equals(string8) : string8 != null) ? "" : (String)params.tempDirRegion().map((Function1 & Serializable & scala.Serializable)region -> new StringBuilder(9).append("REGION '").append((String)region).append("'").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String string9 = format;
        String string10 = "PARQUET";
        String serializeToJSON = !(string9 != null ? !string9.equals(string10) : string10 != null) ? "SERIALIZETOJSON" : "";
        String copySqlStatement = new StringBuilder(36).append("COPY ").append(params.table().get()).append(" ").append(columns).append("FROM '").append(fixedUrl).append("'").append(" FORMAT AS ").append(format).append(" ").append(serializeToJSON).append(" manifest").append(" ").append(regionClause).append(" ").append(params.extraCopyOptions()).toString();
        return new StringBuilder(15).append(copySqlStatement).append(" CREDENTIALS '").append(credsString).append("'").toString();
    }

    public List<String> commentActions(Option<String> tableComment, StructType schema) {
        return (List)((List)tableComment.toList().map((Function1 & Serializable & scala.Serializable)desc -> new StringBuilder(25).append("COMMENT ON TABLE %s IS '").append(desc.replace("'", "''")).append("'").toString(), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).withFilter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)RedshiftWriter.$anonfun$commentActions$2(f))).map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(29).append("COMMENT ON COLUMN %s.\"").append(f.name().replace("\"", "\\\"")).append("\"").append(" IS '").append(f.metadata().getString("description").replace("'", "''")).append("'").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))), List$.MODULE$.canBuildFrom());
    }

    private void doRedshiftLoad(RedshiftConnection conn, Dataset<Row> data, Parameters.MergedParameters params, AWSCredentialsProvider creds, Option<String> manifestUrl2) {
        String createStatement = this.createTableSql(data, params);
        this.log().info("Creating table within Redshift: {}", new Object[]{params.table().get()});
        this.redshiftWrapper.executeInterruptibly(conn, createStatement);
        List preActions = (List)this.commentActions(params.description(), data.schema()).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])params.preActions())), List$.MODULE$.canBuildFrom());
        preActions.foreach((Function1 & Serializable & scala.Serializable)action -> BoxesRunTime.boxToBoolean((boolean)RedshiftWriter.$anonfun$doRedshiftLoad$1(this, params, conn, action)));
        manifestUrl2.foreach((Function1 & Serializable & scala.Serializable)manifestUrl -> BoxesRunTime.boxToBoolean((boolean)RedshiftWriter.$anonfun$doRedshiftLoad$2(this, data, params, creds, conn, manifestUrl)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])params.postActions())).foreach((Function1 & Serializable & scala.Serializable)action -> BoxesRunTime.boxToBoolean((boolean)RedshiftWriter.$anonfun$doRedshiftLoad$8(this, params, conn, action)));
    }

    private Option<DataType> findUnsupportedMapKeyType(DataType dataType) {
        None$ none$;
        block5: {
            MapType mapType;
            boolean bl;
            while (true) {
                bl = false;
                mapType = null;
                DataType dataType2 = dataType;
                if (dataType2 instanceof StructType) {
                    StructType structType = (StructType)dataType2;
                    none$ = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).map((Function1 & Serializable & scala.Serializable)field -> this.findUnsupportedMapKeyType(field.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Option.class))))).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.nonEmpty())).flatten(Predef$.MODULE$.$conforms());
                    break block5;
                }
                if (dataType2 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType2;
                    dataType = arrayType.elementType();
                    continue;
                }
                if (!(dataType2 instanceof MapType)) break;
                bl = true;
                mapType = (MapType)dataType2;
                DataType dataType3 = mapType.keyType();
                DataType other = mapType.valueType();
                if (!StringType$.MODULE$.equals(dataType3)) break;
                dataType = other;
            }
            if (bl) {
                DataType keyType = mapType.keyType();
                none$ = new Some((Object)keyType);
            } else {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    private Option<String> unloadData(SQLContext sqlContext, Dataset<Row> data, String tempDir, String tempFormat, String nullString, boolean trimCSV) {
        None$ none$;
        DataFrameWriter dataFrameWriter;
        Function1[] conversionFunctions = (Function1[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.schema().fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            boolean bl = false;
            DataType dataType = null;
            DataType dataType2 = field.dataType();
            if (dataType2 instanceof DecimalType) {
                String string = tempFormat;
                String string2 = "PARQUET";
                if (string == null ? string2 != null : !string.equals(string2)) {
                    return (Function1 & Serializable & scala.Serializable)v -> v == null ? null : v.toString();
                }
            }
            if (DateType$.MODULE$.equals(dataType2)) {
                String string = tempFormat;
                String string3 = "PARQUET";
                if (string == null ? string3 != null : !string.equals(string3)) {
                    SimpleDateFormat dateFormat = Conversions$.MODULE$.createRedshiftDateFormat();
                    return (Function1 & Serializable & scala.Serializable)v -> v == null ? null : dateFormat.format((Date)v);
                }
            }
            if (TimestampType$.MODULE$.equals(dataType2)) {
                bl = true;
                dataType = dataType2;
                String string = tempFormat;
                String string4 = "PARQUET";
                if (string == null ? string4 != null : !string.equals(string4)) {
                    return (Function1 & Serializable & scala.Serializable)v -> v == null ? null : Conversions$.MODULE$.createRedshiftTimestampFormat().format(((Timestamp)v).toLocalDateTime());
                }
            }
            if (!bl) return (Function1 & Serializable & scala.Serializable)v -> v;
            return (Function1 & Serializable & scala.Serializable)v -> v == null ? null : DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.fromUTCTime(DateTimeUtils$.MODULE$.fromJavaTimestamp((Timestamp)v), ZoneId.systemDefault().getId()));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
        SetAccumulator nonEmptyPartitions = new SetAccumulator();
        sqlContext.sparkContext().register(nonEmptyPartitions);
        StructField[] complexFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.schema().fields())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)RedshiftWriter.$anonfun$unloadData$7(x$4)));
        String string = tempFormat;
        String string2 = "AVRO";
        if (!(string != null ? !string.equals(string2) : string2 != null) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])complexFields)).nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(84).append("Cannot write complex type fields ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])complexFields)).mkString(", ")).append(" with tempformat AVRO; use CSV or CSV GZIP instead.").toString());
        }
        this.findUnsupportedMapKeyType((DataType)data.schema()).foreach((Function1 & Serializable & scala.Serializable)dt -> {
            throw new IllegalArgumentException(new StringBuilder(78).append("Cannot write map with key type ").append(dt).append("; Only maps with StringType keys are supported.").toString());
        });
        Map mapping = tempFormat.startsWith("CSV") ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])complexFields)).map((Function1 & Serializable & scala.Serializable)field -> new Tuple2((Object)field.name(), (Object)functions$.MODULE$.to_json(functions$.MODULE$.col(field.name()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms()) : (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        Dataset complexTypesReplaced = data.withColumns(mapping);
        RDD convertedRows = complexTypesReplaced.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            block0: {
                if (!iter.hasNext()) break block0;
                nonEmptyPartitions.add(BoxesRunTime.boxToInteger((int)TaskContext$.MODULE$.get().partitionId()));
            }
            return iter.map((Function1 & Serializable & scala.Serializable)row -> {
                Object[] convertedValues = new Object[conversionFunctions.length];
                for (int i = 0; i < conversionFunctions.length; ++i) {
                    convertedValues[i] = conversionFunctions[i].apply(row.apply(i));
                }
                return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)convertedValues));
            });
        }, complexTypesReplaced.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class));
        StructType schemaWithLowercaseColumnNames = StructType$.MODULE$.apply((Seq)complexTypesReplaced.schema().map((Function1 & Serializable & scala.Serializable)f -> f.copy(f.name().toLowerCase(), f.copy$default$2(), f.copy$default$3(), f.copy$default$4()), Seq$.MODULE$.canBuildFrom()));
        if (((TraversableOnce)schemaWithLowercaseColumnNames.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), Seq$.MODULE$.canBuildFrom())).toSet().size() != complexTypesReplaced.schema().size()) {
            throw new IllegalArgumentException(new StringBuilder(113).append("Cannot save table to Redshift because two or more column names would be identical after conversion to lowercase: ").append(((TraversableOnce)complexTypesReplaced.schema().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        }
        StructType convertedSchema = StructType$.MODULE$.apply((Seq)schemaWithLowercaseColumnNames.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StructField structField = x0$1;
            String string = tempFormat;
            String string2 = "PARQUET";
            if (string == null) {
                if (string2 == null) return structField;
            } else if (string.equals(string2)) {
                return structField;
            }
            if (structField != null) {
                String name = structField.name();
                boolean nullable = structField.nullable();
                Metadata meta = structField.metadata();
                if (structField.dataType() instanceof DecimalType) {
                    return new StructField(name, (DataType)StringType$.MODULE$, nullable, meta);
                }
            }
            if (structField != null) {
                String name = structField.name();
                DataType dataType = structField.dataType();
                boolean nullable = structField.nullable();
                Metadata meta = structField.metadata();
                if (DateType$.MODULE$.equals(dataType)) {
                    return new StructField(name, (DataType)StringType$.MODULE$, nullable, meta);
                }
            }
            if (structField == null) return structField;
            String name = structField.name();
            DataType dataType = structField.dataType();
            boolean nullable = structField.nullable();
            Metadata meta = structField.metadata();
            if (!TimestampType$.MODULE$.equals(dataType)) return structField;
            return new StructField(name, (DataType)StringType$.MODULE$, nullable, meta);
        }, Seq$.MODULE$.canBuildFrom()));
        this.log().info("Unloading data to S3");
        DataFrameWriter writer = sqlContext.createDataFrame(convertedRows, convertedSchema).write();
        String string3 = tempFormat;
        if ("AVRO".equals(string3)) {
            dataFrameWriter = writer.format("avro");
        } else if ("CSV".equals(string3)) {
            dataFrameWriter = writer.format("csv").option("escape", "\"").option("nullValue", nullString).option("ignoreLeadingWhiteSpace", trimCSV).option("ignoreTrailingWhiteSpace", trimCSV);
        } else if ("CSV GZIP".equals(string3)) {
            dataFrameWriter = writer.format("csv").option("escape", "\"").option("nullValue", nullString).option("ignoreLeadingWhiteSpace", trimCSV).option("ignoreTrailingWhiteSpace", trimCSV).option("compression", "gzip");
        } else if ("PARQUET".equals(string3)) {
            dataFrameWriter = writer.format("parquet");
        } else {
            throw new MatchError((Object)string3);
        }
        dataFrameWriter.save(tempDir);
        if (nonEmptyPartitions.value().isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            FileSystem fs = FileSystem.get((URI)URI.create(tempDir), (Configuration)sqlContext.sparkContext().hadoopConfiguration());
            Regex partitionIdRegex = new StringOps(Predef$.MODULE$.augmentString("^part-(?:r-)?(\\d+)[^\\d+].*$")).r();
            Set nonEmptyPartitionIds = nonEmptyPartitions.value().toSet();
            Seq filesToLoad = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(tempDir)))).map((Function1 & Serializable & scala.Serializable)status -> new Tuple2((Object)status.getPath().getName(), (Object)BoxesRunTime.boxToLong((long)status.getLen())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).collect((PartialFunction)new scala.Serializable(null, partitionIdRegex, nonEmptyPartitionIds){
                public static final long serialVersionUID = 0L;
                private final Regex partitionIdRegex$1;
                private final Set nonEmptyPartitionIds$1;

                public final <A1 extends Tuple2<String, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    String id;
                    String string;
                    Option option;
                    A1 A1 = x1;
                    Object object = A1 != null && !(option = this.partitionIdRegex$1.unapplySeq((CharSequence)(string = (String)A1._1()))).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 && this.nonEmptyPartitionIds$1.contains((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(id = (String)((LinearSeqOptimized)option.get()).apply(0))).toInt())) ? A1 : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, Object> x1) {
                    String id;
                    String string;
                    Option option;
                    Tuple2<String, Object> tuple2 = x1;
                    boolean bl = tuple2 != null && !(option = this.partitionIdRegex$1.unapplySeq((CharSequence)(string = (String)tuple2._1()))).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 && this.nonEmptyPartitionIds$1.contains((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(id = (String)((LinearSeqOptimized)option.get()).apply(0))).toInt()));
                    return bl;
                }
                {
                    this.partitionIdRegex$1 = partitionIdRegex$1;
                    this.nonEmptyPartitionIds$1 = nonEmptyPartitionIds$1;
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            String sameFileSystemDir = new StringOps(Predef$.MODULE$.augmentString(Utils$.MODULE$.removeCredentialsFromURI(URI.create(tempDir)).toString())).stripSuffix("/");
            String sanitizedTempDir = Utils$.MODULE$.fixS3Url(sameFileSystemDir);
            Seq manifestEntries = (Seq)filesToLoad.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String file = (String)tuple2._1();
                long length = tuple2._2$mcJ$sp();
                String string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(84).append("{\"url\":\"").append(sanitizedTempDir).append("/").append(file).append("\",\n           | \"mandatory\":true,\n           | \"meta\": {\"content_length\":").append(length).append("}}").toString())).stripMargin();
                return string;
            }, Seq$.MODULE$.canBuildFrom());
            String manifest = new StringBuilder(15).append("{\"entries\": [").append(manifestEntries.mkString(",\n")).append("]}").toString();
            String manifestPath = new StringBuilder(14).append(sameFileSystemDir).append("/manifest.json").toString();
            try (FSDataOutputStream fsDataOut = fs.create(new Path(manifestPath));){
                fsDataOut.write(manifest.getBytes("utf-8"));
            }
            none$ = new Some((Object)manifestPath);
        }
        return none$;
    }

    public void saveToRedshift(SQLContext sqlContext, Dataset<Row> data, SaveMode saveMode, Parameters.MergedParameters params) {
        if (params.table().isEmpty()) {
            throw new IllegalArgumentException("For save operations you must specify a Redshift table name with the 'dbtable' parameter");
        }
        if (!params.useStagingTable()) {
            this.log().warn("Setting useStagingTable=false is deprecated; instead, we recommend that you drop the target table yourself. For more details on this deprecation, seehttps://github.com/databricks/spark-redshift/pull/157");
        }
        AWSCredentialsProvider credsProvider = AWSCredentialsUtils$.MODULE$.load(params, sqlContext.sparkContext().hadoopConfiguration());
        this.checkS3BucketUsage(params, credsProvider);
        String string = params.tempFormat();
        String string2 = "AVRO";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.schema().fieldNames())).foreach((Function1 & Serializable & scala.Serializable)fieldName -> {
                RedshiftWriter.$anonfun$saveToRedshift$1(fieldName);
                return BoxedUnit.UNIT;
            });
        }
        if (params.checkS3BucketUsage()) {
            Utils$.MODULE$.assertThatFileSystemIsNotS3BlockFileSystem(new URI(params.rootTempDir()), sqlContext.sparkContext().hadoopConfiguration());
        }
        Utils$.MODULE$.collectMetrics(params, Utils$.MODULE$.collectMetrics$default$2());
        Option<String> manifestUrl = this.unloadData(sqlContext, data, params.createPerQueryTempDir(), params.tempFormat(), params.nullString(), params.legacyTrimCSVWrites());
        if (new StringOps(Predef$.MODULE$.augmentString((String)params.parameters().apply((Object)Parameters$.MODULE$.PARAM_COPY_DELAY()))).toLong() > 0L) {
            this.log().info("Sleeping {} milliseconds before proceeding to redshift copy", (Object)BoxesRunTime.boxToLong((long)params.copyDelay()));
            Thread.sleep(params.copyDelay());
        }
        String queryGroup = Utils$.MODULE$.queryGroupInfo(Utils$Write$.MODULE$, params, sqlContext);
        Utils$.MODULE$.retry(params.copyRetryCount(), params.copyDelay(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.redshiftWrapper.setAutoCommit(conn, false);
            try (RedshiftConnection conn = $this.redshiftWrapper.getConnectorWithQueryGroup(params, queryGroup);){
                try {
                    Object object;
                    Object object2;
                    TableName table = (TableName)params.table().get();
                    if (new StringOps(Predef$.MODULE$.augmentString(table.unescapedDatabaseName())).nonEmpty()) {
                        String useDbStr = new StringBuilder(4).append("use ").append(table.escapedDatabaseName()).toString();
                        object2 = BoxesRunTime.boxToBoolean((boolean)$this.redshiftWrapper.executeInterruptibly(conn, useDbStr));
                    } else {
                        object2 = BoxedUnit.UNIT;
                    }
                    SaveMode saveMode = saveMode;
                    SaveMode saveMode2 = SaveMode.Overwrite;
                    if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null)) {
                        this.log().info("Dropping table within Redshift: {}", new Object[]{table});
                        $this.redshiftWrapper.executeInterruptibly(conn, new StringBuilder(22).append("DROP TABLE IF EXISTS ").append(table).append(";").toString());
                        if (!params.useStagingTable()) {
                            $this.redshiftWrapper.commit(conn);
                            if (new StringOps(Predef$.MODULE$.augmentString(table.unescapedDatabaseName())).nonEmpty()) {
                                String useDbStr = new StringBuilder(4).append("use ").append(table.escapedDatabaseName()).toString();
                                object = BoxesRunTime.boxToBoolean((boolean)$this.redshiftWrapper.executeInterruptibly(conn, useDbStr));
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    this.log().info("Loading new Redshift data to: {}", new Object[]{table});
                    this.doRedshiftLoad(conn, data, params, credsProvider, manifestUrl);
                    $this.redshiftWrapper.commit(conn);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e;
                        block18: {
                            e = (Throwable)option.get();
                            try {
                                this.log().error("Exception thrown during Redshift load; will roll back transaction: {}", new Object[]{e.getMessage()});
                                $this.redshiftWrapper.rollback(conn);
                            }
                            catch (Throwable throwable3) {
                                Throwable throwable4 = throwable3;
                                Option option2 = NonFatal$.MODULE$.unapply(throwable4);
                                if (!option2.isEmpty()) {
                                    Throwable e2 = (Throwable)option2.get();
                                    this.log().error("Exception while rolling back transaction: {}", new Object[]{e2.getMessage()});
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block18;
                                }
                                throw throwable3;
                            }
                        }
                        throw e;
                    }
                    throw throwable;
                }
            }
        });
    }

    private void checkS3BucketUsage(Parameters.MergedParameters params, AWSCredentialsProvider credsProvider) {
        if (!params.checkS3BucketUsage()) {
            return;
        }
        AmazonS3 s3Client = (AmazonS3)this.s3ClientFactory.apply((Object)credsProvider, (Object)params);
        String string = params.tempFormat();
        String string2 = "PARQUET";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Utils$.MODULE$.checkRedshiftAndS3OnSameRegionParquetWrite(params, s3Client);
        } else {
            Utils$.MODULE$.checkRedshiftAndS3OnSameRegion(params, s3Client);
        }
        Utils$.MODULE$.checkThatBucketHasObjectLifecycleConfiguration(params, s3Client);
    }

    public static final /* synthetic */ boolean $anonfun$commentActions$2(StructField f) {
        return f.metadata().contains("description");
    }

    public static final /* synthetic */ boolean $anonfun$doRedshiftLoad$1(RedshiftWriter $this, Parameters.MergedParameters params$1, RedshiftConnection conn$1, String action) {
        String actionSql = action.contains("%s") ? new StringOps(Predef$.MODULE$.augmentString(action)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params$1.table().get()})) : action;
        return $this.redshiftWrapper.executeInterruptibly(conn$1, actionSql);
    }

    public static final /* synthetic */ boolean $anonfun$doRedshiftLoad$4(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$doRedshiftLoad$2(RedshiftWriter $this, Dataset data$1, Parameters.MergedParameters params$1, AWSCredentialsProvider creds$1, RedshiftConnection conn$1, String manifestUrl) {
        boolean bl;
        String copyStatement = $this.copySql(data$1.sqlContext(), data$1.schema(), params$1, creds$1, manifestUrl);
        try {
            bl = $this.redshiftWrapper.executeInterruptibly(conn$1, copyStatement);
        }
        catch (SQLException e) {
            None$ none$;
            $this.log().error("SQLException thrown while running COPY query; will attempt to retrieve more information by querying the STL_LOAD_ERRORS table: {}", new Object[]{e.getMessage()});
            $this.redshiftWrapper.rollback(conn$1);
            String errorLookupQuery = new StringOps(Predef$.MODULE$.augmentString("\n              | SELECT *\n              | FROM stl_load_errors\n              | WHERE query = pg_last_query_id()\n            ")).stripMargin();
            try {
                RedshiftResults results = $this.redshiftWrapper.executeQueryInterruptibly(conn$1, errorLookupQuery);
                if (results.next()) {
                    int errCode = results.getInt("err_code");
                    String errReason = results.getString("err_reason").trim();
                    String columnLength = (String)Option$.MODULE$.apply((Object)results.getString("col_length")).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)RedshiftWriter.$anonfun$doRedshiftLoad$4(x$2))).map((Function1 & Serializable & scala.Serializable)n -> new StringBuilder(2).append("(").append((String)n).append(")").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                    String exceptionMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(260).append("\n                   |Error (code ").append(errCode).append(") while loading data into Redshift: \"").append(errReason).append("\"\n                   |Table name: ").append(params$1.table().get()).append("\n                   |Column name: ").append(results.getString("colname").trim()).append("\n                   |Column type: ").append(results.getString("type").trim()).append(columnLength).append("\n                   |Raw line: ").append(results.getString("raw_line")).append("\n                   |Raw field value: ").append(results.getString("raw_field_value")).append("\n                  ").toString())).stripMargin();
                    none$ = new Some((Object)new SQLException(exceptionMessage, e));
                } else {
                    none$ = None$.MODULE$;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e2 = (Throwable)option.get();
                $this.log().error("Error occurred while querying STL_LOAD_ERRORS: {}", new Object[]{e2.getMessage()});
                None$ none$2 = None$.MODULE$;
                none$ = none$2;
            }
            None$ detailedException = none$;
            throw (Throwable)detailedException.getOrElse((Function0 & Serializable & scala.Serializable)() -> e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doRedshiftLoad$8(RedshiftWriter $this, Parameters.MergedParameters params$1, RedshiftConnection conn$1, String action) {
        String actionSql = action.contains("%s") ? new StringOps(Predef$.MODULE$.augmentString(action)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params$1.table().get()})) : action;
        return $this.redshiftWrapper.executeInterruptibly(conn$1, actionSql);
    }

    public static final /* synthetic */ boolean $anonfun$unloadData$7(StructField x$4) {
        DataType dataType = x$4.dataType();
        boolean bl = dataType instanceof MapType ? true : (dataType instanceof StructType ? true : dataType instanceof ArrayType);
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$saveToRedshift$2(char c) {
        return RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c)) || c == '_';
    }

    public static final /* synthetic */ void $anonfun$saveToRedshift$1(String fieldName) {
        boolean isValid;
        char firstChar = fieldName.charAt(0);
        boolean bl = isValid = (RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(firstChar)) || firstChar == '_') && new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(fieldName)).tail())).forall((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)RedshiftWriter.$anonfun$saveToRedshift$2(BoxesRunTime.unboxToChar((Object)c))));
        if (!isValid) {
            throw new IllegalArgumentException(new StringBuilder(182).append("The field name '").append(fieldName).append("' is not supported when using the Avro tempformat. ").append("Try using the CSV tempformat  instead. For more details, see ").append("https://github.com/databricks/spark-redshift/issues/84").toString());
        }
    }

    public RedshiftWriter(RedshiftWrapper redshiftWrapper, Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> s3ClientFactory) {
        this.redshiftWrapper = redshiftWrapper;
        this.s3ClientFactory = s3ClientFactory;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

