/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import io.github.spark_redshift_community.spark.redshift.Parameters;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class Parameters$ {
    public static Parameters$ MODULE$;
    private final String PARAM_AUTO_PUSHDOWN;
    private final String PARAM_PUSHDOWN_S3_RESULT_CACHE;
    private final String PARAM_UNLOAD_S3_FORMAT;
    private final String PARAM_COPY_RETRY_COUNT;
    private final String PARAM_COPY_DELAY;
    private final String PARAM_LEGACY_JDBC_REAL_TYPE_MAPPING;
    private final String PARAM_LEGACY_TRIM_CSV_WRITES;
    private final String PARAM_OVERRIDE_NULLABLE;
    private final String PARAM_TEMPDIR_REGION;
    private final String PARAM_SECRET_ID;
    private final String PARAM_SECRET_REGION;
    private final String PARAM_USER_QUERY_GROUP_LABEL;
    private final String PARAM_DATA_API_REGION;
    private final String PARAM_DATA_API_DATABASE;
    private final String PARAM_DATA_API_USER;
    private final String PARAM_DATA_API_CLUSTER;
    private final String PARAM_DATA_API_WORKGROUP;
    private final String PARAM_TEMPORARY_AWS_ACCESS_KEY_ID;
    private final String PARAM_TEMPORARY_AWS_SECRET_ACCESS_KEY;
    private final String PARAM_TEMPORARY_AWS_SESSION_TOKEN;
    private final String PARAM_LEGACY_MAPPING_SHORT_TO_INT;
    private final String PARAM_CHECK_S3_BUCKET_USAGE;
    private final String PARAM_HOST_CONNECTOR;
    private final Map<String, String> DEFAULT_PARAMETERS;
    private final Set<String> VALID_TEMP_FORMATS;
    private final long DEFAULT_RETRY_DELAY;

    static {
        new Parameters$();
    }

    public String PARAM_AUTO_PUSHDOWN() {
        return this.PARAM_AUTO_PUSHDOWN;
    }

    public String PARAM_PUSHDOWN_S3_RESULT_CACHE() {
        return this.PARAM_PUSHDOWN_S3_RESULT_CACHE;
    }

    public String PARAM_UNLOAD_S3_FORMAT() {
        return this.PARAM_UNLOAD_S3_FORMAT;
    }

    public String PARAM_COPY_RETRY_COUNT() {
        return this.PARAM_COPY_RETRY_COUNT;
    }

    public String PARAM_COPY_DELAY() {
        return this.PARAM_COPY_DELAY;
    }

    public String PARAM_LEGACY_JDBC_REAL_TYPE_MAPPING() {
        return this.PARAM_LEGACY_JDBC_REAL_TYPE_MAPPING;
    }

    public String PARAM_LEGACY_TRIM_CSV_WRITES() {
        return this.PARAM_LEGACY_TRIM_CSV_WRITES;
    }

    public String PARAM_OVERRIDE_NULLABLE() {
        return this.PARAM_OVERRIDE_NULLABLE;
    }

    public String PARAM_TEMPDIR_REGION() {
        return this.PARAM_TEMPDIR_REGION;
    }

    public String PARAM_SECRET_ID() {
        return this.PARAM_SECRET_ID;
    }

    public String PARAM_SECRET_REGION() {
        return this.PARAM_SECRET_REGION;
    }

    public String PARAM_USER_QUERY_GROUP_LABEL() {
        return this.PARAM_USER_QUERY_GROUP_LABEL;
    }

    public String PARAM_DATA_API_REGION() {
        return this.PARAM_DATA_API_REGION;
    }

    public String PARAM_DATA_API_DATABASE() {
        return this.PARAM_DATA_API_DATABASE;
    }

    public String PARAM_DATA_API_USER() {
        return this.PARAM_DATA_API_USER;
    }

    public String PARAM_DATA_API_CLUSTER() {
        return this.PARAM_DATA_API_CLUSTER;
    }

    public String PARAM_DATA_API_WORKGROUP() {
        return this.PARAM_DATA_API_WORKGROUP;
    }

    public String PARAM_TEMPORARY_AWS_ACCESS_KEY_ID() {
        return this.PARAM_TEMPORARY_AWS_ACCESS_KEY_ID;
    }

    public String PARAM_TEMPORARY_AWS_SECRET_ACCESS_KEY() {
        return this.PARAM_TEMPORARY_AWS_SECRET_ACCESS_KEY;
    }

    public String PARAM_TEMPORARY_AWS_SESSION_TOKEN() {
        return this.PARAM_TEMPORARY_AWS_SESSION_TOKEN;
    }

    public String PARAM_LEGACY_MAPPING_SHORT_TO_INT() {
        return this.PARAM_LEGACY_MAPPING_SHORT_TO_INT;
    }

    public String PARAM_CHECK_S3_BUCKET_USAGE() {
        return this.PARAM_CHECK_S3_BUCKET_USAGE;
    }

    public String PARAM_HOST_CONNECTOR() {
        return this.PARAM_HOST_CONNECTOR;
    }

    public Map<String, String> DEFAULT_PARAMETERS() {
        return this.DEFAULT_PARAMETERS;
    }

    public Set<String> VALID_TEMP_FORMATS() {
        return this.VALID_TEMP_FORMATS;
    }

    public long DEFAULT_RETRY_DELAY() {
        return this.DEFAULT_RETRY_DELAY;
    }

    private boolean dataAPICredentials(Map<String, String> userParameters) {
        return userParameters.contains((Object)this.PARAM_DATA_API_REGION()) || userParameters.contains((Object)this.PARAM_DATA_API_DATABASE()) || userParameters.contains((Object)this.PARAM_DATA_API_USER()) || userParameters.contains((Object)this.PARAM_DATA_API_CLUSTER()) || userParameters.contains((Object)this.PARAM_DATA_API_WORKGROUP());
    }

    private void checkUnsupportedParameters(Map<String, String> userParameters, String incompatibleType, Seq<String> unsupportedParams) {
        unsupportedParams.foreach((Function1 & java.io.Serializable & Serializable)unsupportedParam -> {
            Parameters$.$anonfun$checkUnsupportedParameters$1(userParameters, incompatibleType, unsupportedParam);
            return BoxedUnit.UNIT;
        });
    }

    private void validateUserParameters(Map<String, String> userParameters) {
        if (!userParameters.contains((Object)"tempdir")) {
            throw new IllegalArgumentException("'tempdir' is required for all Redshift loads and saves");
        }
        if (userParameters.contains((Object)"tempformat") && !this.VALID_TEMP_FORMATS().contains((Object)((String)userParameters.apply((Object)"tempformat")).toUpperCase())) {
            throw new IllegalArgumentException(new StringBuilder(42).append("Invalid temp format: ").append(userParameters.apply((Object)"tempformat")).append("; ").append("valid formats are: ").append(this.VALID_TEMP_FORMATS().mkString(", ")).toString());
        }
        if (!userParameters.contains((Object)"dbtable") && !userParameters.contains((Object)"query")) {
            throw new IllegalArgumentException("You must specify a Redshift table name with the 'dbtable' parameter or a query with the 'query' parameter.");
        }
        if (userParameters.contains((Object)"dbtable") && userParameters.contains((Object)"query")) {
            throw new IllegalArgumentException("You cannot specify both the 'dbtable' and 'query' parameters at the same time.");
        }
        if (userParameters.get((Object)this.PARAM_HOST_CONNECTOR()).exists((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Parameters$.$anonfun$validateUserParameters$1(x$1)))) {
            char invalid = BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString((String)userParameters.apply((Object)this.PARAM_HOST_CONNECTOR()))).find((Function1 & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Parameters$.$anonfun$validateUserParameters$3(BoxesRunTime.unboxToChar((Object)x$3)))).get());
            throw new IllegalArgumentException(new StringBuilder(131).append("All characters in '").append(this.PARAM_HOST_CONNECTOR()).append("' option must be valid unicode ").append("identifier parts (char.isUnicodeIdentifierPart == true), '").append(invalid).append("' character ").append("not allowed").toString());
        }
        if (userParameters.get((Object)this.PARAM_USER_QUERY_GROUP_LABEL()).exists((Function1 & java.io.Serializable & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Parameters$.$anonfun$validateUserParameters$4(x$4)))) {
            char invalid = BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString((String)userParameters.apply((Object)this.PARAM_USER_QUERY_GROUP_LABEL()))).find((Function1 & java.io.Serializable & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Parameters$.$anonfun$validateUserParameters$6(BoxesRunTime.unboxToChar((Object)x$6)))).get());
            throw new IllegalArgumentException(new StringBuilder(131).append("All characters in '").append(this.PARAM_USER_QUERY_GROUP_LABEL()).append("' option must be valid unicode ").append("identifier parts (char.isUnicodeIdentifierPart == true), '").append(invalid).append("' character ").append("not allowed").toString());
        }
        if (!this.dataAPICredentials(userParameters)) {
            if (!userParameters.contains((Object)"url")) {
                throw new IllegalArgumentException("A JDBC URL must be provided with 'url' parameter");
            }
            Option credsInURL = userParameters.get((Object)"url").filter((Function1 & java.io.Serializable & Serializable)url -> BoxesRunTime.boxToBoolean((boolean)Parameters$.$anonfun$validateUserParameters$7(url)));
            if ((userParameters.contains((Object)"user") || userParameters.contains((Object)"password")) && credsInURL.isDefined()) {
                throw new IllegalArgumentException("You cannot specify credentials in both the URL and as user/password options");
            }
            if (credsInURL.isDefined() && userParameters.contains((Object)this.PARAM_SECRET_ID())) {
                throw new IllegalArgumentException("You cannot give a secret and specify credentials in URL");
            }
            if ((userParameters.contains((Object)"user") || userParameters.contains((Object)"password")) && userParameters.contains((Object)this.PARAM_SECRET_ID())) {
                throw new IllegalArgumentException("You cannot give a secret and specify user/password options");
            }
        } else {
            this.checkUnsupportedParameters(userParameters, "Data API", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user", "password", "url", "jdbcdriver", this.PARAM_SECRET_REGION(), "secret.vpcEndpointUrl", "secret.vpcEndpointRegion"}));
            userParameters.foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
                Parameters$.$anonfun$validateUserParameters$8(x0$1);
                return BoxedUnit.UNIT;
            });
            if (userParameters.contains((Object)this.PARAM_DATA_API_USER()) && userParameters.contains((Object)this.PARAM_SECRET_ID())) {
                throw new IllegalArgumentException("You cannot specify both the 'data_api_user' and provide a secret at the same time.");
            }
            if (!userParameters.contains((Object)this.PARAM_DATA_API_DATABASE())) {
                throw new IllegalArgumentException("You must specify a Redshift database name with the 'data_api_database' parameter to use the Redshift Data API");
            }
            if (userParameters.contains((Object)this.PARAM_DATA_API_CLUSTER()) && userParameters.contains((Object)this.PARAM_DATA_API_WORKGROUP())) {
                throw new IllegalArgumentException("The parameters 'data_api_cluster' and 'data_api_workgroup' are mutually-exclusive.");
            }
            if (userParameters.contains((Object)this.PARAM_DATA_API_WORKGROUP()) && userParameters.contains((Object)this.PARAM_DATA_API_USER())) {
                throw new IllegalArgumentException("You cannot use 'data_api_user' when connecting to a serverless workgroup using 'data_api_workgroup'");
            }
        }
    }

    public Parameters.MergedParameters mergeParameters(Map<String, String> userParameters) {
        this.validateUserParameters(userParameters);
        return new Parameters.MergedParameters((Map<String, String>)this.DEFAULT_PARAMETERS().$plus$plus(userParameters));
    }

    public static final /* synthetic */ void $anonfun$checkUnsupportedParameters$1(Map userParameters$1, String incompatibleType$1, String unsupportedParam) {
        if (userParameters$1.contains((Object)unsupportedParam)) {
            throw new IllegalArgumentException(new StringBuilder(53).append("The parameter '").append(unsupportedParam).append("' is not compatible with ").append(incompatibleType$1).append(" credentials.").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateUserParameters$2(char x$2) {
        return !RichChar$.MODULE$.isUnicodeIdentifierPart$extension(Predef$.MODULE$.charWrapper(x$2));
    }

    public static final /* synthetic */ boolean $anonfun$validateUserParameters$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).exists((Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Parameters$.$anonfun$validateUserParameters$2(BoxesRunTime.unboxToChar((Object)x$2))));
    }

    public static final /* synthetic */ boolean $anonfun$validateUserParameters$3(char x$3) {
        return !RichChar$.MODULE$.isUnicodeIdentifierPart$extension(Predef$.MODULE$.charWrapper(x$3));
    }

    public static final /* synthetic */ boolean $anonfun$validateUserParameters$5(char x$5) {
        return !RichChar$.MODULE$.isUnicodeIdentifierPart$extension(Predef$.MODULE$.charWrapper(x$5));
    }

    public static final /* synthetic */ boolean $anonfun$validateUserParameters$4(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).exists((Function1 & java.io.Serializable & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Parameters$.$anonfun$validateUserParameters$5(BoxesRunTime.unboxToChar((Object)x$5))));
    }

    public static final /* synthetic */ boolean $anonfun$validateUserParameters$6(char x$6) {
        return !RichChar$.MODULE$.isUnicodeIdentifierPart$extension(Predef$.MODULE$.charWrapper(x$6));
    }

    public static final /* synthetic */ boolean $anonfun$validateUserParameters$7(String url) {
        return url.contains("user=") || url.contains("password=") || url.contains("DbUser=");
    }

    public static final /* synthetic */ void $anonfun$validateUserParameters$8(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            if (key.matches("^jdbc\\..+")) {
                throw new IllegalArgumentException(new StringBuilder(61).append("The parameter '").append(key).append("' is not compatible with Data API credentials.").toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Parameters$() {
        MODULE$ = this;
        this.PARAM_AUTO_PUSHDOWN = "autopushdown";
        this.PARAM_PUSHDOWN_S3_RESULT_CACHE = "autopushdown.s3_result_cache";
        this.PARAM_UNLOAD_S3_FORMAT = "unload_s3_format";
        this.PARAM_COPY_RETRY_COUNT = "copyretrycount";
        this.PARAM_COPY_DELAY = "copydelay";
        this.PARAM_LEGACY_JDBC_REAL_TYPE_MAPPING = "legacy_jdbc_real_type_mapping";
        this.PARAM_LEGACY_TRIM_CSV_WRITES = "legacy_trim_csv_writes";
        this.PARAM_OVERRIDE_NULLABLE = "overridenullable";
        this.PARAM_TEMPDIR_REGION = "tempdir_region";
        this.PARAM_SECRET_ID = "secret.id";
        this.PARAM_SECRET_REGION = "secret.region";
        this.PARAM_USER_QUERY_GROUP_LABEL = "label";
        this.PARAM_DATA_API_REGION = "data_api_region";
        this.PARAM_DATA_API_DATABASE = "data_api_database";
        this.PARAM_DATA_API_USER = "data_api_user";
        this.PARAM_DATA_API_CLUSTER = "data_api_cluster";
        this.PARAM_DATA_API_WORKGROUP = "data_api_workgroup";
        this.PARAM_TEMPORARY_AWS_ACCESS_KEY_ID = "temporary_aws_access_key_id";
        this.PARAM_TEMPORARY_AWS_SECRET_ACCESS_KEY = "temporary_aws_secret_access_key";
        this.PARAM_TEMPORARY_AWS_SESSION_TOKEN = "temporary_aws_session_token";
        this.PARAM_LEGACY_MAPPING_SHORT_TO_INT = "legacy_mapping_short_to_int";
        this.PARAM_CHECK_S3_BUCKET_USAGE = "check_s3_bucket_usage";
        this.PARAM_HOST_CONNECTOR = "host_connector";
        this.DEFAULT_PARAMETERS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"forward_spark_s3_credentials"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tempformat"), (Object)"AVRO"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"csvnullstring"), (Object)"@NULL@"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"overwrite"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"diststyle"), (Object)"EVEN"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"usestagingtable"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"preactions"), (Object)";"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"postactions"), (Object)";"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"include_column_list"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_AUTO_PUSHDOWN()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_PUSHDOWN_S3_RESULT_CACHE()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_UNLOAD_S3_FORMAT()), (Object)"PARQUET"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_OVERRIDE_NULLABLE()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_COPY_RETRY_COUNT()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_COPY_DELAY()), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_LEGACY_JDBC_REAL_TYPE_MAPPING()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_LEGACY_TRIM_CSV_WRITES()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_TEMPDIR_REGION()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_LEGACY_MAPPING_SHORT_TO_INT()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_CHECK_S3_BUCKET_USAGE()), (Object)"true")}));
        this.VALID_TEMP_FORMATS = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AVRO", "CSV", "CSV GZIP", "PARQUET"}));
        this.DEFAULT_RETRY_DELAY = 30000L;
    }
}

