/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.Parameters$;
import io.github.spark_redshift_community.spark.redshift.RedshiftRelation;
import io.github.spark_redshift_community.spark.redshift.RedshiftWriter;
import io.github.spark_redshift_community.spark.redshift.TableName;
import io.github.spark_redshift_community.spark.redshift.Utils$;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftConnection;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftWrapper;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftWrapperFactory$;
import io.github.spark_redshift_community.spark.redshift.pushdown.RedshiftStrategy;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.ExperimentalMethods;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.SparkStrategy;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001\u0002\u0006\f\u0001YA\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\u00065\u0002!\ta\u0017\u0005\b?\u0002\u0011\r\u0011\"\u0003a\u0011\u00199\u0007\u0001)A\u0005C\")!\f\u0001C\u0001Q\")\u0011\u000e\u0001C!U\"1\u0011\u000e\u0001C!\u0003\u0007Aa!\u001b\u0001\u0005B\u0005m\u0001bBA'\u0001\u0011\u0005\u0011q\n\u0002\u000e\t\u00164\u0017-\u001e7u'>,(oY3\u000b\u00051i\u0011\u0001\u0003:fIND\u0017N\u001a;\u000b\u00059y\u0011!B:qCJ\\'B\u0001\t\u0012\u0003a\u0019\b/\u0019:l?J,Gm\u001d5jMR|6m\\7nk:LG/\u001f\u0006\u0003%M\taaZ5uQV\u0014'\"\u0001\u000b\u0002\u0005%|7\u0001A\n\u0006\u0001]i\"&\f\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005yAS\"A\u0010\u000b\u0005\u0001\n\u0013aB:pkJ\u001cWm\u001d\u0006\u0003E\r\n1a]9m\u0015\tqAE\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<\u0017BA\u0015 \u0005A\u0011V\r\\1uS>t\u0007K]8wS\u0012,'\u000f\u0005\u0002\u001fW%\u0011Af\b\u0002\u0017'\u000eDW-\\1SK2\fG/[8o!J|g/\u001b3feB\u0011aDL\u0005\u0003_}\u0011\u0011d\u0011:fCR\f'\r\\3SK2\fG/[8o!J|g/\u001b3fe\u0006y1oM\"mS\u0016tGOR1di>\u0014\u0018\u0010E\u0003\u0019eQr$+\u0003\u000243\tIa)\u001e8di&|gN\r\t\u0003kqj\u0011A\u000e\u0006\u0003oa\nA!Y;uQ*\u0011\u0011HO\u0001\nC6\f'p\u001c8boNT\u0011aO\u0001\u0004G>l\u0017BA\u001f7\u0005Y\tukU\"sK\u0012,g\u000e^5bYN\u0004&o\u001c<jI\u0016\u0014\bCA P\u001d\t\u0001UJ\u0004\u0002B\u0019:\u0011!i\u0013\b\u0003\u0007*s!\u0001R%\u000f\u0005\u0015CU\"\u0001$\u000b\u0005\u001d+\u0012A\u0002\u001fs_>$h(C\u0001\u0015\u0013\t\u00112#\u0003\u0002\u0011#%\u0011abD\u0005\u0003\u00195I!AT\u0006\u0002\u0015A\u000b'/Y7fi\u0016\u00148/\u0003\u0002Q#\n\u0001R*\u001a:hK\u0012\u0004\u0016M]1nKR,'o\u001d\u0006\u0003\u001d.\u0001\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\u0005M\u001c$BA,9\u0003!\u0019XM\u001d<jG\u0016\u001c\u0018BA-U\u0005!\tU.\u0019>p]N\u001b\u0014A\u0002\u001fj]&$h\b\u0006\u0002]=B\u0011Q\fA\u0007\u0002\u0017!)\u0001G\u0001a\u0001c\u0005\u0019An\\4\u0016\u0003\u0005\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u0014\u0002\u000bMdg\r\u000e6\n\u0005\u0019\u001c'A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004C#\u0001/\u0002\u001d\r\u0014X-\u0019;f%\u0016d\u0017\r^5p]R\u00191N\u001c;\u0011\u0005ya\u0017BA7 \u00051\u0011\u0015m]3SK2\fG/[8o\u0011\u0015yg\u00011\u0001q\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u0003cJl\u0011!I\u0005\u0003g\u0006\u0012!bU)M\u0007>tG/\u001a=u\u0011\u0015)h\u00011\u0001w\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005onthP\u0004\u0002ysB\u0011Q)G\u0005\u0003uf\ta\u0001\u0015:fI\u00164\u0017B\u0001?~\u0005\ri\u0015\r\u001d\u0006\u0003uf\u0001\"a^@\n\u0007\u0005\u0005QP\u0001\u0004TiJLgn\u001a\u000b\bW\u0006\u0015\u0011qAA\u0006\u0011\u0015yw\u00011\u0001q\u0011\u0019\tIa\u0002a\u0001m\u0006qQo]3s!\u0006\u0014\u0018-\\3uKJ\u001c\bbBA\u0007\u000f\u0001\u0007\u0011qB\u0001\u0007g\u000eDW-\\1\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006\"\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tI\"a\u0005\u0003\u0015M#(/^2u)f\u0004X\rF\u0005l\u0003;\ty\"!\u000b\u0002,!)q\u000e\u0003a\u0001a\"9\u0011\u0011\u0005\u0005A\u0002\u0005\r\u0012\u0001C:bm\u0016lu\u000eZ3\u0011\u0007E\f)#C\u0002\u0002(\u0005\u0012\u0001bU1wK6{G-\u001a\u0005\u0007\u0003\u0013A\u0001\u0019\u0001<\t\u000f\u00055\u0002\u00021\u0001\u00020\u0005!A-\u0019;b!\u0011\t\t$a\u0012\u000f\t\u0005M\u00121\t\b\u0005\u0003k\t\tE\u0004\u0003\u00028\u0005}b\u0002BA\u001d\u0003{q1!RA\u001e\u0013\u00059\u0013BA\u0013'\u0013\tqA%\u0003\u0002#G%\u0019\u0011QI\u0011\u0002\u000fA\f7m[1hK&!\u0011\u0011JA&\u0005%!\u0015\r^1Ge\u0006lWMC\u0002\u0002F\u0005\nQ#\u001a8bE2,\u0007+^:iI><hnU3tg&|g\u000e\u0006\u0003\u0002R\u0005]\u0003c\u0001\r\u0002T%\u0019\u0011QK\r\u0003\tUs\u0017\u000e\u001e\u0005\b\u00033J\u0001\u0019AA.\u0003\u001d\u0019Xm]:j_:\u00042!]A/\u0013\r\ty&\t\u0002\r'B\f'o[*fgNLwN\u001c")
public class DefaultSource
implements RelationProvider,
SchemaRelationProvider,
CreatableRelationProvider {
    private final Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> s3ClientFactory;
    private final Logger log;

    private Logger log() {
        return this.log;
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        return this.createRelation(sqlContext, parameters, null);
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> userParameters, StructType schema) {
        Parameters.MergedParameters mergedParams = Parameters$.MODULE$.mergeParameters(userParameters);
        if (mergedParams.autoPushdown()) {
            this.enablePushdownSession(sqlContext.sparkSession());
        }
        return new RedshiftRelation(RedshiftWrapperFactory$.MODULE$.apply(mergedParams), this.s3ClientFactory, mergedParams, (Option<StructType>)Option$.MODULE$.apply((Object)schema), sqlContext);
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode saveMode, Map<String, String> userParameters, Dataset<Row> data) {
        block12: {
            Tuple2.mcZZ.sp sp2;
            Parameters.MergedParameters mergedParams = Parameters$.MODULE$.mergeParameters(userParameters);
            TableName table = (TableName)mergedParams.table().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException("For save operations you must specify a Redshift table name with the 'dbtable' parameter");
            });
            RedshiftWrapper redshiftWrapper = RedshiftWrapperFactory$.MODULE$.apply(mergedParams);
            SaveMode saveMode2 = saveMode;
            if (SaveMode.Append.equals(saveMode2)) {
                sp2 = new Tuple2.mcZZ.sp(true, false);
            } else if (SaveMode.Overwrite.equals(saveMode2)) {
                sp2 = new Tuple2.mcZZ.sp(true, true);
            } else if (SaveMode.ErrorIfExists.equals(saveMode2)) {
                if (DefaultSource.tableExists$1(redshiftWrapper, mergedParams, table)) {
                    throw package$.MODULE$.error(new StringBuilder(57).append("Table ").append(table).append(" already exists! (SaveMode is set to ErrorIfExists)").toString());
                }
                sp2 = new Tuple2.mcZZ.sp(true, false);
            } else if (SaveMode.Ignore.equals(saveMode2)) {
                Tuple2.mcZZ.sp sp3;
                if (DefaultSource.tableExists$1(redshiftWrapper, mergedParams, table)) {
                    this.log().info(new StringBuilder(47).append("Table ").append(table).append(" already exists -- ignoring save request.").toString());
                    sp3 = new Tuple2.mcZZ.sp(false, false);
                } else {
                    sp3 = new Tuple2.mcZZ.sp(true, false);
                }
                sp2 = sp3;
            } else {
                throw new MatchError((Object)saveMode2);
            }
            Tuple2.mcZZ.sp sp4 = sp2;
            if (sp4 == null) {
                throw new MatchError((Object)sp4);
            }
            boolean doSave = sp4._1$mcZ$sp();
            boolean dropExisting = sp4._2$mcZ$sp();
            Tuple2.mcZZ.sp sp5 = new Tuple2.mcZZ.sp(doSave, dropExisting);
            Tuple2.mcZZ.sp sp6 = sp5;
            boolean doSave2 = sp6._1$mcZ$sp();
            boolean dropExisting2 = sp6._2$mcZ$sp();
            if (!doSave2) break block12;
            Map updatedUserParameters = userParameters.updated((Object)"overwrite", (Object)Boolean.toString(dropExisting2));
            Parameters.MergedParameters mergedParameters = Parameters$.MODULE$.mergeParameters((Map<String, String>)updatedUserParameters);
            new RedshiftWriter(redshiftWrapper, this.s3ClientFactory).saveToRedshift(sqlContext, data, saveMode, mergedParameters);
        }
        return this.createRelation(sqlContext, userParameters);
    }

    public void enablePushdownSession(SparkSession session) {
        block0: {
            if (session.experimental().extraStrategies().exists((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$enablePushdownSession$1(s)))) break block0;
            this.log().info("Enable auto pushdown.");
            ExperimentalMethods experimentalMethods = session.experimental();
            experimentalMethods.extraStrategies_$eq((Seq)experimentalMethods.extraStrategies().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new RedshiftStrategy(session), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
        }
    }

    private static final boolean tableExists$1(RedshiftWrapper redshiftWrapper$1, Parameters.MergedParameters mergedParams$1, TableName table$1) {
        boolean bl;
        try (RedshiftConnection conn = redshiftWrapper$1.getConnector(mergedParams$1);){
            bl = redshiftWrapper$1.tableExists(conn, table$1.toString());
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$enablePushdownSession$1(SparkStrategy s) {
        return s instanceof RedshiftStrategy;
    }

    public DefaultSource(Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> s3ClientFactory) {
        this.s3ClientFactory = s3ClientFactory;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public DefaultSource() {
        this(Utils$.MODULE$.s3ClientBuilder());
    }
}

