/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ForEachStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.ImportDeclarationHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.LambdaExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.ResolvedTypeHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.VariableDeclarationExprHepers;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyAfterMe;
import eu.solven.cleanthat.engine.java.refactorer.mutators.ARefactorConsecutiveStatements;
import eu.solven.cleanthat.engine.java.refactorer.mutators.LambdaIsMethodReference;
import eu.solven.cleanthat.engine.java.refactorer.mutators.SimplifyBooleanInitialization;
import java.util.Optional;
import java.util.Set;

@ApplyAfterMe(value={LambdaIsMethodReference.class})
public class ForEachIfBreakToStreamFindFirst
extends ARefactorConsecutiveStatements {
    public String minimalJavaVersion() {
        return "1.8";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Stream", (Object)"Loop", (Object)"Initialization");
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("EnhancedForLoopToStreamFindFirst");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/enhanced-for-loop-to-stream-find-first.html";
    }

    @Override
    protected boolean trySimplifyingStatements(NodeAndSymbolSolver<BlockStmt> blockStmtAndSolver, Statement currentStmt, Statement nextStmt) {
        Optional<VariableDeclarationExpr> optAssignExpr = VariableDeclarationExprHepers.optSimpleDeclaration(currentStmt);
        if (optAssignExpr.isEmpty()) {
            return false;
        }
        VariableDeclarationExpr assignExpr = optAssignExpr.get();
        VariableDeclarator singleVariable = assignExpr.getVariable(0);
        Optional optInitializer = singleVariable.getInitializer();
        if (optInitializer.isEmpty()) {
            return false;
        }
        if (!nextStmt.isForEachStmt()) {
            return false;
        }
        ForEachStmt forEachStmt = nextStmt.asForEachStmt();
        if (!(forEachStmt.getBody().isBlockStmt() && forEachStmt.getBody().asBlockStmt().getStatements().size() == 1 && forEachStmt.getBody().asBlockStmt().getStatement(0).isIfStmt() && forEachStmt.getBody().asBlockStmt().getStatement(0).asIfStmt().hasThenBlock())) {
            return false;
        }
        IfStmt ifStmt = forEachStmt.getBody().asBlockStmt().getStatement(0).asIfStmt();
        BlockStmt thenStmt = ifStmt.getThenStmt().asBlockStmt();
        if (thenStmt.getStatements().size() != 2 || !thenStmt.getStatement(1).isBreakStmt()) {
            return false;
        }
        Optional<AssignExpr> optIfAssignExpr = SimplifyBooleanInitialization.searchSingleAssignExpr(thenStmt.getStatement(0));
        if (optIfAssignExpr.isEmpty()) {
            return false;
        }
        AssignExpr ifAssignExpr = optIfAssignExpr.get();
        if (SimplifyBooleanInitialization.notAssignOperator(ifAssignExpr) || !ifAssignExpr.getTarget().isNameExpr() || !ifAssignExpr.getTarget().asNameExpr().getNameAsString().equals(singleVariable.getNameAsString())) {
            return false;
        }
        MethodCallExpr streamCall = new MethodCallExpr(forEachStmt.getIterable(), "stream");
        VariableDeclarator forEachVariable = forEachStmt.getVariableDeclarator();
        Optional<LambdaExpr> lambdaExpr = LambdaExprHelpers.makeLambdaExpr(forEachVariable.getName(), ifStmt.getCondition());
        if (lambdaExpr.isEmpty()) {
            return false;
        }
        MethodCallExpr filterCall = new MethodCallExpr((Expression)streamCall, "filter", new NodeList((Node[])new Expression[]{(Expression)lambdaExpr.get()}));
        MethodCallExpr findFirstCall = new MethodCallExpr((Expression)filterCall, "findFirst");
        if (!ifAssignExpr.getValue().isNameExpr()) {
            Optional<LambdaExpr> optLambdaExpr = LambdaExprHelpers.makeLambdaExpr(forEachVariable.getName(), ifAssignExpr.getValue());
            if (optLambdaExpr.isEmpty()) {
                return false;
            }
            findFirstCall = new MethodCallExpr((Expression)findFirstCall, "map", new NodeList((Node[])new Expression[]{(Expression)optLambdaExpr.get()}));
        }
        Optional<ResolvedType> optVariableType = ResolvedTypeHelpers.optResolvedType(singleVariable.getType());
        Optional<ResolvedType> optForEachType = ResolvedTypeHelpers.optResolvedType(forEachVariable.getType());
        if (optVariableType.isEmpty() || optForEachType.isEmpty()) {
            return false;
        }
        ResolvedType variableResolvedType = optVariableType.get();
        ResolvedType forEachType = optForEachType.get();
        if (!forEachType.isAssignableBy(variableResolvedType)) {
            MethodReferenceExpr methodReferenceExpr;
            if (variableResolvedType.isPrimitive()) {
                ResolvedPrimitiveType asPrimitive = variableResolvedType.asPrimitive();
                methodReferenceExpr = new MethodReferenceExpr((Expression)ImportDeclarationHelpers.nameOrQualifiedName(blockStmtAndSolver, asPrimitive.getBoxTypeClass()), new NodeList(), "valueOf");
            } else {
                String typeName = assignExpr.getElementType().asString();
                methodReferenceExpr = new MethodReferenceExpr((Expression)new FieldAccessExpr((Expression)new NameExpr(typeName), "class"), new NodeList(), "cast");
            }
            findFirstCall = new MethodCallExpr((Expression)findFirstCall, "map", new NodeList((Node[])new Expression[]{methodReferenceExpr}));
        }
        Expression defaultExpr = (Expression)optInitializer.get();
        MethodCallExpr orElseCall = new MethodCallExpr((Expression)findFirstCall, "orElse", new NodeList((Node[])new Expression[]{defaultExpr}));
        singleVariable.setInitializer((Expression)orElseCall);
        this.tryRemove((Node)forEachStmt);
        return true;
    }
}

