/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.utils;

import java.util.Optional;

public final class ResultOrError<R, E> {
    final Optional<R> optResult;
    final Optional<E> optError;

    public ResultOrError(Optional<R> optResult, Optional<E> optError) {
        this.optResult = optResult;
        this.optError = optError;
        if (optResult.isEmpty() && optError.isEmpty()) {
            throw new IllegalArgumentException("Need a result or an error");
        }
        if (optResult.isPresent() && optError.isPresent()) {
            throw new IllegalArgumentException("Can not have both a result and an error");
        }
    }

    public Optional<R> getOptResult() {
        return this.optResult;
    }

    public Optional<E> getOptError() {
        return this.optError;
    }

    public static <R, E> ResultOrError<R, E> result(R result) {
        return new ResultOrError(Optional.of(result), Optional.empty());
    }

    public static <R, E> ResultOrError<R, E> error(E error) {
        return new ResultOrError(Optional.empty(), Optional.of(error));
    }
}

