/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.formatter;

import java.util.Optional;
import java.util.function.Supplier;

public enum LineEnding {
    NATIVE(System.lineSeparator()),
    LF("\n"),
    CRLF("\r\n"),
    CR("\r"),
    KEEP(null),
    GIT(null),
    AUTO(System.lineSeparator());

    private final String chars;

    private LineEnding(String value) {
        this.chars = value;
    }

    public Optional<String> optChars() {
        return Optional.ofNullable(this.chars);
    }

    public static Optional<LineEnding> determineLineEnding(String fileDataString) {
        int lfCount = 0;
        int crCount = 0;
        int crlfCount = 0;
        for (int i = 0; i < fileDataString.length(); ++i) {
            char c = fileDataString.charAt(i);
            if (c == '\r') {
                if (i + 1 < fileDataString.length() && fileDataString.charAt(i + 1) == '\n') {
                    ++crlfCount;
                    ++i;
                    continue;
                }
                ++crCount;
                continue;
            }
            if (c != '\n') continue;
            ++lfCount;
        }
        if (lfCount > crCount && lfCount > crlfCount) {
            return Optional.of(LF);
        }
        if (crlfCount > lfCount && crlfCount > crCount) {
            return Optional.of(CRLF);
        }
        if (crCount > lfCount && crCount > crlfCount) {
            return Optional.of(CR);
        }
        return Optional.empty();
    }

    public static String getOrGuess(LineEnding lineSeparator, Supplier<String> codeWithEol) {
        return lineSeparator.optChars().or(() -> LineEnding.determineLineEnding((String)codeWithEol.get()).flatMap(LineEnding::optChars)).orElse(NATIVE.optChars().get());
    }
}

