/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.config.pojo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import eu.solven.cleanthat.formatter.LineEnding;
import eu.solven.cleanthat.language.ISourceCodeProperties;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonDeserialize(builder=SourceCodePropertiesBuilder.class)
public class SourceCodeProperties
implements ISourceCodeProperties {
    public static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<String> excludes;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<String> includes;
    private String encoding;
    private LineEnding lineEnding;

    @Override
    @JsonIgnore
    public LineEnding getLineEndingAsEnum() {
        return this.lineEnding;
    }

    public String getLineEnding() {
        return Optional.ofNullable(this.lineEnding).map(Object::toString).orElse(null);
    }

    @JsonIgnore
    public void setLineEndingAsEnum(LineEnding lineEnding) {
        this.lineEnding = lineEnding;
    }

    public static SourceCodeProperties defaultRoot() {
        return SourceCodeProperties.builder().encoding(DEFAULT_ENCODING).lineEnding(LineEnding.GIT).build();
    }

    public static SourceCodeProperties defaultChild() {
        return SourceCodeProperties.builder().build();
    }

    SourceCodeProperties(List<String> excludes, List<String> includes, String encoding, LineEnding lineEnding) {
        this.excludes = excludes;
        this.includes = includes;
        this.encoding = encoding;
        this.lineEnding = lineEnding;
    }

    public static SourceCodePropertiesBuilder builder() {
        return new SourceCodePropertiesBuilder();
    }

    @Override
    public List<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public List<String> getIncludes() {
        return this.includes;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceCodeProperties)) {
            return false;
        }
        SourceCodeProperties other = (SourceCodeProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$excludes = this.getExcludes();
        List<String> other$excludes = other.getExcludes();
        if (this$excludes == null ? other$excludes != null : !((Object)this$excludes).equals(other$excludes)) {
            return false;
        }
        List<String> this$includes = this.getIncludes();
        List<String> other$includes = other.getIncludes();
        if (this$includes == null ? other$includes != null : !((Object)this$includes).equals(other$includes)) {
            return false;
        }
        String this$encoding = this.getEncoding();
        String other$encoding = other.getEncoding();
        if (this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding)) {
            return false;
        }
        String this$lineEnding = this.getLineEnding();
        String other$lineEnding = other.getLineEnding();
        return !(this$lineEnding == null ? other$lineEnding != null : !this$lineEnding.equals(other$lineEnding));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SourceCodeProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $excludes = this.getExcludes();
        result = result * 59 + ($excludes == null ? 43 : ((Object)$excludes).hashCode());
        List<String> $includes = this.getIncludes();
        result = result * 59 + ($includes == null ? 43 : ((Object)$includes).hashCode());
        String $encoding = this.getEncoding();
        result = result * 59 + ($encoding == null ? 43 : $encoding.hashCode());
        String $lineEnding = this.getLineEnding();
        result = result * 59 + ($lineEnding == null ? 43 : $lineEnding.hashCode());
        return result;
    }

    public String toString() {
        return "SourceCodeProperties(excludes=" + this.getExcludes() + ", includes=" + this.getIncludes() + ", encoding=" + this.getEncoding() + ", lineEnding=" + this.getLineEnding() + ")";
    }

    @JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class SourceCodePropertiesBuilder {
        private ArrayList<String> excludes;
        private ArrayList<String> includes;
        private String encoding;
        private LineEnding lineEnding;

        SourceCodePropertiesBuilder() {
        }

        public SourceCodePropertiesBuilder exclude(String exclude) {
            if (this.excludes == null) {
                this.excludes = new ArrayList();
            }
            this.excludes.add(exclude);
            return this;
        }

        public SourceCodePropertiesBuilder excludes(Collection<? extends String> excludes) {
            if (excludes == null) {
                throw new NullPointerException("excludes cannot be null");
            }
            if (this.excludes == null) {
                this.excludes = new ArrayList();
            }
            this.excludes.addAll(excludes);
            return this;
        }

        public SourceCodePropertiesBuilder clearExcludes() {
            if (this.excludes != null) {
                this.excludes.clear();
            }
            return this;
        }

        public SourceCodePropertiesBuilder include(String include) {
            if (this.includes == null) {
                this.includes = new ArrayList();
            }
            this.includes.add(include);
            return this;
        }

        public SourceCodePropertiesBuilder includes(Collection<? extends String> includes) {
            if (includes == null) {
                throw new NullPointerException("includes cannot be null");
            }
            if (this.includes == null) {
                this.includes = new ArrayList();
            }
            this.includes.addAll(includes);
            return this;
        }

        public SourceCodePropertiesBuilder clearIncludes() {
            if (this.includes != null) {
                this.includes.clear();
            }
            return this;
        }

        public SourceCodePropertiesBuilder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public SourceCodePropertiesBuilder lineEnding(LineEnding lineEnding) {
            this.lineEnding = lineEnding;
            return this;
        }

        public SourceCodeProperties build() {
            List<String> includes;
            List<String> excludes;
            switch (this.excludes == null ? 0 : this.excludes.size()) {
                case 0: {
                    excludes = Collections.emptyList();
                    break;
                }
                case 1: {
                    excludes = Collections.singletonList(this.excludes.get(0));
                    break;
                }
                default: {
                    excludes = Collections.unmodifiableList(new ArrayList<String>(this.excludes));
                }
            }
            switch (this.includes == null ? 0 : this.includes.size()) {
                case 0: {
                    includes = Collections.emptyList();
                    break;
                }
                case 1: {
                    includes = Collections.singletonList(this.includes.get(0));
                    break;
                }
                default: {
                    includes = Collections.unmodifiableList(new ArrayList<String>(this.includes));
                }
            }
            return new SourceCodeProperties(excludes, includes, this.encoding, this.lineEnding);
        }

        public String toString() {
            return "SourceCodeProperties.SourceCodePropertiesBuilder(excludes=" + this.excludes + ", includes=" + this.includes + ", encoding=" + this.encoding + ", lineEnding=" + this.lineEnding + ")";
        }
    }
}

