/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.config;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludeExcludeHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncludeExcludeHelpers.class);
    public static final List<String> DEFAULT_INCLUDES_JAVA = Arrays.asList("glob:**/*.java");

    protected IncludeExcludeHelpers() {
    }

    public static Optional<PathMatcher> findMatching(List<PathMatcher> includeMatchers, Path fileName) {
        return includeMatchers.stream().filter(pm -> pm.matches(fileName)).findFirst();
    }

    public static List<PathMatcher> prepareMatcher(FileSystem fs, Collection<String> globOrRegex) {
        return globOrRegex.stream().flatMap(r -> {
            Object newPattern;
            if (!((String)r).startsWith("glob:") && !((String)r).startsWith("regex:")) {
                newPattern = "glob:" + (String)r;
                LOGGER.info("We implied glob from implicit syntax: {} -> {}", r, newPattern);
                r = newPattern;
            }
            if ("\\".equals(fs.getSeparator())) {
                newPattern = ((String)r).replace("/", "\\\\");
                LOGGER.info("File.separator='{}' so we switched regex to: {}", (Object)fs.getSeparator(), newPattern);
            } else {
                newPattern = r;
            }
            if (((String)r).startsWith("glob:**/")) {
                String patternFromRoot = "glob:" + ((String)r).substring("glob:**/".length());
                return Stream.of(newPattern, patternFromRoot);
            }
            return Stream.of(newPattern);
        }).map(r -> {
            try {
                return fs.getPathMatcher((String)r);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Invalid regex: " + r, e);
            }
        }).collect(Collectors.toList());
    }
}

