/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.plugins;

import java.nio.channels.AsynchronousChannelGroup;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.extension.plugins.AbstractPlugin;
import org.smartboot.socket.transport.AioQuickClient;
import org.smartboot.socket.transport.AioSession;

class ReconnectPlugin
extends AbstractPlugin {
    private final AsynchronousChannelGroup asynchronousChannelGroup;
    private final AioQuickClient client;
    private boolean shutdown = false;

    public ReconnectPlugin(AioQuickClient client) {
        this(client, null);
    }

    public ReconnectPlugin(AioQuickClient client, AsynchronousChannelGroup asynchronousChannelGroup) {
        this.client = client;
        this.asynchronousChannelGroup = asynchronousChannelGroup;
    }

    @Override
    public void stateEvent(StateMachineEnum stateMachineEnum, AioSession session, Throwable throwable) {
        if (stateMachineEnum != StateMachineEnum.SESSION_CLOSED || this.shutdown) {
            return;
        }
        try {
            if (this.asynchronousChannelGroup == null) {
                this.client.start();
            } else {
                this.client.start(this.asynchronousChannelGroup);
            }
        }
        catch (Exception e) {
            this.shutdown = true;
            e.printStackTrace();
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }
}

