/*
 * Decompiled with CFR 0.152.
 */
package jadx.zip.security;

import jadx.zip.IZipEntry;
import jadx.zip.security.IJadxZipSecurity;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxZipSecurity
implements IJadxZipSecurity {
    private static final Logger LOG = LoggerFactory.getLogger(JadxZipSecurity.class);
    private static final Path CWD = Paths.get(".", new String[0]).toAbsolutePath().normalize();
    private int zipBombDetectionFactor = 100;
    private int zipBombMinUncompressedSize = 0x1900000;
    private int maxEntriesCount = 100000;
    private boolean useLimitedDataStream = true;

    @Override
    public boolean isValidEntry(IZipEntry entry) {
        return this.isValidEntryName(entry.getName()) && !this.isZipBomb(entry);
    }

    @Override
    public boolean useLimitedDataStream() {
        return this.useLimitedDataStream;
    }

    @Override
    public int getMaxEntriesCount() {
        return this.maxEntriesCount;
    }

    @Override
    public boolean isValidEntryName(String entryName) {
        if (entryName.contains("..") && (entryName.contains("../") || entryName.contains("..\\"))) {
            LOG.error("Path traversal attack detected in entry: '{}'", (Object)entryName);
            return false;
        }
        try {
            Path entryPath = CWD.resolve(entryName).normalize();
            if (entryPath.startsWith(CWD)) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.error("Invalid file name or path traversal attack detected: {} - error: {}", (Object)entryName, (Object)e.getMessage());
            return false;
        }
        LOG.error("Invalid file name or path traversal attack detected: {}", (Object)entryName);
        return false;
    }

    @Override
    public boolean isInSubDirectory(File baseDir, File file) {
        try {
            return JadxZipSecurity.isInSubDirectoryInternal(baseDir.getCanonicalFile(), file.getCanonicalFile());
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isZipBomb(IZipEntry entry) {
        boolean possibleZipBomb;
        long compressedSize = entry.getCompressedSize();
        long uncompressedSize = entry.getUncompressedSize();
        boolean invalidSize = compressedSize < 0L || uncompressedSize < 0L;
        boolean bl = possibleZipBomb = uncompressedSize >= (long)this.zipBombMinUncompressedSize && compressedSize * (long)this.zipBombDetectionFactor < uncompressedSize;
        if (invalidSize || possibleZipBomb) {
            LOG.error("Potential zip bomb attack detected, invalid sizes: compressed {}, uncompressed {}, name {}", new Object[]{compressedSize, uncompressedSize, entry.getName()});
            return true;
        }
        return false;
    }

    private static boolean isInSubDirectoryInternal(File baseDir, File file) {
        File current = file;
        while (current != null) {
            if (current.equals(baseDir)) {
                return true;
            }
            current = current.getParentFile();
        }
        return false;
    }

    public void setMaxEntriesCount(int maxEntriesCount) {
        this.maxEntriesCount = maxEntriesCount;
    }

    public void setZipBombDetectionFactor(int zipBombDetectionFactor) {
        this.zipBombDetectionFactor = zipBombDetectionFactor;
    }

    public void setZipBombMinUncompressedSize(int zipBombMinUncompressedSize) {
        this.zipBombMinUncompressedSize = zipBombMinUncompressedSize;
    }

    public void setUseLimitedDataStream(boolean useLimitedDataStream) {
        this.useLimitedDataStream = useLimitedDataStream;
    }
}

