/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.xapk;

import jadx.api.ResourceFile;
import jadx.api.ResourcesLoader;
import jadx.api.plugins.CustomResourcesLoader;
import jadx.api.plugins.JadxPluginContext;
import jadx.api.plugins.input.ICodeLoader;
import jadx.api.plugins.input.JadxCodeInput;
import jadx.api.plugins.input.data.impl.EmptyCodeLoader;
import jadx.plugins.input.dex.DexInputPlugin;
import jadx.plugins.input.xapk.XApkLoader;
import jadx.plugins.input.xapk.data.XApkData;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class XApkCustomInput
implements JadxCodeInput,
CustomResourcesLoader {
    private final JadxPluginContext context;
    private final XApkLoader loader;

    public XApkCustomInput(JadxPluginContext context, XApkLoader loader) {
        this.context = context;
        this.loader = loader;
    }

    public ICodeLoader loadFiles(List<Path> input) {
        ArrayList<Path> apks = new ArrayList<Path>();
        for (Path inputPath : input) {
            XApkData data = this.loader.checkAndLoad(inputPath);
            if (data == null) continue;
            apks.addAll(data.getApks());
        }
        if (apks.isEmpty()) {
            return EmptyCodeLoader.INSTANCE;
        }
        DexInputPlugin dexInputPlugin = (DexInputPlugin)this.context.plugins().getInstance(DexInputPlugin.class);
        return dexInputPlugin.loadFiles(apks);
    }

    public boolean load(ResourcesLoader resLoader, List<ResourceFile> list, File file) {
        XApkData xApkData = this.loader.checkAndLoad(file.toPath());
        if (xApkData == null) {
            return false;
        }
        for (Path apkPath : xApkData.getApks()) {
            resLoader.defaultLoadFile(list, apkPath.toFile(), String.valueOf(apkPath.getFileName()) + "/");
        }
        for (Path filePath : xApkData.getFiles()) {
            resLoader.defaultLoadFile(list, filePath.toFile(), "");
        }
        return true;
    }

    public void close() throws IOException {
    }
}

