/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.xapk;

import com.google.gson.Gson;
import jadx.api.plugins.utils.ZipSecurity;
import jadx.core.utils.files.FileUtils;
import jadx.plugins.input.xapk.XapkManifest;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Ljadx/plugins/input/xapk/XapkUtils;", "", "()V", "getManifest", "Ljadx/plugins/input/xapk/XapkManifest;", "file", "Ljava/io/File;", "isSupported", "", "manifest", "jadx-xapk-input"})
public final class XapkUtils {
    @NotNull
    public static final XapkUtils INSTANCE = new XapkUtils();

    private XapkUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final XapkManifest getManifest(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!FileUtils.isZipFile((File)file)) {
            return null;
        }
        try {
            Closeable closeable = new ZipFile(file);
            Throwable throwable = null;
            try {
                XapkManifest xapkManifest;
                ZipEntry zipEntry;
                ZipFile zip = (ZipFile)closeable;
                boolean bl = false;
                Object object = zip.getEntry("manifest.json");
                if (object == null) {
                    XapkManifest xapkManifest2 = null;
                    return xapkManifest2;
                }
                Intrinsics.checkNotNull((Object)zipEntry);
                ZipEntry manifestEntry = object;
                object = new InputStreamReader(ZipSecurity.getInputStreamForEntry((ZipFile)zip, (ZipEntry)manifestEntry));
                Throwable throwable2 = null;
                try {
                    InputStreamReader it = (InputStreamReader)object;
                    boolean bl2 = false;
                    xapkManifest = (XapkManifest)new Gson().fromJson((Reader)it, XapkManifest.class);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                }
                XapkManifest xapkManifest3 = xapkManifest;
                return xapkManifest3;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public final boolean isSupported(@NotNull XapkManifest manifest) {
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        return manifest.getXapkVersion() == 2 && !((Collection)manifest.getSplitApks()).isEmpty();
    }
}

