/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.smali;

import com.android.tools.smali.smali.SmaliOptions;
import jadx.plugins.input.dex.utils.IDexData;
import jadx.plugins.input.dex.utils.SimpleDexData;
import jadx.plugins.input.smali.SmaliInputOptions;
import jadx.plugins.input.smali.SmaliUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmaliConvert {
    private static final Logger LOG = LoggerFactory.getLogger(SmaliConvert.class);
    private final List<IDexData> dexData = new ArrayList<IDexData>();

    public boolean execute(List<Path> input, SmaliInputOptions options) {
        List<Path> smaliFiles = this.filterSmaliFiles(input);
        if (smaliFiles.isEmpty()) {
            return false;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            boolean success;
            SmaliConvert.collectSystemErrors(out, () -> this.compile(smaliFiles, options));
            boolean bl = success = out.size() == 0;
            if (!success) {
                LOG.error("Smali error:\n{}", (Object)out);
            }
        }
        catch (Exception e) {
            LOG.error("Smali process error", (Throwable)e);
        }
        return !this.dexData.isEmpty();
    }

    private void compile(List<Path> inputFiles, SmaliInputOptions options) {
        SmaliOptions smaliOptions = new SmaliOptions();
        smaliOptions.apiLevel = options.getApiLevel();
        smaliOptions.verboseErrors = true;
        smaliOptions.allowOdexOpcodes = false;
        smaliOptions.printTokens = false;
        int threads = options.getThreads();
        LOG.debug("Compiling smali files: {}, threads: {}", (Object)inputFiles.size(), (Object)threads);
        long start = System.currentTimeMillis();
        if (threads == 1) {
            for (Path inputFile : inputFiles) {
                this.assemble(inputFile, smaliOptions);
            }
        } else {
            try {
                ExecutorService executor = Executors.newFixedThreadPool(threads);
                for (Path inputFile : inputFiles) {
                    executor.execute(() -> this.assemble(inputFile, smaliOptions));
                }
                executor.shutdown();
                executor.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                LOG.error("Smali compile interrupted", (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Smali compile done in: {}ms", (Object)(System.currentTimeMillis() - start));
        }
    }

    private void assemble(Path inputFile, SmaliOptions smaliOptions) {
        String fileName = inputFile.toAbsolutePath().toString();
        try (BufferedReader reader = Files.newBufferedReader(inputFile);){
            byte[] assemble = SmaliUtils.assemble(reader, smaliOptions);
            this.dexData.add((IDexData)new SimpleDexData(fileName, assemble));
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to compile: " + fileName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectSystemErrors(OutputStream out, Runnable exec) {
        PrintStream systemErr = System.err;
        try (PrintStream err = new PrintStream(out);){
            System.setErr(err);
            try {
                exec.run();
            }
            catch (Exception e) {
                e.printStackTrace(err);
            }
        }
        finally {
            System.setErr(systemErr);
        }
    }

    private List<Path> filterSmaliFiles(List<Path> input) {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:**.smali");
        return input.stream().filter(matcher::matches).collect(Collectors.toList());
    }

    public List<IDexData> getDexData() {
        return this.dexData;
    }
}

