/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.script.runtime;

import io.github.oshai.kotlinlogging.KLogger;
import jadx.api.JadxArgs;
import jadx.api.JadxDecompiler;
import jadx.api.JavaClass;
import jadx.api.plugins.events.IJadxEvents;
import jadx.api.plugins.pass.JadxPass;
import jadx.plugins.script.runtime.JadxScriptData;
import jadx.plugins.script.runtime.data.Debug;
import jadx.plugins.script.runtime.data.Decompile;
import jadx.plugins.script.runtime.data.Gui;
import jadx.plugins.script.runtime.data.JadxScriptOptions;
import jadx.plugins.script.runtime.data.Rename;
import jadx.plugins.script.runtime.data.Replace;
import jadx.plugins.script.runtime.data.Search;
import jadx.plugins.script.runtime.data.Stages;
import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010J\u001a\u00020K2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020K0MJ\u000e\u0010N\u001a\u00020K2\u0006\u0010O\u001a\u00020PR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0017\u001a\u00020\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0011\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001c\u001a\u00020\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0011\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010!\u001a\u00020\"8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0011\u001a\u0004\b#\u0010$R\u001b\u0010&\u001a\u00020'8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u0011\u001a\u0004\b(\u0010)R\u001b\u0010+\u001a\u00020,8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\u0011\u001a\u0004\b-\u0010.R\u001b\u00100\u001a\u0002018FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u0011\u001a\u0004\b2\u00103R\u0011\u00105\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0011\u00109\u001a\u00020:8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0017\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0011\u0010B\u001a\u00020C8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u0011\u0010F\u001a\u00020G8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010IR\u0011\u0010Q\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\bR\u0010S\u00a8\u0006T"}, d2={"Ljadx/plugins/script/runtime/JadxScriptInstance;", "", "scriptData", "Ljadx/plugins/script/runtime/JadxScriptData;", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "<init>", "(Ljadx/plugins/script/runtime/JadxScriptData;Lio/github/oshai/kotlinlogging/KLogger;)V", "getLog", "()Lio/github/oshai/kotlinlogging/KLogger;", "decompiler", "Ljadx/api/JadxDecompiler;", "options", "Ljadx/plugins/script/runtime/data/JadxScriptOptions;", "getOptions", "()Ljadx/plugins/script/runtime/data/JadxScriptOptions;", "options$delegate", "Lkotlin/Lazy;", "rename", "Ljadx/plugins/script/runtime/data/Rename;", "getRename", "()Ljadx/plugins/script/runtime/data/Rename;", "rename$delegate", "stages", "Ljadx/plugins/script/runtime/data/Stages;", "getStages", "()Ljadx/plugins/script/runtime/data/Stages;", "stages$delegate", "replace", "Ljadx/plugins/script/runtime/data/Replace;", "getReplace", "()Ljadx/plugins/script/runtime/data/Replace;", "replace$delegate", "decompile", "Ljadx/plugins/script/runtime/data/Decompile;", "getDecompile", "()Ljadx/plugins/script/runtime/data/Decompile;", "decompile$delegate", "search", "Ljadx/plugins/script/runtime/data/Search;", "getSearch", "()Ljadx/plugins/script/runtime/data/Search;", "search$delegate", "gui", "Ljadx/plugins/script/runtime/data/Gui;", "getGui", "()Ljadx/plugins/script/runtime/data/Gui;", "gui$delegate", "debug", "Ljadx/plugins/script/runtime/data/Debug;", "getDebug", "()Ljadx/plugins/script/runtime/data/Debug;", "debug$delegate", "events", "Ljadx/api/plugins/events/IJadxEvents;", "getEvents", "()Ljadx/api/plugins/events/IJadxEvents;", "args", "Ljadx/api/JadxArgs;", "getArgs", "()Ljadx/api/JadxArgs;", "classes", "", "Ljadx/api/JavaClass;", "getClasses", "()Ljava/util/List;", "scriptFile", "Ljava/io/File;", "getScriptFile", "()Ljava/io/File;", "scriptName", "", "getScriptName", "()Ljava/lang/String;", "afterLoad", "", "block", "Lkotlin/Function0;", "addPass", "pass", "Ljadx/api/plugins/pass/JadxPass;", "internalDecompiler", "getInternalDecompiler", "()Ljadx/api/JadxDecompiler;", "jadx-script-runtime"})
public final class JadxScriptInstance {
    @NotNull
    private final JadxScriptData scriptData;
    @NotNull
    private final KLogger log;
    @NotNull
    private final JadxDecompiler decompiler;
    @NotNull
    private final Lazy options$delegate;
    @NotNull
    private final Lazy rename$delegate;
    @NotNull
    private final Lazy stages$delegate;
    @NotNull
    private final Lazy replace$delegate;
    @NotNull
    private final Lazy decompile$delegate;
    @NotNull
    private final Lazy search$delegate;
    @NotNull
    private final Lazy gui$delegate;
    @NotNull
    private final Lazy debug$delegate;

    public JadxScriptInstance(@NotNull JadxScriptData scriptData, @NotNull KLogger log) {
        Intrinsics.checkNotNullParameter((Object)scriptData, (String)"scriptData");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.scriptData = scriptData;
        this.log = log;
        this.decompiler = this.scriptData.getJadxInstance();
        this.options$delegate = LazyKt.lazy(() -> JadxScriptInstance.options_delegate$lambda$0(this));
        this.rename$delegate = LazyKt.lazy(() -> JadxScriptInstance.rename_delegate$lambda$1(this));
        this.stages$delegate = LazyKt.lazy(() -> JadxScriptInstance.stages_delegate$lambda$2(this));
        this.replace$delegate = LazyKt.lazy(() -> JadxScriptInstance.replace_delegate$lambda$3(this));
        this.decompile$delegate = LazyKt.lazy(() -> JadxScriptInstance.decompile_delegate$lambda$4(this));
        this.search$delegate = LazyKt.lazy(() -> JadxScriptInstance.search_delegate$lambda$5(this));
        this.gui$delegate = LazyKt.lazy(() -> JadxScriptInstance.gui_delegate$lambda$6(this));
        this.debug$delegate = LazyKt.lazy(() -> JadxScriptInstance.debug_delegate$lambda$7(this));
    }

    @NotNull
    public final KLogger getLog() {
        return this.log;
    }

    @NotNull
    public final JadxScriptOptions getOptions() {
        Lazy lazy = this.options$delegate;
        return (JadxScriptOptions)lazy.getValue();
    }

    @NotNull
    public final Rename getRename() {
        Lazy lazy = this.rename$delegate;
        return (Rename)lazy.getValue();
    }

    @NotNull
    public final Stages getStages() {
        Lazy lazy = this.stages$delegate;
        return (Stages)lazy.getValue();
    }

    @NotNull
    public final Replace getReplace() {
        Lazy lazy = this.replace$delegate;
        return (Replace)lazy.getValue();
    }

    @NotNull
    public final Decompile getDecompile() {
        Lazy lazy = this.decompile$delegate;
        return (Decompile)lazy.getValue();
    }

    @NotNull
    public final Search getSearch() {
        Lazy lazy = this.search$delegate;
        return (Search)lazy.getValue();
    }

    @NotNull
    public final Gui getGui() {
        Lazy lazy = this.gui$delegate;
        return (Gui)lazy.getValue();
    }

    @NotNull
    public final Debug getDebug() {
        Lazy lazy = this.debug$delegate;
        return (Debug)lazy.getValue();
    }

    @NotNull
    public final IJadxEvents getEvents() {
        IJadxEvents iJadxEvents = this.scriptData.getPluginContext().events();
        Intrinsics.checkNotNullExpressionValue((Object)iJadxEvents, (String)"events(...)");
        return iJadxEvents;
    }

    @NotNull
    public final JadxArgs getArgs() {
        JadxArgs jadxArgs = this.decompiler.getArgs();
        Intrinsics.checkNotNullExpressionValue((Object)jadxArgs, (String)"getArgs(...)");
        return jadxArgs;
    }

    @NotNull
    public final List<JavaClass> getClasses() {
        List list = this.decompiler.getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getClasses(...)");
        return list;
    }

    @NotNull
    public final File getScriptFile() {
        return this.scriptData.getScriptFile();
    }

    @NotNull
    public final String getScriptName() {
        return this.scriptData.getScriptName();
    }

    public final void afterLoad(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.scriptData.getAfterLoad().add(block);
    }

    public final void addPass(@NotNull JadxPass pass) {
        Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
        this.scriptData.getPluginContext().addPass(pass);
    }

    @ApiStatus.Internal
    @NotNull
    public final JadxDecompiler getInternalDecompiler() {
        return this.decompiler;
    }

    private static final JadxScriptOptions options_delegate$lambda$0(JadxScriptInstance this$0) {
        return new JadxScriptOptions(this$0, this$0.scriptData.getOptions());
    }

    private static final Rename rename_delegate$lambda$1(JadxScriptInstance this$0) {
        return new Rename(this$0);
    }

    private static final Stages stages_delegate$lambda$2(JadxScriptInstance this$0) {
        return new Stages(this$0);
    }

    private static final Replace replace_delegate$lambda$3(JadxScriptInstance this$0) {
        return new Replace(this$0);
    }

    private static final Decompile decompile_delegate$lambda$4(JadxScriptInstance this$0) {
        return new Decompile(this$0);
    }

    private static final Search search_delegate$lambda$5(JadxScriptInstance this$0) {
        return new Search(this$0);
    }

    private static final Gui gui_delegate$lambda$6(JadxScriptInstance this$0) {
        return new Gui(this$0, this$0.scriptData.getPluginContext().getGuiContext());
    }

    private static final Debug debug_delegate$lambda$7(JadxScriptInstance this$0) {
        return new Debug(this$0);
    }
}

