/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.raung;

import io.github.skylot.raung.asm.RaungAsm;
import java.io.Closeable;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaungConvert
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RaungConvert.class);
    @Nullable
    private Path tmpJar;

    public boolean execute(List<Path> input) {
        List<Path> raungInputs = this.filterRaungFiles(input);
        if (raungInputs.isEmpty()) {
            return false;
        }
        try {
            this.tmpJar = Files.createTempFile("jadx-raung-", ".jar", new FileAttribute[0]);
            RaungAsm.create().output(this.tmpJar).inputs(input).execute();
            return true;
        }
        catch (Exception e) {
            LOG.error("Raung process error", (Throwable)e);
            this.close();
            return false;
        }
    }

    private List<Path> filterRaungFiles(List<Path> input) {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:**.raung");
        return input.stream().filter(matcher::matches).collect(Collectors.toList());
    }

    public List<Path> getFiles() {
        if (this.tmpJar == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.tmpJar);
    }

    @Override
    public void close() {
        try {
            if (this.tmpJar != null) {
                Files.deleteIfExists(this.tmpJar);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to remove tmp jar file: {}", (Object)this.tmpJar, (Object)e);
        }
    }
}

