/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.tools.resolvers.github;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import jadx.plugins.tools.resolvers.github.LocationInfo;
import jadx.plugins.tools.resolvers.github.data.Release;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;

public class GithubTools {
    private static final String GITHUB_API_URL = "https://api.github.com/";
    private static final Type RELEASE_TYPE = new TypeToken<Release>(){}.getType();
    private static final Type RELEASE_LIST_TYPE = new TypeToken<List<Release>>(){}.getType();

    public static Release fetchRelease(LocationInfo info) {
        String projectUrl = "https://api.github.com/repos/" + info.getOwner() + "/" + info.getProject();
        String version = info.getVersion();
        if (version == null) {
            return (Release)GithubTools.get(projectUrl + "/releases/latest", RELEASE_TYPE);
        }
        List releases = (List)GithubTools.get(projectUrl + "/releases", RELEASE_LIST_TYPE);
        return releases.stream().filter(r -> r.getName().equals(version)).findFirst().orElseThrow(() -> new RuntimeException("Release with version: " + version + " not found. Available versions: " + releases.stream().map(Release::getName).collect(Collectors.joining(", "))));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T get(String url, Type type) {
        HttpURLConnection con;
        try {
            con = (HttpURLConnection)URI.create(url).toURL().openConnection();
            con.setRequestMethod("GET");
            int code = con.getResponseCode();
            if (code != 200) {
                throw new RuntimeException("Request failed, response: " + code + ", url: " + url);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Request failed, url: " + url, e);
        }
        try (InputStreamReader reader = new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8);){
            Object object = new Gson().fromJson((Reader)reader, type);
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse response, url: " + url, e);
        }
    }
}

