/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.kotlin.metadata.pass;

import jadx.api.plugins.pass.JadxPassInfo;
import jadx.api.plugins.pass.impl.OrderedJadxPassInfo;
import jadx.api.plugins.pass.types.JadxDecompilePass;
import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AttrNode;
import jadx.core.dex.attributes.nodes.RenameReasonAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.plugins.kotlin.metadata.KotlinMetadataOptions;
import jadx.plugins.kotlin.metadata.model.CompanionRename;
import jadx.plugins.kotlin.metadata.model.FieldRename;
import jadx.plugins.kotlin.metadata.model.MethodArgRename;
import jadx.plugins.kotlin.metadata.model.MethodRename;
import jadx.plugins.kotlin.metadata.model.ToStringRename;
import jadx.plugins.kotlin.metadata.utils.KmClassWrapper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0013\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljadx/plugins/kotlin/metadata/pass/KotlinMetadataDecompilePass;", "Ljadx/api/plugins/pass/types/JadxDecompilePass;", "options", "Ljadx/plugins/kotlin/metadata/KotlinMetadataOptions;", "(Ljadx/plugins/kotlin/metadata/KotlinMetadataOptions;)V", "fixDataClass", "", "wrapper", "Ljadx/plugins/kotlin/metadata/utils/KmClassWrapper;", "getInfo", "Ljadx/api/plugins/pass/JadxPassInfo;", "init", "root", "Ljadx/core/dex/nodes/RootNode;", "renameCompanion", "renameFields", "renameGetters", "renameMethodArgs", "renameToString", "visit", "", "cls", "Ljadx/core/dex/nodes/ClassNode;", "mth", "Ljadx/core/dex/nodes/MethodNode;", "Companion", "jadx-kotlin-metadata"})
@SourceDebugExtension(value={"SMAP\nKotlinMetadataDecompilePass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMetadataDecompilePass.kt\njadx/plugins/kotlin/metadata/pass/KotlinMetadataDecompilePass\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,143:1\n1855#2,2:144\n1855#2,2:147\n1855#2,2:150\n1855#2,2:152\n1855#2,2:154\n215#3:146\n216#3:149\n*S KotlinDebug\n*F\n+ 1 KotlinMetadataDecompilePass.kt\njadx/plugins/kotlin/metadata/pass/KotlinMetadataDecompilePass\n*L\n33#1:144,2\n53#1:147,2\n63#1:150,2\n116#1:152,2\n127#1:154,2\n52#1:146\n52#1:149\n*E\n"})
public final class KotlinMetadataDecompilePass
implements JadxDecompilePass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinMetadataOptions options;
    @NotNull
    private static final String METADATA_REASON = "from kotlin metadata";
    @NotNull
    private static final String COMPANION_FIELD = "INSTANCE";
    @NotNull
    private static final String COMPANION_CLASS = "Companion";
    @NotNull
    private static final String TO_STRING_REASON = "from toString";
    @NotNull
    private static final String GETTER_REASON = "from getter";

    public KotlinMetadataDecompilePass(@NotNull KotlinMetadataOptions options) {
        Intrinsics.checkNotNullParameter((Object)((Object)options), (String)"options");
        this.options = options;
    }

    @NotNull
    public JadxPassInfo getInfo() {
        OrderedJadxPassInfo orderedJadxPassInfo = new OrderedJadxPassInfo("KotlinMetadataDecompile", "Use kotlin.Metadata annotation perform various renames").before("CodeRenameVisitor");
        Intrinsics.checkNotNullExpressionValue((Object)orderedJadxPassInfo, (String)"before(...)");
        return (JadxPassInfo)orderedJadxPassInfo;
    }

    public void init(@NotNull RootNode root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
    }

    public boolean visit(@NotNull ClassNode cls) {
        Intrinsics.checkNotNullParameter((Object)cls, (String)"cls");
        List list = cls.getInnerClasses();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInnerClasses(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassNode p0 = (ClassNode)element$iv;
            boolean bl = false;
            this.visit(p0);
        }
        KmClassWrapper kmClassWrapper = KmClassWrapper.Companion.getWrapper(cls);
        if (kmClassWrapper == null) {
            return false;
        }
        KmClassWrapper wrapper = kmClassWrapper;
        if (this.options.isMethodArgs()) {
            this.renameMethodArgs(wrapper);
        }
        if (this.options.isFields()) {
            this.renameFields(wrapper);
        }
        if (this.options.isCompanion()) {
            this.renameCompanion(wrapper);
        }
        if (this.options.isDataClass()) {
            this.fixDataClass(wrapper);
        }
        if (this.options.isToString()) {
            this.renameToString(wrapper);
        }
        if (this.options.isGetters()) {
            this.renameGetters(wrapper);
        }
        return false;
    }

    public void visit(@Nullable MethodNode mth) {
    }

    private final void renameMethodArgs(KmClassWrapper wrapper) {
        Map<MethodNode, List<MethodArgRename>> args;
        Map<MethodNode, List<MethodArgRename>> $this$forEach$iv = args = wrapper.getMethodArgs();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<MethodNode, List<MethodArgRename>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<MethodNode, List<MethodArgRename>> element$iv;
            Map.Entry<MethodNode, List<MethodArgRename>> entry = element$iv = iterator.next();
            boolean bl = false;
            List<MethodArgRename> list = entry.getValue();
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                MethodArgRename methodArgRename = (MethodArgRename)element$iv2;
                boolean bl2 = false;
                RegisterArg rArg = methodArgRename.component1();
                String alias = methodArgRename.component2();
                RenameReasonAttr.forNode((AttrNode)((AttrNode)rArg)).append(METADATA_REASON);
                rArg.setName(alias);
            }
        }
    }

    private final void renameFields(KmClassWrapper wrapper) {
        List<FieldRename> fields = wrapper.getFields();
        Iterable $this$forEach$iv = fields;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FieldRename fieldRename = (FieldRename)element$iv;
            boolean bl = false;
            FieldNode field = fieldRename.component1();
            String alias = fieldRename.component2();
            if (field.contains(AFlag.DONT_RENAME)) continue;
            RenameReasonAttr.forNode((AttrNode)((AttrNode)field)).append(METADATA_REASON);
            field.rename(alias);
        }
    }

    private final void renameCompanion(KmClassWrapper wrapper) {
        block3: {
            CompanionRename companion;
            CompanionRename companionRename = companion = wrapper.getCompanion();
            if (companionRename == null) break block3;
            CompanionRename $this$renameCompanion_u24lambda_u243 = companionRename;
            boolean bl = false;
            if (!$this$renameCompanion_u24lambda_u243.getField().contains(AFlag.DONT_RENAME)) {
                RenameReasonAttr.forNode((AttrNode)((AttrNode)$this$renameCompanion_u24lambda_u243.getField())).append(METADATA_REASON);
                $this$renameCompanion_u24lambda_u243.getField().rename(COMPANION_FIELD);
            }
            if (!$this$renameCompanion_u24lambda_u243.getCls().contains(AFlag.DONT_RENAME)) {
                RenameReasonAttr.forNode((AttrNode)((AttrNode)$this$renameCompanion_u24lambda_u243.getCls())).append(METADATA_REASON);
                $this$renameCompanion_u24lambda_u243.getCls().rename(COMPANION_CLASS);
            }
            if ($this$renameCompanion_u24lambda_u243.getHide()) {
                $this$renameCompanion_u24lambda_u243.getField().add(AFlag.DONT_GENERATE);
                $this$renameCompanion_u24lambda_u243.getCls().add(AFlag.DONT_GENERATE);
                $this$renameCompanion_u24lambda_u243.getCls().add(AFlag.DONT_INLINE);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void fixDataClass(KmClassWrapper wrapper) {
        boolean isData = wrapper.isDataClass();
        ClassNode $this$fixDataClass_u24lambda_u245 = wrapper.getCls();
        boolean bl = false;
        if (isData != $this$fixDataClass_u24lambda_u245.getAccessFlags().isData()) {
            void $this$fixDataClass_u24lambda_u245_u24lambda_u244;
            AccessInfo accessInfo = $this$fixDataClass_u24lambda_u245.getAccessFlags();
            ClassNode classNode = $this$fixDataClass_u24lambda_u245;
            boolean bl2 = false;
            classNode.setAccessFlags(isData ? $this$fixDataClass_u24lambda_u245_u24lambda_u244.add(262144) : $this$fixDataClass_u24lambda_u245_u24lambda_u244.remove(262144));
        }
    }

    private final void renameToString(KmClassWrapper wrapper) {
        block3: {
            ToStringRename toString;
            ToStringRename toStringRename = toString = wrapper.parseToString();
            if (toStringRename == null) break block3;
            ToStringRename $this$renameToString_u24lambda_u248 = toStringRename;
            boolean bl = false;
            String string = $this$renameToString_u24lambda_u248.getClsAlias();
            if (string != null) {
                String alias = string;
                boolean bl2 = false;
                if (NameMapper.isValidIdentifier((String)alias) && !$this$renameToString_u24lambda_u248.getCls().contains(AFlag.DONT_RENAME)) {
                    RenameReasonAttr.forNode((AttrNode)((AttrNode)$this$renameToString_u24lambda_u248.getCls())).append(TO_STRING_REASON);
                    $this$renameToString_u24lambda_u248.getCls().rename(alias);
                }
            }
            Iterable $this$forEach$iv = $this$renameToString_u24lambda_u248.getFields();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FieldRename fieldRename = (FieldRename)element$iv;
                boolean bl3 = false;
                FieldNode field = fieldRename.component1();
                String alias = fieldRename.component2();
                if (!NameMapper.isValidIdentifier((String)alias) || field.contains(AFlag.DONT_RENAME)) continue;
                RenameReasonAttr.forNode((AttrNode)((AttrNode)field)).append(TO_STRING_REASON);
                field.rename(alias);
            }
        }
    }

    private final void renameGetters(KmClassWrapper wrapper) {
        List<MethodRename> getters = wrapper.getGetters();
        Iterable $this$forEach$iv = getters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MethodRename methodRename = (MethodRename)element$iv;
            boolean bl = false;
            MethodNode mth = methodRename.component1();
            String alias = methodRename.component2();
            if (mth.contains(AFlag.DONT_RENAME)) continue;
            RenameReasonAttr.forNode((AttrNode)((AttrNode)mth)).append(GETTER_REASON);
            mth.rename(alias);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljadx/plugins/kotlin/metadata/pass/KotlinMetadataDecompilePass$Companion;", "", "()V", "COMPANION_CLASS", "", "COMPANION_FIELD", "GETTER_REASON", "METADATA_REASON", "TO_STRING_REASON", "jadx-kotlin-metadata"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

