/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data.attributes.types;

import jadx.api.plugins.input.data.annotations.AnnotationVisibility;
import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.api.plugins.input.data.attributes.types.MethodParamsAttr;
import jadx.api.plugins.utils.Utils;
import jadx.plugins.input.java.data.attributes.IJavaAttribute;
import jadx.plugins.input.java.data.attributes.IJavaAttributeReader;
import jadx.plugins.input.java.data.attributes.JavaAttrStorage;
import jadx.plugins.input.java.data.attributes.JavaAttrType;
import jadx.plugins.input.java.data.attributes.types.JavaAnnotationsAttr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JavaParamAnnsAttr
implements IJavaAttribute {
    private final List<List<IAnnotation>> list;

    public JavaParamAnnsAttr(List<List<IAnnotation>> list) {
        this.list = list;
    }

    public List<List<IAnnotation>> getList() {
        return this.list;
    }

    public static IJavaAttributeReader reader(AnnotationVisibility visibility) {
        return (clsData, reader) -> {
            int len = reader.readU1();
            ArrayList<List<IAnnotation>> list = new ArrayList<List<IAnnotation>>(len);
            for (int i = 0; i < len; ++i) {
                list.add(JavaAnnotationsAttr.readAnnotationsList(visibility, clsData, reader));
            }
            return new JavaParamAnnsAttr(list);
        };
    }

    public static MethodParamsAttr merge(JavaAttrStorage storage) {
        JavaParamAnnsAttr runtimeAnnAttr = storage.get(JavaAttrType.RUNTIME_PARAMETER_ANNOTATIONS);
        JavaParamAnnsAttr buildAnnAttr = storage.get(JavaAttrType.BUILD_PARAMETER_ANNOTATIONS);
        if (runtimeAnnAttr == null && buildAnnAttr == null) {
            return null;
        }
        if (buildAnnAttr == null) {
            return MethodParamsAttr.pack(runtimeAnnAttr.getList());
        }
        if (runtimeAnnAttr == null) {
            return MethodParamsAttr.pack(buildAnnAttr.getList());
        }
        return MethodParamsAttr.pack(JavaParamAnnsAttr.mergeParamLists(runtimeAnnAttr.getList(), buildAnnAttr.getList()));
    }

    private static List<List<IAnnotation>> mergeParamLists(List<List<IAnnotation>> first, List<List<IAnnotation>> second) {
        int firstSize = first.size();
        int secondSize = second.size();
        int size = Math.max(firstSize, secondSize);
        ArrayList<List<IAnnotation>> result = new ArrayList<List<IAnnotation>>(size);
        for (int i = 0; i < size; ++i) {
            List firstList = i < firstSize ? first.get(i) : Collections.emptyList();
            List secondList = i < secondSize ? second.get(i) : Collections.emptyList();
            result.add(Utils.concat(firstList, secondList));
        }
        return result;
    }
}

