/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data.code.decoders;

import jadx.api.plugins.input.insns.Opcode;
import jadx.plugins.input.java.data.DataReader;
import jadx.plugins.input.java.data.code.CodeDecodeState;
import jadx.plugins.input.java.data.code.JavaInsnData;
import jadx.plugins.input.java.data.code.decoders.IJavaInsnDecoder;
import jadx.plugins.input.java.utils.JavaClassParseException;

public class WideDecoder
implements IJavaInsnDecoder {
    private static final int IINC = 132;

    @Override
    public void decode(CodeDecodeState state) {
        DataReader reader = state.reader();
        JavaInsnData insn = state.insn();
        int opcode = reader.readU1();
        if (opcode == 132) {
            int varNum = reader.readU2();
            int constValue = reader.readS2();
            state.local(0, varNum).local(1, varNum).lit(constValue);
            insn.setPayloadSize(5);
            insn.setRegsCount(2);
            insn.setOpcode(Opcode.ADD_INT_LIT);
            return;
        }
        int index = reader.readU2();
        switch (opcode) {
            case 21: 
            case 23: 
            case 25: {
                state.local(1, index).push(0);
                break;
            }
            case 22: 
            case 24: {
                state.local(1, index).pushWide(0);
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                state.pop(1).local(0, index);
                break;
            }
            default: {
                throw new JavaClassParseException("Unexpected opcode in 'wide': 0x" + Integer.toHexString(opcode));
            }
        }
        insn.setPayloadSize(3);
        insn.setRegsCount(2);
        insn.setOpcode(Opcode.MOVE);
    }

    @Override
    public void skip(CodeDecodeState state) {
        DataReader reader = state.reader();
        JavaInsnData insn = state.insn();
        int opcode = reader.readU1();
        if (opcode == 132) {
            reader.skip(4);
            insn.setPayloadSize(5);
        } else {
            reader.skip(2);
            insn.setPayloadSize(3);
        }
    }
}

