/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.javaconvert;

import jadx.api.plugins.JadxPlugin;
import jadx.api.plugins.JadxPluginContext;
import jadx.api.plugins.JadxPluginInfo;
import jadx.api.plugins.JadxPluginInfoBuilder;
import jadx.api.plugins.data.JadxPluginRuntimeData;
import jadx.api.plugins.input.ICodeLoader;
import jadx.api.plugins.input.JadxCodeInput;
import jadx.api.plugins.input.data.impl.EmptyCodeLoader;
import jadx.api.plugins.options.JadxPluginOptions;
import jadx.plugins.input.javaconvert.ConvertResult;
import jadx.plugins.input.javaconvert.JavaConvertLoader;
import jadx.plugins.input.javaconvert.JavaConvertOptions;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.List;

public class JavaConvertPlugin
implements JadxPlugin,
JadxCodeInput {
    public static final String PLUGIN_ID = "java-convert";
    private final JavaConvertOptions options = new JavaConvertOptions();
    private final JavaConvertLoader loader = new JavaConvertLoader(this.options);
    private JadxPluginRuntimeData dexInput;

    public JadxPluginInfo getPluginInfo() {
        return JadxPluginInfoBuilder.pluginId((String)PLUGIN_ID).name("Java Convert").description("Convert .class, .jar and .aar files to dex").provides("java-input").build();
    }

    public void init(JadxPluginContext context) {
        this.dexInput = context.plugins().getById("dex-input");
        context.registerOptions((JadxPluginOptions)this.options);
        context.addCodeInput((JadxCodeInput)this);
    }

    public ICodeLoader loadFiles(List<Path> input) {
        ConvertResult result = this.loader.process(input);
        if (result.isEmpty()) {
            result.close();
            return EmptyCodeLoader.INSTANCE;
        }
        return this.dexInput.loadCodeFiles(result.getConverted(), (Closeable)result);
    }
}

