/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.res;

import jadx.api.ICodeInfo;
import jadx.api.ResourceFile;
import jadx.api.ResourceFileContent;
import jadx.api.ResourceType;
import jadx.core.xmlgen.ResContainer;
import jadx.gui.treemodel.JResource;
import jadx.gui.treemodel.JSubResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ResTableHelper {
    private final List<JResource> roots = new ArrayList<JResource>();
    private final Map<String, JResource> dirs = new HashMap<String, JResource>();
    private final JResource resTableRes;

    public static List<JResource> buildTree(JResource resTableRes, ResContainer resTable) {
        ResTableHelper resTableHelper = new ResTableHelper(resTableRes);
        resTableHelper.process(resTable);
        return resTableHelper.roots;
    }

    private ResTableHelper(JResource resTableRes) {
        this.resTableRes = resTableRes;
    }

    private void process(ResContainer resTable) {
        for (ResContainer subFile : resTable.getSubFiles()) {
            this.loadSubNodes(subFile);
        }
    }

    private void loadSubNodes(ResContainer rc) {
        String name;
        String dir;
        String resName = rc.getName();
        int split = resName.lastIndexOf(47);
        if (split == -1) {
            dir = null;
            name = resName;
        } else {
            dir = resName.substring(0, split);
            name = resName.substring(split + 1);
        }
        ICodeInfo code = rc.getText();
        ResourceFileContent fileContent = new ResourceFileContent(name, ResourceType.XML, code);
        JSubResource resFile = new JSubResource(this.resTableRes, (ResourceFile)fileContent, resName, name, JResource.JResType.FILE);
        this.addResFile(dir, resFile);
        for (ResContainer subFile : rc.getSubFiles()) {
            this.loadSubNodes(subFile);
        }
    }

    private void addResFile(@Nullable String dir, JResource resFile) {
        if (dir == null) {
            this.roots.add(resFile);
            return;
        }
        JResource dirRes = this.dirs.get(dir);
        if (dirRes != null) {
            dirRes.addSubNode(resFile);
            return;
        }
        JResource parentDir = null;
        int splitPos = -1;
        while (true) {
            int prevStart;
            boolean last;
            String path;
            JResource curDir;
            if ((curDir = this.dirs.get(path = (last = (splitPos = dir.indexOf(47, prevStart = splitPos + 1)) == -1) ? dir : dir.substring(0, splitPos))) == null) {
                String dirName = last ? dir.substring(prevStart) : dir.substring(prevStart, splitPos);
                curDir = new JSubResource(this.resTableRes, null, path, dirName, JResource.JResType.DIR);
                this.dirs.put(path, curDir);
                if (parentDir == null) {
                    this.roots.add(curDir);
                } else {
                    parentDir.addSubNode(curDir);
                }
            }
            if (last) {
                curDir.addSubNode(resFile);
                return;
            }
            parentDir = curDir;
        }
    }
}

