/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.plugins;

import jadx.api.JadxArgs;
import jadx.api.JadxDecompiler;
import jadx.api.plugins.loader.JadxPluginLoader;
import jadx.cli.plugins.JadxFilesGetter;
import jadx.core.plugins.AppContext;
import jadx.core.plugins.JadxPluginManager;
import jadx.core.plugins.PluginContext;
import jadx.core.plugins.files.IJadxFilesGetter;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.plugins.CloseablePlugins;
import jadx.plugins.tools.JadxExternalPluginsLoader;
import java.util.ArrayList;
import java.util.Optional;
import java.util.SortedSet;

public class CollectPlugins {
    private final MainWindow mainWindow;

    public CollectPlugins(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    public CloseablePlugins build() {
        Optional<JadxDecompiler> currentDecompiler = this.mainWindow.getWrapper().getCurrentDecompiler();
        if (currentDecompiler.isPresent()) {
            JadxDecompiler decompiler = currentDecompiler.get();
            SortedSet plugins = decompiler.getPluginManager().getResolvedPluginContexts();
            return new CloseablePlugins(new ArrayList<PluginContext>(plugins), null);
        }
        JadxArgs jadxArgs = this.mainWindow.getSettings().toJadxArgs();
        jadxArgs.setFilesGetter((IJadxFilesGetter)JadxFilesGetter.INSTANCE);
        try (JadxDecompiler decompiler = new JadxDecompiler(jadxArgs);){
            JadxPluginManager pluginManager = decompiler.getPluginManager();
            pluginManager.registerAddPluginListener(pluginContext -> {
                AppContext appContext = new AppContext();
                appContext.setGuiContext(null);
                appContext.setFilesGetter(jadxArgs.getFilesGetter());
                pluginContext.setAppContext(appContext);
            });
            pluginManager.load((JadxPluginLoader)new JadxExternalPluginsLoader());
            SortedSet allPlugins = pluginManager.getAllPluginContexts();
            pluginManager.init(allPlugins);
            Runnable closeable = () -> pluginManager.unload(allPlugins);
            CloseablePlugins closeablePlugins = new CloseablePlugins(new ArrayList<PluginContext>(allPlugins), closeable);
            return closeablePlugins;
        }
    }
}

