/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.pkgs;

import jadx.api.JavaPackage;
import jadx.core.dex.info.PackageInfo;
import jadx.core.utils.ListUtils;
import jadx.core.utils.Utils;
import jadx.gui.JadxWrapper;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JPackage;
import jadx.gui.utils.JNodeCache;
import jadx.gui.utils.pkgs.JRenamePackage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PackageHelper.class);
    private static final Comparator<JClass> CLASS_COMPARATOR = Comparator.comparing(JClass::getName, String.CASE_INSENSITIVE_ORDER);
    private static final Comparator<JPackage> PKG_COMPARATOR = Comparator.comparing(JPackage::getName, String.CASE_INSENSITIVE_ORDER);
    private final JadxWrapper wrapper;
    private final JNodeCache nodeCache;
    private List<String> excludedPackages;
    private final Map<PackageInfo, JPackage> pkgInfoMap = new HashMap<PackageInfo, JPackage>();

    public PackageHelper(JadxWrapper wrapper, JNodeCache jNodeCache) {
        this.wrapper = wrapper;
        this.nodeCache = jNodeCache;
    }

    public List<JPackage> getRoots(boolean flatPackages) {
        this.excludedPackages = this.wrapper.getExcludedPackages();
        this.pkgInfoMap.clear();
        if (flatPackages) {
            return this.prepareFlatPackages();
        }
        long start = System.currentTimeMillis();
        List<JPackage> roots = this.prepareHierarchyPackages();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Prepare hierarchy packages in {} ms", (Object)(System.currentTimeMillis() - start));
        }
        return roots;
    }

    public List<JRenamePackage> getRenameNodes(JPackage pkg) {
        ArrayList<JRenamePackage> list = new ArrayList<JRenamePackage>();
        PackageInfo pkgInfo = pkg.getPkg().getPkgNode().getAliasPkgInfo();
        HashSet<String> added = new HashSet<String>();
        do {
            JavaPackage javaPkg;
            JPackage jPkg;
            if ((jPkg = this.pkgInfoMap.get(pkgInfo)) == null || jPkg.isSynthetic() || (javaPkg = jPkg.getPkg()).isDefault()) continue;
            JRenamePackage renamePkg = new JRenamePackage(javaPkg, javaPkg.getRawFullName(), javaPkg.getFullName(), javaPkg.getName());
            if (!added.add(javaPkg.getFullName())) continue;
            list.add(renamePkg);
        } while ((pkgInfo = pkgInfo.getParentPkg()) != null);
        return list;
    }

    private List<JPackage> prepareFlatPackages() {
        ArrayList<JPackage> list = new ArrayList<JPackage>();
        for (JavaPackage javaPkg : this.wrapper.getPackages()) {
            if (!javaPkg.isLeaf() && javaPkg.getClasses().isEmpty()) continue;
            JPackage pkg = this.buildJPackage(javaPkg, false);
            pkg.setName(javaPkg.getFullName());
            list.add(pkg);
            this.pkgInfoMap.put(javaPkg.getPkgNode().getAliasPkgInfo(), pkg);
        }
        list.sort(PKG_COMPARATOR);
        return list;
    }

    private List<JPackage> prepareHierarchyPackages() {
        JPackage root = JPackage.makeTmpRoot();
        List<JavaPackage> packages = this.wrapper.getPackages();
        ArrayList<JPackage> jPackages = new ArrayList<JPackage>(packages.size());
        for (JavaPackage javaPkg : packages) {
            JPackage jPkg = this.buildJPackage(javaPkg, false);
            jPackages.add(jPkg);
            PackageInfo aliasPkgInfo = javaPkg.getPkgNode().getAliasPkgInfo();
            jPkg.setName(aliasPkgInfo.getName());
            this.pkgInfoMap.put(aliasPkgInfo, jPkg);
            if (!aliasPkgInfo.isRoot()) continue;
            root.getSubPackages().add(jPkg);
        }
        for (JPackage jPkg : jPackages) {
            if (!jPkg.getPkg().isLeaf()) continue;
            this.buildLeafPath(jPkg, root, this.pkgInfoMap);
        }
        ArrayList<JPackage> toMerge = new ArrayList<JPackage>();
        PackageHelper.traverseMiddlePackages(root, toMerge);
        Utils.treeDfsVisit((Object)root, JPackage::getSubPackages, v -> v.getSubPackages().sort(PKG_COMPARATOR));
        return root.getSubPackages();
    }

    private void buildLeafPath(JPackage jPkg, JPackage root, Map<PackageInfo, JPackage> pkgMap) {
        JPackage currentJPkg = jPkg;
        PackageInfo current = jPkg.getPkg().getPkgNode().getAliasPkgInfo();
        while ((current = current.getParentPkg()) != null) {
            String pkgName;
            List<JPackage> subPackages;
            JPackage parentJPkg = pkgMap.get(current);
            if (parentJPkg == null) {
                parentJPkg = this.buildJPackage(currentJPkg.getPkg(), true);
                parentJPkg.setName(current.getName());
                pkgMap.put(current, parentJPkg);
                if (current.isRoot()) {
                    root.getSubPackages().add(parentJPkg);
                }
            }
            if (ListUtils.noneMatch(subPackages = parentJPkg.getSubPackages(), arg_0 -> PackageHelper.lambda$buildLeafPath$1(pkgName = currentJPkg.getName(), arg_0))) {
                subPackages.add(currentJPkg);
            }
            currentJPkg = parentJPkg;
        }
    }

    private static void traverseMiddlePackages(JPackage pkg, List<JPackage> toMerge) {
        List<JPackage> subPackages = pkg.getSubPackages();
        int count = subPackages.size();
        for (int i = 0; i < count; ++i) {
            JPackage subPackage = subPackages.get(i);
            JPackage replacePkg = PackageHelper.mergeMiddlePackages(subPackage, toMerge);
            if (replacePkg != subPackage) {
                subPackages.set(i, replacePkg);
            }
            PackageHelper.traverseMiddlePackages(replacePkg, toMerge);
        }
    }

    private static JPackage mergeMiddlePackages(JPackage jPkg, List<JPackage> merged) {
        List<JPackage> subPackages = jPkg.getSubPackages();
        if (subPackages.size() == 1 && jPkg.getClasses().isEmpty()) {
            merged.add(jPkg);
            JPackage endPkg = PackageHelper.mergeMiddlePackages(subPackages.get(0), merged);
            merged.clear();
            return endPkg;
        }
        if (!merged.isEmpty()) {
            merged.add(jPkg);
            jPkg.setName(Utils.listToString(merged, (String)".", JPackage::getName));
        }
        return jPkg;
    }

    private JPackage buildJPackage(JavaPackage javaPkg, boolean synthetic) {
        List classes;
        boolean pkgEnabled = PackageHelper.isPkgEnabled(javaPkg.getRawFullName(), this.excludedPackages);
        if (synthetic) {
            classes = Collections.emptyList();
        } else {
            classes = Utils.collectionMap((Collection)javaPkg.getClassesNoDup(), this.nodeCache::makeFrom);
            classes.sort(CLASS_COMPARATOR);
        }
        return this.nodeCache.newJPackage(javaPkg, synthetic, pkgEnabled, classes);
    }

    private static boolean isPkgEnabled(String fullPkgName, List<String> excludedPackages) {
        return excludedPackages.isEmpty() || excludedPackages.stream().noneMatch(p -> PackageHelper.isPkgMatch(fullPkgName, p));
    }

    private static boolean isPkgMatch(String fullPkgName, String filterPkg) {
        if (fullPkgName.equals(filterPkg)) {
            return true;
        }
        int filterPkgLen = filterPkg.length();
        return fullPkgName.length() > filterPkgLen && fullPkgName.charAt(filterPkgLen) == '.' && fullPkgName.startsWith(filterPkg);
    }

    private static /* synthetic */ boolean lambda$buildLeafPath$1(String pkgName, JPackage p) {
        return p.getName().equals(pkgName);
    }
}

