/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.utils.UiUtils;
import java.awt.Font;
import java.io.InputStream;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FontUtils.class);

    public static Font loadByStr(String fontDesc) {
        int size;
        String[] parts = fontDesc.split("/");
        if (parts.length != 3) {
            throw new JadxRuntimeException("Unsupported font description format: " + fontDesc);
        }
        String family = parts[0];
        int style = FontUtils.parseFontStyle(parts[1]);
        Font font = FontUtils.getCompositeFont(family, style, size = Integer.parseInt(parts[2]));
        if (font == null) {
            throw new JadxRuntimeException("Font not found: " + fontDesc);
        }
        return font;
    }

    public static String convertToStr(@Nullable Font font) {
        if (font == null) {
            return "";
        }
        if (font.getSize() < 1) {
            throw new JadxRuntimeException("Bad font size: " + font.getSize());
        }
        return font.getFamily() + "/" + FontUtils.convertFontStyleToString(font.getStyle()) + "/" + font.getSize();
    }

    public static String convertFontStyleToString(int style) {
        if (style == 0) {
            return "plain";
        }
        StringBuilder sb = new StringBuilder();
        if ((style & 1) != 0) {
            sb.append("bold");
        }
        if ((style & 2) != 0) {
            sb.append(" italic");
        }
        return sb.toString().trim();
    }

    private static int parseFontStyle(String str) {
        int style = 0;
        if (str.contains("bold")) {
            style |= 1;
        }
        if (str.contains("italic")) {
            style |= 2;
        }
        return style;
    }

    @Nullable
    public static Font openFontTTF(String name) {
        Font font;
        block8: {
            String fontPath = "/fonts/" + name + ".ttf";
            InputStream is = UiUtils.class.getResourceAsStream(fontPath);
            try {
                Font font2 = Font.createFont(0, is);
                font = font2.deriveFont(12.0f);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error("Failed load font by path: {}", (Object)fontPath, (Object)e);
                    return null;
                }
            }
            is.close();
        }
        return font;
    }

    public static boolean canStringBeDisplayed(String str, Font font) {
        int codePoint;
        if (str == null || str.isEmpty()) {
            return true;
        }
        for (int offset = 0; offset < str.length(); offset += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(offset);
            if (font.canDisplay(codePoint)) continue;
            return false;
        }
        return true;
    }

    public static Font getCompositeFont(String family, int style, int size) {
        return com.formdev.flatlaf.util.FontUtils.getCompositeFont((String)family, (int)style, (int)size);
    }

    private FontUtils() {
    }
}

