/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.tab.dnd;

import jadx.gui.settings.JadxSettings;
import jadx.gui.ui.tab.dnd.TabDndController;
import jadx.gui.ui.tab.dnd.TabDndGhostType;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class TabDndGhostPane
extends JComponent {
    private final TabDndController dnd;
    private final Rectangle lineRect = new Rectangle();
    private final Point location = new Point();
    private transient BufferedImage ghostImage;
    private JadxSettings settings;
    private TabDndGhostType tabDndGhostType = TabDndGhostType.OUTLINE;
    private Dimension ghostSize;
    private Color ghostColor;
    private Insets insets;

    protected TabDndGhostPane(TabDndController dnd, JadxSettings settings) {
        this.dnd = dnd;
        this.settings = settings;
        this.loadSettings();
    }

    public void loadSettings() {
        Color systemColor = UIManager.getColor("Component.focusColor");
        Color fallbackColor = new Color(0, 100, 255);
        this.ghostColor = systemColor != null ? systemColor : fallbackColor;
        Insets ins = UIManager.getInsets("TabbedPane.tabInsets");
        this.insets = ins != null ? ins : new Insets(0, 0, 0, 0);
        this.tabDndGhostType = this.settings.getTabDndGhostType();
    }

    public void setTargetRect(int x, int y, int width, int height) {
        this.lineRect.setBounds(x, y, width, height);
    }

    public void setGhostImage(BufferedImage ghostImage) {
        this.ghostImage = ghostImage;
    }

    public void setGhostSize(Dimension ghostSize) {
        ghostSize.setSize(ghostSize.width + this.insets.left + this.insets.right, ghostSize.height + this.insets.top + this.insets.bottom);
        this.ghostSize = ghostSize;
    }

    public void setGhostType(TabDndGhostType tabDndGhostType) {
        this.tabDndGhostType = tabDndGhostType;
    }

    public TabDndGhostType getGhostType() {
        return this.tabDndGhostType;
    }

    public void setColor(Color color) {
        this.ghostColor = color;
    }

    public Color getColor() {
        return this.ghostColor;
    }

    public void setPoint(Point pt) {
        this.location.setLocation(pt);
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    public void setVisible(boolean v) {
        super.setVisible(v);
        if (!v) {
            this.setTargetRect(0, 0, 0, 0);
            this.setGhostImage(null);
            this.setGhostSize(new Dimension());
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        this.dnd.onPaintGlassPane(g2);
        this.renderMark(g2);
        this.renderGhost(g2);
        g2.dispose();
    }

    private void renderGhost(Graphics2D g) {
        switch (this.tabDndGhostType) {
            case IMAGE: {
                g.setComposite(AlphaComposite.getInstance(3, 0.5f));
                if (this.ghostImage == null) {
                    return;
                }
                double x = this.location.getX() - (double)this.ghostImage.getWidth(this) / 2.0;
                double y = this.location.getY() - (double)this.ghostImage.getHeight(this) / 2.0;
                g.drawImage((Image)this.ghostImage, (int)x, (int)y, this);
                break;
            }
            case OUTLINE: {
                g.setComposite(AlphaComposite.getInstance(3, 0.2f));
                if (this.ghostSize == null) {
                    return;
                }
                double x = this.location.getX() - this.ghostSize.getWidth() / 2.0;
                double y = this.location.getY() - this.ghostSize.getHeight() / 2.0;
                g.setPaint(this.ghostColor);
                g.fillRect((int)x, (int)y, this.ghostSize.width, this.ghostSize.height);
                break;
            }
        }
    }

    private void renderMark(Graphics2D g) {
        g.setComposite(AlphaComposite.getInstance(3, 0.7f));
        g.setPaint(this.ghostColor);
        g.fill(this.lineRect);
    }
}

