/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.startpage;

import jadx.gui.settings.JadxSettings;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.startpage.RecentProjectItem;
import jadx.gui.ui.startpage.RecentProjectListCellRenderer;
import jadx.gui.ui.startpage.StartPageNode;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.utils.Icons;
import jadx.gui.utils.NLS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.nio.file.Path;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class StartPagePanel
extends ContentPanel {
    private static final long serialVersionUID = 2457805175218770732L;
    private final RecentProjectsJList recentList;
    private final DefaultListModel<RecentProjectItem> recentListModel;
    private final MainWindow mainWindow;
    private final JadxSettings settings;
    public static int hoveredRemoveBtnIndex = -1;

    public StartPagePanel(TabbedPane tabbedPane, StartPageNode node) {
        super(tabbedPane, node);
        this.mainWindow = tabbedPane.getMainWindow();
        this.settings = this.mainWindow.getSettings();
        Font baseFont = this.settings.getUiFont();
        JButton openFile = new JButton(NLS.str("file.open_title"), Icons.OPEN);
        openFile.addActionListener(ev -> this.mainWindow.openFileDialog());
        JButton openProject = new JButton(NLS.str("file.open_project"), Icons.OPEN_PROJECT);
        openProject.addActionListener(ev -> this.mainWindow.openProjectDialog());
        JPanel start = new JPanel();
        start.setBorder(StartPagePanel.sectionFrame(NLS.str("start_page.start"), baseFont));
        start.setLayout(new BoxLayout(start, 2));
        start.add(openFile);
        start.add(Box.createRigidArea(new Dimension(10, 0)));
        start.add(openProject);
        start.add(Box.createHorizontalGlue());
        this.recentListModel = new DefaultListModel();
        this.recentList = new RecentProjectsJList(this.recentListModel);
        this.recentList.setCellRenderer(new RecentProjectListCellRenderer(baseFont));
        this.recentList.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.recentList);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setPreferredSize(new Dimension(400, 250));
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.recentList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = StartPagePanel.this.recentList.locationToIndex(e.getPoint());
                if (index == -1) {
                    return;
                }
                RecentProjectItem item = StartPagePanel.this.recentListModel.getElementAt(index);
                if (item == null) {
                    return;
                }
                RecentProjectListCellRenderer renderer = (RecentProjectListCellRenderer)StartPagePanel.this.recentList.getCellRenderer().getListCellRendererComponent(StartPagePanel.this.recentList, item, index, false, false);
                Rectangle cellBounds = StartPagePanel.this.recentList.getCellBounds(index, index);
                if (cellBounds != null) {
                    int xInCell = e.getX() - cellBounds.x;
                    int yInCell = e.getY() - cellBounds.y;
                    Rectangle removeIconBounds = renderer.getRemoveIconBounds();
                    if (removeIconBounds != null && removeIconBounds.contains(xInCell, yInCell)) {
                        StartPagePanel.this.removeRecentProject(item.getPath());
                        return;
                    }
                }
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    StartPagePanel.this.openRecentProject(item.getPath());
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    StartPagePanel.this.recentList.setSelectedIndex(index);
                    StartPagePanel.this.showRecentProjectContextMenu(e);
                }
            }
        });
        this.recentList.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int oldHoveredRemoveBtnIndex = hoveredRemoveBtnIndex;
                hoveredRemoveBtnIndex = -1;
                int currentCellIndex = StartPagePanel.this.recentList.locationToIndex(e.getPoint());
                if (currentCellIndex != -1) {
                    RecentProjectItem item = StartPagePanel.this.recentListModel.getElementAt(currentCellIndex);
                    RecentProjectListCellRenderer renderer = (RecentProjectListCellRenderer)StartPagePanel.this.recentList.getCellRenderer().getListCellRendererComponent(StartPagePanel.this.recentList, item, currentCellIndex, StartPagePanel.this.recentList.isSelectedIndex(currentCellIndex), false);
                    Rectangle cellBounds = StartPagePanel.this.recentList.getCellBounds(currentCellIndex, currentCellIndex);
                    if (cellBounds != null) {
                        int xInCell = e.getX() - cellBounds.x;
                        int yInCell = e.getY() - cellBounds.y;
                        Rectangle removeIconBounds = renderer.getRemoveIconBounds();
                        if (removeIconBounds != null && removeIconBounds.contains(xInCell, yInCell)) {
                            hoveredRemoveBtnIndex = currentCellIndex;
                        }
                    }
                }
                if (oldHoveredRemoveBtnIndex != hoveredRemoveBtnIndex) {
                    Rectangle bounds;
                    if (oldHoveredRemoveBtnIndex != -1 && (bounds = StartPagePanel.this.recentList.getCellBounds(oldHoveredRemoveBtnIndex, oldHoveredRemoveBtnIndex)) != null) {
                        StartPagePanel.this.recentList.repaint(bounds);
                    }
                    if (hoveredRemoveBtnIndex != -1 && (bounds = StartPagePanel.this.recentList.getCellBounds(hoveredRemoveBtnIndex, hoveredRemoveBtnIndex)) != null) {
                        StartPagePanel.this.recentList.repaint(bounds);
                    }
                }
            }
        });
        JPanel recent = new JPanel();
        recent.setBorder(StartPagePanel.sectionFrame(NLS.str("start_page.recent"), baseFont));
        recent.setLayout(new BoxLayout(recent, 3));
        recent.add(scrollPane);
        JPanel center = new JPanel();
        center.setLayout(new BorderLayout(10, 10));
        center.add((Component)start, "First");
        center.add((Component)recent, "Center");
        center.setMaximumSize(new Dimension(700, 600));
        center.setAlignmentX(0.5f);
        this.setLayout(new BoxLayout(this, 3));
        this.setBorder(BorderFactory.createEmptyBorder(50, 50, 50, 50));
        this.add(Box.createVerticalGlue());
        this.add(center);
        this.add(Box.createVerticalGlue());
        this.fillRecentProjectsList();
    }

    private void fillRecentProjectsList() {
        this.recentListModel.clear();
        List<Path> recentPaths = this.settings.getRecentProjects();
        for (Path path : recentPaths) {
            this.recentListModel.addElement(new RecentProjectItem(path));
        }
        this.recentList.revalidate();
        this.recentList.repaint();
    }

    private void openRecentProject(Path path) {
        this.mainWindow.open(path);
    }

    private void removeRecentProject(Path path) {
        this.settings.removeRecentProject(path);
        this.fillRecentProjectsList();
        if (hoveredRemoveBtnIndex != -1 && hoveredRemoveBtnIndex >= this.recentListModel.size()) {
            hoveredRemoveBtnIndex = -1;
        }
    }

    private void showRecentProjectContextMenu(MouseEvent e) {
        JPopupMenu popupMenu = new JPopupMenu();
        RecentProjectItem selectedItem = (RecentProjectItem)this.recentList.getSelectedValue();
        if (selectedItem != null) {
            JMenuItem openItem = new JMenuItem(NLS.str("file.open_project"));
            openItem.addActionListener(actionEvent -> this.openRecentProject(selectedItem.getPath()));
            popupMenu.add(openItem);
            JMenuItem removeItem = new JMenuItem(NLS.str("start_page.list.delete_recent_project"));
            removeItem.addActionListener(actionEvent -> this.removeRecentProject(selectedItem.getPath()));
            popupMenu.add(removeItem);
        }
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    private static Border sectionFrame(String title, Font font) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(title);
        titledBorder.setTitleFont(font.deriveFont(1, font.getSize() + 1));
        Border spacing = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        return BorderFactory.createCompoundBorder(titledBorder, spacing);
    }

    @Override
    public void loadSettings() {
    }

    private static class RecentProjectsJList
    extends JList<RecentProjectItem> {
        private static final long serialVersionUID = 1L;

        public RecentProjectsJList(DefaultListModel<RecentProjectItem> model) {
            super(model);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            int index = this.locationToIndex(event.getPoint());
            if (index == -1) {
                return null;
            }
            RecentProjectItem item = (RecentProjectItem)this.getModel().getElementAt(index);
            if (item == null) {
                return null;
            }
            RecentProjectListCellRenderer renderer = (RecentProjectListCellRenderer)this.getCellRenderer().getListCellRendererComponent(this, item, index, this.isSelectedIndex(index), false);
            Rectangle cellBounds = this.getCellBounds(index, index);
            if (cellBounds != null) {
                int xInCell = event.getX() - cellBounds.x;
                int yInCell = event.getY() - cellBounds.y;
                Rectangle removeIconBounds = renderer.getRemoveIconBounds();
                if (removeIconBounds != null && removeIconBounds.contains(xInCell, yInCell)) {
                    return NLS.str("start_page.list.delete_recent_project.tooltip");
                }
            }
            return item.getAbsolutePath();
        }
    }
}

