/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.panel;

import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.LineNumbersMode;
import jadx.gui.settings.ui.font.FontChooserHack;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.ui.treenodes.UndisplayedStringsNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import org.drjekyll.fontchooser.FontChooser;
import org.drjekyll.fontchooser.model.FontSelectionModel;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class UndisplayedStringsPanel
extends ContentPanel {
    private static final long serialVersionUID = 695370628262996993L;
    private final RSyntaxTextArea textPane;
    private final RTextScrollPane codeScrollPane;

    public UndisplayedStringsPanel(TabbedPane panel, UndisplayedStringsNode node) {
        super(panel, node);
        this.setLayout(new BorderLayout());
        this.textPane = AbstractCodeArea.getDefaultArea(panel.getMainWindow());
        JadxSettings settings = this.getSettings();
        Font selectedFont = settings.getCodeFont();
        FontChooser fontChooser = new FontChooser();
        fontChooser.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        fontChooser.setSelectedFont(selectedFont);
        FontChooserHack.hidePreview(fontChooser);
        fontChooser.addChangeListener(event -> {
            FontSelectionModel model = (FontSelectionModel)event.getSource();
            settings.setCodeFont(model.getSelectedFont());
            this.getMainWindow().loadSettings();
        });
        this.codeScrollPane = new RTextScrollPane((RTextArea)this.textPane);
        this.add((Component)this.codeScrollPane, "Center");
        this.add((Component)fontChooser, "East");
        this.applySettings();
        this.showData(node.makeDescString());
    }

    private void applySettings() {
        this.codeScrollPane.setLineNumbersEnabled(this.getSettings().getLineNumbersMode() != LineNumbersMode.DISABLE);
        this.codeScrollPane.getGutter().setLineNumberFont(this.getSettings().getCodeFont());
        this.textPane.setFont(this.getSettings().getCodeFont());
    }

    private void showData(String data) {
        this.textPane.setText(data);
        this.textPane.setCaretPosition(0);
    }

    @Override
    public void loadSettings() {
        this.applySettings();
    }
}

