/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.panel;

import jadx.api.ICodeInfo;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.LineNumbersMode;
import jadx.gui.treemodel.CodeNode;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.utils.NLS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCodePanel
extends JPanel {
    private static final long serialVersionUID = -4073178549744330905L;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleCodePanel.class);
    private final RSyntaxTextArea codeArea;
    private final RTextScrollPane codeScrollPane;
    private final JLabel titleLabel;

    public SimpleCodePanel(MainWindow mainWindow) {
        JadxSettings settings = mainWindow.getSettings();
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setMinimumSize(new Dimension(300, 400));
        this.setPreferredSize(new Dimension(800, 600));
        this.titleLabel = new JLabel(NLS.str("usage_dialog_plus.code_view"));
        this.titleLabel.setFont(settings.getCodeFont());
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
        this.codeArea = AbstractCodeArea.getDefaultArea(mainWindow);
        this.codeArea.setText("// " + NLS.str("usage_dialog_plus.select_node"));
        this.codeScrollPane = new RTextScrollPane((RTextArea)this.codeArea);
        this.codeScrollPane.setHorizontalScrollBarPolicy(30);
        this.codeScrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)this.titleLabel, "North");
        this.add((Component)this.codeScrollPane, "Center");
        this.applySettings(settings);
    }

    private void applySettings(JadxSettings settings) {
        this.codeScrollPane.setLineNumbersEnabled(settings.getLineNumbersMode() != LineNumbersMode.DISABLE);
        this.codeScrollPane.getGutter().setLineNumberFont(settings.getCodeFont());
        this.codeArea.setFont(settings.getCodeFont());
    }

    public void showCode(JNode node, String codeLine) {
        if (node != null) {
            this.titleLabel.setText(NLS.str("usage_dialog_plus.code_for", node.makeLongString()));
            this.codeArea.setSyntaxEditingStyle(node.getSyntaxName());
            String contextCode = this.getContextCode(node, codeLine);
            this.codeArea.setText(contextCode);
            this.scrollToCodeLine(this.codeArea, codeLine);
            if (node instanceof CodeNode) {
                CodeNode codeNode = (CodeNode)node;
                int pos = codeNode.getPos();
                if (pos > 0) {
                    try {
                        String text = this.codeArea.getText();
                        int lineNum = 0;
                        int curPos = 0;
                        for (int i = 0; i < text.length() && curPos <= pos; ++curPos, ++i) {
                            if (text.charAt(i) != '\n') continue;
                            ++lineNum;
                        }
                        if (lineNum > 0) {
                            int finalLineNum = lineNum;
                            SwingUtilities.invokeLater(() -> {
                                try {
                                    Rectangle2D lineRect = this.codeArea.modelToView2D(this.codeArea.getLineStartOffset(finalLineNum));
                                    if (lineRect != null) {
                                        JScrollPane scrollPane = (JScrollPane)this.codeArea.getParent().getParent();
                                        Rectangle viewRect = scrollPane.getViewport().getViewRect();
                                        int y = (int)(lineRect.getY() - ((double)viewRect.height - lineRect.getHeight()) / 2.0);
                                        if (y < 0) {
                                            y = 0;
                                        }
                                        scrollPane.getViewport().setViewPosition(new Point(0, y));
                                    }
                                }
                                catch (Exception e) {
                                    this.scrollToCodeLine(this.codeArea, codeLine);
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        this.scrollToCodeLine(this.codeArea, codeLine);
                    }
                } else {
                    this.scrollToCodeLine(this.codeArea, codeLine);
                }
            } else {
                this.scrollToCodeLine(this.codeArea, codeLine);
            }
        } else {
            this.titleLabel.setText(NLS.str("usage_dialog_plus.code_view"));
            this.codeArea.setText("// " + NLS.str("usage_dialog_plus.select_node"));
        }
    }

    private String getContextCode(JNode node, String codeLine) {
        String fullCode;
        CodeNode codeNode;
        JClass usageJNode;
        if (node instanceof CodeNode && (usageJNode = (codeNode = (CodeNode)node).getJParent()) != null && (fullCode = this.getFullNodeCode(usageJNode)) != null && !fullCode.isEmpty()) {
            return fullCode;
        }
        return "// Unable to get complete context, only display related lines\n\n" + codeLine;
    }

    private String getFullNodeCode(JNode node) {
        if (node != null) {
            ICodeInfo codeInfo = node.getCodeInfo();
            if (codeInfo != null && !codeInfo.equals(ICodeInfo.EMPTY)) {
                return codeInfo.getCodeStr();
            }
            if (node instanceof JClass) {
                JClass jClass = (JClass)node;
                return jClass.getCodeInfo().getCodeStr();
            }
        }
        return null;
    }

    private void scrollToCodeLine(RSyntaxTextArea textArea, String lineToHighlight) {
        try {
            String fullText = textArea.getText();
            int lineIndex = fullText.indexOf(lineToHighlight);
            if (lineIndex >= 0) {
                textArea.revalidate();
                textArea.setCaretPosition(lineIndex);
                int endIndex = lineIndex + lineToHighlight.length();
                textArea.select(lineIndex, endIndex);
                textArea.getCaret().setSelectionVisible(true);
                SwingUtilities.invokeLater(() -> {
                    try {
                        int lineNum = textArea.getLineOfOffset(lineIndex);
                        Rectangle2D lineRect = textArea.modelToView2D(textArea.getLineStartOffset(lineNum));
                        if (lineRect != null) {
                            JScrollPane scrollPane = (JScrollPane)textArea.getParent().getParent();
                            Rectangle viewRect = scrollPane.getViewport().getViewRect();
                            int y = (int)(lineRect.getY() - ((double)viewRect.height - lineRect.getHeight()) / 2.0);
                            if (y < 0) {
                                y = 0;
                            }
                            scrollPane.getViewport().setViewPosition(new Point(0, y));
                        }
                    }
                    catch (Exception e) {
                        LOG.debug("Error scrolling to line: {}", (Object)e.getMessage());
                    }
                });
            } else {
                LOG.debug("Could not find line to highlight: {}", (Object)lineToHighlight);
            }
        }
        catch (Exception e) {
            LOG.debug("Error highlighting line: {}", (Object)e.getMessage());
        }
    }
}

