/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.hexviewer;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.highlight.swing.NonAsciiCodeAreaColorAssessor;
import org.exbin.bined.highlight.swing.NonprintablesCodeAreaAssessor;
import org.exbin.bined.highlight.swing.SearchCodeAreaColorAssessor;
import org.exbin.bined.swing.CodeAreaCharAssessor;
import org.exbin.bined.swing.CodeAreaColorAssessor;
import org.exbin.bined.swing.CodeAreaPaintState;

public class BinEdCodeAreaAssessor
implements CodeAreaColorAssessor,
CodeAreaCharAssessor {
    private final List<PositionColorModifier> priorityColorModifiers = new ArrayList<PositionColorModifier>();
    private final List<PositionColorModifier> colorModifiers = new ArrayList<PositionColorModifier>();
    private final CodeAreaColorAssessor parentColorAssessor;
    private final CodeAreaCharAssessor parentCharAssessor;

    public BinEdCodeAreaAssessor(CodeAreaColorAssessor parentColorAssessor, CodeAreaCharAssessor parentCharAssessor) {
        NonAsciiCodeAreaColorAssessor nonAsciiCodeAreaColorAssessor = new NonAsciiCodeAreaColorAssessor(parentColorAssessor);
        NonprintablesCodeAreaAssessor nonprintablesCodeAreaAssessor = new NonprintablesCodeAreaAssessor((CodeAreaColorAssessor)nonAsciiCodeAreaColorAssessor, parentCharAssessor);
        SearchCodeAreaColorAssessor searchCodeAreaColorAssessor = new SearchCodeAreaColorAssessor((CodeAreaColorAssessor)nonprintablesCodeAreaAssessor);
        this.parentColorAssessor = searchCodeAreaColorAssessor;
        this.parentCharAssessor = nonprintablesCodeAreaAssessor;
    }

    public void addColorModifier(PositionColorModifier colorModifier) {
        this.colorModifiers.add(colorModifier);
    }

    public void removeColorModifier(PositionColorModifier colorModifier) {
        this.colorModifiers.remove(colorModifier);
    }

    public void addPriorityColorModifier(PositionColorModifier colorModifier) {
        this.priorityColorModifiers.add(colorModifier);
    }

    public void removePriorityColorModifier(PositionColorModifier colorModifier) {
        this.priorityColorModifiers.remove(colorModifier);
    }

    public void startPaint(CodeAreaPaintState codeAreaPaintState) {
        for (PositionColorModifier colorModifier : this.priorityColorModifiers) {
            colorModifier.resetColors();
        }
        for (PositionColorModifier colorModifier : this.colorModifiers) {
            colorModifier.resetColors();
        }
        if (this.parentColorAssessor != null) {
            this.parentColorAssessor.startPaint(codeAreaPaintState);
        }
    }

    public Color getPositionBackgroundColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean inSelection) {
        Color positionBackgroundColor;
        for (PositionColorModifier colorModifier : this.priorityColorModifiers) {
            positionBackgroundColor = colorModifier.getPositionBackgroundColor(rowDataPosition, byteOnRow, charOnRow, section, inSelection);
            if (positionBackgroundColor == null) continue;
            return positionBackgroundColor;
        }
        if (!inSelection) {
            for (PositionColorModifier colorModifier : this.colorModifiers) {
                positionBackgroundColor = colorModifier.getPositionBackgroundColor(rowDataPosition, byteOnRow, charOnRow, section, inSelection);
                if (positionBackgroundColor == null) continue;
                return positionBackgroundColor;
            }
        }
        if (this.parentColorAssessor != null) {
            return this.parentColorAssessor.getPositionBackgroundColor(rowDataPosition, byteOnRow, charOnRow, section, inSelection);
        }
        return null;
    }

    public Color getPositionTextColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean inSelection) {
        Color positionTextColor;
        for (PositionColorModifier colorModifier : this.priorityColorModifiers) {
            positionTextColor = colorModifier.getPositionTextColor(rowDataPosition, byteOnRow, charOnRow, section, inSelection);
            if (positionTextColor == null) continue;
            return positionTextColor;
        }
        if (!inSelection) {
            for (PositionColorModifier colorModifier : this.colorModifiers) {
                positionTextColor = colorModifier.getPositionTextColor(rowDataPosition, byteOnRow, charOnRow, section, inSelection);
                if (positionTextColor == null) continue;
                return positionTextColor;
            }
        }
        if (this.parentColorAssessor != null) {
            return this.parentColorAssessor.getPositionTextColor(rowDataPosition, byteOnRow, charOnRow, section, inSelection);
        }
        return null;
    }

    public char getPreviewCharacter(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section) {
        return this.parentCharAssessor != null ? this.parentCharAssessor.getPreviewCharacter(rowDataPosition, byteOnRow, charOnRow, section) : (char)' ';
    }

    public char getPreviewCursorCharacter(long rowDataPosition, int byteOnRow, int charOnRow, byte[] cursorData, int cursorDataLength, CodeAreaSection section) {
        return this.parentCharAssessor != null ? this.parentCharAssessor.getPreviewCursorCharacter(rowDataPosition, byteOnRow, charOnRow, cursorData, cursorDataLength, section) : (char)' ';
    }

    public Optional<CodeAreaCharAssessor> getParentCharAssessor() {
        return Optional.ofNullable(this.parentCharAssessor);
    }

    public Optional<CodeAreaColorAssessor> getParentColorAssessor() {
        return Optional.ofNullable(this.parentColorAssessor);
    }

    public static interface PositionColorModifier {
        public Color getPositionBackgroundColor(long var1, int var3, int var4, CodeAreaSection var5, boolean var6);

        public Color getPositionTextColor(long var1, int var3, int var4, CodeAreaSection var5, boolean var6);

        public void resetColors();
    }
}

