/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.dialog;

import com.formdev.flatlaf.icons.FlatSearchWithHistoryIcon;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Emitter;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import jadx.api.JavaClass;
import jadx.api.JavaPackage;
import jadx.api.resources.ResourceContentType;
import jadx.core.dex.nodes.PackageNode;
import jadx.core.utils.ListUtils;
import jadx.core.utils.StringUtils;
import jadx.core.utils.Utils;
import jadx.gui.jobs.ITaskInfo;
import jadx.gui.jobs.ITaskProgress;
import jadx.gui.search.SearchSettings;
import jadx.gui.search.SearchTask;
import jadx.gui.search.providers.ClassSearchProvider;
import jadx.gui.search.providers.CodeSearchProvider;
import jadx.gui.search.providers.CommentSearchProvider;
import jadx.gui.search.providers.FieldSearchProvider;
import jadx.gui.search.providers.MergedSearchProvider;
import jadx.gui.search.providers.MethodSearchProvider;
import jadx.gui.search.providers.ResourceFilter;
import jadx.gui.search.providers.ResourceSearchProvider;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JResource;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.dialog.CommonSearchDialog;
import jadx.gui.utils.CacheObject;
import jadx.gui.utils.Icons;
import jadx.gui.utils.JumpPosition;
import jadx.gui.utils.NLS;
import jadx.gui.utils.SimpleListener;
import jadx.gui.utils.TextStandardActions;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.cache.ValueCache;
import jadx.gui.utils.layout.WrapLayout;
import jadx.gui.utils.rx.RxUtils;
import jadx.gui.utils.ui.DocumentUpdateListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchDialog
extends CommonSearchDialog {
    private static final Logger LOG = LoggerFactory.getLogger(SearchDialog.class);
    private static final long serialVersionUID = -5105405456969134105L;
    private final transient SearchPreset searchPreset;
    private final transient Set<SearchOptions> options;
    private final transient SimpleListener<Set<SearchOptions>> optionsListener = new SimpleListener();
    private transient JTextField searchField;
    private transient JTextField packageField;
    private transient JTextField resExtField;
    private transient JSpinner resSizeLimit;
    @Nullable
    private transient SearchTask searchTask;
    private transient JButton loadAllButton;
    private transient JButton loadMoreButton;
    private transient JButton stopBtn;
    private transient JButton sortBtn;
    private transient Disposable searchDisposable;
    private transient SearchEventEmitter searchEmitter;
    private transient ChangeListener activeTabListener;
    private transient String initSearchText = null;
    private transient String initSearchPackage = null;
    private final List<JNode> pendingResults = new ArrayList<JNode>();
    private final Executor searchBackgroundExecutor = Executors.newSingleThreadExecutor();
    private final ValueCache<String, List<JavaClass>> includedClsCache = new ValueCache();
    private final ValueCache<List<JavaClass>, List<List<JavaClass>>> batchesCache = new ValueCache();

    public static void search(MainWindow window, SearchPreset preset) {
        SearchDialog searchDialog = new SearchDialog(window, preset, Collections.emptySet());
        SearchDialog.show(searchDialog, window);
    }

    public static void searchInActiveTab(MainWindow window, SearchPreset preset) {
        SearchDialog searchDialog = new SearchDialog(window, preset, EnumSet.of(SearchOptions.ACTIVE_TAB));
        SearchDialog.show(searchDialog, window);
    }

    public static void searchText(MainWindow window, String text) {
        SearchDialog searchDialog = new SearchDialog(window, SearchPreset.TEXT, Collections.emptySet());
        searchDialog.initSearchText = text;
        SearchDialog.show(searchDialog, window);
    }

    public static void searchPackage(MainWindow window, String packageName) {
        SearchDialog searchDialog = new SearchDialog(window, SearchPreset.TEXT, Collections.emptySet());
        searchDialog.initSearchPackage = packageName;
        SearchDialog.show(searchDialog, window);
    }

    private static void show(SearchDialog searchDialog, MainWindow mw) {
        mw.addLoadListener(loaded -> {
            if (!loaded) {
                searchDialog.dispose();
                return true;
            }
            return false;
        });
        searchDialog.setVisible(true);
    }

    private SearchDialog(MainWindow mainWindow, SearchPreset preset, Set<SearchOptions> additionalOptions) {
        super(mainWindow, NLS.str("menu.text_search"));
        this.searchPreset = preset;
        this.options = this.buildOptions(preset);
        this.options.addAll(additionalOptions);
        this.loadWindowPos();
        this.initUI();
        this.initSearchEvents();
        this.registerInitOnOpen();
        this.registerActiveTabListener();
    }

    @Override
    public void dispose() {
        if (this.searchDisposable != null && !this.searchDisposable.isDisposed()) {
            this.searchDisposable.dispose();
        }
        this.resultsModel.clear();
        this.removeActiveTabListener();
        this.searchBackgroundExecutor.execute(() -> {
            this.stopSearchTask();
            this.unloadTempData();
        });
        super.dispose();
    }

    private Set<SearchOptions> buildOptions(SearchPreset preset) {
        Set<SearchOptions> searchOptions = this.cache.getLastSearchOptions().get((Object)preset);
        if (searchOptions == null) {
            searchOptions = EnumSet.noneOf(SearchOptions.class);
        }
        switch (preset) {
            case TEXT: {
                if (!searchOptions.isEmpty()) break;
                searchOptions.add(SearchOptions.CODE);
                searchOptions.add(SearchOptions.IGNORE_CASE);
                break;
            }
            case CLASS: {
                searchOptions.add(SearchOptions.CLASS);
                break;
            }
            case COMMENT: {
                searchOptions.add(SearchOptions.COMMENT);
                searchOptions.remove((Object)SearchOptions.ACTIVE_TAB);
            }
        }
        return searchOptions;
    }

    @Override
    protected void openInit() {
        String searchPackage;
        String searchText;
        String string = searchText = this.initSearchText != null ? this.initSearchText : this.cache.getLastSearch();
        if (searchText != null) {
            this.searchField.setText(searchText);
            this.searchField.selectAll();
        }
        String string2 = searchPackage = this.initSearchPackage != null ? this.initSearchPackage : this.cache.getLastSearchPackage();
        if (searchPackage != null) {
            this.packageField.setText(searchPackage);
        }
        this.searchField.requestFocus();
        this.resultsTable.initColumnWidth();
        if (this.options.contains((Object)SearchOptions.COMMENT)) {
            this.searchEmitter.emitSearch();
        }
    }

    private void initUI() {
        this.searchField = new JTextField();
        TextStandardActions.attach(this.searchField);
        this.addSearchHistoryButton();
        this.searchField.putClientProperty("JTextField.showClearButton", true);
        boolean autoSearch = this.mainWindow.getSettings().isUseAutoSearch();
        JButton searchBtn = new JButton(NLS.str("search_dialog.search_button"));
        searchBtn.setVisible(!autoSearch);
        searchBtn.addActionListener(ev -> this.searchEmitter.emitSearch());
        JCheckBox autoSearchCB = new JCheckBox(NLS.str("search_dialog.auto_search"));
        autoSearchCB.setSelected(autoSearch);
        autoSearchCB.addActionListener(ev -> {
            boolean newValue = autoSearchCB.isSelected();
            this.mainWindow.getSettings().saveUseAutoSearch(newValue);
            searchBtn.setVisible(!newValue);
            this.initSearchEvents();
            if (newValue) {
                this.searchEmitter.emitSearch();
            }
        });
        JPanel searchButtons = new JPanel();
        searchButtons.setLayout(new BoxLayout(searchButtons, 2));
        searchButtons.add(searchBtn);
        searchButtons.add(Box.createRigidArea(new Dimension(5, 0)));
        searchButtons.add(this.makeOptionsToggleButton(NLS.str("search_dialog.ignorecase"), Icons.ICON_MATCH, Icons.ICON_MATCH_SELECTED, SearchOptions.IGNORE_CASE));
        searchButtons.add(Box.createRigidArea(new Dimension(5, 0)));
        searchButtons.add(this.makeOptionsToggleButton(NLS.str("search_dialog.regex"), Icons.ICON_REGEX, Icons.ICON_REGEX_SELECTED, SearchOptions.USE_REGEX));
        searchButtons.add(Box.createRigidArea(new Dimension(5, 0)));
        searchButtons.add(this.makeOptionsToggleButton(NLS.str("search_dialog.active_tab"), Icons.ICON_ACTIVE_TAB, Icons.ICON_ACTIVE_TAB_SELECTED, SearchOptions.ACTIVE_TAB));
        searchButtons.add(Box.createRigidArea(new Dimension(5, 0)));
        searchButtons.add(autoSearchCB);
        JPanel searchFieldPanel = new JPanel();
        searchFieldPanel.setLayout(new BorderLayout(5, 5));
        searchFieldPanel.add((Component)new JLabel(NLS.str("search_dialog.open_by_name")), "Before");
        searchFieldPanel.add((Component)this.searchField, "Center");
        searchFieldPanel.add((Component)searchButtons, "After");
        JPanel searchInPanel = new JPanel();
        searchInPanel.setLayout(new BoxLayout(searchInPanel, 2));
        searchInPanel.setBorder(BorderFactory.createTitledBorder(NLS.str("search_dialog.search_in")));
        searchInPanel.add(this.makeOptionsCheckBox(NLS.str("search_dialog.class"), SearchOptions.CLASS));
        searchInPanel.add(this.makeOptionsCheckBox(NLS.str("search_dialog.method"), SearchOptions.METHOD));
        searchInPanel.add(this.makeOptionsCheckBox(NLS.str("search_dialog.field"), SearchOptions.FIELD));
        searchInPanel.add(this.makeOptionsCheckBox(NLS.str("search_dialog.code"), SearchOptions.CODE));
        searchInPanel.add(this.makeOptionsCheckBox(NLS.str("search_dialog.resource"), SearchOptions.RESOURCE));
        searchInPanel.add(this.makeOptionsCheckBox(NLS.str("search_dialog.comments"), SearchOptions.COMMENT));
        this.packageField = new JTextField(Math.min(100, this.getMaxPkgLen()));
        TextStandardActions.attach(this.packageField);
        this.packageField.putClientProperty("JTextField.showClearButton", true);
        this.packageField.setToolTipText(NLS.str("search_dialog.limit_package"));
        JPanel searchPackagePanel = new JPanel(new BorderLayout());
        searchPackagePanel.setBorder(BorderFactory.createTitledBorder(NLS.str("search_dialog.limit_package")));
        searchPackagePanel.add((Component)this.packageField, "Center");
        Dimension minPanelSize = this.calcMinSizeForTitledBorder(searchPackagePanel);
        searchPackagePanel.setPreferredSize(new Dimension(Math.max(this.packageField.getPreferredSize().width, minPanelSize.width), minPanelSize.height));
        this.resExtField = new JTextField(30);
        TextStandardActions.attach(this.resExtField);
        this.resExtField.putClientProperty("JTextField.showClearButton", true);
        this.resExtField.setToolTipText(NLS.str("preferences.res_file_ext"));
        String resFilterStr = this.mainWindow.getProject().getSearchResourcesFilter();
        this.resExtField.setText(resFilterStr);
        ResourceFilter resFilter = ResourceFilter.parse(resFilterStr);
        JCheckBox textResBox = new JCheckBox(NLS.str("search_dialog.res_text"));
        textResBox.setSelected(resFilter.getContentTypes().contains(ResourceContentType.CONTENT_TEXT));
        JCheckBox binResBox = new JCheckBox(NLS.str("search_dialog.res_binary"));
        binResBox.setSelected(resFilter.getContentTypes().contains(ResourceContentType.CONTENT_BINARY));
        ItemListener resContentTypeListener = ev -> {
            try {
                String newStr;
                EnumSet<ResourceContentType> contentTypes = EnumSet.noneOf(ResourceContentType.class);
                if (textResBox.isSelected()) {
                    contentTypes.add(ResourceContentType.CONTENT_TEXT);
                }
                if (binResBox.isSelected()) {
                    contentTypes.add(ResourceContentType.CONTENT_BINARY);
                }
                if (!(newStr = ResourceFilter.withContentType(this.resExtField.getText(), contentTypes)).equals(this.resExtField.getText())) {
                    this.resExtField.setText(newStr);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        textResBox.addItemListener(resContentTypeListener);
        binResBox.addItemListener(resContentTypeListener);
        this.resExtField.getDocument().addDocumentListener(new DocumentUpdateListener(ev -> UiUtils.uiRun(() -> {
            try {
                ResourceFilter filter = ResourceFilter.parse(this.resExtField.getText());
                textResBox.setSelected(filter.getContentTypes().contains(ResourceContentType.CONTENT_TEXT));
                binResBox.setSelected(filter.getContentTypes().contains(ResourceContentType.CONTENT_BINARY));
            }
            catch (Exception exception) {
                // empty catch block
            }
        })));
        JPanel resExtFilePanel = new JPanel();
        resExtFilePanel.setLayout(new BoxLayout(resExtFilePanel, 2));
        resExtFilePanel.setBorder(BorderFactory.createTitledBorder(NLS.str("preferences.res_file_ext")));
        resExtFilePanel.add(this.resExtField);
        resExtFilePanel.add(textResBox);
        resExtFilePanel.add(binResBox);
        resExtFilePanel.setPreferredSize(this.calcMinSizeForTitledBorder(resExtFilePanel));
        this.resSizeLimit = new JSpinner(new SpinnerNumberModel(this.mainWindow.getProject().getSearchResourcesSizeLimit(), 0, Integer.MAX_VALUE, 1));
        this.resSizeLimit.setToolTipText(NLS.str("preferences.res_skip_file"));
        JPanel sizeLimitPanel = new JPanel(new BorderLayout());
        sizeLimitPanel.setBorder(BorderFactory.createTitledBorder(NLS.str("preferences.res_skip_file")));
        sizeLimitPanel.add((Component)this.resSizeLimit, "Center");
        sizeLimitPanel.setPreferredSize(this.calcMinSizeForTitledBorder(sizeLimitPanel));
        final JPanel optionsPanel = new JPanel(new WrapLayout(0));
        optionsPanel.add(searchInPanel);
        optionsPanel.add(searchPackagePanel);
        optionsPanel.add(resExtFilePanel);
        optionsPanel.add(sizeLimitPanel);
        this.optionsListener.addListener(searchOptions -> {
            boolean codeSearch = Utils.isSetContainsAny((Set)searchOptions, EnumSet.of(SearchOptions.CODE, SearchOptions.CLASS, SearchOptions.METHOD, SearchOptions.FIELD, SearchOptions.COMMENT));
            searchPackagePanel.setVisible(codeSearch);
            boolean resSearch = searchOptions.contains((Object)SearchOptions.RESOURCE);
            resExtFilePanel.setVisible(resSearch);
            sizeLimitPanel.setVisible(resSearch);
            optionsPanel.revalidate();
            optionsPanel.repaint();
        });
        JPanel searchPane = new JPanel();
        searchPane.setLayout(new BoxLayout(searchPane, 3));
        searchPane.add(searchFieldPanel);
        searchPane.add(Box.createRigidArea(new Dimension(0, 5)));
        searchPane.add(optionsPanel);
        this.initCommon();
        JPanel resultsPanel = this.initResultsTable();
        JPanel buttonPane = this.initButtonsPanel();
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout(5, 5));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPanel.add((Component)searchPane, "First");
        contentPanel.add((Component)resultsPanel, "Center");
        contentPanel.add((Component)buttonPane, "Last");
        this.getContentPane().add(contentPanel);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                optionsPanel.revalidate();
                optionsPanel.repaint();
            }
        });
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
    }

    private int getMaxPkgLen() {
        CacheObject cacheObject = this.mainWindow.getCacheObject();
        int maxPkgLength = cacheObject.getMaxPkgLength();
        if (maxPkgLength != 0) {
            return maxPkgLength;
        }
        int max = 1;
        for (PackageNode pkg : this.mainWindow.getWrapper().getRootNode().getPackages()) {
            int len = pkg.getPkgInfo().getFullName().length();
            if (len <= max) continue;
            max = len;
        }
        cacheObject.setMaxPkgLength(max);
        return max;
    }

    private Dimension calcMinSizeForTitledBorder(JPanel panel) {
        TitledBorder border = (TitledBorder)panel.getBorder();
        Insets borderInsets = border.getBorderInsets(panel);
        int insets = 2 * (borderInsets.left + borderInsets.right);
        double titleWidth = panel.getFontMetrics(border.getTitleFont()).stringWidth(border.getTitle());
        return new Dimension((int)titleWidth + insets, panel.getPreferredSize().height);
    }

    private void addSearchHistoryButton() {
        JButton searchHistoryButton = new JButton((Icon)new FlatSearchWithHistoryIcon(true));
        searchHistoryButton.setToolTipText(NLS.str("search_dialog.search_history"));
        searchHistoryButton.addActionListener(e -> {
            JPopupMenu popupMenu = new JPopupMenu();
            List<String> searchHistory = this.mainWindow.getProject().getSearchHistory();
            if (searchHistory.isEmpty()) {
                popupMenu.add("(empty)");
            } else {
                for (String str : searchHistory) {
                    JMenuItem item = popupMenu.add(str);
                    item.addActionListener(ev -> this.searchField.setText(str));
                }
            }
            popupMenu.show(searchHistoryButton, 0, searchHistoryButton.getHeight());
        });
        this.searchField.putClientProperty("JTextField.leadingComponent", searchHistoryButton);
    }

    @Override
    protected void addResultsActions(JPanel resultsActionsPanel) {
        this.loadAllButton = new JButton(NLS.str("search_dialog.load_all"));
        this.loadAllButton.addActionListener(e -> this.loadMoreResults(true));
        this.loadAllButton.setEnabled(false);
        this.loadMoreButton = new JButton(NLS.str("search_dialog.load_more"));
        this.loadMoreButton.addActionListener(e -> this.loadMoreResults(false));
        this.loadMoreButton.setEnabled(false);
        this.stopBtn = new JButton(NLS.str("search_dialog.stop"));
        this.stopBtn.addActionListener(e -> this.pauseSearch());
        this.stopBtn.setEnabled(false);
        this.sortBtn = new JButton(NLS.str("search_dialog.sort_results"));
        this.sortBtn.addActionListener(e -> {
            List<JNode> list = this.pendingResults;
            synchronized (list) {
                this.resultsModel.sort();
                this.resultsTable.updateTable();
            }
        });
        this.sortBtn.setEnabled(false);
        resultsActionsPanel.add(this.loadAllButton);
        resultsActionsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        resultsActionsPanel.add(this.loadMoreButton);
        resultsActionsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        resultsActionsPanel.add(this.stopBtn);
        resultsActionsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        resultsActionsPanel.add(this.stopBtn);
        super.addResultsActions(resultsActionsPanel);
        resultsActionsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        resultsActionsPanel.add(this.sortBtn);
    }

    private void initSearchEvents() {
        if (this.searchDisposable != null) {
            this.searchDisposable.dispose();
            this.searchDisposable = null;
        }
        this.searchEmitter = new SearchEventEmitter();
        Flowable searchEvents = this.mainWindow.getSettings().isUseAutoSearch() ? Flowable.merge(List.of(RxUtils.textFieldChanges(this.searchField), RxUtils.textFieldEnterPress(this.searchField), RxUtils.textFieldChanges(this.packageField), RxUtils.textFieldEnterPress(this.packageField), RxUtils.textFieldChanges(this.resExtField), RxUtils.textFieldEnterPress(this.resExtField), RxUtils.spinnerChanges(this.resSizeLimit), RxUtils.spinnerEnterPress(this.resSizeLimit), this.searchEmitter.getFlowable())) : Flowable.merge(List.of(RxUtils.textFieldEnterPress(this.searchField), RxUtils.textFieldEnterPress(this.packageField), RxUtils.textFieldEnterPress(this.resExtField), RxUtils.spinnerEnterPress(this.resSizeLimit), this.searchEmitter.getFlowable()));
        this.searchDisposable = searchEvents.debounce(100L, TimeUnit.MILLISECONDS).observeOn(Schedulers.from((Executor)this.searchBackgroundExecutor)).subscribe(t -> this.search(this.searchField.getText()));
        this.optionsListener.sendUpdate(this.options);
    }

    private void search(String text) {
        UiUtils.notUiThreadGuard();
        this.stopSearchTask();
        UiUtils.uiRun(this::resetSearch);
        this.searchTask = this.prepareSearch(text);
        if (this.searchTask == null) {
            return;
        }
        UiUtils.uiRunAndWait(() -> {
            this.updateTableHighlight();
            this.prepareForSearch();
        });
        this.searchTask.setResultsLimit(this.mainWindow.getSettings().getSearchResultsPerPage());
        this.searchTask.setProgressListener(this::updateProgress);
        this.searchTask.fetchResults();
        LOG.debug("Total search items count estimation: {}", (Object)this.searchTask.getTaskProgress().total());
    }

    private SearchTask prepareSearch(String text) {
        if (text == null || this.options.isEmpty()) {
            return null;
        }
        if (text.isEmpty() && !this.options.contains((Object)SearchOptions.COMMENT)) {
            return null;
        }
        LOG.debug("Building search for '{}', options: {}", (Object)text, this.options);
        SearchSettings searchSettings = new SearchSettings(text);
        searchSettings.setIgnoreCase(this.options.contains((Object)SearchOptions.IGNORE_CASE));
        searchSettings.setUseRegex(this.options.contains((Object)SearchOptions.USE_REGEX));
        searchSettings.setSearchPkgStr(this.packageField.getText().trim());
        searchSettings.setResFilterStr(this.resExtField.getText().trim());
        searchSettings.setResSizeLimit((Integer)this.resSizeLimit.getValue());
        String error = searchSettings.prepare(this.mainWindow);
        UiUtils.highlightAsErrorField(this.searchField, !StringUtils.isEmpty((String)error));
        if (!StringUtils.isEmpty((String)error)) {
            this.resultsInfoLabel.setText(error);
            return null;
        }
        SearchTask newSearchTask = new SearchTask(this.mainWindow, this::addSearchResult, this::searchFinished);
        if (!this.buildSearch(newSearchTask, text, searchSettings)) {
            UiUtils.highlightAsErrorField(this.searchField, true);
            return null;
        }
        this.mainWindow.getProject().setSearchResourcesFilter(this.resExtField.getText().trim());
        this.mainWindow.getProject().setSearchResourcesSizeLimit(searchSettings.getResSizeLimit());
        return newSearchTask;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean buildSearch(SearchTask newSearchTask, String text, SearchSettings searchSettings) {
        JavaPackage searchPkg;
        List<JavaClass> searchClasses;
        if (this.options.contains((Object)SearchOptions.ACTIVE_TAB)) {
            JumpPosition currentPos = this.mainWindow.getTabbedPane().getCurrentPosition();
            if (currentPos == null) {
                this.resultsInfoLabel.setText("Can't search in current tab");
                return false;
            }
            JNode currentNode = currentPos.getNode();
            if (currentNode instanceof JClass) {
                JClass activeCls = currentNode.getRootClass();
                searchSettings.setActiveCls(activeCls);
                searchClasses = Collections.singletonList(activeCls.getCls());
            } else {
                if (!(currentNode instanceof JResource)) {
                    this.resultsInfoLabel.setText("Can't search in current tab");
                    return false;
                }
                searchSettings.setActiveResource((JResource)currentNode);
                searchClasses = Collections.emptyList();
            }
        } else {
            searchClasses = this.includedClsCache.get(this.mainWindow.getSettings().getExcludedPackages(), exc -> this.mainWindow.getWrapper().getIncludedClassesWithInners());
        }
        if ((searchPkg = searchSettings.getSearchPackage()) != null) {
            searchClasses = searchClasses.stream().filter(searchSettings::isInSearchPkg).collect(Collectors.toList());
        }
        if (text.isEmpty() && this.options.contains((Object)SearchOptions.COMMENT)) {
            newSearchTask.addProviderJob(new CommentSearchProvider(this.mainWindow, searchSettings, searchClasses));
            return true;
        }
        if (!searchClasses.isEmpty()) {
            MergedSearchProvider merged = new MergedSearchProvider();
            if (this.options.contains((Object)SearchOptions.CLASS)) {
                merged.add(new ClassSearchProvider(this.mainWindow, searchSettings, searchClasses));
            }
            if (this.options.contains((Object)SearchOptions.METHOD)) {
                merged.add(new MethodSearchProvider(this.mainWindow, searchSettings, searchClasses));
            }
            if (this.options.contains((Object)SearchOptions.FIELD)) {
                merged.add(new FieldSearchProvider(this.mainWindow, searchSettings, searchClasses));
            }
            if (!merged.isEmpty()) {
                merged.prepare();
                newSearchTask.addProviderJob(merged);
            }
            if (this.options.contains((Object)SearchOptions.CODE)) {
                int clsCount = searchClasses.size();
                if (clsCount == 1) {
                    newSearchTask.addProviderJob(new CodeSearchProvider(this.mainWindow, searchSettings, searchClasses, null));
                } else if (clsCount > 1) {
                    List topClasses = ListUtils.filter(searchClasses, c -> !c.isInner());
                    List batches = this.batchesCache.get(topClasses, clsList -> this.mainWindow.getWrapper().buildDecompileBatches((List<JavaClass>)clsList));
                    HashSet<JavaClass> includedClasses = new HashSet<JavaClass>(topClasses);
                    for (List batch : batches) {
                        newSearchTask.addProviderJob(new CodeSearchProvider(this.mainWindow, searchSettings, batch, includedClasses));
                    }
                }
            }
            if (this.options.contains((Object)SearchOptions.COMMENT)) {
                newSearchTask.addProviderJob(new CommentSearchProvider(this.mainWindow, searchSettings, searchClasses));
            }
        }
        if (this.options.contains((Object)SearchOptions.RESOURCE)) {
            newSearchTask.addProviderJob(new ResourceSearchProvider(this.mainWindow, searchSettings, this));
        }
        return true;
    }

    @Override
    protected void openItem(JNode node) {
        if (this.mainWindow.getSettings().isUseAutoSearch()) {
            this.mainWindow.getProject().addToSearchHistory(this.searchField.getText());
        }
        super.openItem(node);
    }

    private void pauseSearch() {
        this.stopBtn.setEnabled(false);
        this.searchBackgroundExecutor.execute(() -> {
            if (this.searchTask != null) {
                this.searchTask.cancel();
            }
        });
    }

    private void stopSearchTask() {
        UiUtils.notUiThreadGuard();
        if (this.searchTask != null) {
            this.searchTask.cancel();
            this.searchTask.waitTask();
            this.searchTask = null;
        }
    }

    private void loadMoreResults(boolean all) {
        this.searchBackgroundExecutor.execute(() -> {
            if (this.searchTask == null) {
                return;
            }
            this.searchTask.cancel();
            this.searchTask.waitTask();
            UiUtils.uiRunAndWait(this::prepareForSearch);
            if (all) {
                this.searchTask.setResultsLimit(0);
            }
            this.searchTask.fetchResults();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSearch() {
        UiUtils.uiThreadGuard();
        this.resultsModel.clear();
        this.resultsTable.updateTable();
        List<JNode> list = this.pendingResults;
        synchronized (list) {
            this.pendingResults.clear();
        }
        this.updateProgressLabel("");
        this.progressPane.setVisible(false);
        this.warnLabel.setVisible(false);
        this.loadAllButton.setEnabled(false);
        this.loadMoreButton.setEnabled(false);
    }

    private void prepareForSearch() {
        UiUtils.uiThreadGuard();
        this.stopBtn.setEnabled(true);
        this.sortBtn.setEnabled(false);
        this.showSearchState();
        this.progressStartCommon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSearchResult(JNode node) {
        Objects.requireNonNull(node);
        List<JNode> list = this.pendingResults;
        synchronized (list) {
            UiUtils.notUiThreadGuard();
            this.pendingResults.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTable() {
        List<JNode> list = this.pendingResults;
        synchronized (list) {
            UiUtils.uiThreadGuard();
            Collections.sort(this.pendingResults);
            this.resultsModel.addAll(this.pendingResults);
            this.pendingResults.clear();
            this.resultsTable.updateTable();
        }
    }

    private void updateTableHighlight() {
        String text = this.searchField.getText();
        this.updateHighlightContext(text, !this.options.contains((Object)SearchOptions.IGNORE_CASE), this.options.contains((Object)SearchOptions.USE_REGEX), false);
        this.cache.setLastSearch(text);
        this.cache.setLastSearchPackage(this.packageField.getText());
        this.cache.getLastSearchOptions().put(this.searchPreset, this.options);
        if (!this.mainWindow.getSettings().isUseAutoSearch()) {
            this.mainWindow.getProject().addToSearchHistory(text);
        }
    }

    private void updateProgress(ITaskProgress progress) {
        UiUtils.uiRun(() -> {
            this.progressPane.setProgress(progress);
            this.updateTable();
        });
    }

    public void updateProgressLabel(String text) {
        UiUtils.uiRun(() -> this.progressInfoLabel.setText(text));
    }

    private void searchFinished(ITaskInfo status, Boolean complete) {
        UiUtils.uiThreadGuard();
        LOG.debug("Search complete: {}, complete: {}", (Object)status, (Object)complete);
        this.loadAllButton.setEnabled(complete == false);
        this.loadMoreButton.setEnabled(complete == false);
        this.stopBtn.setEnabled(false);
        this.progressFinishedCommon();
        this.updateTable();
        this.updateProgressLabel(complete);
        this.sortBtn.setEnabled(this.resultsModel.getRowCount() != 0);
    }

    private void unloadTempData() {
        this.mainWindow.getWrapper().unloadClasses();
        System.gc();
    }

    private JCheckBox makeOptionsCheckBox(String name, SearchOptions opt) {
        JCheckBox chBox = new JCheckBox(name);
        chBox.setSelected(this.options.contains((Object)opt));
        chBox.addItemListener(e -> {
            if (chBox.isSelected()) {
                this.options.add(opt);
            } else {
                this.options.remove((Object)opt);
            }
            this.optionsListener.sendUpdate(this.options);
            this.searchEmitter.emitSearch();
        });
        return chBox;
    }

    private JToggleButton makeOptionsToggleButton(String name, ImageIcon icon, ImageIcon selectedIcon, SearchOptions opt) {
        JToggleButton toggleButton = new JToggleButton();
        toggleButton.setToolTipText(name);
        toggleButton.setIcon(icon);
        toggleButton.setSelectedIcon(selectedIcon);
        toggleButton.setSelected(this.options.contains((Object)opt));
        toggleButton.addItemListener(e -> {
            if (toggleButton.isSelected()) {
                this.options.add(opt);
            } else {
                this.options.remove((Object)opt);
            }
            this.optionsListener.sendUpdate(this.options);
            this.searchEmitter.emitSearch();
        });
        return toggleButton;
    }

    @Override
    protected void loadFinished() {
        this.resultsTable.setEnabled(true);
        this.searchField.setEnabled(true);
        this.searchEmitter.emitSearch();
    }

    @Override
    protected void loadStart() {
        this.resultsTable.setEnabled(false);
        this.searchField.setEnabled(false);
    }

    private void registerActiveTabListener() {
        this.removeActiveTabListener();
        this.activeTabListener = e -> {
            if (this.options.contains((Object)SearchOptions.ACTIVE_TAB)) {
                LOG.debug("active tab change event received");
                this.searchEmitter.emitSearch();
            }
        };
        this.mainWindow.getTabbedPane().addChangeListener(this.activeTabListener);
    }

    private void removeActiveTabListener() {
        if (this.activeTabListener != null) {
            this.mainWindow.getTabbedPane().removeChangeListener(this.activeTabListener);
            this.activeTabListener = null;
        }
    }

    private class SearchEventEmitter {
        private final Flowable<String> flowable = Flowable.create(this::saveEmitter, (BackpressureStrategy)BackpressureStrategy.LATEST);
        private Emitter<String> emitter;

        public Flowable<String> getFlowable() {
            return this.flowable;
        }

        private void saveEmitter(Emitter<String> emitter) {
            this.emitter = emitter;
        }

        public synchronized void emitSearch() {
            this.emitter.onNext((Object)SearchDialog.this.searchField.getText());
        }
    }

    public static enum SearchOptions {
        CLASS,
        METHOD,
        FIELD,
        CODE,
        RESOURCE,
        COMMENT,
        IGNORE_CASE,
        USE_REGEX,
        ACTIVE_TAB;

    }

    public static enum SearchPreset {
        TEXT,
        CLASS,
        COMMENT;

    }
}

