/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.dialog;

import jadx.api.metadata.ICodeNodeRef;
import jadx.api.plugins.events.IJadxEvent;
import jadx.api.plugins.events.types.NodeRenamedByUser;
import jadx.core.utils.Utils;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JPackage;
import jadx.gui.treemodel.JRenameNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.dialog.CommonDialog;
import jadx.gui.utils.NLS;
import jadx.gui.utils.TextStandardActions;
import jadx.gui.utils.pkgs.JRenamePackage;
import jadx.gui.utils.ui.DocumentUpdateListener;
import jadx.gui.utils.ui.NodeLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class RenameDialog
extends CommonDialog {
    private static final long serialVersionUID = -3269715644416902410L;
    private final transient JRenameNode node;
    private transient JTextField renameField;
    private transient JButton renameBtn;

    public static boolean rename(MainWindow mainWindow, JRenameNode node) {
        SwingUtilities.invokeLater(() -> {
            RenameDialog renameDialog = new RenameDialog(mainWindow, node);
            renameDialog.initRenameField();
            renameDialog.setVisible(true);
        });
        return true;
    }

    public static JPopupMenu buildRenamePopup(MainWindow mainWindow, JRenameNode node) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(RenameDialog.buildRenamePopupMenuItem(mainWindow, node));
        return menu;
    }

    public static JMenuItem buildRenamePopupMenuItem(MainWindow mainWindow, JRenameNode node) {
        JMenuItem jmi = new JMenuItem(NLS.str("popup.rename"));
        jmi.addActionListener(action -> RenameDialog.rename(mainWindow, node));
        jmi.setEnabled(node.canRename());
        return jmi;
    }

    private RenameDialog(MainWindow mainWindow, JRenameNode node) {
        super(mainWindow);
        this.node = node.replace();
        this.initUI();
    }

    private void initRenameField() {
        this.renameField.setText(this.node.getName());
        this.renameField.selectAll();
    }

    private boolean checkNewName(String newName) {
        if (newName.isEmpty()) {
            return true;
        }
        boolean valid = this.node.isValidName(newName);
        if (this.renameBtn.isEnabled() != valid) {
            this.renameBtn.setEnabled(valid);
            this.renameField.putClientProperty("JComponent.outline", valid ? "" : "error");
        }
        return valid;
    }

    private void rename() {
        this.rename(this.renameField.getText().trim());
    }

    private void resetName() {
        this.rename("");
    }

    private void rename(String newName) {
        String newNodeName;
        if (!this.checkNewName(newName)) {
            return;
        }
        String oldName = this.node.getName();
        boolean reset = newName.isEmpty();
        if (reset) {
            this.node.removeAlias();
            newNodeName = (String)Utils.getOrElse((Object)this.node.getJavaNode().getName(), (Object)"");
        } else {
            newNodeName = newName;
        }
        this.sendRenameEvent(oldName, newNodeName, reset);
        this.dispose();
    }

    private void sendRenameEvent(String oldName, String newName, boolean reset) {
        ICodeNodeRef nodeRef = this.node.getJavaNode().getCodeNodeRef();
        NodeRenamedByUser event = new NodeRenamedByUser(nodeRef, oldName, newName);
        event.setRenameNode((Object)this.node);
        event.setResetName(reset);
        this.mainWindow.events().send((IJadxEvent)event);
    }

    @NotNull
    protected JPanel initButtonsPanel() {
        JButton resetButton = new JButton(NLS.str("common_dialog.reset"));
        resetButton.addActionListener(event -> this.resetName());
        JButton cancelButton = new JButton(NLS.str("common_dialog.cancel"));
        cancelButton.addActionListener(event -> this.dispose());
        this.renameBtn = new JButton(NLS.str("common_dialog.ok"));
        this.renameBtn.addActionListener(event -> this.rename());
        this.getRootPane().setDefaultButton(this.renameBtn);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(resetButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(this.renameBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        return buttonPane;
    }

    private void initUI() {
        JLabel lbl = new JLabel(NLS.str("popup.rename"));
        NodeLabel nodeLabel = new NodeLabel(this.node.getTitle());
        nodeLabel.setIcon(this.node.getIcon());
        if (this.node instanceof JNode) {
            nodeLabel.disableHtml(((JNode)((Object)this.node)).disableHtml());
        } else if (this.node instanceof JRenamePackage) {
            nodeLabel.disableHtml(!this.node.getTitle().equals(JPackage.PACKAGE_DEFAULT_HTML_STR));
        }
        lbl.setLabelFor(nodeLabel);
        this.renameField = new JTextField(40);
        this.renameField.setFont(this.mainWindow.getSettings().getCodeFont());
        this.renameField.getDocument().addDocumentListener(new DocumentUpdateListener(ev -> this.checkNewName(this.renameField.getText())));
        this.renameField.addActionListener(e -> this.rename());
        new TextStandardActions(this.renameField);
        JPanel renamePane = new JPanel();
        renamePane.setLayout(new FlowLayout(0));
        renamePane.add(lbl);
        renamePane.add(nodeLabel);
        renamePane.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        JPanel textPane = new JPanel();
        textPane.setLayout(new BoxLayout(textPane, 3));
        textPane.add(this.renameField);
        if (this.node instanceof JClass) {
            textPane.add(new JLabel(NLS.str("rename_dialog.class_help")));
        }
        textPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        JPanel buttonPane = this.initButtonsPanel();
        Container contentPane = this.getContentPane();
        contentPane.add((Component)renamePane, "First");
        contentPane.add((Component)textPane, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.setTitle(NLS.str("popup.rename"));
        this.commonWindowInit();
    }
}

